/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.visad.Util;
import ucar.visad.display.ColorScaleInfo;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import visad.ConstantMap;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.Integer1DSet;
import visad.MathType;
import visad.MouseBehavior;
import visad.PlotText;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.ShadowType;
import visad.ShapeControl;
import visad.TextControl;
import visad.Unit;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADTriangleArray;
import visad.bom.ScreenLockedRendererJ3D;
import visad.java2d.DefaultRendererJ2D;
import visad.java2d.DisplayRendererJ2D;
import visad.util.HersheyFont;

public class ColorScale
extends DisplayableData {
    public static final int VERTICAL_ORIENT = 0;
    public static final int HORIZONTAL_ORIENT = 1;
    public static final int PRIMARY = 0;
    public static final int SECONDARY = 1;
    public static final String TOP = "Top";
    public static final String BOTTOM = "Bottom";
    public static final String LEFT = "Left";
    public static final String RIGHT = "Right";
    private static float BAR_THICKNESS = 0.017f;
    private static float BAR_LENGTH = 0.8f;
    private float X;
    private float Y;
    private boolean labelVisible = true;
    private boolean labelAllTicks = true;
    private static int instance = 0;
    private static Object INSTANCE_MUTEX = new Object();
    private Rectangle2D.Float scaleBounds = null;
    private ScalarMap csMap = null;
    private RealType csType = null;
    private ShapeControl shapeControl = null;
    private VisADGeometryArray[] shapes = null;
    private float[][] colorPalette = null;
    private int orient = 1;
    private double lowRange = Double.NaN;
    private double highRange = Double.NaN;
    private Hashtable labelTable = new Hashtable();
    private Object labelFont = null;
    private boolean userLabels = false;
    private int labelSize = 10;
    private int labelSide = 0;
    public static final Color DEFAULT_LABEL_COLOR = Color.lightGray;
    private Color labelColor = null;
    private double zPosition = 2.0;
    private boolean useAlpha = false;
    private Unit unit;
    private boolean unitVisible;

    public ColorScale(String name) throws VisADException, RemoteException {
        this(name, 0);
    }

    public ColorScale(String name, int orient) throws VisADException, RemoteException {
        this(name, orient, null);
    }

    public ColorScale(String name, int orient, float[][] table) throws VisADException, RemoteException {
        this(name, orient, ColorScale.getX(orient, ColorScale.getDefaultPlace(orient)), ColorScale.getY(orient, ColorScale.getDefaultPlace(orient)), table);
    }

    public ColorScale(String name, int orient, double x, double y) throws VisADException, RemoteException {
        this(name, orient, x, y, null);
    }

    public ColorScale(String name, int orient, double x, double y, float[][] table) throws VisADException, RemoteException {
        super(name);
        this.orient = orient;
        this.X = (float)x;
        this.Y = (float)y;
        this.colorPalette = table;
        this.setUpScalarMaps();
        this.makeShapes();
    }

    public ColorScale(ColorScaleInfo info) throws VisADException, RemoteException {
        super(info.getName());
        this.orient = info.getOrientation();
        this.X = info.getX();
        this.Y = info.getY();
        this.colorPalette = info.getColorPalette();
        this.labelFont = info.getLabelFont();
        this.labelColor = info.getLabelColor();
        this.labelSide = info.getLabelSide();
        this.labelVisible = info.getLabelVisible();
        this.useAlpha = info.getUseAlpha();
        this.unit = info.getUnit();
        this.unitVisible = info.isUnitVisible();
        this.setVisible(info.getIsVisible());
        this.setUpScalarMaps();
        this.makeShapes();
    }

    @Override
    public void setRangeForColor(double low, double hi) throws VisADException, RemoteException {
        this.lowRange = low;
        this.highRange = hi;
        this.makeShapes();
    }

    public int getOrientation() {
        return this.orient;
    }

    public void setOrientation(int orient) throws RemoteException, VisADException {
        this.orient = orient;
        this.makeShapes();
    }

    public void setColorScaleInfo(ColorScaleInfo info) throws RemoteException, VisADException {
        this.orient = info.getOrientation();
        this.X = info.getX();
        this.Y = info.getY();
        this.colorPalette = info.getColorPalette();
        this.labelFont = info.getLabelFont();
        this.labelColor = info.getLabelColor();
        this.labelSide = info.getLabelSide();
        this.labelVisible = info.getLabelVisible();
        this.useAlpha = info.getUseAlpha();
        this.unitVisible = info.isUnitVisible();
        this.setVisible(info.getIsVisible());
        this.unit = info.getUnit();
        this.makeShapes();
    }

    public void setLabelColor(Color color) throws RemoteException, VisADException {
        this.labelColor = color;
        this.makeShapes();
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setLabelVisible(boolean visible) throws RemoteException, VisADException {
        this.labelVisible = visible;
        this.makeShapes();
    }

    public boolean getLabelVisble() {
        return this.labelVisible;
    }

    public boolean isUnitVisible() {
        return this.unitVisible;
    }

    public void setUnitVisible(boolean unitVisible) {
        this.unitVisible = unitVisible;
    }

    public boolean getUseAlpha() {
        return this.useAlpha;
    }

    public void setUseAlpha(boolean useAlpha) throws RemoteException, VisADException {
        this.useAlpha = useAlpha;
        this.makeShapes();
    }

    public void setLabelSide(int side) throws RemoteException, VisADException {
        this.labelSide = side;
        this.makeShapes();
    }

    public int getLabelSide() {
        return this.labelSide;
    }

    @Override
    public void setColorPalette(float[][] colorPalette) throws RemoteException, VisADException {
        this.colorPalette = colorPalette;
        this.makeShapes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUpScalarMaps() throws VisADException, RemoteException {
        int myInstance;
        Object object = INSTANCE_MUTEX;
        synchronized (object) {
            myInstance = instance++;
        }
        this.csType = RealType.getRealType("Color_Scale" + myInstance);
        this.csMap = new ScalarMap(this.csType, Display.Shape);
        this.csMap.addScalarMapListener(new ScalarMapListener(){

            @Override
            public void controlChanged(ScalarMapControlEvent event) throws RemoteException, VisADException {
                block5: {
                    block4: {
                        int id = event.getId();
                        if (id == 3) break block4;
                        if (id != 5) break block5;
                    }
                    ColorScale.this.shapeControl = (ShapeControl)ColorScale.this.csMap.getControl();
                    if (ColorScale.this.shapeControl != null) {
                        ColorScale.this.makeShapes();
                    }
                }
            }

            @Override
            public void mapChanged(ScalarMapEvent event) throws RemoteException, VisADException {
            }
        });
        this.addScalarMap(this.csMap);
        this.setData(new Integer1DSet((MathType)this.csType, 3));
    }

    private void setPositionData() throws VisADException {
        try {
            this.addConstantMaps(new ConstantMap[]{new ConstantMap(this.scaleBounds.x, Display.XAxis), new ConstantMap(this.scaleBounds.y, Display.YAxis), new ConstantMap(this.zPosition, Display.ZAxis)});
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setShapesInControl(VisADGeometryArray[] shapes) throws VisADException, RemoteException {
        if (this.shapeControl != null && shapes != null) {
            if (shapes.length > 0) {
                this.shapeControl.setShapeSet(new Integer1DSet(shapes.length));
                this.shapeControl.setShapes(shapes);
            } else {
                VisADLineArray shape = new VisADLineArray();
                shape.coordinates = new float[0];
                shapes = new VisADGeometryArray[]{shape};
                this.shapeControl.setShapeSet(new Integer1DSet(shapes.length));
                this.shapeControl.setShapes(shapes);
            }
        }
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        return this;
    }

    public void reDisplay() {
        try {
            this.makeShapes();
        }
        catch (VisADException visADException) {
            // empty catch block
        }
    }

    private void makeShapes() throws VisADException {
        VisADGeometryArray[] labels;
        VisADTriangleArray bar;
        if (this.getDisplay() == null) {
            return;
        }
        this.calculateScaleBounds();
        Vector<VisADGeometryArray> shapeVector = new Vector<VisADGeometryArray>();
        if (this.colorPalette != null && (bar = this.createTriangles(this.scaleBounds.width, this.scaleBounds.height)) != null && bar.coordinates != null) {
            shapeVector.add(bar);
        }
        if (this.labelVisible && this.colorPalette != null && (labels = this.createLabels(this.scaleBounds.width, this.scaleBounds.height)) != null) {
            for (int i = 0; i < labels.length; ++i) {
                VisADGeometryArray ith = labels[i];
                if (ith == null || ith.coordinates == null) continue;
                shapeVector.add(ith);
            }
        }
        this.shapes = new VisADGeometryArray[shapeVector.size()];
        try {
            this.shapes = shapeVector.toArray(this.shapes);
            this.setShapesInControl(this.shapes);
            this.setPositionData();
        }
        catch (Exception t) {
            System.err.println("unable to display colorscale");
        }
    }

    private VisADTriangleArray createTriangles(float width, float height) throws VisADException {
        int numColours = this.colorPalette[0].length;
        boolean hasAlpha = this.colorPalette.length == 4 && this.useAlpha;
        float delta = (this.orient == 1 ? width : height) / (float)numColours;
        int numPointsPerTriangle = 3;
        int numValuesPerPoint = 3;
        int numColoursPerPoint = hasAlpha ? 4 : 3;
        int numTriangles = numColours * 2;
        float[] triangles = new float[numTriangles * numPointsPerTriangle * numValuesPerPoint];
        byte[] colors = new byte[numTriangles * numPointsPerTriangle * numColoursPerPoint];
        int index = 0;
        int colorIndex = 0;
        for (int i = 0; i < numColours; ++i) {
            byte red = (byte)(this.colorPalette[0][i] * 255.0f);
            byte green = (byte)(this.colorPalette[1][i] * 255.0f);
            byte blue = (byte)(this.colorPalette[2][i] * 255.0f);
            byte alpha = 0;
            if (hasAlpha) {
                alpha = (byte)(this.colorPalette[3][i] * 255.0f);
            }
            if (this.orient == 1) {
                triangles[index++] = delta * (float)i;
                triangles[index++] = 0.0f;
                triangles[index++] = 0.0f;
                triangles[index++] = delta * (float)(i + 1);
                triangles[index++] = 0.0f;
                triangles[index++] = 0.0f;
                triangles[index++] = delta * (float)(i + 1);
                triangles[index++] = height;
                triangles[index++] = 0.0f;
            } else {
                triangles[index++] = 0.0f;
                triangles[index++] = -height + delta * (float)(i + 1);
                triangles[index++] = 0.0f;
                triangles[index++] = width;
                triangles[index++] = -height + delta * (float)(i + 1);
                triangles[index++] = 0.0f;
                triangles[index++] = width;
                triangles[index++] = -height + delta * (float)i;
                triangles[index++] = 0.0f;
            }
            if (this.orient == 1) {
                triangles[index++] = delta * (float)i;
                triangles[index++] = 0.0f;
                triangles[index++] = 0.0f;
                triangles[index++] = delta * (float)(i + 1);
                triangles[index++] = height;
                triangles[index++] = 0.0f;
                triangles[index++] = delta * (float)i;
                triangles[index++] = height;
                triangles[index++] = 0.0f;
            } else {
                triangles[index++] = 0.0f;
                triangles[index++] = -height + delta * (float)(i + 1);
                triangles[index++] = 0.0f;
                triangles[index++] = width;
                triangles[index++] = -height + delta * (float)i;
                triangles[index++] = 0.0f;
                triangles[index++] = 0.0f;
                triangles[index++] = -height + delta * (float)i;
                triangles[index++] = 0.0f;
            }
            for (int n = 0; n < 6; ++n) {
                colors[colorIndex++] = red;
                colors[colorIndex++] = green;
                colors[colorIndex++] = blue;
                if (!hasAlpha) continue;
                colors[colorIndex++] = alpha;
            }
        }
        float[] normals = new float[numTriangles * numPointsPerTriangle * numValuesPerPoint];
        index = 0;
        for (int i = 0; i < numTriangles; ++i) {
            normals[index++] = 0.0f;
            normals[index++] = 0.0f;
            normals[index++] = 1.0f;
            normals[index++] = 0.0f;
            normals[index++] = 0.0f;
            normals[index++] = 1.0f;
            normals[index++] = 0.0f;
            normals[index++] = 0.0f;
            normals[index++] = 1.0f;
        }
        VisADTriangleArray triangleArray = new VisADTriangleArray();
        triangleArray.coordinates = triangles;
        triangleArray.normals = normals;
        triangleArray.colors = colors;
        triangleArray.vertexCount = numTriangles * numPointsPerTriangle;
        return triangleArray;
    }

    private VisADLineArray createOutline(float width, float height) throws VisADException {
        int numPoints = 4;
        int numValuesPerPoint = 3;
        int numPointsPerLine = 2;
        float[] outline = new float[numPoints * numPointsPerLine * numValuesPerPoint];
        float[] rgb = this.labelColor == null ? (this.getDisplay() != null ? this.getDisplay().getDisplayRenderer().getRendererControl().getForegroundColor() : DEFAULT_LABEL_COLOR.getColorComponents(null)) : this.labelColor.getColorComponents(null);
        byte red = ShadowType.floatToByte(rgb[0]);
        byte green = ShadowType.floatToByte(rgb[1]);
        byte blue = ShadowType.floatToByte(rgb[2]);
        byte[] colors = new byte[numPoints * numPointsPerLine * numValuesPerPoint];
        int colorIndex = 0;
        int index = 0;
        float xdelta = width;
        float ydelta = this.orient == 1 ? height : -height;
        for (int i = 0; i < numPoints; ++i) {
            switch (i) {
                case 0: {
                    outline[index++] = 0.0f;
                    outline[index++] = 0.0f;
                    outline[index++] = 0.0f;
                    outline[index++] = xdelta;
                    outline[index++] = 0.0f;
                    outline[index++] = 0.0f;
                    break;
                }
                case 1: {
                    outline[index++] = xdelta;
                    outline[index++] = 0.0f;
                    outline[index++] = 0.0f;
                    outline[index++] = xdelta;
                    outline[index++] = ydelta;
                    outline[index++] = 0.0f;
                    break;
                }
                case 2: {
                    outline[index++] = xdelta;
                    outline[index++] = ydelta;
                    outline[index++] = 0.0f;
                    outline[index++] = 0.0f;
                    outline[index++] = ydelta;
                    outline[index++] = 0.0f;
                    break;
                }
                case 3: {
                    outline[index++] = 0.0f;
                    outline[index++] = ydelta;
                    outline[index++] = 0.0f;
                    outline[index++] = 0.0f;
                    outline[index++] = 0.0f;
                    outline[index++] = 0.0f;
                    break;
                }
            }
            for (int j = 0; j < numPointsPerLine; ++j) {
                colors[colorIndex++] = red;
                colors[colorIndex++] = green;
                colors[colorIndex++] = blue;
            }
        }
        VisADLineArray lineArray = new VisADLineArray();
        lineArray.coordinates = outline;
        lineArray.colors = colors;
        lineArray.vertexCount = numPoints * numPointsPerLine;
        return lineArray;
    }

    private VisADGeometryArray[] createLabels(float width, float height) throws VisADException {
        int i;
        byte[] colors;
        byte green;
        float[] rgb;
        double SCALE;
        double[] base = null;
        double[] up = null;
        double[] startn = null;
        double[] startp = null;
        TextControl.Justification justification = this.orient == 1 ? TextControl.Justification.CENTER : TextControl.Justification.LEFT;
        Vector<VisADLineArray> lineArrayVector = new Vector<VisADLineArray>();
        Vector<VisADTriangleArray> labelArrayVector = new Vector<VisADTriangleArray>();
        double ONE = this.lowRange > this.highRange ? -1.0 : 1.0;
        double min = Math.min(this.lowRange, this.highRange);
        double max = Math.max(this.lowRange, this.highRange);
        double range = Math.abs(max - min);
        double majorTickSpacing = Misc.computeTickSpacing(min, max);
        double firstValue = this.lowRange;
        double fontScale = 1.0;
        if (this.labelFont != null && this.labelFont instanceof Font) {
            fontScale = (double)((Font)this.labelFont).getSize() / 12.0;
        }
        Rectangle r = this.getDisplayMaster().getScreenBounds();
        if (this.orient == 1) {
            SCALE = (double)height * 0.8 * fontScale;
            if (this.labelSide == 0) {
                base = new double[]{SCALE, 0.0, 0.0};
                up = new double[]{0.0, SCALE, 0.0};
                startn = new double[]{0.0, (double)(-height) - SCALE * 0.5, 0.0};
                startp = new double[]{width, (double)(-height) - SCALE * 0.5, 0.0};
            } else {
                base = new double[]{SCALE, 0.0, 0.0};
                up = new double[]{0.0, SCALE, 0.0};
                startn = new double[]{0.0, (double)height + SCALE * 0.5, 0.0};
                startp = new double[]{width, (double)height + SCALE * 0.5, 0.0};
            }
        } else {
            SCALE = (double)width * 0.8 * fontScale;
            if (this.labelSide == 0) {
                base = new double[]{SCALE, 0.0, 0.0};
                up = new double[]{0.0, SCALE, 0.0};
                startn = new double[]{(double)width + SCALE * 0.5, -height, 0.0};
                startp = new double[]{(double)width + SCALE * 0.5, 0.0, 0.0};
            } else {
                base = new double[]{SCALE, 0.0, 0.0};
                up = new double[]{0.0, SCALE, 0.0};
                startn = new double[]{-SCALE * 0.5, -height, 0.0};
                startp = new double[]{-SCALE * 0.5, 0.0, 0.0};
                justification = TextControl.Justification.RIGHT;
            }
        }
        double dist = this.orient == 1 ? SCALE + SCALE / 10.0 : (double)width + SCALE / 10.0;
        double[] updir = up;
        if (!this.userLabels) {
            this.createStandardLabels(max, min, min, !this.labelAllTicks ? range : majorTickSpacing, false);
        }
        if (this.labelTable.isEmpty()) {
            return null;
        }
        double val_unit = Math.abs(this.highRange - this.lowRange) / range;
        val_unit += val_unit * 5.0 / 100.0;
        double[] point_unit = new double[3];
        for (int j = 0; j < 3; ++j) {
            point_unit[j] = (1.0 - val_unit) * startn[j] + val_unit * startp[j] - dist * up[j];
        }
        if (this.unit != null && this.unitVisible) {
            if (this.labelFont == null) {
                VisADLineArray label = PlotText.render_label(this.unit + "", point_unit, base, updir, justification);
                lineArrayVector.add(label);
            } else if (this.labelFont instanceof Font) {
                VisADTriangleArray label = PlotText.render_font(this.unit + "", (Font)this.labelFont, point_unit, base, updir, justification);
                labelArrayVector.add(label);
            } else if (this.labelFont instanceof HersheyFont) {
                VisADLineArray label = PlotText.render_font(this.unit + "", (HersheyFont)this.labelFont, point_unit, base, updir, justification);
                lineArrayVector.add(label);
            }
        }
        Enumeration e = this.labelTable.keys();
        while (e.hasMoreElements()) {
            Double Value;
            try {
                Value = (Double)e.nextElement();
            }
            catch (ClassCastException cce) {
                throw new VisADException("Invalid keys in label hashtable");
            }
            double test = Value;
            if (test > max || test < min) continue;
            double val = Math.abs(test - this.lowRange) / range;
            double[] point = new double[3];
            for (int j = 0; j < 3; ++j) {
                point[j] = (1.0 - val) * startn[j] + val * startp[j] - dist * up[j];
            }
            if (this.labelFont == null) {
                VisADLineArray label = PlotText.render_label((String)this.labelTable.get(Value), point, base, updir, justification);
                lineArrayVector.add(label);
                continue;
            }
            if (this.labelFont instanceof Font) {
                VisADTriangleArray label = PlotText.render_font((String)this.labelTable.get(Value), (Font)this.labelFont, point, base, updir, justification);
                labelArrayVector.add(label);
                continue;
            }
            if (!(this.labelFont instanceof HersheyFont)) continue;
            VisADLineArray label = PlotText.render_font((String)this.labelTable.get(Value), (HersheyFont)this.labelFont, point, base, updir, justification);
            lineArrayVector.add(label);
        }
        VisADLineArray lineLabels = null;
        VisADTriangleArray triLabels = null;
        if (!lineArrayVector.isEmpty()) {
            VisADLineArray[] arrays = lineArrayVector.toArray(new VisADLineArray[lineArrayVector.size()]);
            lineLabels = VisADLineArray.merge(arrays);
            rgb = this.labelColor == null ? (this.getDisplay() != null ? this.getDisplay().getDisplayRenderer().getRendererControl().getForegroundColor() : DEFAULT_LABEL_COLOR.getColorComponents(null)) : this.labelColor.getColorComponents(null);
            byte red = ShadowType.floatToByte(rgb[0]);
            green = ShadowType.floatToByte(rgb[1]);
            byte blue = ShadowType.floatToByte(rgb[2]);
            int n = 3 * lineLabels.vertexCount;
            colors = new byte[n];
            for (i = 0; i < n; i += 3) {
                colors[i] = red;
                colors[i + 1] = green;
                colors[i + 2] = blue;
            }
            lineLabels.colors = colors;
        }
        if (!labelArrayVector.isEmpty()) {
            VisADTriangleArray[] labelArrays = labelArrayVector.toArray(new VisADTriangleArray[labelArrayVector.size()]);
            triLabels = VisADTriangleArray.merge(labelArrays);
            rgb = this.labelColor.getColorComponents(null);
            byte red = ShadowType.floatToByte(rgb[0]);
            green = ShadowType.floatToByte(rgb[1]);
            byte blue = ShadowType.floatToByte(rgb[2]);
            int n = 3 * triLabels.vertexCount;
            colors = new byte[n];
            for (i = 0; i < n; i += 3) {
                colors[i] = red;
                colors[i + 1] = green;
                colors[i + 2] = blue;
            }
            triLabels.colors = colors;
        }
        return new VisADGeometryArray[]{lineLabels, triLabels};
    }

    @Override
    protected DataRenderer getDataRenderer() throws VisADException {
        DataRenderer renderer = this.getDisplay().getDisplayRenderer() instanceof DisplayRendererJ2D ? new DefaultRendererJ2D() : new ScreenLockedRendererJ3D();
        this.makeShapes();
        return renderer;
    }

    private void calculateScaleBounds() {
        DisplayImpl display = (DisplayImpl)this.getDisplay();
        this.scaleBounds = new Rectangle2D.Float();
        boolean isPerspective = display.getGraphicsModeControl().getProjectionPolicy() == 1;
        try {
            Rectangle r = this.getDisplayMaster().getScreenBounds();
            if (!r.isEmpty()) {
                int x = r.x + (int)(this.X * (float)r.width);
                int y = r.y + (int)(this.Y * (float)r.height);
                double ratio = (double)r.width / (double)r.height;
                MouseBehavior behavior = ((DisplayImpl)this.getDisplayMaster().getDisplay()).getMouseBehavior();
                double[] matrix = this.getDisplayMaster().getProjectionMatrix();
                boolean is2D = this.getDisplayMaster().getDisplay().getDisplayRenderer().getMode2D();
                double[] rot = new double[3];
                double[] scale = new double[3];
                double[] trans = new double[3];
                behavior.instance_unmake_matrix(rot, scale, trans, matrix);
                double defScale = is2D ? 0.65 : 0.5;
                double scalex = scale[0] / defScale;
                double scaley = scale[1] / defScale;
                double transx = trans[0] / defScale;
                double transy = trans[1] / defScale;
                double[] ray = Util.getVWorldCoords(display, x, y, null);
                double[] ray1 = Util.getVWorldCoords(display, r.x, r.y + r.height, null);
                double[] ray2 = Util.getVWorldCoords(display, r.x + r.width, r.y, null);
                if (this.orient == 1) {
                    this.scaleBounds.setRect(ray[0], ray[1], (double)BAR_LENGTH * (ray2[0] - ray1[0]), (double)BAR_THICKNESS * ratio * (ray2[1] - ray1[1]));
                } else {
                    this.scaleBounds.setRect(ray[0], ray[1], (double)BAR_THICKNESS * (ray2[0] - ray1[0]), (double)BAR_LENGTH * (ray2[1] - ray1[1]));
                }
                this.zPosition = isPerspective ? ray[2] : 2.0;
            }
        }
        catch (Exception e) {
            LogUtil.logException("Trying to calc starting position ", e);
        }
    }

    private void createStandardLabels(double max, double min, double base, double increment, boolean byuser) {
        this.labelTable = Misc.createLabelTable(max, min, base, increment);
        if (byuser) {
            try {
                this.userLabels = true;
                this.makeShapes();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    private String createLabelString(double value) {
        return Misc.format(value);
    }

    public void setFont(Font font) {
        Object oldFont = this.labelFont;
        this.labelFont = font;
        if (this.labelFont != null && !this.labelFont.equals(oldFont)) {
            if (this.labelFont instanceof Font) {
                this.labelSize = ((Font)this.labelFont).getSize();
            }
            try {
                this.makeShapes();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public void setFont(HersheyFont font) {
        Object oldFont = this.labelFont;
        this.labelFont = font;
        if (this.labelFont != null && !this.labelFont.equals(oldFont)) {
            this.labelSize = 12;
            try {
                this.makeShapes();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
    }

    public Font getFont() {
        return this.labelFont instanceof Font ? (Font)this.labelFont : null;
    }

    @Override
    public void setUseFastRendering(boolean fastRender) throws VisADException, RemoteException {
        super.setUseFastRendering(true);
    }

    public static String getDefaultPlace(int orient) {
        return orient == 1 ? BOTTOM : LEFT;
    }

    public static int getDefaultOrient(String place) {
        if (place == null) {
            place = TOP;
        }
        return place.equals(LEFT) || place.equals(RIGHT) ? 0 : 1;
    }

    public static float getX(int orient, String placement) {
        float x = 0.1f;
        if (orient == 0) {
            x = placement.equals(LEFT) ? 0.01f : 0.99f - BAR_THICKNESS;
        }
        return x;
    }

    public static float getY(int orient, String placement) {
        float y = 0.1f;
        if (orient == 1) {
            y = placement.equals(TOP) ? 0.01f + BAR_THICKNESS : 0.99f - 2.0f * BAR_THICKNESS;
        }
        return y;
    }
}

