/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.visad.display.LineDrawing;
import ucar.visad.display.SelectorDisplayable;
import ucar.visad.display.SelectorPoint;
import visad.ActionImpl;
import visad.ConstantMap;
import visad.Display;
import visad.Gridded3DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;

public class AreaProbe
extends SelectorDisplayable {
    private static RealTupleType areaType;
    private SelectorPoint ulPoint;
    private SelectorPoint lrPoint;
    private LineDrawing box;
    private Real constant;
    private float pointSize = 5.0f;
    private volatile boolean settingPosition = false;

    public AreaProbe() throws VisADException, RemoteException {
        this(new RealTuple(AreaProbe.getAreaType(), new double[]{-0.9, -0.9, 0.9, 0.9}));
    }

    public AreaProbe(RealTuple position) throws VisADException, RemoteException {
        this(position, new Real(RealType.ZAxis, 1.0));
    }

    public AreaProbe(RealTuple position, Real constant) throws VisADException, RemoteException {
        if (!position.getType().equals(AreaProbe.getAreaType())) {
            throw new VisADException("Can't yet handle " + position.getType());
        }
        if (!constant.getType().equals(RealType.ZAxis)) {
            throw new VisADException("Can't yet handle constant " + constant.getType());
        }
        this.constant = constant;
        this.ulPoint = new SelectorPoint("Probe point", RealTupleType.SpatialCartesian2DTuple);
        this.lrPoint = new SelectorPoint("Probe point", RealTupleType.SpatialCartesian2DTuple);
        this.box = new LineDrawing("AreaProbe.box");
        this.ulPoint.addConstantMap(new ConstantMap(constant.getValue(), Display.ZAxis));
        this.lrPoint.addConstantMap(new ConstantMap(constant.getValue(), Display.ZAxis));
        this.box.addConstantMap(new ConstantMap(constant.getValue(), Display.ZAxis));
        this.addDisplayable(this.ulPoint);
        this.addDisplayable(this.lrPoint);
        this.addDisplayable(this.box);
        this.setPosition(position);
        ActionImpl action = new ActionImpl("point listener"){

            @Override
            public void doAction() throws VisADException, RemoteException {
                if (AreaProbe.this.settingPosition) {
                    return;
                }
                AreaProbe.this.setLinePosition();
                AreaProbe.this.notifyListenersOfMove();
            }
        };
        this.ulPoint.addAction(action);
        this.lrPoint.addAction(action);
    }

    @Override
    public void setManipulable(boolean manip) throws VisADException, RemoteException {
        this.ulPoint.setManipulable(manip);
        this.lrPoint.setManipulable(manip);
    }

    public static RealTupleType getAreaType() throws VisADException, RemoteException {
        if (areaType == null) {
            areaType = new RealTupleType(RealType.XAxis, RealType.YAxis, RealType.XAxis, RealType.YAxis);
        }
        return areaType;
    }

    private double[] getValues() throws VisADException, RemoteException {
        Real[] ulReals = this.ulPoint.getPoint().getRealComponents();
        Real[] lrReals = this.lrPoint.getPoint().getRealComponents();
        return new double[]{ulReals[0].getValue(), ulReals[1].getValue(), lrReals[0].getValue(), lrReals[1].getValue()};
    }

    public RealTuple getArea() throws VisADException, RemoteException {
        return new RealTuple(AreaProbe.getAreaType(), this.getValues());
    }

    @Override
    public void setAutoSize(boolean yesorno) throws VisADException, RemoteException {
        this.ulPoint.setAutoSize(yesorno);
        this.lrPoint.setAutoSize(yesorno);
        super.setAutoSize(yesorno);
    }

    public void setPosition(double x1, double y1, double x2, double y2) throws VisADException, RemoteException {
        this.setPosition(new RealTuple(AreaProbe.getAreaType(), new double[]{x1, y1, x2, y2}));
    }

    public void setPosition(RealTuple position) throws VisADException, RemoteException {
        this.settingPosition = true;
        try {
            if (!position.getType().equals(AreaProbe.getAreaType())) {
                throw new VisADException("Can't yet handle " + position.getType());
            }
            Real[] values = position.getRealComponents();
            this.ulPoint.setPoint(new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{values[0].getValue(), values[1].getValue()}));
            this.lrPoint.setPoint(new RealTuple(RealTupleType.SpatialCartesian2DTuple, new double[]{values[2].getValue(), values[3].getValue()}));
            this.setLinePosition();
        }
        finally {
            this.settingPosition = false;
        }
    }

    private void setLinePosition() throws VisADException, RemoteException {
        Real[] ulReals = this.ulPoint.getPoint().getRealComponents();
        Real[] lrReals = this.lrPoint.getPoint().getRealComponents();
        float zValue = (float)this.constant.getValue();
        float left = (float)ulReals[0].getValue();
        float right = (float)lrReals[0].getValue();
        float top = (float)ulReals[1].getValue();
        float bottom = (float)lrReals[1].getValue();
        float[][] boxVals = new float[][]{{left, right, right, left, left}, {top, top, bottom, bottom, top}, {zValue, zValue, zValue, zValue, zValue}};
        Gridded3DSet boxData = new Gridded3DSet((MathType)RealTupleType.SpatialCartesian3DTuple, (float[][])boxVals, 5);
        if (!boxData.equals(this.box.getData())) {
            this.box.setData(boxData);
        }
    }
}

