/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import ucar.unidata.collab.Sharable;
import ucar.unidata.collab.SharableImpl;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Resource;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.display.Animation;
import ucar.visad.display.AnimationBoxPanel;
import ucar.visad.display.AnimationInfo;
import ucar.visad.display.AnimationPropertiesDialog;
import ucar.visad.display.AnimationSetInfo;
import ucar.visad.display.DisplayMaster;
import visad.DateTime;
import visad.Real;
import visad.Set;
import visad.VisADException;

public class AnimationWidget
extends SharableImpl
implements ActionListener {
    static int cnt = 0;
    int mycnt = cnt++;
    public static boolean bigIcon = false;
    private AnimationPropertiesDialog propertiesDialog;
    private PropertyChangeListener animationListener;
    private AnimationBoxPanel boxPanel;
    private boolean boxPanelVisible = true;
    private int timestamp = 0;
    private boolean showingPlayBtn = false;
    private static Icon stopIcon;
    private static Icon startIcon;
    public static final String CMD_INDEX = "CMD_INDEX";
    public static final String CMD_BEGINNING = "CMD_BEGINNING";
    public static final String CMD_BACKWARD = "CMD_BACKWARD";
    public static final String CMD_STARTSTOP = "CMD_STARTSTOP";
    public static final String CMD_FORWARD = "CMD_FORWARD";
    public static final String CMD_END = "CMD_END";
    public static final String CMD_PROPS = "CMD_PROPS";
    public static final String SHARE_VALUE = "SHARE_VALUE";
    public static final String SHARE_INDEX = "SHARE_INDEX";
    static final XmlUtil XU;
    AbstractButton startStopBtn;
    private Animation anime;
    private JComponent contents;
    private Real lastSharedValue;
    private boolean settingStartStop = false;
    private boolean ignoreAnimationSetChange = false;
    private AnimationInfo animationInfo;
    private JComboBox timesCbx = new JComboBox(){

        @Override
        public String getToolTipText(MouseEvent event) {
            if (AnimationWidget.this.boxPanel != null) {
                return AnimationWidget.this.boxPanel.getToolTipText();
            }
            return " ";
        }
    };
    private boolean timesCbxVisible = true;
    private Object timesCbxMutex;
    private DateTime[] timesArray;
    private boolean ignoreTimesCbxEvents = false;
    private boolean madeContents = false;
    int xcnt = 0;

    public AnimationWidget() {
        this(null, null, null);
    }

    public AnimationWidget(AnimationInfo info) {
        this(null, null, info);
    }

    public AnimationWidget(JFrame parentf) {
        this(parentf, null);
    }

    public AnimationWidget(JFrame parentf, Animation anim) {
        this(parentf, anim, null);
    }

    public AnimationWidget(JFrame parentf, Animation anim, AnimationInfo info) {
        super("AnimationWidget", true);
        this.timesCbx.setToolTipText("");
        this.timesCbxMutex = this.timesCbx.getTreeLock();
        this.timesCbx.setFont(new Font("Dialog", 0, 9));
        this.timesCbx.setLightWeightPopupEnabled(false);
        this.timesCbx.setVisible(false);
        this.timesCbx.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!AnimationWidget.this.ignoreTimesCbxEvents && AnimationWidget.this.anime != null) {
                    AnimationWidget.this.debug("got timesCbx event");
                    AnimationWidget.this.setTimeFromUser((Real)AnimationWidget.this.timesCbx.getSelectedItem());
                    if (AnimationWidget.this.boxPanel != null) {
                        AnimationWidget.this.boxPanel.setOnIndex(AnimationWidget.this.timesCbx.getSelectedIndex());
                    }
                }
            }
        });
        this.animationInfo = new AnimationInfo();
        if (anim != null) {
            this.setAnimation(anim);
        }
        if (this.anime != null) {
            this.animationInfo.set(this.anime.getAnimationInfo());
        }
        if (info != null) {
            this.setProperties(info);
            this.animationInfo.setRunning(info.getRunning());
        }
        this.boxPanel = new AnimationBoxPanel(this);
        if (this.timesArray != null) {
            this.updateBoxPanel(this.timesArray);
        }
    }

    public void showDateBox(boolean v) {
        this.timesCbxVisible = v;
        if (this.timesCbx != null) {
            this.timesCbx.setVisible(v);
        }
    }

    public void setBaseTimes(Set times) throws VisADException, RemoteException {
        this.getAnimationSetInfo().setBaseTimes(times);
        if (times != null) {
            if (this.anime != null) {
                if (this.getAnimationSetInfo().getActive()) {
                    Set newSet = this.getAnimationSetInfo().makeTimeSet((DisplayMaster)null);
                    this.anime.setSet(newSet);
                } else {
                    this.anime.setSet(times);
                }
                this.updateIndicator(this.anime.getSet());
            }
        } else {
            this.updateIndicator(null);
        }
    }

    public JComponent getContents() {
        return this.getContents(false);
    }

    public JComponent getContents(boolean floatToolBar) {
        if (this.contents == null) {
            this.initSharable();
            this.contents = this.doMakeContents(floatToolBar);
            if (this.animationInfo.getRunning()) {
                this.setRunning(true);
            }
        }
        return this.contents;
    }

    public Component getIndicatorComponent() {
        return this.timesCbx;
    }

    private String getIcon(String name) {
        if (name.equals("Information") && !bigIcon) {
            return "/auxdata/ui/icons/information.png";
        }
        return "/auxdata/ui/icons/" + name + (bigIcon ? "24" : "16") + ".gif";
    }

    private JComponent doMakeContents(boolean floatToolBar) {
        int height;
        String imgp = "/auxdata/ui/icons/";
        KeyAdapter listener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getSource() instanceof JComboBox) {
                    return;
                }
                int code = e.getKeyCode();
                char c = e.getKeyChar();
                if (code == 39 || code == 227) {
                    if (e.isShiftDown()) {
                        AnimationWidget.this.gotoIndex(AnimationWidget.this.anime.getNumSteps() - 1);
                    } else {
                        AnimationWidget.this.actionPerformed(AnimationWidget.CMD_FORWARD);
                    }
                } else if (code == 37 || code == 226) {
                    if (e.isShiftDown()) {
                        AnimationWidget.this.gotoIndex(0);
                    } else {
                        AnimationWidget.this.actionPerformed(AnimationWidget.CMD_BACKWARD);
                    }
                } else if (code == 10) {
                    AnimationWidget.this.actionPerformed(AnimationWidget.CMD_STARTSTOP);
                } else if (code == 80 && e.isControlDown()) {
                    AnimationWidget.this.actionPerformed(AnimationWidget.CMD_PROPS);
                } else if (Character.isDigit(c)) {
                    int step = new Integer("" + c) - 1;
                    if (step < 0) {
                        step = 0;
                    }
                    if (step >= AnimationWidget.this.anime.getNumSteps()) {
                        step = AnimationWidget.this.anime.getNumSteps() - 1;
                    }
                    AnimationWidget.this.gotoIndex(step);
                }
            }
        };
        ArrayList<JComponent> buttonList = new ArrayList<JComponent>();
        buttonList.add(this.timesCbx);
        this.setTimesInTimesBox();
        Dimension preferredSize = this.timesCbx.getPreferredSize();
        if (preferredSize != null && (height = preferredSize.height) < 50) {
            JComponent filler = GuiUtils.filler(3, height);
            buttonList.add(filler);
        }
        String[][] buttonInfo = new String[][]{{"Go to first frame", CMD_BEGINNING, this.getIcon("Rewind")}, {"One frame back", CMD_BACKWARD, this.getIcon("StepBack")}, {"Run/Stop", CMD_STARTSTOP, this.getIcon("Play")}, {"One frame forward", CMD_FORWARD, this.getIcon("StepForward")}, {"Go to last frame", CMD_END, this.getIcon("FastForward")}, {"Properties", CMD_PROPS, this.getIcon("Information")}};
        for (int i = 0; i < buttonInfo.length; ++i) {
            JButton btn = GuiUtils.getScaledImageButton(buttonInfo[i][2], this.getClass(), 2, 2);
            btn.setToolTipText(buttonInfo[i][0]);
            btn.setActionCommand(buttonInfo[i][1]);
            btn.addActionListener(this);
            btn.addKeyListener(listener);
            btn.setBorder(BorderFactory.createEtchedBorder(1));
            buttonList.add(btn);
            if (i != 2) continue;
            this.startStopBtn = btn;
        }
        JComponent contents = GuiUtils.hflow(buttonList, 1, 0);
        if (this.boxPanel == null) {
            this.boxPanel = new AnimationBoxPanel(this);
            if (this.timesArray != null) {
                this.updateBoxPanel(this.timesArray);
            }
        }
        this.boxPanel.addKeyListener(listener);
        if (!this.getBoxPanelVisible()) {
            this.boxPanel.setVisible(false);
        }
        contents = GuiUtils.doLayout(new Component[]{this.boxPanel, contents}, 1, GuiUtils.WT_Y, GuiUtils.WT_N);
        if (floatToolBar) {
            JToolBar toolbar = new JToolBar(0);
            toolbar.setFloatable(true);
            contents = GuiUtils.left(contents);
            toolbar.add(contents);
            contents = toolbar;
        }
        this.updateRunButton();
        this.madeContents = true;
        return contents;
    }

    private void debug(String msg) {
    }

    protected void applyProperties(AnimationInfo info, boolean andShare) {
        if (this.boxPanel != null) {
            this.boxPanel.applyProperties(this.propertiesDialog.boxPanel);
        }
        this.setProperties(info);
        if (andShare) {
            this.doShare((Object)CMD_PROPS, info);
        }
    }

    public void animationSetChanged() {
        if (this.propertiesDialog == null) {
            AnimationBoxPanel propertiesBoxPanel = new AnimationBoxPanel(null, this.boxPanel.getStepsOk());
            this.propertiesDialog = new AnimationPropertiesDialog(this, GuiUtils.getFrame(this.getContents()), propertiesBoxPanel);
            this.animationInfo.shared = this.getSharing();
            this.animationInfo.boxesVisible = this.getBoxPanelVisible();
            this.propertiesDialog.setInfo(this.animationInfo);
        }
        this.propertiesDialog.applyAnimationSetProperties();
    }

    protected void showPropertiesDialog() {
        if (this.propertiesDialog == null) {
            AnimationBoxPanel propertiesBoxPanel = new AnimationBoxPanel(null, this.boxPanel.getStepsOk());
            this.propertiesDialog = new AnimationPropertiesDialog(this, GuiUtils.getFrame(this.getContents()), propertiesBoxPanel);
            this.animationInfo.shared = this.getSharing();
            this.animationInfo.boxesVisible = this.getBoxPanelVisible();
            this.propertiesDialog.setInfo(this.animationInfo);
        }
        this.propertiesDialog.boxPanel.applyProperties(this.boxPanel);
        this.propertiesDialog.setVisible(true);
    }

    protected void boxPanelChanged(AnimationBoxPanel boxPanel) {
        if (this.propertiesDialog != null && this.boxPanel == boxPanel) {
            this.propertiesDialog.boxPanel.applyProperties(boxPanel);
        }
    }

    public void resetProperties() {
        this.setProperties(this.animationInfo);
    }

    public void setProperties(AnimationInfo transfer) {
        this.setBoxPanelVisible(transfer.getBoxesVisible());
        this.animationInfo.set(transfer);
        this.setSharing(this.animationInfo.shared);
        if (this.animationInfo.getAnimationGroup() != null) {
            this.setShareGroup(this.animationInfo.getAnimationGroup());
        }
        if (this.propertiesDialog != null) {
            this.propertiesDialog.setInfo(this.animationInfo);
        }
        try {
            if (this.anime != null) {
                this.anime.setAnimationInfo(this.animationInfo);
                DisplayMaster displayMaster = this.anime.getDisplayMaster();
                if (displayMaster != null) {
                    displayMaster.dataChange();
                } else if (this.getAnimationSetInfo().getActive()) {
                    this.anime.setSet(this.getAnimationSetInfo().makeTimeSet((DisplayMaster)null));
                } else {
                    this.anime.setSet(this.getAnimationSetInfo().getBaseTimes());
                }
            }
        }
        catch (Exception exp) {
            LogUtil.logException("Error setting properties", exp);
        }
        this.updateRunButton();
        this.checkAutoUpdate();
    }

    private void checkAutoUpdate() {
        ++this.timestamp;
        if (this.animationInfo.getAnimationSetInfo().usingCurrentTime()) {
            Misc.run(new Runnable(){

                @Override
                public void run() {
                    AnimationWidget.this.updateAnimationSet(++AnimationWidget.this.timestamp);
                }
            });
        }
    }

    protected DisplayMaster getDisplayMaster() {
        if (this.anime != null) {
            return this.anime.getDisplayMaster();
        }
        return null;
    }

    private void updateAnimationSet(int myTimestamp) {
        try {
            while (true) {
                long seconds = (long)(this.animationInfo.getAnimationSetInfo().getPollMinutes() * 60.0);
                Misc.sleepSeconds(seconds);
                DisplayMaster displayMaster = this.getDisplayMaster();
                if (displayMaster != null && this.anime != null && myTimestamp == this.timestamp) {
                    displayMaster.dataChange();
                    continue;
                }
                break;
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Error updating animation set", exc);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.actionPerformed(e.getActionCommand());
    }

    public void actionPerformed(String cmd) {
        if (cmd.equals(CMD_STARTSTOP)) {
            this.setRunning(!this.isRunning());
        } else if (cmd.equals(CMD_FORWARD)) {
            this.stepForward();
        } else if (cmd.equals(CMD_BACKWARD)) {
            this.stepBackward();
        } else if (cmd.equals(CMD_BEGINNING)) {
            this.gotoBeginning();
        } else if (cmd.equals(CMD_END)) {
            this.gotoEnd();
        } else if (cmd.equals(CMD_PROPS)) {
            this.showPropertiesDialog();
        }
    }

    protected void handleSharedTime(Real time) {
        if (this.anime != null) {
            this.anime.setAniValue(time);
        }
    }

    public void setTimeFromUser(Real time) {
        this.anime.setAniValue(time);
        this.shareValue();
    }

    @Override
    public void receiveShareData(Sharable from, Object dataId, Object[] data) {
        if (dataId.equals(SHARE_INDEX)) {
            if (this.anime != null) {
                this.anime.setCurrent((Integer)data[0]);
            }
        } else if (dataId.equals(SHARE_VALUE)) {
            Real sharedValue = (Real)data[0];
            this.debug("receiveShareData " + sharedValue);
            this.handleSharedTime(sharedValue);
        } else if (dataId.equals(CMD_STARTSTOP)) {
            this.setRunning((Boolean)data[0]);
        } else if (dataId.equals(CMD_FORWARD)) {
            this.stepForward();
        } else if (dataId.equals(CMD_BACKWARD)) {
            this.stepBackward();
        } else if (dataId.equals(CMD_BEGINNING)) {
            this.gotoBeginning();
        } else if (dataId.equals(CMD_END)) {
            this.gotoEnd();
        } else if (dataId.equals(CMD_PROPS)) {
            AnimationInfo newInfo = (AnimationInfo)data[0];
            if (this.propertiesDialog != null) {
                newInfo.shared = this.getSharing();
                this.propertiesDialog.setInfo(newInfo);
            }
            this.setProperties(newInfo);
        } else {
            super.receiveShareData(from, dataId, data);
        }
    }

    private void updateRunButton() {
        if (stopIcon == null) {
            stopIcon = Resource.getIcon(this.getIcon("Pause"), true);
            startIcon = Resource.getIcon(this.getIcon("Play"), true);
        }
        if (this.startStopBtn != null) {
            boolean running;
            boolean bl = running = this.isRunning() && this.haveTimes();
            if (running) {
                this.startStopBtn.setIcon(stopIcon);
                this.startStopBtn.setToolTipText("Stop animation");
            } else {
                this.startStopBtn.setIcon(startIcon);
                this.startStopBtn.setToolTipText("Start animation");
            }
        }
    }

    public void setRunning(boolean state) {
        if (this.settingStartStop) {
            return;
        }
        this.settingStartStop = true;
        this.animationInfo.setRunning(state);
        if (this.anime != null) {
            this.anime.setAnimating(state);
        }
        if (!state) {
            this.doShare((Object)CMD_STARTSTOP, new Boolean(state));
        }
        this.shareValue();
        this.updateRunButton();
        this.settingStartStop = false;
    }

    public boolean isRunning() {
        if (this.anime != null) {
            return this.anime.isAnimating();
        }
        return false;
    }

    public AnimationInfo getAnimationInfo() {
        return this.animationInfo;
    }

    public AnimationSetInfo getAnimationSetInfo() {
        return this.animationInfo.getAnimationSetInfo();
    }

    protected void shareIndex() {
        this.doShare((Object)SHARE_INDEX, new Integer(this.anime.getCurrent()));
    }

    protected void shareValue() {
        Animation myAnimation = this.anime;
        AnimationInfo myAnimationInfo = this.animationInfo;
        if (myAnimation != null && myAnimationInfo != null && myAnimation.getNumSteps() > 0) {
            if (this.animationInfo.getShareIndex()) {
                this.shareIndex();
            } else {
                this.shareValue(myAnimation.getAniValue());
            }
        }
    }

    protected void shareValue(Real time) {
        this.lastSharedValue = time;
        this.debug("shareValue:" + time);
        this.doShare((Object)SHARE_VALUE, time);
    }

    public void stepForward() {
        if (this.anime != null) {
            this.anime.takeStepForward();
        }
        this.shareValue();
    }

    protected void stepBackward() {
        if (this.anime != null) {
            this.anime.takeStepBackward();
        }
        this.shareValue();
    }

    public void gotoIndex(int index) {
        if (this.anime != null) {
            this.setRunning(false);
            this.anime.setCurrent(index, false);
        }
        this.shareValue();
    }

    public void gotoBeginning() {
        if (this.anime != null) {
            this.anime.setCurrent(0);
        }
        this.setRunning(false);
        this.shareValue();
    }

    public DateTime[] getTimes() {
        return this.anime.getTimes();
    }

    public void gotoEnd() {
        Set aset;
        if (this.anime != null && (aset = this.anime.getSet()) != null) {
            try {
                this.anime.setCurrent(aset.getLength() - 1);
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
        this.setRunning(false);
        this.shareValue();
    }

    public void stepsOkChanged(boolean[] stepsOk) {
        try {
            this.anime.setStepsOk(stepsOk);
        }
        catch (Exception exp) {
            LogUtil.logException("Error setting steps ok", exp);
        }
    }

    public void setAnimation(Animation newAnimation) {
        if (newAnimation == null) {
            throw new NullPointerException("Animation can't be null");
        }
        this.removeAnimationListener();
        this.anime = newAnimation;
        this.animationInfo.set(this.anime.getAnimationInfo());
        this.updateIndicator(this.anime.getSet());
        this.animationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AnimationWidget.this.handleAnimationPropertyChange(evt);
            }
        };
        this.anime.addPropertyChangeListener(this.animationListener);
    }

    private void handleAnimationPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("aniValue")) {
            this.debug("handleAnimationPropertyChange value :" + evt.getPropertyName());
            Real eventValue = (Real)evt.getNewValue();
            if (eventValue == null || eventValue.isMissing()) {
                return;
            }
            DateTime time = null;
            try {
                time = new DateTime(eventValue);
            }
            catch (VisADException visADException) {
                // empty catch block
            }
            final DateTime theDateTime = time;
            final int theIndex = this.anime != null ? this.anime.getCurrent() : -1;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean oldValue = AnimationWidget.this.ignoreTimesCbxEvents;
                    try {
                        AnimationWidget.this.ignoreTimesCbxEvents = true;
                        ++AnimationWidget.this.xcnt;
                        AnimationWidget.this.timesCbx.setSelectedItem(theDateTime);
                        if (AnimationWidget.this.boxPanel != null && theIndex >= 0) {
                            AnimationWidget.this.boxPanel.setOnIndex(theIndex);
                        }
                        AnimationWidget.this.timesCbx.repaint();
                    }
                    finally {
                        AnimationWidget.this.ignoreTimesCbxEvents = oldValue;
                    }
                }
            });
            this.shareValue();
        } else if (evt.getPropertyName().equals("animationSet")) {
            if (this.ignoreAnimationSetChange) {
                return;
            }
            this.updateIndicatorInner((Set)evt.getNewValue(), true);
        }
    }

    private void removeAnimationListener() {
        if (this.anime != null && this.animationListener != null) {
            this.anime.removePropertyChangeListener(this.animationListener);
            this.animationListener = null;
            this.anime = null;
        }
    }

    public void destroy() {
        this.removeSharable();
        this.removeAnimationListener();
        ++this.timestamp;
    }

    public void addAnimation(Animation anim) {
        this.setAnimation(anim);
    }

    public void updateIndicator(Set timeSet) {
        this.updateIndicatorInner(timeSet, false);
    }

    public DateTime getTimeAtIndex(int index) {
        if (this.anime == null) {
            return null;
        }
        if (this.timesArray == null) {
            this.timesArray = Animation.getDateTimeArray(this.anime.getSet());
        }
        if (this.timesArray == null || index < 0 || index >= this.timesArray.length) {
            return null;
        }
        return this.timesArray[index];
    }

    public DateTime[] getTimesArray() {
        return this.timesArray;
    }

    private boolean haveTimes() {
        return this.timesArray != null && this.timesArray.length > 0;
    }

    private void updateIndicatorInner(Set timeSet, boolean timeSetChange) {
        this.timesArray = Animation.getDateTimeArray(timeSet);
        if (this.timesArray.length == 0 && timeSetChange) {
            this.setRunning(false);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (AnimationWidget.this.madeContents) {
                    AnimationWidget.this.setTimesInTimesBox();
                    AnimationWidget.this.updateRunButton();
                }
            }
        });
        this.updateBoxPanel(this.timesArray);
    }

    private void setTimesInTimesBox() {
        Object[] theTimesArray = this.timesArray;
        if (theTimesArray == null) {
            return;
        }
        boolean oldValue = this.ignoreTimesCbxEvents;
        try {
            this.ignoreTimesCbxEvents = true;
            GuiUtils.setListData(this.timesCbx, theTimesArray);
            this.timesCbx.setVisible(this.timesCbxVisible && theTimesArray != null && this.timesCbx.getItemCount() > 0);
        }
        finally {
            this.ignoreTimesCbxEvents = oldValue;
        }
    }

    private void updateBoxPanel(DateTime[] timesArray) {
        if (this.boxPanel != null) {
            this.boxPanel.setNumTimes(timesArray.length);
            if (this.anime != null) {
                this.boxPanel.setOnIndex(this.anime.getCurrent());
            }
            if (this.propertiesDialog != null) {
                this.propertiesDialog.boxPanel.applyProperties(this.boxPanel);
            }
        }
    }

    public void setBoxPanelVisible(boolean value) {
        this.boxPanelVisible = value;
        if (this.boxPanel != null && this.boxPanel.isVisible() != this.boxPanelVisible) {
            this.boxPanel.setVisible(this.boxPanelVisible);
            if (this.boxPanel.getParent() != null) {
                this.boxPanel.getParent().doLayout();
            }
        }
    }

    public boolean getBoxPanelVisible() {
        return this.boxPanelVisible;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        AnimationWidget widget = new AnimationWidget(frame);
        frame.getContentPane().add(widget.getContents());
        frame.pack();
        frame.setVisible(true);
    }

    static {
        XU = null;
    }
}

