/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ucar.visad.data.CalendarDateTime;
import ucar.visad.display.DisplayMaster;
import visad.DateTime;
import visad.Set;
import visad.VisADException;

public class AnimationSetInfo {
    public static final int TIMEMODE_DATA = 0;
    public static final int TIMEMODE_CURRENT = 1;
    public static final int TIMEMODE_FIXED = 2;
    public static final int TIMEMODE_RELATIVE = 3;
    public static int[] TIMEMODES = new int[]{0, 1, 2, 3};
    public static String[] STARTMODELABELS = new String[]{"Use Minimum Time from All Data", "Current Time (Now)", "Fixed", "Relative to End Time"};
    public static String[] ENDMODELABELS = new String[]{"Use Maximum Time from All Data", "Current Time (Now)", "Fixed", "Relative to Start Time"};
    private long startFixedTime = Long.MAX_VALUE;
    private long endFixedTime = Long.MAX_VALUE;
    private long startOffsetMinutes = 0L;
    private long endOffsetMinutes = 0L;
    private double intervalMinutes = 15.0;
    private int startMode = 0;
    private int endMode = 0;
    private boolean active = false;
    private double pollMinutes = 5.0;
    private double roundTo = 1.0;
    private Set baseTimes;
    private boolean isTimeDriver;

    public AnimationSetInfo() {
    }

    public AnimationSetInfo(AnimationSetInfo that) {
        this.active = that.active;
        this.startMode = that.startMode;
        this.endMode = that.endMode;
        this.intervalMinutes = that.intervalMinutes;
        this.pollMinutes = that.pollMinutes;
        this.startOffsetMinutes = that.startOffsetMinutes;
        this.endOffsetMinutes = that.endOffsetMinutes;
        this.roundTo = that.roundTo;
        this.startFixedTime = that.startFixedTime;
        this.endFixedTime = that.endFixedTime;
        this.baseTimes = that.baseTimes;
        this.isTimeDriver = that.isTimeDriver;
    }

    public boolean equals(AnimationSetInfo that) {
        return this.active == that.active && this.startMode == that.startMode && this.endMode == that.endMode && this.intervalMinutes == that.intervalMinutes && this.pollMinutes == that.pollMinutes && this.startOffsetMinutes == that.startOffsetMinutes && this.endOffsetMinutes == that.endOffsetMinutes && this.roundTo == that.roundTo && this.startFixedTime == that.startFixedTime && this.endFixedTime == that.endFixedTime && this.baseTimes == that.baseTimes && this.isTimeDriver == that.isTimeDriver;
    }

    private double round(double seconds) {
        return AnimationSetInfo.roundTo(this.roundTo, seconds);
    }

    public static double roundTo(double roundTo, double seconds) {
        int roundToSeconds = (int)((long)roundTo * 60L);
        if (roundToSeconds == 0) {
            return seconds;
        }
        return seconds - (double)((long)seconds % (long)roundToSeconds);
    }

    protected void setBaseTimes(Set times) {
        this.baseTimes = times;
    }

    protected Set getBaseTimes() {
        return this.baseTimes;
    }

    protected Set makeTimeSet(DisplayMaster displayMaster) throws VisADException, RemoteException {
        double cnt;
        int i;
        double interval;
        ArrayList<CalendarDateTime> dateTimes = new ArrayList<CalendarDateTime>();
        long now = System.currentTimeMillis() / 1000L;
        long startSeconds = 0L;
        long endSeconds = 0L;
        double[][] dataTimeSet = null;
        if (this.startMode == 0 || this.endMode == 0) {
            Set timeSet;
            Set set = this.baseTimes != null ? this.baseTimes : (timeSet = displayMaster != null ? displayMaster.getAnimationSetFromDisplayables() : null);
            if (timeSet == null) {
                return null;
            }
            dataTimeSet = timeSet.getDoubles();
            if (dataTimeSet == null || dataTimeSet.length == 0 || dataTimeSet[0].length == 0) {
                return null;
            }
        }
        if ((interval = 60.0 * this.getIntervalMinutes()) == 0.0) {
            return null;
        }
        if (this.startMode == 0) {
            if (dataTimeSet != null) {
                double minValue = dataTimeSet[0][0];
                for (i = 1; i < dataTimeSet[0].length; ++i) {
                    minValue = Math.min(minValue, dataTimeSet[0][i]);
                }
                startSeconds = (long)minValue;
            } else {
                startSeconds = now;
            }
        } else if (this.startMode == 1) {
            startSeconds = now;
        } else if (this.startMode == 2) {
            startSeconds = this.startFixedTime / 1000L;
        }
        if (this.endMode == 0) {
            if (dataTimeSet != null) {
                double maxValue = dataTimeSet[0][0];
                for (i = 1; i < dataTimeSet[0].length; ++i) {
                    maxValue = Math.max(maxValue, dataTimeSet[0][i]);
                }
                endSeconds = (long)maxValue;
            } else {
                endSeconds = now;
            }
        } else if (this.endMode == 1) {
            endSeconds = now;
        } else if (this.endMode == 2) {
            endSeconds = this.endFixedTime / 1000L;
        }
        if (this.startMode != 3) {
            startSeconds += this.startOffsetMinutes * 60L;
            startSeconds = (long)this.round(startSeconds);
        }
        if (this.endMode != 3) {
            endSeconds += this.endOffsetMinutes * 60L;
            endSeconds = (long)this.round(endSeconds);
        }
        if (this.startMode == 3) {
            startSeconds = endSeconds + this.startOffsetMinutes * 60L;
            startSeconds = (long)this.round(startSeconds);
        }
        if (this.endMode == 3) {
            endSeconds = startSeconds + this.endOffsetMinutes * 60L;
            endSeconds = (long)this.round(endSeconds);
        }
        if ((cnt = (double)((int)(endSeconds - startSeconds)) / interval) > 10000.0) {
            throw new IllegalStateException("Too many times in animation set:" + cnt);
        }
        while (startSeconds <= endSeconds) {
            dateTimes.add(0, new CalendarDateTime((double)startSeconds, null));
            startSeconds = (long)((double)startSeconds + interval);
        }
        if (dateTimes.size() == 0) {
            return null;
        }
        return this.makeTimeSet(dateTimes);
    }

    private Set makeTimeSet(List dateTimes) throws VisADException, RemoteException {
        DateTime[] dateTimeArray = new DateTime[dateTimes.size()];
        for (int i = 0; i < dateTimes.size(); ++i) {
            dateTimeArray[i] = (DateTime)dateTimes.get(i);
        }
        return CalendarDateTime.makeTimeSet(dateTimeArray);
    }

    public boolean usingCurrentTime() {
        return this.active && (this.startMode == 1 || this.endMode == 1);
    }

    public void setActive(boolean value) {
        this.active = value;
    }

    public boolean getActive() {
        return this.active;
    }

    public void setStartMode(int value) {
        this.startMode = value;
    }

    public int getStartMode() {
        return this.startMode;
    }

    public void setEndMode(int value) {
        this.endMode = value;
    }

    public int getEndMode() {
        return this.endMode;
    }

    public void setIntervalMinutes(double value) {
        this.intervalMinutes = value;
    }

    public double getIntervalMinutes() {
        return this.intervalMinutes;
    }

    public void setPollMinutes(double value) {
        this.pollMinutes = value;
        if (this.pollMinutes < 0.1) {
            this.pollMinutes = 0.1;
        }
    }

    public double getPollMinutes() {
        return this.pollMinutes;
    }

    public void setStartOffsetMinutes(double value) {
        this.startOffsetMinutes = (long)value;
    }

    public double getStartOffsetMinutes() {
        return this.startOffsetMinutes;
    }

    public void setEndOffsetMinutes(double value) {
        this.endOffsetMinutes = (long)value;
    }

    public double getEndOffsetMinutes() {
        return this.endOffsetMinutes;
    }

    public void setRoundTo(double value) {
        this.roundTo = value;
    }

    public double getRoundTo() {
        return this.roundTo;
    }

    public void setStartFixedTime(long value) {
        this.startFixedTime = value;
    }

    public void setStartFixedTime(Date d) {
        this.startFixedTime = d.getTime();
    }

    public void setEndFixedTime(Date d) {
        this.endFixedTime = d.getTime();
    }

    public Date getStartFixedDate() {
        return new Date(this.getStartFixedTime());
    }

    public Date getEndFixedDate() {
        return new Date(this.getEndFixedTime());
    }

    public long getStartFixedTime() {
        if (this.startFixedTime == Long.MAX_VALUE) {
            this.startFixedTime = System.currentTimeMillis();
        }
        return this.startFixedTime;
    }

    public void setEndFixedTime(long value) {
        this.endFixedTime = value;
    }

    public long getEndFixedTime() {
        if (this.endFixedTime == Long.MAX_VALUE) {
            this.endFixedTime = System.currentTimeMillis();
        }
        return this.endFixedTime;
    }

    public boolean getIsTimeDriver() {
        return this.isTimeDriver;
    }

    public void setIsTimeDriver(boolean yesorno) {
        this.isTimeDriver = yesorno;
    }
}

