/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import ucar.nc2.time.Calendar;
import ucar.unidata.ui.DateTimePicker;
import ucar.unidata.ui.TimeLengthField;
import ucar.unidata.ui.Timeline;
import ucar.unidata.util.DatedObject;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.Util;
import ucar.visad.data.CalendarDateTime;
import ucar.visad.display.Animation;
import ucar.visad.display.AnimationBoxPanel;
import ucar.visad.display.AnimationInfo;
import ucar.visad.display.AnimationSetInfo;
import ucar.visad.display.AnimationWidget;
import visad.CommonUnit;
import visad.DateTime;
import visad.Set;
import visad.VisADException;

public class AnimationPropertiesDialog
extends JDialog
implements ActionListener,
ChangeListener {
    private List resetList;
    private boolean ok;
    private JSlider fwdSlider;
    private JSlider backSlider;
    private JSlider startSlider;
    private JSlider endSlider;
    private JTextField fwdField;
    private JTextField backField;
    private JTextField startField;
    private JTextField endField;
    private JRadioButton shareNoneBtn;
    private JRadioButton shareAbsBtn;
    private JRadioButton shareRelBtn;
    private JCheckBox boxesVisibleButton;
    private JButton predefinedBtn;
    private JComboBox dirCbx;
    private JCheckBox saveAsPrototypeCbx;
    private JComboBox resetCbx;
    private AnimationInfo myInfo = new AnimationInfo();
    private AnimationWidget animationWidget;
    AnimationBoxPanel boxPanel;
    private JComponent setContents;
    private TimeLengthField intervalField;
    private TimeLengthField startOffsetField;
    private TimeLengthField endOffsetField;
    private TimeLengthField roundToField;
    private GuiUtils.CardLayoutPanel startExtra;
    private GuiUtils.CardLayoutPanel endExtra;
    private JLabel startDataModeLabel;
    private JLabel endDataModeLabel;
    private JLabel startCurrentModeLabel;
    private JLabel endCurrentModeLabel;
    private JLabel startRelativeModeLabel;
    private JLabel endRelativeModeLabel;
    private JTextField pollIntervalFld;
    private JRadioButton animationSetNotActiveBtn;
    private JRadioButton animationSetActiveBtn;
    private JComboBox startTimeBox;
    private JComboBox endTimeBox;
    private DateTimePicker startTimePicker;
    private DateTimePicker endTimePicker;
    List baseTimeList = new ArrayList();
    List pollList = new ArrayList();
    List intervalList = new ArrayList();
    private String intervalText = "";
    private boolean okToUpdate = false;
    private Timeline timeline;
    private JCheckBox timeDriverCbx;
    String[] PREDEFINED_METHODS = new String[]{"predefinedDataRange", "predefinedRealTime"};
    String[] PREDEFINED_LABELS = new String[]{"Uniform Across Data Range", "Real Time"};
    TimeLengthField predefinedIntervalField;
    JDialog predefinedDialog;

    public AnimationPropertiesDialog(AnimationWidget animationWidget, JFrame parent, AnimationBoxPanel boxPanel) {
        super(parent, "Time Animation Properties", false);
        JTabbedPane tabbedPane = new JTabbedPane();
        this.boxPanel = boxPanel;
        this.animationWidget = animationWidget;
        this.dirCbx = new JComboBox(new Vector(Misc.newList("Forward", "Backward", "Rocking")));
        this.dirCbx.setToolTipText("<html>Set loop direction</html>");
        this.boxesVisibleButton = new JCheckBox("Boxes Visible", this.myInfo.getBoxesVisible());
        this.resetList = Misc.newList(new TwoFacedObject((Object)"Start Time", "reset.beginning"), new TwoFacedObject((Object)"No Change", "reset.current"), new TwoFacedObject((Object)"End Time", "reset.end"));
        this.resetCbx = new JComboBox(new Vector(this.resetList));
        this.resetCbx.setToolTipText("When there are new times in the display what should happen?");
        boolean shared = this.myInfo.getShared();
        boolean shareIndex = this.myInfo.getShareIndex();
        this.shareNoneBtn = new JRadioButton("None", !shared);
        this.shareNoneBtn.setToolTipText("Don't share times");
        this.shareAbsBtn = new JRadioButton("Absolute", shared && !shareIndex);
        this.shareAbsBtn.setToolTipText("Share absolute time step");
        this.shareRelBtn = new JRadioButton("Relative", shared && shareIndex);
        this.shareRelBtn.setToolTipText("Share relative time step");
        GuiUtils.buttonGroup(this.shareNoneBtn, this.shareAbsBtn).add(this.shareRelBtn);
        JPanel sharingComponent = GuiUtils.hbox((Component)this.shareNoneBtn, (Component)this.shareAbsBtn, this.shareRelBtn);
        this.startField = this.makeField();
        this.endField = this.makeField();
        this.fwdField = this.makeField();
        this.backField = this.makeField();
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        JPanel dwellPanel = GuiUtils.doLayout(new Component[]{GuiUtils.rLabel("Forward:"), GuiUtils.left(GuiUtils.hbox(this.fwdField, this.makeSlider(this.fwdField))), GuiUtils.rLabel("First:"), GuiUtils.left(GuiUtils.hbox(this.startField, this.makeSlider(this.startField))), GuiUtils.rLabel("Reverse:"), GuiUtils.left(GuiUtils.hbox(this.backField, this.makeSlider(this.backField))), GuiUtils.rLabel("Last:"), GuiUtils.left(GuiUtils.hbox(this.endField, this.makeSlider(this.endField)))}, 4, GuiUtils.WT_NN, GuiUtils.WT_N);
        GuiUtils.tmpInsets = new Insets(5, 5, 5, 5);
        this.timeline = new Timeline(new ArrayList(), 300);
        this.timeline.setIsCapableOfSelection(false);
        JComponent top = GuiUtils.formLayout(new Component[]{GuiUtils.rLabel("Dwell:"), GuiUtils.left(dwellPanel), GuiUtils.rLabel("Direction:"), GuiUtils.left(this.dirCbx), GuiUtils.rLabel("Share Times:"), GuiUtils.left(sharingComponent), GuiUtils.filler(), GuiUtils.left(animationWidget.getSharablePropertiesComponent()), GuiUtils.rLabel("Skip Steps:"), GuiUtils.left(GuiUtils.hbox(this.boxesVisibleButton, boxPanel)), GuiUtils.rLabel("Reset To:"), GuiUtils.left(GuiUtils.hbox(this.resetCbx, GuiUtils.lLabel("  When the time set has changed")))});
        top = GuiUtils.top(top);
        JPanel buttons = GuiUtils.makeApplyOkCancelButtons(this);
        this.saveAsPrototypeCbx = new JCheckBox("Save As Default", false);
        if (Misc.getPrototypeManager() != null) {
            buttons = GuiUtils.wrap(GuiUtils.hbox((Component)buttons, this.saveAsPrototypeCbx));
        }
        JPanel mainContents = GuiUtils.inset((Component)top, 5);
        JPanel contents = GuiUtils.centerBottom(GuiUtils.inset((Component)tabbedPane, 5), buttons);
        tabbedPane.add("Settings", mainContents);
        tabbedPane.add("Define Animation Times", GuiUtils.inset((Component)GuiUtils.top(this.getAnimationSetComponent()), 5));
        this.setInfo(this.myInfo);
        this.getContentPane().add("Center", contents);
        this.pack();
        this.setLocation(300, 100);
        this.okToUpdate = true;
    }

    private DateTime[] getAnimationTimes() throws VisADException, RemoteException {
        Set timeSet = this.animationWidget.getAnimationSetInfo().getBaseTimes();
        if (timeSet == null && this.animationWidget.getDisplayMaster() != null) {
            timeSet = this.animationWidget.getDisplayMaster().getAnimationSetFromDisplayables();
        }
        DateTime[] timesArray = Animation.getDateTimeArray(timeSet);
        return timesArray;
    }

    private void updateLabels() {
        try {
            if (!this.okToUpdate) {
                return;
            }
            this.updateTimeline();
            DateTime[] timesArray = this.getAnimationTimes();
            double startOffset = this.startOffsetField.getTime() * 60.0;
            double endOffset = this.endOffsetField.getTime() * 60.0;
            DateTime min = null;
            DateTime max = null;
            if (timesArray.length > 0) {
                Calendar cal = null;
                if (timesArray[0] instanceof CalendarDateTime) {
                    cal = ((CalendarDateTime)timesArray[0]).getCalendar();
                }
                min = timesArray[0];
                max = timesArray[timesArray.length - 1];
                double minSeconds = min.getValue(CommonUnit.secondsSinceTheEpoch);
                min = new CalendarDateTime(AnimationSetInfo.roundTo(this.roundToField.getTime(), minSeconds) + startOffset, cal);
                double maxSeconds = max.getValue(CommonUnit.secondsSinceTheEpoch);
                max = new CalendarDateTime(AnimationSetInfo.roundTo(this.roundToField.getTime(), maxSeconds) + endOffset, cal);
            }
            String startDataText = min != null ? min.toString() : "";
            String endDataText = max != null ? max.toString() : "";
            this.startDataModeLabel.setText(startDataText);
            this.endDataModeLabel.setText(endDataText);
            double now = System.currentTimeMillis() / 1000L;
            now = AnimationSetInfo.roundTo(this.roundToField.getTime(), now);
            this.startCurrentModeLabel.setText(new DateTime(now + startOffset).toString());
            this.endCurrentModeLabel.setText(new DateTime(now + endOffset).toString());
        }
        catch (Exception exc) {
            LogUtil.logException("Error initializing dialog", exc);
        }
    }

    private JComponent makeSlider(final JTextField field) {
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider slide = (JSlider)e.getSource();
                if (slide.getValueIsAdjusting()) {
                    // empty if block
                }
                AnimationPropertiesDialog.this.setFieldFromSlider(slide, field);
            }
        };
        JComponent[] comps = GuiUtils.makeSliderPopup(5, 1000, 50, listener);
        ((JSlider)comps[1]).setMinorTickSpacing(5);
        if (field == this.fwdField) {
            this.fwdSlider = (JSlider)comps[1];
        }
        if (field == this.backField) {
            this.backSlider = (JSlider)comps[1];
        }
        if (field == this.startField) {
            this.startSlider = (JSlider)comps[1];
        }
        if (field == this.endField) {
            this.endSlider = (JSlider)comps[1];
        }
        return comps[0];
    }

    private JComponent addTo(JComponent comp, List comps) {
        comps.add(comp);
        return comp;
    }

    private JComponent getAnimationSetComponent() {
        this.predefinedBtn = GuiUtils.makeButton("Predefined", this, "popupPredefinedMenu");
        this.pollIntervalFld = new JTextField("", 4);
        this.intervalField = new TimeLengthField("Interval", true);
        this.startOffsetField = new TimeLengthField("Start Offset"){

            @Override
            public void timeChanged() {
                super.timeChanged();
                AnimationPropertiesDialog.this.updateLabels();
            }
        };
        this.endOffsetField = new TimeLengthField("End Offset"){

            @Override
            public void timeChanged() {
                super.timeChanged();
                AnimationPropertiesDialog.this.updateLabels();
            }
        };
        this.roundToField = new TimeLengthField("Round To Value", true){

            @Override
            public void timeChanged() {
                super.timeChanged();
                AnimationPropertiesDialog.this.updateLabels();
            }
        };
        this.animationSetNotActiveBtn = new JRadioButton("Use all times from data");
        this.animationSetActiveBtn = new JRadioButton("Define your own list of times");
        GuiUtils.buttonGroup(this.animationSetNotActiveBtn, this.animationSetActiveBtn);
        this.animationSetActiveBtn.addChangeListener(this);
        this.startTimeBox = GuiUtils.makeComboBox(AnimationSetInfo.TIMEMODES, AnimationSetInfo.STARTMODELABELS, 0);
        ActionListener boxListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AnimationPropertiesDialog.this.checkEnabled();
                AnimationPropertiesDialog.this.updateLabels();
            }
        };
        this.startTimeBox.addActionListener(boxListener);
        this.endTimeBox = GuiUtils.makeComboBox(AnimationSetInfo.TIMEMODES, AnimationSetInfo.ENDMODELABELS, 0);
        this.endTimeBox.addActionListener(boxListener);
        Date startDate = null;
        Date endDate = null;
        this.startTimePicker = new DateTimePicker(startDate);
        this.endTimePicker = new DateTimePicker(endDate);
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        JPanel startOffsetPanel = GuiUtils.hbox(new JLabel("  Offset: "), this.startOffsetField.getContents());
        JPanel endOffsetPanel = GuiUtils.hbox(new JLabel("  Offset: "), this.endOffsetField.getContents());
        JPanel startDetails = GuiUtils.hbox(this.startTimeBox, startOffsetPanel);
        JPanel endDetails = GuiUtils.hbox(this.endTimeBox, endOffsetPanel);
        this.startExtra = new GuiUtils.CardLayoutPanel();
        this.endExtra = new GuiUtils.CardLayoutPanel();
        JPanel startPickerPanel = GuiUtils.inset((Component)GuiUtils.left(this.startTimePicker), new Insets(5, 0, 0, 0));
        JPanel endPickerPanel = GuiUtils.inset((Component)GuiUtils.left(this.endTimePicker), new Insets(5, 0, 0, 0));
        this.startDataModeLabel = new JLabel(" ");
        this.endDataModeLabel = new JLabel(" ");
        this.startRelativeModeLabel = new JLabel(" ");
        this.endRelativeModeLabel = new JLabel(" ");
        this.startCurrentModeLabel = new JLabel(" ");
        this.endCurrentModeLabel = new JLabel(" ");
        this.startExtra.add("0", this.startDataModeLabel);
        this.endExtra.add("0", this.endDataModeLabel);
        this.startExtra.add("1", this.startCurrentModeLabel);
        this.endExtra.add("1", this.endCurrentModeLabel);
        this.startExtra.add("3", this.startRelativeModeLabel);
        this.endExtra.add("3", this.endRelativeModeLabel);
        this.startExtra.add("2", startPickerPanel);
        this.endExtra.add("2", endPickerPanel);
        comps.add(GuiUtils.rLabel("Start Time:"));
        comps.add(GuiUtils.left(GuiUtils.vbox((Component)startDetails, this.startExtra)));
        comps.add(GuiUtils.rLabel("End Time:"));
        comps.add(GuiUtils.left(GuiUtils.vbox((Component)endDetails, this.endExtra)));
        comps.add(this.addTo(GuiUtils.rLabel("Interval:"), this.intervalList));
        comps.add(GuiUtils.left(this.addTo(this.intervalField.getContents(), this.intervalList)));
        comps.add(GuiUtils.rLabel("Round To:"));
        comps.add(GuiUtils.left(this.roundToField.getContents()));
        JPanel pollIntervalPanel = GuiUtils.hbox(new Component[]{this.pollIntervalFld, GuiUtils.lLabel(" minutes")});
        comps.add(this.addTo(GuiUtils.rLabel("Refresh Rate:"), this.pollList));
        comps.add(GuiUtils.left(this.addTo(pollIntervalPanel, this.pollList)));
        this.timeDriverCbx = new JCheckBox("", this.animationWidget.getAnimationSetInfo().getIsTimeDriver());
        comps.add(GuiUtils.rLabel("Set as Time Driver:"));
        comps.add(this.timeDriverCbx);
        GuiUtils.tmpInsets = new Insets(10, 5, 5, 5);
        this.setContents = GuiUtils.top(GuiUtils.doLayout(comps, 2, GuiUtils.WT_NN, GuiUtils.WT_N));
        return GuiUtils.vbox(GuiUtils.left(this.animationSetNotActiveBtn), GuiUtils.left(GuiUtils.hbox(this.animationSetActiveBtn, this.predefinedBtn)), GuiUtils.inset(GuiUtils.filler(), 5), this.setContents);
    }

    public void popupPredefinedMenu() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        for (int i = 0; i < this.PREDEFINED_METHODS.length; ++i) {
            items.add(GuiUtils.makeMenuItem(this.PREDEFINED_LABELS[i], this, this.PREDEFINED_METHODS[i]));
        }
        GuiUtils.showPopupMenu(items, this.predefinedBtn);
    }

    private JComponent getPredefinedInterval() {
        if (this.predefinedIntervalField == null) {
            this.predefinedIntervalField = new TimeLengthField("Interval", true, false);
        }
        this.predefinedIntervalField.setTime(this.intervalField.getTime());
        return this.predefinedIntervalField.getFieldsComponent(true);
    }

    private boolean applyPredefinedInterval() {
        if (!this.predefinedIntervalField.applyFields(true)) {
            return false;
        }
        this.intervalField.setTime(this.predefinedIntervalField.getTime());
        return true;
    }

    public void predefinedDataRange() {
        String label = "Configure the animation set to run from start time of data to end time with a uniform time step";
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        comps.add(GuiUtils.rLabel("Time Step Every:"));
        comps.add(this.getPredefinedInterval());
        GuiUtils.tmpInsets = GuiUtils.INSETS_5;
        JPanel contents = GuiUtils.doLayout(comps, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        do {
            if (this.showPredefined(contents, label, "Uniform Data Range")) continue;
            return;
        } while (!this.applyPredefinedInterval());
        this.startTimeBox.setSelectedIndex(0);
        this.endTimeBox.setSelectedIndex(0);
    }

    public void predefinedRealTime() {
        TimeLengthField widthField = new TimeLengthField("Interval", true, false);
        widthField.setTime(this.startOffsetField.getTime());
        String label = "Configure the animation set to run from current time (now) back an amount of time";
        ArrayList<JComponent> comps = new ArrayList<JComponent>();
        JTextField pollIntervalFld = new JTextField(this.pollIntervalFld.getText(), 4);
        JPanel pollIntervalPanel = GuiUtils.hbox(new Component[]{pollIntervalFld, GuiUtils.lLabel(" minutes")});
        comps.add(GuiUtils.rLabel("Time Length:"));
        comps.add(GuiUtils.left(widthField.getFieldsComponent(true)));
        comps.add(GuiUtils.rLabel("Time Step Every:"));
        comps.add(this.getPredefinedInterval());
        comps.add(GuiUtils.rLabel("Update Every:"));
        comps.add(GuiUtils.left(pollIntervalPanel));
        GuiUtils.tmpInsets = GuiUtils.INSETS_5;
        JPanel contents = GuiUtils.doLayout(comps, 2, GuiUtils.WT_NY, GuiUtils.WT_N);
        boolean ok = false;
        while (!ok) {
            ok = true;
            if (!this.showPredefined(contents, label, "Real Time")) {
                return;
            }
            if (!this.applyPredefinedInterval()) {
                ok = false;
            }
            if (widthField.applyFields(true)) continue;
            ok = false;
        }
        this.startOffsetField.setTime(-widthField.getTime());
        this.pollIntervalFld.setText(pollIntervalFld.getText());
        this.startTimeBox.setSelectedIndex(3);
        this.endTimeBox.setSelectedIndex(1);
    }

    private boolean showPredefined(JComponent contents, String label, String title) {
        this.predefinedDialog = new JDialog(this, title, true);
        final boolean[] ok = new boolean[]{false};
        JButton okBtn = new JButton("OK");
        okBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ok[0] = true;
                AnimationPropertiesDialog.this.predefinedDialog.dispose();
            }
        });
        JButton cancelBtn = new JButton("Cancel");
        cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AnimationPropertiesDialog.this.predefinedDialog.dispose();
            }
        });
        JPanel buttons = GuiUtils.hbox((Component)okBtn, (Component)cancelBtn, 5);
        JLabel lbl = new JLabel(label);
        contents = GuiUtils.topCenterBottom(GuiUtils.inset((Component)lbl, 10), GuiUtils.inset((Component)contents, 10), GuiUtils.inset((Component)GuiUtils.wrap(buttons), 10));
        this.predefinedDialog.getContentPane().add(contents);
        this.predefinedDialog.setLocation(this.predefinedBtn.getLocationOnScreen());
        this.predefinedDialog.pack();
        this.predefinedDialog.setVisible(true);
        return ok[0];
    }

    private double getNum(String t) {
        this.intervalText = t = t.trim();
        if (t.length() == 0) {
            return 0.0;
        }
        return new Double(t);
    }

    protected boolean applyAnimationSetProperties() {
        AnimationSetInfo aniSet = this.myInfo.getAnimationSetInfo();
        aniSet.setActive(this.animationSetActiveBtn.isSelected());
        aniSet.setIsTimeDriver(this.timeDriverCbx.isSelected());
        int startMode = GuiUtils.getValueFromBox(this.startTimeBox);
        int endMode = GuiUtils.getValueFromBox(this.endTimeBox);
        if (startMode == endMode && startMode == 3) {
            LogUtil.userErrorMessage("You cannot set both times to be relative");
            return false;
        }
        try {
            String msg;
            double startOffset = this.startOffsetField.getTime();
            double endOffset = this.endOffsetField.getTime();
            if (startMode == 3) {
                while (startOffset > 0.0) {
                    msg = "<html>The start offset is postitive which will result in a start time after the end time<br>Do you want to change the value to:</html>";
                    this.startOffsetField.setTime(-startOffset);
                    if (!this.startOffsetField.showDialog(msg)) {
                        this.startOffsetField.setTime(startOffset);
                        return false;
                    }
                    startOffset = this.startOffsetField.getTime();
                }
            }
            if (endMode == 3) {
                while (endOffset < 0.0) {
                    msg = "<html>The end offset is negative which will result in an end before the start time.<br>Do you want to change the value to:</html>";
                    this.endOffsetField.setTime(-endOffset);
                    if (!this.endOffsetField.showDialog(msg)) {
                        this.endOffsetField.setTime(endOffset);
                        return false;
                    }
                    endOffset = this.endOffsetField.getTime();
                }
            }
            aniSet.setPollMinutes(this.getNum(this.pollIntervalFld.getText()));
            aniSet.setIntervalMinutes(this.intervalField.getTime());
            aniSet.setStartOffsetMinutes(startOffset);
            aniSet.setEndOffsetMinutes(endOffset);
            aniSet.setRoundTo(this.roundToField.getTime());
            aniSet.setStartMode(startMode);
            aniSet.setEndMode(endMode);
        }
        catch (NumberFormatException nfe) {
            LogUtil.userErrorMessage("Bad value:" + this.intervalText);
            return false;
        }
        try {
            if (aniSet.getStartMode() == 2) {
                aniSet.setStartFixedTime(this.startTimePicker.getDate());
            }
            if (aniSet.getEndMode() == 2) {
                aniSet.setEndFixedTime(this.endTimePicker.getDate());
            }
        }
        catch (NumberFormatException nfe) {
            LogUtil.userErrorMessage("Bad value:" + nfe);
            return false;
        }
        return true;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.updateTimeline();
        }
        super.setVisible(visible);
    }

    protected void checkEnabled() {
        this.startExtra.show("" + this.startTimeBox.getSelectedIndex());
        this.endExtra.show("" + this.endTimeBox.getSelectedIndex());
        int startMode = GuiUtils.getValueFromBox(this.startTimeBox);
        int endMode = GuiUtils.getValueFromBox(this.endTimeBox);
        if (this.animationSetActiveBtn.isSelected()) {
            GuiUtils.enableTree(this.setContents, true);
            this.predefinedBtn.setEnabled(true);
            GuiUtils.enableComponents(this.pollList, startMode == 1 || endMode == 1);
        } else {
            GuiUtils.enableTree(this.setContents, false);
            this.predefinedBtn.setEnabled(false);
        }
    }

    protected void updateAnimationSetProperties() {
        AnimationSetInfo aniSet = this.myInfo.getAnimationSetInfo();
        this.animationSetActiveBtn.setSelected(aniSet.getActive());
        this.animationSetNotActiveBtn.setSelected(!aniSet.getActive());
        GuiUtils.setValueOfBox(this.startTimeBox, aniSet.getStartMode(), AnimationSetInfo.TIMEMODES, AnimationSetInfo.STARTMODELABELS);
        GuiUtils.setValueOfBox(this.endTimeBox, aniSet.getEndMode(), AnimationSetInfo.TIMEMODES, AnimationSetInfo.ENDMODELABELS);
        this.intervalField.setTime(aniSet.getIntervalMinutes());
        this.startOffsetField.setTime(aniSet.getStartOffsetMinutes());
        this.endOffsetField.setTime(aniSet.getEndOffsetMinutes());
        this.roundToField.setTime(aniSet.getRoundTo());
        this.pollIntervalFld.setText("" + aniSet.getPollMinutes());
        this.startTimePicker.setDate(aniSet.getStartFixedDate());
        this.endTimePicker.setDate(aniSet.getEndFixedDate());
        this.timeDriverCbx.setSelected(aniSet.getIsTimeDriver());
        this.checkEnabled();
    }

    private JTextField makeField() {
        JTextField textField = new JTextField("     ", 5);
        textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                AnimationPropertiesDialog.this.setSlidersFromFields();
            }
        });
        return textField;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.checkEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_APPLY)) {
            if (!this.applyAnimationSetProperties()) {
                return;
            }
            this.myInfo.setResetPolicy(TwoFacedObject.getIdString(this.resetCbx.getSelectedItem()));
            try {
                this.myInfo.setFwdSpeed((float)Misc.parseNumber(this.fwdField.getText().trim()));
                this.myInfo.setBackSpeed((float)Misc.parseNumber(this.backField.getText().trim()));
                this.myInfo.setStartDwell((float)Misc.parseNumber(this.startField.getText().trim()));
                this.myInfo.setEndDwell((float)Misc.parseNumber(this.endField.getText().trim()));
            }
            catch (NumberFormatException nfe) {
                LogUtil.userErrorMessage("Bad number format:" + nfe);
                return;
            }
            int dirIdx = this.dirCbx.getSelectedIndex();
            this.myInfo.setRocking(dirIdx == 2);
            this.myInfo.setDirection(dirIdx == 0);
            this.myInfo.setShared(this.shareAbsBtn.isSelected() || this.shareRelBtn.isSelected());
            this.myInfo.setShareIndex(this.shareRelBtn.isSelected());
            this.myInfo.setBoxesVisible(this.boxesVisibleButton.isSelected());
            this.animationWidget.applySharableProperties();
            this.myInfo.setAnimationGroup((String)this.animationWidget.getShareGroup());
            if (this.saveAsPrototypeCbx.isSelected() && Misc.getPrototypeManager() != null) {
                Misc.getPrototypeManager().writePrototype(this.myInfo);
            }
            this.animationWidget.applyProperties(this.myInfo, false);
        }
        if (cmd.equals(GuiUtils.CMD_OK) || cmd.equals(GuiUtils.CMD_CANCEL)) {
            this.setVisible(false);
        }
    }

    private void setSlidersFromFields() {
        this.setSliderFromField(this.fwdField, this.fwdSlider);
        this.setSliderFromField(this.backField, this.backSlider);
        this.setSliderFromField(this.startField, this.startSlider);
        this.setSliderFromField(this.endField, this.endSlider);
    }

    private void setSliderFromField(JTextField field, JSlider bar) {
        try {
            double v = Math.max(0.01, Misc.parseValue(field.getText().trim()));
            bar.setValue((int)(v * 100.0));
            field.setText("" + v);
        }
        catch (NumberFormatException nfe) {
            LogUtil.userErrorMessage("Bad number format:" + field.getText().trim());
        }
    }

    private void setFieldFromSlider(JSlider bar, JTextField field) {
        int rawValue = bar.getValue();
        rawValue -= rawValue % 5;
        field.setText((float)rawValue / 100.0f + "");
    }

    protected void setInfo(AnimationInfo transfer) {
        this.myInfo.set(transfer);
        this.fwdField.setText("" + this.myInfo.getFwdSpeed());
        this.backField.setText("" + this.myInfo.getBackSpeed());
        this.startField.setText("" + this.myInfo.getStartDwell());
        this.endField.setText("" + this.myInfo.getEndDwell());
        this.setSlidersFromFields();
        if (this.myInfo.getRocking()) {
            this.dirCbx.setSelectedIndex(2);
        } else if (this.myInfo.getDirection()) {
            this.dirCbx.setSelectedIndex(0);
        } else {
            this.dirCbx.setSelectedIndex(1);
        }
        boolean shared = this.myInfo.getShared();
        boolean shareIndex = this.myInfo.getShareIndex();
        this.shareAbsBtn.setSelected(shared && !shareIndex);
        this.shareRelBtn.setSelected(shared && shareIndex);
        this.shareNoneBtn.setSelected(!shared);
        this.boxesVisibleButton.setSelected(this.myInfo.getBoxesVisible());
        int idx = this.resetList.indexOf(new TwoFacedObject(this.myInfo.getResetPolicy()));
        if (idx >= 0) {
            this.resetCbx.setSelectedIndex(idx);
        }
        this.okToUpdate = false;
        this.updateAnimationSetProperties();
        this.okToUpdate = true;
        this.updateLabels();
    }

    private void updateTimeline() {
        try {
            List datedThings = DatedObject.wrap(Util.makeDates(this.getAnimationTimes()));
            this.timeline.setDatedThings(datedThings, true);
        }
        catch (Exception exc) {
            LogUtil.logException("Error initializing dialog", exc);
        }
    }

    public AnimationBoxPanel getBoxPanel() {
        return this.boxPanel;
    }
}

