/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import ucar.visad.display.AnimationSetInfo;

public class AnimationInfo {
    public static final String RESET_BEGINNING = "reset.beginning";
    public static final String RESET_CURRENT = "reset.current";
    public static final String RESET_END = "reset.end";
    private AnimationSetInfo animationSetInfo = new AnimationSetInfo();
    protected String resetPolicy = "reset.beginning";
    protected boolean boxesVisible = true;
    protected float fwdSpeed;
    protected float backSpeed;
    protected float startDwell;
    protected float endDwell;
    protected boolean direction;
    protected boolean rocking;
    protected boolean shared = true;
    protected String animationGroup;
    private boolean running = false;
    private boolean shareIndex = false;

    public AnimationInfo() {
        this.fwdSpeed = 0.5f;
        this.backSpeed = 0.5f;
        this.startDwell = 0.5f;
        this.endDwell = 1.2f;
        this.direction = true;
        this.rocking = false;
        this.shared = true;
        this.shareIndex = false;
        this.boxesVisible = true;
    }

    public AnimationInfo(float fwdSpeed, float backSpeed, float startDwell, float endDwell, boolean direction, boolean rocking) {
        this(fwdSpeed, backSpeed, startDwell, endDwell, direction, rocking, true);
    }

    public AnimationInfo(float fwdSpeed, float backSpeed, float startDwell, float endDwell, boolean direction, boolean rocking, boolean shared) {
        this.fwdSpeed = fwdSpeed;
        this.backSpeed = backSpeed;
        this.startDwell = startDwell;
        this.endDwell = endDwell;
        this.direction = direction;
        this.rocking = rocking;
        this.shared = shared;
        this.shareIndex = false;
    }

    public void set(AnimationInfo that) {
        this.running = that.running;
        this.resetPolicy = that.resetPolicy;
        this.fwdSpeed = that.fwdSpeed;
        this.backSpeed = that.backSpeed;
        this.startDwell = that.startDwell;
        this.endDwell = that.endDwell;
        this.direction = that.direction;
        this.rocking = that.rocking;
        this.shared = that.shared;
        this.shareIndex = that.shareIndex;
        this.boxesVisible = that.boxesVisible;
        this.animationGroup = that.animationGroup;
        if (that.animationSetInfo != null) {
            this.animationSetInfo = new AnimationSetInfo(that.animationSetInfo);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("AnimationInfo:\n");
        buf.append("fwdspd=");
        buf.append(this.fwdSpeed);
        buf.append(" backspd=");
        buf.append(this.backSpeed);
        buf.append(" startDwell=");
        buf.append(this.startDwell);
        buf.append(" endDwell=");
        buf.append(this.endDwell);
        buf.append(" rocking=");
        buf.append(this.rocking);
        buf.append(" shared=");
        buf.append(this.shared);
        buf.append(" shareIndex=");
        buf.append(this.shareIndex);
        buf.append(" reset=");
        buf.append(this.resetPolicy);
        buf.append(" boxesVisible=");
        buf.append(this.boxesVisible);
        buf.append(" animationGroup=");
        buf.append(this.animationGroup);
        return buf.toString();
    }

    public void setShared(boolean value) {
        this.shared = value;
    }

    public boolean getShared() {
        return this.shared;
    }

    public void setRocking(boolean value) {
        this.rocking = value;
    }

    public boolean getRocking() {
        return this.rocking;
    }

    public void setDirection(boolean value) {
        this.direction = value;
    }

    public boolean getDirection() {
        return this.direction;
    }

    public void setFwdSpeed(float value) {
        this.fwdSpeed = value;
    }

    public float getFwdSpeed() {
        return this.fwdSpeed;
    }

    public void setBackSpeed(float value) {
        this.backSpeed = value;
    }

    public float getBackSpeed() {
        return this.backSpeed;
    }

    public void setStartDwell(float value) {
        this.startDwell = value;
    }

    public float getStartDwell() {
        return this.startDwell;
    }

    public void setEndDwell(float value) {
        this.endDwell = value;
    }

    public float getEndDwell() {
        return this.endDwell;
    }

    public void setResetPolicy(String value) {
        this.resetPolicy = value;
    }

    public String getResetPolicy() {
        return this.resetPolicy;
    }

    public boolean resetToEnd() {
        return this.resetPolicy.equals(RESET_END);
    }

    public boolean resetToCurrent() {
        return this.resetPolicy.equals(RESET_CURRENT);
    }

    public boolean resetToBeginning() {
        return this.resetPolicy.equals(RESET_BEGINNING);
    }

    public void setBoxesVisible(boolean value) {
        this.boxesVisible = value;
    }

    public boolean getBoxesVisible() {
        return this.boxesVisible;
    }

    public void setAnimationGroup(String value) {
        this.animationGroup = value;
    }

    public String getAnimationGroup() {
        return this.animationGroup;
    }

    public void setAnimationSetInfo(AnimationSetInfo value) {
        this.animationSetInfo = value;
    }

    public AnimationSetInfo getAnimationSetInfo() {
        return this.animationSetInfo;
    }

    public void setRunning(boolean value) {
        this.running = value;
    }

    public boolean getRunning() {
        return this.running;
    }

    public void setShareIndex(boolean value) {
        this.shareIndex = value;
    }

    public boolean getShareIndex() {
        return this.shareIndex;
    }
}

