/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import ucar.visad.display.AnimationWidget;
import visad.DateTime;

public class AnimationBoxPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    private static final Color COLOR_OK = Color.green;
    private static final Color COLOR_NOTOK = Color.red;
    private static final Color COLOR_ON = Color.blue;
    private static final int BOX_HEIGHT = 6;
    private int myHeight = 6;
    private static final int SPACE_V = 2;
    private static final int BOX_WIDTH = 10;
    private static final int SPACE_H = 3;
    private AnimationWidget widget;
    private Object BOXES_MUTEX = new Object();
    private List myBoxes = new ArrayList();
    private int overBoxIndex = -1;
    private boolean[] copyForDrag;
    private int dragStartIndex;
    private boolean dragStartOk;
    private int dragCurrentIndex;
    private boolean numberKeyDown = false;
    private int numberKey = 0;

    public AnimationBoxPanel(AnimationWidget widget) {
        this(widget, null);
    }

    public AnimationBoxPanel(AnimationWidget widget, boolean[] okArray) {
        this.widget = widget;
        if (widget == null) {
            this.myHeight = 12;
        }
        this.setPreferredSize(new Dimension(100, 10));
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setToolTipText("<html>Click: toggle<br>Control-click:toggle left<br>Shift-click: toggle right</html>");
        if (okArray != null) {
            this.setNumTimes(okArray.length, okArray);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        this.numberKeyDown = false;
        char c = e.getKeyChar();
        try {
            this.numberKey = Integer.parseInt("" + c);
            if (this.numberKey > 0) {
                this.numberKeyDown = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.numberKeyDown = false;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.widget == null) {
            return super.getToolTipText(event);
        }
        return this.getToolTipText();
    }

    @Override
    public String getToolTipText() {
        if (this.widget == null) {
            return "";
        }
        String text = "";
        if (this.overBoxIndex >= 0 && this.widget != null) {
            DateTime dttm = this.widget.getTimeAtIndex(this.overBoxIndex);
            if (dttm != null) {
                text = "Time:" + dttm + " (" + (this.overBoxIndex + 1) + " of " + this.myBoxes.size() + ")";
            }
        } else {
            text = text + "Number of times:" + this.myBoxes.size();
        }
        DateTime startTime = this.widget.getTimeAtIndex(0);
        DateTime endTime = this.widget.getTimeAtIndex(this.myBoxes.size() - 1);
        if (startTime != null && endTime != null) {
            text = text + "<br>" + "Range:" + startTime + " - " + endTime;
        }
        return "<html>" + text + "</html>";
    }

    @Override
    public void paint(Graphics graphics) {
        double space;
        super.paint(graphics);
        Graphics2D g = (Graphics2D)graphics;
        Rectangle bounds = this.getBounds();
        double width = 10.0;
        List boxes = this.getBoxes();
        int size = boxes.size();
        if (size == 0) {
            return;
        }
        for (space = 3.0; space >= 1.0 && (double)bounds.width < (double)size * (width + space); space -= 1.0) {
        }
        while (width >= 4.0 && (double)bounds.width < (double)size * (width + space)) {
            width -= 1.0;
        }
        boolean discrete = true;
        if ((double)bounds.width < (double)size * (width + space)) {
            width = (double)bounds.width / (double)size;
            discrete = false;
        }
        double x = 0.0;
        int iWidth = (int)width;
        if (iWidth <= 0) {
            iWidth = 1;
        }
        Rectangle2D.Double onBox = null;
        if (!discrete) {
            g.setColor(COLOR_OK);
            g.fillRect(1, 2, bounds.width, this.myHeight);
        }
        for (int i = 0; i < boxes.size(); ++i) {
            Box box = (Box)boxes.get(i);
            if (box.on) {
                onBox = box;
                g.setColor(COLOR_ON);
            } else if (box.ok) {
                g.setColor(COLOR_OK);
            } else {
                g.setColor(COLOR_NOTOK);
            }
            if (discrete || !box.ok) {
                g.fillRect((int)x, 2, iWidth, this.myHeight);
            }
            if (width >= 4.0) {
                if (i == this.overBoxIndex) {
                    g.setColor(Color.darkGray);
                } else {
                    g.setColor(Color.gray);
                }
                g.drawRect((int)x, 2, iWidth, this.myHeight);
            }
            box.setRect(x, 2.0, iWidth, this.myHeight);
            x = x + width + space;
        }
        if (onBox != null) {
            g.setColor(COLOR_ON);
            g.fillRect((int)onBox.getX(), 2, iWidth, this.myHeight);
        }
    }

    public void setOnIndex(int index) {
        List boxes = this.getBoxes();
        for (int i = 0; i < boxes.size(); ++i) {
            Box box = (Box)boxes.get(i);
            box.on = index == i;
        }
        this.repaint();
    }

    public void setNumTimes(int numTimes) {
        this.setNumTimes(numTimes, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNumTimes(int numTimes, boolean[] okArray) {
        Object object = this.BOXES_MUTEX;
        synchronized (object) {
            if (numTimes <= 0) {
                this.myBoxes = new ArrayList();
                this.repaint();
                return;
            }
            boolean changed = false;
            while (this.myBoxes.size() < numTimes) {
                this.myBoxes.add(new Box());
                changed = true;
            }
            while (this.myBoxes.size() > numTimes) {
                this.myBoxes.remove(this.myBoxes.size() - 1);
                changed = true;
            }
            if (okArray != null) {
                for (int onIdx = 0; onIdx < okArray.length && onIdx < this.myBoxes.size(); ++onIdx) {
                    ((Box)this.myBoxes.get((int)onIdx)).ok = okArray[onIdx];
                }
            }
            if (changed) {
                this.checkStepsOk();
                this.repaint();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBoxes() {
        Object object = this.BOXES_MUTEX;
        synchronized (object) {
            ArrayList tmp = new ArrayList(this.myBoxes);
            return tmp;
        }
    }

    protected void applyProperties(AnimationBoxPanel that) {
        boolean[] stepsOk = that.getStepsOk();
        this.setNumTimes(stepsOk.length, stepsOk);
        this.checkStepsOk();
        this.repaint();
    }

    private int findBox(int x, int y) {
        List boxes = this.getBoxes();
        for (int i = 0; i < boxes.size(); ++i) {
            Box box = (Box)boxes.get(i);
            if (!((double)x >= box.getX()) || !((double)x < box.getX() + box.getWidth())) continue;
            return i;
        }
        int closestIndex = -1;
        int minDistance = Integer.MAX_VALUE;
        for (int i = 0; i < boxes.size(); ++i) {
            Box box = (Box)boxes.get(i);
            int tmp = (int)Math.abs((double)x - box.getX());
            if (tmp >= minDistance || tmp >= 4) continue;
            closestIndex = i;
            minDistance = tmp;
        }
        return closestIndex;
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.requestFocus();
        int theBoxIndex = this.findBox(event.getX(), event.getY());
        if (theBoxIndex < 0) {
            return;
        }
        if (!(event.isControlDown() || event.isShiftDown() || SwingUtilities.isRightMouseButton(event))) {
            if (this.widget != null) {
                this.widget.gotoIndex(theBoxIndex);
            }
            return;
        }
        List boxes = this.getBoxes();
        Box box = (Box)boxes.get(theBoxIndex);
        boolean ok = box.ok = !box.ok;
        if (event.isControlDown()) {
            for (int i = theBoxIndex - 1; i >= 0; --i) {
                box = (Box)boxes.get(i);
                box.ok = ok;
            }
        } else if (event.isShiftDown()) {
            for (int i = theBoxIndex + 1; i < boxes.size(); ++i) {
                box = (Box)boxes.get(i);
                box.ok = ok;
            }
        }
        this.checkStepsOk();
        this.repaint();
        if (this.copyForDrag == null) {
            this.dragStartIndex = theBoxIndex;
            if (this.dragStartIndex < 0) {
                return;
            }
            this.copyForDrag = this.getStepsOk();
            this.dragStartOk = this.copyForDrag[this.dragStartIndex];
        }
        if (this.widget != null) {
            this.widget.boxPanelChanged(this);
        }
    }

    public boolean[] getStepsOk() {
        List boxes = this.getBoxes();
        boolean[] stepsOk = new boolean[boxes.size()];
        for (int i = 0; i < boxes.size(); ++i) {
            stepsOk[i] = ((Box)boxes.get((int)i)).ok;
        }
        return stepsOk;
    }

    private void checkStepsOk() {
        if (this.widget != null) {
            this.widget.stepsOkChanged(this.getStepsOk());
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int index = this.findBox(e.getX(), e.getY());
        if (this.overBoxIndex != index) {
            this.overBoxIndex = index;
            this.repaint();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.overBoxIndex = -1;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        int index = this.findBox(event.getX(), this.myHeight / 2);
        if (index < 0) {
            return;
        }
        if (this.copyForDrag == null) {
            return;
        }
        if (index == this.dragCurrentIndex) {
            return;
        }
        this.dragCurrentIndex = index;
        List boxes = this.getBoxes();
        for (int i = 0; i < this.copyForDrag.length && i < boxes.size(); ++i) {
            ((Box)boxes.get((int)i)).ok = this.copyForDrag[i];
        }
        int count = 0;
        if (this.dragStartIndex < index) {
            for (int i = this.dragStartIndex; i <= index && i < boxes.size(); ++i) {
                ((Box)boxes.get((int)i)).ok = this.numberKeyDown && count % this.numberKey != 0 ? !this.dragStartOk : this.dragStartOk;
                ++count;
            }
        } else {
            for (int i = this.dragStartIndex; i >= index && i >= 0 && i < boxes.size(); --i) {
                ((Box)boxes.get((int)i)).ok = this.numberKeyDown && count % this.numberKey != 0 ? !this.dragStartOk : this.dragStartOk;
                ++count;
            }
        }
        this.checkStepsOk();
        if (this.widget != null) {
            this.widget.boxPanelChanged(this);
        }
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.copyForDrag = null;
    }

    public static class Box
    extends Rectangle2D.Double {
        public boolean ok = true;
        public boolean on = false;
    }
}

