/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.display;

import java.rmi.RemoteException;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.visad.data.CalendarDateTime;
import ucar.visad.display.AnimationInfo;
import ucar.visad.display.Displayable;
import visad.AnimationControl;
import visad.ControlEvent;
import visad.ControlListener;
import visad.DateTime;
import visad.Display;
import visad.DisplayImpl;
import visad.Real;
import visad.RealTuple;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Set;
import visad.VisADException;
import visad.util.DataUtility;

public class Animation
extends Displayable {
    public static final String ANI_REAL_TYPE = "aniRealType";
    public static final String ANI_VALUE = "aniValue";
    public static final String ANI_SET = "animationSet";
    public static final int FORWARD = 0;
    public static final int REVERSE = 1;
    private boolean enabled = true;
    private ScalarMap animationMap;
    private boolean[] stepsOk;
    private AnimationControl animationControl;
    private RealType aniRealType;
    private Set animationSet;
    private int currentIndex = 0;
    private Real aniValue = null;
    private Real lastTime;
    private Real missingValue = null;
    private final Object MUTEX = new Object();
    private AnimationInfo animationInfo;
    private boolean rocking = false;
    private boolean direction = true;
    private Thread animationThread;
    private long[] fwdTimeSteps;
    private long[] backTimeSteps;
    private final AnimationMapListener mapListener = new AnimationMapListener();
    private final AnimationControlListener controlListener = new AnimationControlListener();

    public Animation() throws VisADException, RemoteException {
        this(RealType.Time);
    }

    public Animation(RealType aniRealType) throws VisADException, RemoteException {
        this.aniRealType = aniRealType;
        if (aniRealType != null) {
            this.setAnimationMap();
        }
        this.animationInfo = new AnimationInfo();
    }

    protected Animation(Animation that) throws VisADException, RemoteException {
        super(that);
        this.aniRealType = that.aniRealType;
        this.animationInfo = that.animationInfo;
        if (this.aniRealType != null) {
            this.setAnimationMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnimationRealType(RealType realType) throws RemoteException, VisADException {
        RealType oldType = null;
        boolean isNew = false;
        Object object = this.MUTEX;
        synchronized (object) {
            if (!realType.equals(this.aniRealType)) {
                oldType = this.aniRealType;
                this.aniRealType = realType;
                isNew = true;
            }
        }
        if (isNew) {
            this.setAnimationMap();
            this.firePropertyChange(ANI_REAL_TYPE, oldType, realType);
        }
    }

    public RealType getAnimationRealType() {
        return this.aniRealType;
    }

    public final Real getAniValue() {
        return this.aniValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAnimationMap() throws RemoteException, VisADException {
        ScalarMap oldMap = null;
        ScalarMap newMap = null;
        boolean isNewMap = false;
        this.missingValue = new Real(this.aniRealType);
        Object object = this.MUTEX;
        synchronized (object) {
            oldMap = this.animationMap;
            this.animationMap = newMap = new ScalarMap(this.aniRealType, Display.Animation);
            isNewMap = true;
        }
        if (isNewMap) {
            if (oldMap != null) {
                oldMap.removeScalarMapListener(this.mapListener);
            }
            newMap.addScalarMapListener(this.mapListener);
            this.replaceScalarMap(oldMap, newMap);
            this.fireScalarMapSetChange();
        }
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new Animation(this);
    }

    @Override
    public final void myAddDataReferences() {
    }

    @Override
    public final void myRemoveDataReferences() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnimationInfo(AnimationInfo ai) throws RemoteException, VisADException {
        if (ai == null) {
            throw new NullPointerException();
        }
        Object object = this.MUTEX;
        synchronized (object) {
            this.animationInfo.set(ai);
        }
        this.resetAnimationInfo();
    }

    public AnimationInfo getAnimationInfo() {
        return this.animationInfo;
    }

    private void resetAnimationInfo() throws RemoteException, VisADException {
        AnimationInfo info = this.animationInfo;
        this.rocking = info.rocking;
        this.direction = info.direction;
        int SKIPTIME = 0;
        int numTimes = this.getNumSteps();
        long[] newFwdTimes = null;
        long[] newBackTimes = null;
        if (numTimes > 0) {
            int nn;
            newFwdTimes = new long[numTimes];
            newBackTimes = new long[numTimes];
            float fwdSpeed = info.getFwdSpeed();
            float backSpeed = info.getBackSpeed();
            for (nn = 0; nn < numTimes; ++nn) {
                if (this.stepsOk != null && nn < this.stepsOk.length && !this.stepsOk[nn]) {
                    newFwdTimes[nn] = SKIPTIME;
                    newBackTimes[nn] = SKIPTIME;
                    continue;
                }
                newFwdTimes[nn] = (int)((double)fwdSpeed * 1000.0);
                newBackTimes[nn] = (int)((double)backSpeed * 1000.0);
            }
            for (nn = 0; nn < numTimes; ++nn) {
                if (newFwdTimes[nn] == (long)SKIPTIME) continue;
                newFwdTimes[nn] = (int)((double)info.getStartDwell() * 1000.0);
                newBackTimes[nn] = (int)((double)info.getStartDwell() * 1000.0);
                break;
            }
            for (nn = numTimes - 1; nn >= 0; --nn) {
                if (newFwdTimes[nn] == (long)SKIPTIME) continue;
                newFwdTimes[nn] = (int)((double)info.getEndDwell() * 1000.0);
                newBackTimes[nn] = (int)((double)info.getEndDwell() * 1000.0);
                break;
            }
        }
        this.setFwdSteps(newFwdTimes);
        this.setBackSteps(newBackTimes);
        this.setAnimating(this.animationInfo.getRunning());
    }

    public void setAnimating(boolean on) {
        this.animationInfo.setRunning(on);
        if (!on) {
            this.animationThread = null;
            return;
        }
        this.animationThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Animation.this.runAnimation();
            }
        });
        this.animationThread.start();
    }

    private void runAnimation() {
        try {
            Thread myThread = Thread.currentThread();
            while (myThread == this.animationThread && this.animationInfo.getRunning()) {
                long sleepTime = 500L;
                int nextIndex = this.getCurrent();
                if (this.direction) {
                    if (!this.anyStepsForward()) {
                        if (this.rocking) {
                            this.direction = false;
                        } else {
                            nextIndex = 0;
                        }
                    } else {
                        ++nextIndex;
                    }
                } else if (!this.anyStepsBack()) {
                    if (this.rocking) {
                        this.direction = true;
                    } else {
                        nextIndex = this.getNumSteps() - 1;
                    }
                } else {
                    --nextIndex;
                }
                nextIndex = this.clipIndex(nextIndex, this.direction);
                this.setCurrent(nextIndex);
                long[] localTimeSteps = this.direction ? this.fwdTimeSteps : this.backTimeSteps;
                if (localTimeSteps != null && nextIndex >= 0 && nextIndex < localTimeSteps.length) {
                    sleepTime = localTimeSteps[nextIndex];
                }
                if (sleepTime == 0L) {
                    sleepTime = 500L;
                }
                Misc.sleep(sleepTime);
            }
        }
        catch (Exception excp) {
            LogUtil.logException("Running animation", excp);
        }
    }

    public boolean shouldShow(Real timeValue) throws VisADException, RemoteException {
        if (this.animationSet == null || this.animationSet.getLength() == 0) {
            return true;
        }
        float timeValueFloat = (float)timeValue.getValue(this.animationSet.getSetUnits()[0]);
        float[][] value = new float[][]{{timeValueFloat}};
        int[] index = this.animationSet.valueToIndex(value);
        return index[0] == this.getCurrent();
    }

    public boolean isAnimating() {
        return this.animationInfo.getRunning() && this.animationThread != null;
    }

    public boolean shouldBeAnimating() {
        return this.animationInfo.getRunning();
    }

    public Set getSet() {
        return this.animationSet;
    }

    public void setSet(Set newSet) throws VisADException, RemoteException {
        this.setSet(newSet, true);
    }

    public Real getCurrentAnimationValue() {
        DateTime[] times = this.getTimes();
        int current = this.getCurrent();
        if (times != null && current >= 0 && current < times.length) {
            return times[current];
        }
        return null;
    }

    public DateTime[] getTimes() {
        if (this.animationSet != null) {
            return Animation.getDateTimeArray(this.animationSet);
        }
        return null;
    }

    public void setSet(Set newSet, boolean transform) throws VisADException, RemoteException {
        Object[] timeArray;
        if (Misc.equals(newSet, this.animationSet)) {
            return;
        }
        this.animationSet = newSet;
        Real oldTime = this.aniValue;
        this.firePropertyChange(ANI_SET, "old value", this.animationSet);
        AnimationControl control = this.animationControl;
        if (control == null) {
            return;
        }
        control.setSet(newSet, transform);
        Object timeIWantToBe = null;
        if (this.animationSet != null && (timeArray = Animation.getDateTimeArray(this.animationSet)) != null && timeArray.length > 0) {
            int index = 0;
            if (this.animationInfo.resetToEnd()) {
                index = timeArray.length - 1;
            } else if (this.animationInfo.resetToBeginning()) {
                index = 0;
            } else if (this.animationInfo.resetToCurrent() && (index = Misc.indexOf(oldTime, timeArray)) < 0) {
                index = 0;
            }
            if (index >= 0 && index < timeArray.length) {
                timeIWantToBe = timeArray[index];
            }
        }
        this.aniValue = null;
        this.setAniValue((Real)timeIWantToBe);
        if (timeIWantToBe != null) {
            // empty if block
        }
    }

    public long[] getSteps() {
        return this.getFwdSteps();
    }

    public void setSteps(long[] newTimes) {
        this.setFwdSteps(newTimes);
    }

    public long[] getFwdSteps() {
        return this.fwdTimeSteps;
    }

    public void setFwdSteps(long[] newTimes) {
        this.fwdTimeSteps = newTimes;
    }

    public long[] getBackSteps() {
        return this.backTimeSteps;
    }

    public void setBackSteps(long[] newTimes) {
        this.backTimeSteps = newTimes;
    }

    public int getNumSteps() {
        try {
            if (this.animationSet != null) {
                return this.animationSet.getLength();
            }
        }
        catch (Exception excp) {
            LogUtil.logException("getNumSteps", excp);
        }
        return 0;
    }

    public int getCurrent() {
        AnimationControl control = this.animationControl;
        if (control != null) {
            this.currentIndex = control.getCurrent();
            return this.currentIndex;
        }
        return this.currentIndex;
    }

    public void setAniValue(Real newTime) {
        if (newTime == null || Misc.equals(this.aniValue, newTime) || !Misc.equals(this.aniRealType, newTime.getType()) || this.animationSet == null) {
            return;
        }
        try {
            this.aniValue = newTime;
            int index = this.animationSet.doubleToIndex(new double[][]{{newTime.getValue(this.animationSet.getSetUnits()[0])}})[0];
            if (index == -1) {
                int lastIndex;
                double[] aniValues = this.animationSet.getDoubles(false)[0];
                double anitime = newTime.getValue(this.animationSet.getSetUnits()[0]);
                index = anitime >= aniValues[lastIndex = aniValues.length - 1] ? lastIndex : 0;
            }
            if (index != this.getCurrent()) {
                this.setCurrent(index, false);
            }
        }
        catch (Exception ve) {
            LogUtil.logException("setting animation value", ve);
        }
    }

    public void setCurrent(int newIndex) {
        this.setCurrent(newIndex, true);
    }

    public void setCurrent(int newIndex, boolean checkUserFrames) {
        try {
            boolean dir;
            AnimationControl control = this.animationControl;
            this.currentIndex = newIndex;
            boolean bl = dir = newIndex > this.getCurrent();
            if (checkUserFrames) {
                newIndex = this.clipIndex(newIndex, dir);
            }
            if (this.enabled) {
                if (control == null) {
                    if (this.animationSet != null && newIndex >= 0 && newIndex < this.animationSet.getLength()) {
                        RealTuple tuple = DataUtility.getSample(this.animationSet, newIndex);
                        this.aniValue = (Real)tuple.getComponent(0);
                    }
                } else {
                    control.setCurrent(newIndex);
                }
            }
            if (!Misc.equals(this.lastTime, this.aniValue)) {
                this.lastTime = this.aniValue;
                this.firePropertyChange(ANI_VALUE, "old value", this.aniValue);
            }
        }
        catch (Exception ve) {
            LogUtil.logException("setCurrent", ve);
        }
    }

    public void takeStep() {
        this.takeStep(this.direction ? 0 : 1);
    }

    public void takeStep(int direction) {
        try {
            int nextIndex = this.getCurrent();
            nextIndex = direction == 0 ? (this.anyStepsForward() ? ++nextIndex : 0) : (this.anyStepsBack() ? --nextIndex : this.getNumSteps() - 1);
            int newIndex = this.clipIndex(nextIndex, direction == 0);
            this.setCurrent(newIndex);
        }
        catch (Exception ve) {
            LogUtil.logException("takeStep", ve);
        }
    }

    public void setStepsOk(boolean[] stepsOk) throws RemoteException, VisADException {
        this.stepsOk = stepsOk;
        this.resetAnimationInfo();
    }

    private int clipIndex(int nextIndex, boolean forward) {
        int numSteps = this.getNumSteps();
        if (this.stepsOk != null) {
            int nextGoodIndex;
            int delta;
            int n = delta = forward ? 1 : -1;
            for (nextGoodIndex = nextIndex; nextGoodIndex >= 0 && nextGoodIndex < this.stepsOk.length && !this.stepsOk[nextGoodIndex]; nextGoodIndex += delta) {
            }
            for (nextGoodIndex = Math.max(Math.min(nextGoodIndex, this.stepsOk.length - 1), 0); nextGoodIndex >= 0 && nextGoodIndex < this.stepsOk.length && !this.stepsOk[nextGoodIndex]; nextGoodIndex -= delta) {
            }
            if (nextGoodIndex >= 0 && nextGoodIndex < numSteps) {
                nextIndex = nextGoodIndex;
            }
        }
        return Math.max(Math.min(nextIndex, numSteps - 1), 0);
    }

    public void setDirection(int direction) {
        this.direction = direction == 0;
    }

    public void takeStepForward() {
        this.takeStep(0);
    }

    public void takeStepBackward() {
        this.takeStep(1);
    }

    public void reCalculateAnimationSet() {
        DisplayImpl display = (DisplayImpl)this.getDisplay();
        if (display != null) {
            display.reAutoScale();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Animation)) {
            return false;
        }
        Animation that = (Animation)obj;
        return Misc.equals(this.animationControl, that.animationControl) && Misc.equals(this.aniRealType, that.aniRealType);
    }

    private boolean anyStepsForward() {
        int current = this.getCurrent();
        if (this.stepsOk != null) {
            for (int i = current + 1; i < this.stepsOk.length; ++i) {
                if (!this.stepsOk[i]) continue;
                return true;
            }
            return false;
        }
        return current < this.getNumSteps() - 1;
    }

    private boolean anyStepsBack() {
        int current = this.getCurrent();
        if (this.stepsOk != null) {
            for (int i = current - 1; i >= 0; --i) {
                if (!this.stepsOk[i]) continue;
                return true;
            }
            return false;
        }
        return current != 0;
    }

    public static DateTime[] getDateTimeArray(Set timeSet) {
        if (timeSet == null) {
            return new DateTime[0];
        }
        try {
            return CalendarDateTime.timeSetToArray(timeSet);
        }
        catch (VisADException visADException) {
            return new DateTime[0];
        }
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
        if (this.enabled != value && value) {
            this.setCurrent(this.currentIndex, false);
        }
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    private class AnimationControlListener
    implements ControlListener {
        private AnimationControlListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void controlChanged(ControlEvent ce) {
            try {
                boolean doFireChange = false;
                Real oldTime = null;
                Real newTime = null;
                Object object = Animation.this.MUTEX;
                synchronized (object) {
                    oldTime = Animation.this.aniValue;
                    Animation.this.aniValue = Animation.this.missingValue;
                    int index = Animation.this.getCurrent();
                    if (Animation.this.animationSet != null) {
                        DateTime[] newTimeArray = Animation.getDateTimeArray(Animation.this.animationSet);
                        if (index >= 0 && index < newTimeArray.length) {
                            Animation.this.aniValue = newTimeArray[index];
                        }
                    }
                    newTime = Animation.this.aniValue;
                    if (!Misc.equals(oldTime, Animation.this.aniValue)) {
                        Animation.this.lastTime = Animation.this.aniValue;
                        doFireChange = true;
                    }
                }
                if (doFireChange) {
                    Animation.this.firePropertyChange(Animation.ANI_VALUE, oldTime, Animation.this.aniValue);
                }
            }
            catch (Exception excp) {
                LogUtil.logException("Error", excp);
            }
        }
    }

    private class AnimationMapListener
    implements ScalarMapListener {
        private AnimationMapListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void controlChanged(ScalarMapControlEvent event) throws RemoteException, VisADException {
            block7: {
                AnimationControl oldControl;
                block6: {
                    int id = event.getId();
                    if (id == 3) break block6;
                    if (id != 5) break block7;
                }
                AnimationControl newControl = (AnimationControl)((Object)Animation.this.animationMap.getControl());
                Object object = Animation.this.MUTEX;
                synchronized (object) {
                    oldControl = Animation.this.animationControl;
                    Animation.this.animationControl = newControl;
                }
                if (oldControl != null) {
                    oldControl.removeControlListener(Animation.this.controlListener);
                }
                if (newControl != null) {
                    newControl.setComputeSet(false);
                    newControl.addControlListener(Animation.this.controlListener);
                    Animation.this.resetAnimationInfo();
                }
            }
        }

        @Override
        public void mapChanged(ScalarMapEvent event) throws RemoteException, VisADException {
            int id = event.getId();
            if (id == 1) {
                Animation.this.resetAnimationInfo();
            }
        }
    }
}

