/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.data;

import java.util.List;
import ucar.ma2.Array;
import ucar.nc2.constants.AxisType;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.GeoReferencedArray;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.DataUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Trace;
import ucar.visad.data.CalendarDateTime;
import visad.CoordinateSystem;
import visad.FunctionType;
import visad.GriddedSet;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.data.CachedFlatField;

public class GridCoverageFlatField
extends CachedFlatField {
    private String readLabel = "";
    private GriddedSet domainSet;
    private transient Coverage geoGrid;
    private SubsetParams subsetParams;
    private int timeIndex;
    private int ensIndex;
    private transient Object readLock;
    double[] vIntv;
    CalendarDateTime runTime;
    double[] coordinateBounds = null;
    public static Object ALLMUTEX = new Object();

    public GridCoverageFlatField(Coverage geoGrid, SubsetParams params, Object readLock, int timeIndex, GriddedSet domainSet, FunctionType type) throws VisADException {
        this(geoGrid, params, readLock, timeIndex, 0, domainSet, type);
    }

    public GridCoverageFlatField(Coverage geoGrid, SubsetParams params, Object readLock, int timeIndex, int ensIndex, GriddedSet domainSet, FunctionType type) throws VisADException {
        super(type, domainSet);
        this.readLock = readLock;
        this.geoGrid = geoGrid;
        this.subsetParams = params;
        this.domainSet = domainSet;
        this.timeIndex = timeIndex;
        this.ensIndex = ensIndex;
        this.vIntv = params.getVertCoordIntv();
    }

    public GridCoverageFlatField(GridCoverageFlatField that, boolean copy, FunctionType type, Set domainSet, CoordinateSystem rangeCoordSys, CoordinateSystem[] rangeCoordSysArray, Set[] rangeSets, Unit[] units) throws VisADException {
        super(that, copy, type, domainSet, rangeCoordSys, rangeCoordSysArray, rangeSets, units);
        this.readLock = that.readLock;
        this.geoGrid = that.geoGrid;
        this.domainSet = that.domainSet;
        this.timeIndex = that.timeIndex;
        this.ensIndex = that.ensIndex;
    }

    @Override
    public CachedFlatField cloneMe(boolean copy, FunctionType type, Set domainSet, CoordinateSystem rangeCoordSys, CoordinateSystem[] rangeCoordSysArray, Set[] rangeSets, Unit[] units) throws VisADException {
        GridCoverageFlatField ccf = new GridCoverageFlatField(this, copy, type, domainSet, rangeCoordSys, rangeCoordSysArray, rangeSets, units);
        return ccf;
    }

    public GridCoverageFlatField(FunctionType type, Set domainSet, CoordinateSystem rangeCoordSys, Set[] rangeSets, Unit[] units, float[][] floats) throws VisADException {
        super(type, domainSet, rangeCoordSys, rangeSets, units, floats);
    }

    private Object getReadLock() {
        if (this.readLock == null) {
            this.readLock = ALLMUTEX;
        }
        return this.readLock;
    }

    public CalendarDateTime getRuntime() {
        return this.runTime;
    }

    public double[] getCoordBounds() {
        return this.coordinateBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[][] readData() {
        float[][] fieldArray;
        block34: {
            this.msg("GeoGrid readData");
            int numLevels = 0;
            fieldArray = new float[1][];
            try {
                Array[] arr;
                this.msg("readData");
                Trace.call1("GeoGridFlatField.geogrid.readVolumeData");
                Object object = this.getReadLock();
                synchronized (object) {
                    LogUtil.message(this.readLabel);
                    DataSourceImpl.incrOutstandingGetDataCalls();
                    try {
                        double[] vIntv;
                        CoverageCoordAxis1D cca = (CoverageCoordAxis1D)this.geoGrid.getCoordSys().getTimeAxis();
                        CoverageCoordAxis1D cca1 = (CoverageCoordAxis1D)this.geoGrid.getCoordSys().getAxis(AxisType.RunTime);
                        Object bobject = cca.getCoordObject(this.timeIndex);
                        if (bobject instanceof double[]) {
                            this.coordinateBounds = (double[])bobject;
                        }
                        List<CalendarDateTime> times = DataUtil.makeDateTimes(cca);
                        if (cca1 != null) {
                            List<CalendarDateTime> timesR = DataUtil.makeDateTimes(cca1);
                            this.runTime = timesR.size() == 1 ? timesR.get(0) : (this.timeIndex > timesR.size() ? timesR.get(timesR.size() - 1) : timesR.get(this.timeIndex));
                        }
                        CalendarDateTime cdt = times.get(this.timeIndex);
                        double[] levels = null;
                        double[] ilevels = null;
                        if (this.geoGrid.getCoordSys().getZAxis() != null) {
                            Array lst = this.geoGrid.getCoordSys().getZAxis().getCoordsAsArray();
                            int size = (int)lst.getSize();
                            levels = new double[size];
                            for (int k = 0; k < size; ++k) {
                                float kValue = lst.getFloat(k);
                                levels[k] = kValue;
                            }
                            ilevels = new double[levels.length];
                        }
                        if ((vIntv = this.vIntv) == null) {
                            numLevels = 1;
                        } else {
                            for (int i = 0; i < levels.length; ++i) {
                                if (!(levels[i] >= vIntv[0]) || !(levels[i] <= vIntv[1])) continue;
                                ilevels[numLevels] = levels[i];
                                ++numLevels;
                            }
                        }
                        arr = new Array[numLevels];
                        if (this.coordinateBounds != null) {
                            this.subsetParams.setRunTime(cca1.getRefDate());
                            this.subsetParams.setTimeOffsetIntv(this.coordinateBounds);
                        } else {
                            this.subsetParams.setTime(cdt.getCalendarDate());
                        }
                        if (vIntv == null) {
                            this.subsetParams.setVertCoordIntv(vIntv);
                            GeoReferencedArray mySubset = this.geoGrid.readData(this.subsetParams);
                            arr[0] = mySubset.getData();
                        } else {
                            for (int j = 0; j < numLevels; ++j) {
                                double[] zIntv = new double[]{ilevels[j], ilevels[j]};
                                this.subsetParams.setVertCoordIntv(zIntv);
                                GeoReferencedArray mySubset = this.geoGrid.readData(this.subsetParams);
                                arr[j] = mySubset.getData();
                            }
                        }
                    }
                    catch (Exception exc) {
                        if (exc.toString().indexOf("Inconsistent array length read") >= 0) {
                            throw new BadDataException("Error reading data from server");
                        }
                        throw new RuntimeException(exc);
                    }
                    LogUtil.message("");
                    Trace.call2("GeoGridFlatField.geogrid.readVolumeData");
                    if (arr[0].getRank() > 2 && this.domainSet.getDimension() == 2) {
                        int[] lengths = this.domainSet.getLengths();
                        int sizeX = lengths[0];
                        int sizeY = lengths[1];
                        int levelIndex = 0;
                        int[] shape = arr[0].getShape();
                        for (int i = 0; i <= arr[0].getRank(); ++i) {
                            if (shape[i] == sizeX || shape[i] == sizeY) continue;
                            arr[0] = arr[0].slice(i, levelIndex);
                            break;
                        }
                    }
                }
                Trace.call1("toFloatArray", " array:" + arr.getClass().getName());
                float[] values = DataUtil.toFloatArray(arr);
                Class dataClass = arr[0].getElementType();
                if (dataClass.equals(Float.TYPE) || !dataClass.equals(Double.TYPE)) {
                    // empty if block
                }
                Trace.call2("toFloatArray", " length:" + values.length);
                try {
                    if (values.length < this.domainSet.getLength()) {
                        float[] newValues = new float[this.domainSet.getLength()];
                        int[] lengths = this.domainSet.getLengths();
                        int l = 0;
                        int sizeX = lengths[0];
                        int sizeY = lengths[1];
                        if (lengths.length == 2) {
                            for (int j = 0; j < sizeY; ++j) {
                                for (int i = 0; i < sizeX; ++i) {
                                    int xpos = i < sizeX - 1 ? i : 0;
                                    newValues[l++] = values[j * (sizeX - 1) + xpos];
                                }
                            }
                        } else {
                            for (int k = 0; k < lengths[2]; ++k) {
                                for (int j = 0; j < sizeY; ++j) {
                                    for (int i = 0; i < sizeX; ++i) {
                                        int xpos = i < sizeX - 1 ? i : 0;
                                        newValues[l++] = values[k * sizeY * (sizeX - 1) + j * (sizeX - 1) + xpos];
                                    }
                                }
                            }
                        }
                        fieldArray[0] = newValues;
                        break block34;
                    }
                    fieldArray[0] = values;
                }
                catch (VisADException e) {
                    LogUtil.logException("trying to extend grid got VisADException", e);
                    float[][] fArray = null;
                    DataSourceImpl.decrOutstandingGetDataCalls();
                    return fArray;
                }
            }
            finally {
                DataSourceImpl.decrOutstandingGetDataCalls();
            }
        }
        this.msg("readData DONE");
        return fieldArray;
    }

    public void setReadLabel(String s) {
        this.readLabel = s;
    }
}

