/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.data;

import java.util.List;
import ucar.ma2.Array;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.unidata.data.BadDataException;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.DataUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Trace;
import ucar.visad.data.CalendarDateTime;
import visad.CoordinateSystem;
import visad.FunctionType;
import visad.GriddedSet;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.data.CachedFlatField;

public class GeoGridFlatField
extends CachedFlatField {
    private String readLabel = "";
    private GriddedSet domainSet;
    private transient GeoGrid geoGrid;
    private int timeIndex;
    private int ensIndex;
    private transient Object readLock;
    CalendarDateTime runTime;
    double[] coordinateBounds = null;
    public static Object ALLMUTEX = new Object();

    public GeoGridFlatField(GeoGrid geoGrid, Object readLock, int timeIndex, GriddedSet domainSet, FunctionType type) throws VisADException {
        this(geoGrid, readLock, timeIndex, 0, domainSet, type);
    }

    public GeoGridFlatField(GeoGrid geoGrid, Object readLock, int timeIndex, int ensIndex, GriddedSet domainSet, FunctionType type) throws VisADException {
        super(type, domainSet);
        this.readLock = readLock;
        this.geoGrid = geoGrid;
        this.domainSet = domainSet;
        this.timeIndex = timeIndex;
        this.ensIndex = ensIndex;
    }

    public GeoGridFlatField(GeoGridFlatField that, boolean copy, FunctionType type, Set domainSet, CoordinateSystem rangeCoordSys, CoordinateSystem[] rangeCoordSysArray, Set[] rangeSets, Unit[] units) throws VisADException {
        super(that, copy, type, domainSet, rangeCoordSys, rangeCoordSysArray, rangeSets, units);
        this.readLock = that.readLock;
        this.geoGrid = that.geoGrid;
        this.domainSet = that.domainSet;
        this.timeIndex = that.timeIndex;
        this.ensIndex = that.ensIndex;
    }

    @Override
    public CachedFlatField cloneMe(boolean copy, FunctionType type, Set domainSet, CoordinateSystem rangeCoordSys, CoordinateSystem[] rangeCoordSysArray, Set[] rangeSets, Unit[] units) throws VisADException {
        GeoGridFlatField ccf = new GeoGridFlatField(this, copy, type, domainSet, rangeCoordSys, rangeCoordSysArray, rangeSets, units);
        return ccf;
    }

    public GeoGridFlatField(FunctionType type, Set domainSet, CoordinateSystem rangeCoordSys, Set[] rangeSets, Unit[] units, float[][] floats) throws VisADException {
        super(type, domainSet, rangeCoordSys, rangeSets, units, floats);
    }

    private Object getReadLock() {
        if (this.readLock == null) {
            this.readLock = ALLMUTEX;
        }
        return this.readLock;
    }

    public CalendarDateTime getRuntime() {
        return this.runTime;
    }

    public double[] getCoordBounds() {
        return this.coordinateBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float[][] readData() {
        float[][] fieldArray;
        block24: {
            Array arr;
            block23: {
                this.msg("GeoGrid readData");
                try {
                    this.msg("readData");
                    Trace.call1("GeoGridFlatField.geogrid.readVolumeData");
                    Object object = this.getReadLock();
                    synchronized (object) {
                        LogUtil.message(this.readLabel);
                        DataSourceImpl.incrOutstandingGetDataCalls();
                        try {
                            CoordinateAxis1DTime ccar = this.geoGrid.getCoordinateSystem().getRunTimeAxis();
                            CoordinateAxis1DTime cca = this.geoGrid.getCoordinateSystem().getTimeAxis1D();
                            if (cca != null && cca.getCoordBoundsDate(this.timeIndex) != null) {
                                this.coordinateBounds = cca.getCoordBounds(this.timeIndex);
                            }
                            if (ccar != null) {
                                List<CalendarDateTime> timesR = DataUtil.makeDateTimes(ccar);
                                this.runTime = timesR.size() == 1 ? timesR.get(0) : (this.timeIndex > timesR.size() ? timesR.get(timesR.size() - 1) : timesR.get(this.timeIndex));
                            }
                            arr = this.geoGrid.readDataSlice(0, this.ensIndex, this.timeIndex, -1, -1, -1);
                        }
                        catch (Exception exc) {
                            if (exc.toString().indexOf("Inconsistent array length read") >= 0) {
                                throw new BadDataException("Error reading data from server");
                            }
                            throw new RuntimeException(exc);
                        }
                        LogUtil.message("");
                    }
                    Trace.call2("GeoGridFlatField.geogrid.readVolumeData");
                    if (arr.getRank() <= 2 || this.domainSet.getDimension() != 2) break block23;
                    int[] lengths = this.domainSet.getLengths();
                    int sizeX = lengths[0];
                    int sizeY = lengths[1];
                    int levelIndex = 0;
                    int[] shape = arr.getShape();
                    for (int i = 0; i <= arr.getRank(); ++i) {
                        if (shape[i] == sizeX || shape[i] == sizeY) continue;
                        arr = arr.slice(i, levelIndex);
                        break;
                    }
                }
                finally {
                    DataSourceImpl.decrOutstandingGetDataCalls();
                }
            }
            Trace.call1("toFloatArray", " array:" + arr.getClass().getName());
            fieldArray = new float[1][];
            float[] values = DataUtil.toFloatArray(arr);
            Class dataClass = arr.getElementType();
            if (!dataClass.equals(Float.TYPE) && !dataClass.equals(Double.TYPE)) {
                values = this.geoGrid.setMissingToNaN(values);
            }
            Trace.call2("toFloatArray", " length:" + values.length);
            try {
                if (values.length < this.domainSet.getLength()) {
                    float[] newValues = new float[this.domainSet.getLength()];
                    int[] lengths = this.domainSet.getLengths();
                    int l = 0;
                    int sizeX = lengths[0];
                    int sizeY = lengths[1];
                    if (lengths.length == 2) {
                        for (int j = 0; j < sizeY; ++j) {
                            for (int i = 0; i < sizeX; ++i) {
                                int xpos = i < sizeX - 1 ? i : 0;
                                newValues[l++] = values[j * (sizeX - 1) + xpos];
                            }
                        }
                    } else {
                        for (int k = 0; k < lengths[2]; ++k) {
                            for (int j = 0; j < sizeY; ++j) {
                                for (int i = 0; i < sizeX; ++i) {
                                    int xpos = i < sizeX - 1 ? i : 0;
                                    newValues[l++] = values[k * sizeY * (sizeX - 1) + j * (sizeX - 1) + xpos];
                                }
                            }
                        }
                    }
                    fieldArray[0] = newValues;
                    break block24;
                }
                fieldArray[0] = values;
            }
            catch (VisADException e) {
                LogUtil.logException("trying to extend grid got VisADException", e);
                return null;
            }
        }
        this.msg("readData DONE");
        return fieldArray;
    }

    public void setReadLabel(String s) {
        this.readLabel = s;
    }
}

