/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.data;

import ucar.nc2.time.Calendar;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DDoubleSet;
import visad.MathType;
import visad.QuickSort;
import visad.Set;
import visad.SetType;
import visad.Unit;
import visad.VisADException;

public class CalendarDateTimeSet
extends Gridded1DDoubleSet {
    private static final long serialVersionUID = 1L;
    private Calendar calendar;

    public CalendarDateTimeSet(MathType type, float[][] samples, int lengthX) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, null);
    }

    public CalendarDateTimeSet(MathType type, double[][] samples, int lengthX) throws VisADException {
        this(type, samples, lengthX, null, null, null, null);
    }

    public CalendarDateTimeSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, coord_sys, units, errors, true, null);
    }

    public CalendarDateTimeSet(MathType type, double[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors) throws VisADException {
        this(type, samples, lengthX, coord_sys, units, errors, true, null);
    }

    public CalendarDateTimeSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, coord_sys, units, errors, copy, null);
    }

    public CalendarDateTimeSet(MathType type, double[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException {
        this(type, samples, lengthX, coord_sys, units, errors, copy, null);
    }

    public CalendarDateTimeSet(MathType type, float[][] samples, int lengthX, Calendar cal) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, cal);
    }

    public CalendarDateTimeSet(MathType type, double[][] samples, int lengthX, Calendar cal) throws VisADException {
        this(type, samples, lengthX, null, null, null, cal);
    }

    public CalendarDateTimeSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, Calendar cal) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, coord_sys, units, errors, true, cal);
    }

    public CalendarDateTimeSet(MathType type, double[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, Calendar cal) throws VisADException {
        this(type, samples, lengthX, coord_sys, units, errors, true, cal);
    }

    public CalendarDateTimeSet(MathType type, float[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy, Calendar cal) throws VisADException {
        this(type, Set.floatToDouble(samples), lengthX, coord_sys, units, errors, copy, cal);
    }

    public CalendarDateTimeSet(MathType type, double[][] samples, int lengthX, CoordinateSystem coord_sys, Unit[] units, ErrorEstimate[] errors, boolean copy, Calendar cal) throws VisADException {
        super(type, samples, lengthX, coord_sys, units, errors, copy);
        this.calendar = cal;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    @Override
    public Set merge1DSets(Set set) throws VisADException {
        int i;
        int i2;
        if (this.getDimension() != 1 || set.getDimension() != 1 || this.equals(set)) {
            return this;
        }
        int length = this.getLength();
        int[] indices = this.getWedge();
        double[][] old_values = this.indexToDouble(indices);
        ErrorEstimate[] errors_out = new ErrorEstimate[1];
        double[][] values = CoordinateSystem.transformCoordinates(((SetType)set.getType()).getDomain(), set.getCoordinateSystem(), set.getSetUnits(), null, ((SetType)this.getType()).getDomain(), this.getCoordinateSystem(), this.getSetUnits(), null, old_values);
        int set_length = set.getLength();
        boolean[] set_indices = new boolean[set_length];
        for (int i3 = 0; i3 < set_length; ++i3) {
            set_indices[i3] = true;
        }
        if (set_length > 1) {
            int[] test_indices = set.doubleToIndex(values);
            try {
                for (i2 = 0; i2 < length; ++i2) {
                    if (test_indices[i2] <= -1) continue;
                    set_indices[test_indices[i2]] = false;
                }
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                throw new VisADException("Cannot merge sets");
            }
        } else {
            double[][] set_values = set.getDoubles();
            double set_val = set_values[0][0];
            double min = Double.MAX_VALUE;
            double max = -1.7976931348623157E308;
            for (int i4 = 0; i4 < length; ++i4) {
                if (values[0][i4] > max) {
                    max = values[0][i4];
                }
                if (!(values[0][i4] < min)) continue;
                min = values[0][i4];
            }
            double delt = (max - min) / (double)length;
            if (min - delt <= set_val && set_val <= max + delt) {
                set_indices[0] = false;
            }
        }
        int num_new = 0;
        for (i2 = 0; i2 < set_length; ++i2) {
            if (!set_indices[i2]) continue;
            ++num_new;
        }
        if (num_new == 0) {
            return this;
        }
        int[] new_indices = new int[num_new];
        num_new = 0;
        for (int i5 = 0; i5 < set_length; ++i5) {
            if (!set_indices[i5]) continue;
            new_indices[num_new] = i5;
            ++num_new;
        }
        double[][] new_values = set.indexToDouble(new_indices);
        new_values = CoordinateSystem.transformCoordinates(((SetType)this.getType()).getDomain(), this.getCoordinateSystem(), this.getSetUnits(), null, ((SetType)set.getType()).getDomain(), set.getCoordinateSystem(), set.getSetUnits(), null, new_values);
        double[][] all_values = new double[1][length + num_new];
        for (i = 0; i < length; ++i) {
            all_values[0][i] = old_values[0][i];
        }
        for (i = 0; i < num_new; ++i) {
            all_values[0][length + i] = new_values[0][i];
        }
        QuickSort.sort(all_values[0]);
        return new CalendarDateTimeSet(this.getType(), all_values, all_values[0].length, this.getCoordinateSystem(), this.getSetUnits(), this.getSetErrors(), false, this.calendar);
    }
}

