/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.time.CalendarTimeZone;
import ucar.visad.Util;
import ucar.visad.data.CalendarDateTimeSet;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.DateTime;
import visad.ErrorEstimate;
import visad.MathType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.Unit;
import visad.VisADException;

public class CalendarDateTime
extends DateTime {
    private CalendarDate calendarDate;

    public CalendarDateTime(CalendarDate cd) throws VisADException {
        super((double)cd.getMillis() / 1000.0);
        this.calendarDate = cd;
    }

    public CalendarDateTime(Date date) throws VisADException {
        this((double)date.getTime() / 1000.0, (Calendar)null);
    }

    public CalendarDateTime(DateTime dt) throws VisADException {
        this(dt.getValue(CommonUnit.secondsSinceTheEpoch), (Calendar)null);
        if (dt instanceof CalendarDateTime) {
            this.calendarDate = ((CalendarDateTime)dt).calendarDate;
        }
    }

    public CalendarDateTime(double secs, Calendar cal) throws VisADException {
        super(secs);
        this.calendarDate = CalendarDateTime.makeCalendarDate(cal, (long)secs * 1000L);
    }

    public CalendarDateTime() throws VisADException {
        this.calendarDate = CalendarDateTime.makeCalendarDate(null, (long)this.getValue() * 1000L);
    }

    private static CalendarDate makeCalendarDate(Calendar cal, long msecs) {
        return CalendarDate.of(cal, msecs);
    }

    @Override
    public String formattedString(String pattern, TimeZone timeZone) {
        CalendarTimeZone ctz = new CalendarTimeZone(timeZone);
        CalendarDateFormatter cdf = new CalendarDateFormatter(pattern, ctz);
        return cdf.toString(this.calendarDate);
    }

    public static CalendarDateTime createDateTime(String dateString, String format, TimeZone timezone, Calendar cal) throws VisADException {
        CalendarDateFormatter cdf = new CalendarDateFormatter(format, new CalendarTimeZone(timezone), cal);
        return new CalendarDateTime(cdf.parse(dateString));
    }

    public static CalendarDateTimeSet makeTimeSet(DateTime[] times) throws VisADException {
        int i;
        if (times == null || times.length == 0) {
            return null;
        }
        Enum cal = null;
        if (times[0] instanceof CalendarDateTime) {
            cal = ((CalendarDateTime)times[0]).getCalendar();
        }
        if (cal != null && cal.equals((Object)Calendar.julian)) {
            DateTime[] timeArray = new DateTime[times.length];
            for (i = 0; i < times.length; ++i) {
                DateTime dt = times[i];
                TimeZone zoneInfo = dt.getFormatTimeZone();
                CalendarDate cdate = ((CalendarDateTime)dt).getCalendarDate();
                int day = cdate.getDayOfMonth();
                int mon = cdate.getFieldValue(CalendarPeriod.Field.Month);
                int year = cdate.getFieldValue(CalendarPeriod.Field.Year);
                int hour = cdate.getFieldValue(CalendarPeriod.Field.Hour);
                int min = cdate.getFieldValue(CalendarPeriod.Field.Minute);
                int sec = cdate.getFieldValue(CalendarPeriod.Field.Second);
                DateTime dt0 = Util.getGregorianDateTime(zoneInfo, year, mon, day, hour, min, sec);
                timeArray[i] = new DateTime(dt0);
            }
            cal = Calendar.gregorian;
            times = timeArray;
        }
        Arrays.sort(times);
        double[][] timeValues = new double[1][times.length];
        for (i = 0; i < times.length; ++i) {
            timeValues[0][i] = times[i].getValue(CommonUnit.secondsSinceTheEpoch);
        }
        return new CalendarDateTimeSet((MathType)RealType.Time, timeValues, times.length, (CoordinateSystem)null, new Unit[]{CommonUnit.secondsSinceTheEpoch}, (ErrorEstimate[])null, false, (Calendar)cal);
    }

    public Calendar getCalendar() {
        return this.calendarDate.getCalendar();
    }

    public CalendarDate getCalendarDate() {
        return this.calendarDate;
    }

    public static CalendarDateTimeSet makeTimeSet(double[] times) throws VisADException {
        Arrays.sort(times);
        double[][] alltimes = new double[1][times.length];
        for (int i = 0; i < times.length; ++i) {
            alltimes[0][i] = times[i];
        }
        return new CalendarDateTimeSet((MathType)RealType.Time, alltimes, times.length, (CoordinateSystem)null, new Unit[]{CommonUnit.secondsSinceTheEpoch}, (ErrorEstimate[])null, false, null);
    }

    public static List<DateTime> getDateTimeList(Set timeSet) throws VisADException {
        Unit unit;
        if (!(timeSet instanceof SampledSet)) {
            throw new VisADException("timeSet is not a SampledSet");
        }
        ArrayList<DateTime> timeList = new ArrayList<DateTime>();
        Calendar cal = null;
        if (timeSet instanceof CalendarDateTimeSet) {
            cal = ((CalendarDateTimeSet)timeSet).getCalendar();
        }
        if (!Unit.canConvert(unit = timeSet.getSetUnits()[0], CommonUnit.secondsSinceTheEpoch)) {
            throw new VisADException("Invalid Units for timeSet");
        }
        double[][] values = !unit.equals(CommonUnit.secondsSinceTheEpoch) ? Unit.convertTuple(timeSet.getDoubles(), new Unit[]{unit}, new Unit[]{CommonUnit.secondsSinceTheEpoch}, false) : timeSet.getDoubles(false);
        for (int i = 0; i < timeSet.getLength(); ++i) {
            timeList.add(new CalendarDateTime(values[0][i], cal));
        }
        return timeList;
    }

    public static CalendarDateTime[] timeSetToArray(Set timeSet) throws VisADException {
        List<DateTime> timeList = CalendarDateTime.getDateTimeList(timeSet);
        if (timeList.isEmpty()) {
            return new CalendarDateTime[0];
        }
        CalendarDateTime[] times = new CalendarDateTime[timeList.size()];
        for (int i = 0; i < timeList.size(); ++i) {
            times[i] = (CalendarDateTime)timeList.get(i);
        }
        return times;
    }

    @Override
    public int compareTo(Object oo) {
        if (oo instanceof CalendarDateTime) {
            return this.calendarDate.compareTo(((CalendarDateTime)oo).calendarDate);
        }
        return super.compareTo(oo);
    }

    @Override
    public boolean equals(Object oo) {
        if (oo instanceof CalendarDateTime) {
            return this.calendarDate.equals(((CalendarDateTime)oo).calendarDate);
        }
        return super.equals(oo);
    }

    @Override
    public int hashCode() {
        return this.calendarDate.hashCode();
    }
}

