/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad.data;

import edu.wisc.ssec.mcidas.AREAnav;
import edu.wisc.ssec.mcidas.AreaDirectory;
import edu.wisc.ssec.mcidas.AreaFile;
import edu.wisc.ssec.mcidas.AreaFileFactory;
import java.io.IOException;
import java.rmi.RemoteException;
import ucar.unidata.data.DataSourceImpl;
import ucar.unidata.data.DataUtil;
import ucar.unidata.data.imagery.AddeImageDescriptor;
import ucar.unidata.data.imagery.AddeImageInfo;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.WrapperException;
import ucar.visad.data.MyAreaImageFlatField;
import visad.CoordinateSystem;
import visad.DateTime;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.Linear2DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.data.CachedFlatField;
import visad.data.mcidas.AREACoordinateSystem;
import visad.data.mcidas.AreaAdapter;
import visad.data.units.Parser;
import visad.jmet.MetUnits;
import visad.meteorology.SingleBandedImage;
import visad.meteorology.SingleBandedImageImpl;

public class AreaImageFlatField
extends CachedFlatField
implements SingleBandedImage {
    private Object READMUTEX = new Object();
    private String readLabel = "";
    private Set domainSet;
    private DateTime startTime;
    private AddeImageDescriptor aid;
    private int[] bandIndices;
    private boolean readDataFailed = false;

    public AreaImageFlatField(AreaImageFlatField that, boolean copy, FunctionType type, Set domainSet, CoordinateSystem rangeCoordSys, CoordinateSystem[] rangeCoordSysArray, Set[] rangeSets, Unit[] units, String readLabel) throws VisADException {
        super(that, copy, type, domainSet, rangeCoordSys, rangeCoordSysArray, rangeSets, units);
        this.aid = that.aid;
        this.readLabel = readLabel;
        if (that.haveData()) {
            this.setDomain(that.getDomainSet());
        }
    }

    public AreaImageFlatField(AddeImageDescriptor aid, FunctionType type, Set domainSet, CoordinateSystem rangeCoordSys, Set[] rangeSets, Unit[] units, float[][] floats, String readLabel) throws VisADException {
        super(type, domainSet, rangeCoordSys, rangeSets, units, floats);
        this.domainSet = domainSet;
        this.aid = aid;
        this.readLabel = readLabel;
    }

    @Override
    public CachedFlatField cloneMe(boolean copy, FunctionType type, Set domainSet, CoordinateSystem rangeCoordSys, CoordinateSystem[] rangeCoordSysArray, Set[] rangeSets, Unit[] units) throws VisADException {
        AreaImageFlatField theClone = new AreaImageFlatField(this, copy, type, domainSet, rangeCoordSys, rangeCoordSysArray, rangeSets, units, this.readLabel);
        theClone.startTime = this.startTime;
        return theClone;
    }

    @Override
    protected void readValuesFromParent(CachedFlatField parent) throws VisADException {
        this.setDomain(parent.getDomainSet());
    }

    public static AreaImageFlatField createImmediate(AddeImageDescriptor aid, String readLabel) throws VisADException, RemoteException, IOException {
        AreaAdapter aa = new AreaAdapter(aid.getSource(), false);
        SingleBandedImageImpl ff = (SingleBandedImageImpl)aa.getImage();
        float[][] samples = ff.unpackFloats();
        FunctionType type = (FunctionType)ff.getType();
        Set domainSet = ff.getDomainSet();
        CoordinateSystem rangeCoordSys = ff.getRangeCoordinateSystem()[0];
        Set[] rangeSets = ff.getRangeSets();
        Unit[] units = ff.getRangeUnits()[0];
        AreaImageFlatField aiff = new AreaImageFlatField(aid, type, domainSet, rangeCoordSys, rangeSets, units, samples, readLabel);
        aiff.startTime = ff.getStartTime();
        return aiff;
    }

    public static AreaImageFlatField createImmediateWithUnit(AddeImageDescriptor aid, String readLabel, Unit unit) throws VisADException, IOException {
        AreaAdapter aa = new AreaAdapter(aid.getSource(), false);
        SingleBandedImageImpl ff = (SingleBandedImageImpl)aa.getImage();
        float[][] samples = ff.unpackFloats();
        FunctionType type = (FunctionType)ff.getType();
        Set domainSet = ff.getDomainSet();
        CoordinateSystem rangeCoordSys = ff.getRangeCoordinateSystem()[0];
        Set[] rangeSets = ff.getRangeSets();
        Unit[] units = new Unit[]{unit};
        FunctionType functionType = new FunctionType(type.getDomain(), new RealTupleType(DataUtil.makeRealType(type.getRange().toString(), unit)));
        AreaImageFlatField aiff = new AreaImageFlatField(aid, functionType, domainSet, rangeCoordSys, rangeSets, units, samples, readLabel);
        aiff.startTime = ff.getStartTime();
        return aiff;
    }

    public static AreaImageFlatField createImmediateWithUnit(AddeImageDescriptor aid, String readLabel, Unit unit, int startLine, int startEle, int lines, int elems, int lineMag, int eleMag, int band) throws VisADException, IOException {
        AreaDirectory ad = aid.getDirectory();
        int elemNum = ad.getElements();
        int lineNum = ad.getLines();
        if (lineMag > 1) {
            lineMag *= -1;
        }
        if (eleMag > 1) {
            eleMag *= -1;
        }
        AreaAdapter aa = new AreaAdapter(aid.getSource(), startLine, startEle, lines, elems, lineMag, eleMag, band);
        SingleBandedImageImpl ff = (SingleBandedImageImpl)aa.getImage();
        float[][] samples = ff.unpackFloats();
        FunctionType type = (FunctionType)ff.getType();
        Set domainSet = ff.getDomainSet();
        CoordinateSystem rangeCoordSys = ff.getRangeCoordinateSystem()[0];
        Set[] rangeSets = ff.getRangeSets();
        Unit[] units = new Unit[]{unit};
        FunctionType functionType = new FunctionType(type.getDomain(), new RealTupleType(DataUtil.makeRealType(type.getRange().toString(), unit)));
        AreaImageFlatField aiff = new AreaImageFlatField(aid, functionType, domainSet, rangeCoordSys, null, units, samples, readLabel);
        aiff.startTime = ff.getStartTime();
        return aiff;
    }

    public static AreaImageFlatField create(AddeImageDescriptor aid, AreaDirectory areaDirectory, MathType rangeType, String readLabel) throws VisADException, RemoteException, IOException {
        int i;
        AddeImageInfo aii = aid.getImageInfo();
        int nLines = aii != null ? aid.getImageInfo().getLines() : areaDirectory.getLines();
        int nEles = aii != null ? aid.getImageInfo().getElements() : areaDirectory.getElements();
        RealType line = RealType.getRealType("ImageLine", null, null);
        RealType element = RealType.getRealType("ImageElement", null, null);
        int band = 0;
        int[] bandNums = new int[1];
        int numBands = 1;
        if (aii != null) {
            String bandString = aii.getBand();
            if (bandString != null) {
                if (!bandString.equals("ALL")) {
                    band = new Integer(bandString);
                }
            }
            bandNums[0] = band;
        } else {
            int[] allBands = areaDirectory.getBands();
            bandNums[0] = allBands[0];
        }
        int[] bandIndices = new int[numBands];
        if (band != 0) {
            bandIndices[0] = -1;
            for (i = 0; i < numBands; ++i) {
                if (band != bandNums[i]) continue;
                bandIndices[0] = i;
                break;
            }
            if (bandIndices[0] == -1) {
                throw new VisADException("requested band number not in image");
            }
            bandNums = new int[]{band};
            numBands = 1;
        } else {
            for (i = 0; i < numBands; ++i) {
                bandIndices[i] = i;
            }
        }
        RealType[] bands = new RealType[numBands];
        Unit calUnit = null;
        try {
            String unit = areaDirectory.getCalibrationUnitName();
            if (unit != null) {
                String unitName = MetUnits.makeSymbol(areaDirectory.getCalibrationUnitName());
                calUnit = Parser.parse(unitName);
                try {
                    calUnit = calUnit.clone(unitName);
                }
                catch (UnitException unitException) {}
            }
        }
        catch (Exception e) {
            calUnit = null;
        }
        String calType = areaDirectory.getCalibrationType();
        for (int i2 = 0; i2 < numBands; ++i2) {
            bands[i2] = calUnit != null ? RealType.getRealType("Band" + bandNums[i2] + "_" + calType, calUnit) : RealType.getRealType("Band" + bandNums[i2]);
        }
        RealTupleType radiance = new RealTupleType(bands);
        RealType[] domain_components = new RealType[]{element, line};
        MyAREACoordinateSystem cs = new MyAREACoordinateSystem();
        RealTupleType image_domain = new RealTupleType(domain_components, (CoordinateSystem)cs, null);
        Linear2DSet domain_set = new Linear2DSet((MathType)image_domain, 0.0, (double)(nEles - 1), nEles, nLines - 1, 0.0, nLines);
        FunctionType image_type = new FunctionType(image_domain, rangeType != null ? rangeType : radiance);
        Set[] rangeSets = null;
        boolean pack = false;
        boolean bl = pack = pack && calType.equalsIgnoreCase("BRIT");
        if (pack) {
            rangeSets = new Set[numBands];
            for (int i3 = 0; i3 < numBands; ++i3) {
                rangeSets[i3] = new Integer1DSet((MathType)bands[i3], 255);
            }
        }
        Unit[] rangeUnits = null;
        if (calUnit != null) {
            rangeUnits = new Unit[numBands];
            for (int i4 = 0; i4 < numBands; ++i4) {
                rangeUnits[i4] = calUnit;
            }
        }
        MyAreaImageFlatField aiff = new MyAreaImageFlatField(aid, image_type, domain_set, null, rangeSets, rangeUnits, (float[][])null, readLabel);
        aiff.bandIndices = bandIndices;
        aiff.startTime = new DateTime(areaDirectory.getNominalTime());
        return aiff;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkReadData() {
        Object object = this.READMUTEX;
        synchronized (object) {
            if (!this.haveData()) {
                try {
                    this.unpackFloats(false);
                }
                catch (VisADException ve) {
                    throw new RuntimeException(ve);
                }
            }
        }
    }

    @Override
    public CoordinateSystem getDomainCoordinateSystem() {
        return this.getDomainSet().getCoordinateSystem();
    }

    public Set getDomainSetNoRead() {
        if (this.domainSet != null) {
            return this.domainSet;
        }
        return super.getDomainSet();
    }

    @Override
    public int getLength() {
        try {
            return this.getDomainSet().getLength();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    @Override
    public Unit[] getDomainUnits() {
        return this.getDomainSet().getSetUnits();
    }

    private void setDomain(Set domainSet) {
        this.domainSet = domainSet;
    }

    public void setDomainIfNeeded(Set domainSet) {
        if (!this.haveData()) {
            this.domainSet = domainSet;
        }
    }

    @Override
    public Set getDomainSet() {
        if (this.aid != null) {
            this.checkReadData();
        }
        if (this.domainSet != null) {
            return this.domainSet;
        }
        throw new IllegalStateException("AreaImageFlatField.getDomainSet: domain set is null");
    }

    private float[][] readDataNewWay() throws Exception {
        try {
            this.msg("readDataNewWay");
            String url = this.aid.getImageInfo() != null ? this.aid.getImageInfo().makeAddeUrl() : this.aid.getSource();
            AreaAdapter aa = new AreaAdapter(url, false);
            SingleBandedImageImpl ff = (SingleBandedImageImpl)aa.getImage();
            float[][] samples = ff.getImageData();
            FunctionType type = (FunctionType)ff.getType();
            Set domainSet = ff.getDomainSet();
            CoordinateSystem rangeCoordSys = ff.getRangeCoordinateSystem()[0];
            Set[] rangeSets = ff.getRangeSets();
            Unit[] units = ff.getRangeUnits()[0];
            this.setDomain(domainSet);
            return samples;
        }
        catch (Exception exc) {
            this.readDataFailed = true;
            String message = exc.toString();
            if (message.indexOf(":") >= 0) {
                message = message.substring(message.lastIndexOf(":"));
            }
            if (this.domainSet == null) {
                this.domainSet = super.getDomainSet();
            }
            System.err.println("Error reading ADDE image:" + this.readLabel + " " + message);
            float[][] values = new float[this.domainSet.getDimension()][this.domainSet.getLength()];
            for (int i = 0; i < values.length; ++i) {
                for (int j = 0; j < values[0].length; ++j) {
                    values[i][j] = Float.NaN;
                }
            }
            return values;
        }
    }

    @Override
    public boolean isMissing() {
        if (this.readDataFailed) {
            return true;
        }
        return super.isMissing();
    }

    private float[][] readDataOldWay() throws Exception {
        long tt1 = System.currentTimeMillis();
        AreaFile areaFile = AreaFileFactory.getAreaFileInstance(this.aid.getImageInfo() != null ? this.aid.getImageInfo().makeAddeUrl() : this.aid.getSource());
        long tt2 = System.currentTimeMillis();
        long t1 = System.currentTimeMillis();
        float[][][] flt_samples = areaFile.getFloatData();
        long t2 = System.currentTimeMillis();
        int nLines = flt_samples[0].length;
        int nEles = flt_samples[0][0].length;
        float[][] samples = new float[1][nEles * nLines];
        float calScale = 1.0f / (float)areaFile.getAreaDirectory().getCalibrationScaleFactor();
        int bandIndex = this.bandIndices[0];
        int lineIdx = 0;
        int elementIdx = 0;
        try {
            for (lineIdx = 0; lineIdx < nLines; ++lineIdx) {
                int sampleOffset = nEles * lineIdx;
                float[] line = flt_samples[bandIndex][lineIdx];
                for (elementIdx = 0; elementIdx < nEles; ++elementIdx) {
                    float v;
                    samples[0][elementIdx + sampleOffset] = v = calScale * line[elementIdx];
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException aioe) {
            System.err.println("error:" + aioe + "\n      band index:" + bandIndex + " neles:" + nEles + " nLines:" + nLines + "  flt:" + flt_samples.length + " X " + flt_samples[0].length + " X " + flt_samples[0][0].length + "   i:" + lineIdx + " elementIdx:" + elementIdx);
            aioe.printStackTrace();
            throw aioe;
        }
        return samples;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public float[][] readData() {
        Object object = this.READMUTEX;
        synchronized (object) {
            try {
                if (this.haveData()) {
                    System.err.println("DOING DOUBLE READ");
                }
                LogUtil.message(this.readLabel);
                DataSourceImpl.incrOutstandingGetDataCalls();
                float[][] fArray = this.readDataNewWay();
                return fArray;
            }
            catch (Exception exc) {
                throw new WrapperException(exc);
            }
            finally {
                DataSourceImpl.decrOutstandingGetDataCalls();
                LogUtil.message("");
            }
        }
    }

    public void setReadLabel(String s) {
        this.readLabel = s;
    }

    @Override
    public DateTime getStartTime() {
        return this.startTime;
    }

    @Override
    public String getDescription() {
        return "image";
    }

    @Override
    public Real getMinRangeValue() {
        return null;
    }

    @Override
    public Real getMaxRangeValue() {
        return null;
    }

    @Override
    public boolean isNavigated() {
        return true;
    }

    public static class MyAREACoordinateSystem
    extends AREACoordinateSystem {
        public MyAREACoordinateSystem(int[] dir, int[] nav, int[] aux, boolean useSpline) throws VisADException {
            super(dir, nav, aux, useSpline);
        }

        public MyAREACoordinateSystem() throws VisADException {
        }

        @Override
        protected AREAnav getAreaNav() {
            AREAnav anav = super.getAreaNav();
            if (anav == null) {
                try {
                    throw new IllegalArgumentException("MyAreaCoordinateSystem.getAreaNav: Should never get to this point");
                }
                catch (Exception exc) {
                    System.err.println("error making making areanav:" + exc);
                    exc.printStackTrace();
                }
            }
            return super.getAreaNav();
        }
    }
}

