/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import visad.Gridded2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.SampledSet;
import visad.UnionSet;
import visad.VisADException;
import visad.python.JPythonMethods;

public class ZebraAsciiMapAdapter {
    private UnionSet maplines;
    private BufferedReader reader;

    public ZebraAsciiMapAdapter(String filename) throws IOException, VisADException {
        this(new FileInputStream(filename));
    }

    public ZebraAsciiMapAdapter(URL url) throws IOException, VisADException {
        this(url.openStream());
    }

    public ZebraAsciiMapAdapter(InputStream is) throws IOException, VisADException {
        this.reader = new BufferedReader(new InputStreamReader(is));
    }

    public UnionSet getData() throws VisADException {
        Vector<Gridded2DSet> sets = new Vector<Gridded2DSet>();
        try {
            boolean i = false;
            String line = this.reader.readLine();
            while (line != null) {
                PolyLineHeader ph = new PolyLineHeader(line);
                int numPoints = ph.getNumPoints();
                float[][] points = new float[2][numPoints];
                int curPoint = 0;
                while (curPoint < numPoints) {
                    line = this.reader.readLine();
                    StringTokenizer tok = new StringTokenizer(line);
                    while (tok.hasMoreTokens()) {
                        points[0][curPoint] = Float.parseFloat(tok.nextToken());
                        points[1][curPoint] = Float.parseFloat(tok.nextToken());
                        ++curPoint;
                    }
                }
                Gridded2DSet set = new Gridded2DSet((MathType)RealTupleType.LatitudeLongitudeTuple, points, numPoints);
                sets.add(set);
                line = this.reader.readLine();
            }
            if (!sets.isEmpty()) {
                Object[] basemaplines = new Gridded2DSet[sets.size()];
                sets.copyInto(basemaplines);
                this.maplines = new UnionSet((SampledSet[])basemaplines);
            }
        }
        catch (IOException ie) {
            ie.printStackTrace();
        }
        return this.maplines;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("must supply filename");
            System.exit(1);
        }
        ZebraAsciiMapAdapter zama = new ZebraAsciiMapAdapter(args[0]);
        JPythonMethods.dumpTypes(zama.getData());
    }

    private class PolyLineHeader {
        private int numPoints;
        private float minLat;
        private float maxLat;
        private float minLon;
        private float maxLon;
        private boolean fill = false;

        public PolyLineHeader(String header) {
            StringTokenizer tok = new StringTokenizer(header);
            this.numPoints = Integer.parseInt(tok.nextToken()) / 2;
            this.maxLat = Float.parseFloat(tok.nextToken());
            this.minLat = Float.parseFloat(tok.nextToken());
            this.maxLon = Float.parseFloat(tok.nextToken());
            this.minLon = Float.parseFloat(tok.nextToken());
            this.fill = tok.hasMoreTokens();
        }

        public int getNumPoints() {
            return this.numPoints;
        }
    }
}

