/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad;

import ucar.visad.WindBarb;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.SphericalCoordinateSystem;
import visad.Unit;
import visad.UnitException;
import visad.bom.BarbRendererJ3D;

public class WindBarbRenderer
extends BarbRendererJ3D {
    private Unit speedUnit = CommonUnit.meterPerSecond;

    public WindBarbRenderer() {
        this(CommonUnit.meterPerSecond);
    }

    public WindBarbRenderer(Unit speedUnit) {
        this.speedUnit = speedUnit;
    }

    @Override
    public float[] makeVector(boolean south, float x, float y, float z, float scale, float pt_size, float f0, float f1, float[] vx, float[] vy, float[] vz, int[] numv, float[] tx, float[] ty, float[] tz, int[] numt) {
        CoordinateSystem dcs;
        Unit u = this.speedUnit;
        if (u != null && Unit.canConvert(u, CommonUnit.meterPerSecond) && !u.equals(CommonUnit.meterPerSecond)) {
            try {
                f0 = (float)CommonUnit.meterPerSecond.toThis(f0, u);
                f1 = (float)CommonUnit.meterPerSecond.toThis(f1, u);
            }
            catch (UnitException unitException) {
                // empty catch block
            }
        }
        boolean rotateToGlobe = (dcs = this.getDisplayCoordinateSystem()) != null && dcs instanceof SphericalCoordinateSystem;
        return WindBarb.makeBarb(south, x, y, z, scale, pt_size, f0, f1, vx, vy, vz, numv, tx, ty, tz, numt, rotateToGlobe);
    }

    @Override
    public Object clone() {
        return new WindBarbRenderer();
    }
}

