/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad;

import javax.media.j3d.Transform3D;
import javax.vecmath.Point3f;
import visad.VisADException;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADTriangleArray;

public class WindBarb {
    private static Object sync = new Object();
    private static final int NUM = 256;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static VisADGeometryArray[] staticMakeFlow(float[][] flow_values, float flowScale, float[][] spatial_values, byte[][] color_values, boolean[][] range_select, boolean isSouth) throws VisADException {
        int i;
        int numColors;
        if (flow_values[0] == null) {
            return null;
        }
        if (spatial_values[0] == null) {
            return null;
        }
        int len = spatial_values[0].length;
        int flen = flow_values[0].length;
        int rlen = 0;
        if (range_select[0] == null) {
            rlen = len;
        } else {
            for (int j = 0; j < range_select[0].length; ++j) {
                if (!range_select[0][j]) continue;
                ++rlen;
            }
        }
        if (rlen == 0) {
            return null;
        }
        boolean[] south = new boolean[len];
        for (int i2 = 0; i2 < len; ++i2) {
            south[i2] = isSouth;
        }
        float[] vx = new float[256];
        float[] vy = new float[256];
        float[] vz = new float[256];
        float[] tx = new float[256];
        float[] ty = new float[256];
        float[] tz = new float[256];
        byte[] vred = null;
        byte[] vgreen = null;
        byte[] vblue = null;
        byte[] valpha = null;
        byte[] tred = null;
        byte[] tgreen = null;
        byte[] tblue = null;
        byte[] talpha = null;
        int n = numColors = color_values != null ? color_values.length : 3;
        if (color_values != null) {
            vred = new byte[256];
            vgreen = new byte[256];
            vblue = new byte[256];
            if (numColors == 4) {
                valpha = new byte[256];
            }
            tred = new byte[256];
            tgreen = new byte[256];
            tblue = new byte[256];
            if (numColors == 4) {
                talpha = new byte[256];
            }
        }
        int[] numv = new int[]{0};
        int[] numt = new int[]{0};
        float scale = flowScale;
        float pt_size = 0.25f * flowScale;
        float f0 = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        for (int j = 0; j < len; ++j) {
            int i3;
            byte[] calpha;
            byte[] cblue;
            byte[] cgreen;
            byte[] cred;
            int l;
            Object cz;
            float[] cy;
            float[] cx;
            if (range_select[0] != null && !range_select[0][j]) continue;
            if (flen == 1) {
                f0 = flow_values[0][0];
                f1 = flow_values[1][0];
                f2 = flow_values[2][0];
            } else {
                f0 = flow_values[0][j];
                f1 = flow_values[1][j];
                f2 = flow_values[2][j];
            }
            if (numv[0] + 64 > vx.length) {
                cx = vx;
                cy = vy;
                cz = vz;
                l = 2 * vx.length;
                vx = new float[l];
                vy = new float[l];
                vz = new float[l];
                System.arraycopy(cx, 0, vx, 0, cx.length);
                System.arraycopy(cy, 0, vy, 0, cy.length);
                System.arraycopy(cz, 0, vz, 0, ((float[])cz).length);
                if (color_values != null) {
                    cred = vred;
                    cgreen = vgreen;
                    cblue = vblue;
                    calpha = valpha;
                    vred = new byte[l];
                    vgreen = new byte[l];
                    vblue = new byte[l];
                    if (calpha != null) {
                        valpha = new byte[l];
                    }
                    System.arraycopy(cred, 0, vred, 0, cred.length);
                    System.arraycopy(cgreen, 0, vgreen, 0, cgreen.length);
                    System.arraycopy(cblue, 0, vblue, 0, cblue.length);
                    if (calpha != null) {
                        System.arraycopy(calpha, 0, valpha, 0, calpha.length);
                    }
                }
            }
            if (numt[0] + 64 > tx.length) {
                cx = tx;
                cy = ty;
                cz = tz;
                l = 2 * tx.length;
                tx = new float[l];
                ty = new float[l];
                tz = new float[l];
                System.arraycopy(cx, 0, tx, 0, cx.length);
                System.arraycopy(cy, 0, ty, 0, cy.length);
                System.arraycopy(cz, 0, tz, 0, ((float[])cz).length);
                if (color_values != null) {
                    cred = tred;
                    cgreen = tgreen;
                    cblue = tblue;
                    calpha = talpha;
                    tred = new byte[l];
                    tgreen = new byte[l];
                    tblue = new byte[l];
                    if (calpha != null) {
                        talpha = new byte[l];
                    }
                    System.arraycopy(cred, 0, tred, 0, cred.length);
                    System.arraycopy(cgreen, 0, tgreen, 0, cgreen.length);
                    System.arraycopy(cblue, 0, tblue, 0, cblue.length);
                    if (calpha != null) {
                        System.arraycopy(calpha, 0, talpha, 0, calpha.length);
                    }
                }
            }
            int oldnv = numv[0];
            int oldnt = numt[0];
            Object object = sync;
            cz = object;
            // MONITORENTER : object
            float[] l2 = WindBarb.makeBarb(south[j], spatial_values[0][j], spatial_values[1][j], spatial_values[2][j], scale, pt_size, f0, f1, vx, vy, vz, numv, tx, ty, tz, numt);
            // MONITOREXIT : cz
            int nv = numv[0];
            int nt = numt[0];
            if (color_values == null) continue;
            if (color_values[0].length > 1) {
                int i4;
                for (i4 = oldnv; i4 < nv; ++i4) {
                    vred[i4] = color_values[0][j];
                    vgreen[i4] = color_values[1][j];
                    vblue[i4] = color_values[2][j];
                    if (numColors != 4) continue;
                    valpha[i4] = color_values[3][j];
                }
                for (i4 = oldnt; i4 < nt; ++i4) {
                    tred[i4] = color_values[0][j];
                    tgreen[i4] = color_values[1][j];
                    tblue[i4] = color_values[2][j];
                    if (numColors != 4) continue;
                    talpha[i4] = color_values[3][j];
                }
                continue;
            }
            for (i3 = oldnv; i3 < nv; ++i3) {
                vred[i3] = color_values[0][0];
                vgreen[i3] = color_values[1][0];
                vblue[i3] = color_values[2][0];
                if (numColors != 4) continue;
                valpha[i3] = color_values[3][0];
            }
            for (i3 = oldnt; i3 < nt; ++i3) {
                tred[i3] = color_values[0][0];
                tgreen[i3] = color_values[1][0];
                tblue[i3] = color_values[2][0];
                if (numColors != 4) continue;
                talpha[i3] = color_values[3][0];
            }
        }
        int nv = numv[0];
        int nt = numt[0];
        if (nv == 0) {
            return null;
        }
        VisADGeometryArray[] arrays = null;
        VisADLineArray array = new VisADLineArray();
        array.vertexCount = nv;
        float[] coordinates = new float[3 * nv];
        int m = 0;
        for (int i5 = 0; i5 < nv; ++i5) {
            coordinates[m++] = vx[i5];
            coordinates[m++] = vy[i5];
            coordinates[m++] = vz[i5];
        }
        array.coordinates = coordinates;
        byte[] colors = null;
        if (color_values != null) {
            colors = new byte[numColors * nv];
            m = 0;
            for (int i6 = 0; i6 < nv; ++i6) {
                colors[m++] = vred[i6];
                colors[m++] = vgreen[i6];
                colors[m++] = vblue[i6];
                if (numColors != 4) continue;
                colors[m++] = valpha[i6];
            }
            array.colors = colors;
        }
        VisADTriangleArray tarray = null;
        if (nt <= 0) {
            return new VisADGeometryArray[]{array};
        }
        tarray = new VisADTriangleArray();
        tarray.vertexCount = nt;
        coordinates = new float[3 * nt];
        float[] normals = new float[3 * nt];
        m = 0;
        for (i = 0; i < nt; ++i) {
            coordinates[m++] = tx[i];
            coordinates[m++] = ty[i];
            coordinates[m++] = tz[i];
        }
        tarray.coordinates = coordinates;
        m = 0;
        for (i = 0; i < nt; ++i) {
            normals[m++] = 0.0f;
            normals[m++] = 0.0f;
            normals[m++] = 1.0f;
        }
        tarray.normals = normals;
        if (color_values == null) return new VisADGeometryArray[]{array, tarray};
        colors = new byte[numColors * nt];
        m = 0;
        for (i = 0; i < nt; ++i) {
            colors[m++] = tred[i];
            colors[m++] = tgreen[i];
            colors[m++] = tblue[i];
            if (numColors != 4) continue;
            colors[m++] = talpha[i];
        }
        tarray.colors = colors;
        return new VisADGeometryArray[]{array, tarray};
    }

    public static float[] makeBarbOld(boolean south, float x, float y, float z, float scale, float pt_size, float f0, float f1, float[] vx, float[] vy, float[] vz, int[] numv, float[] tx, float[] ty, float[] tz, int[] numt) {
        float[] mbarb = new float[4];
        mbarb[0] = x;
        mbarb[1] = y;
        f0 = (float)((double)f0 * 1.9425354836481679);
        f1 = (float)((double)f1 * 1.9425354836481679);
        float wnd_spd = (float)Math.sqrt(f0 * f0 + f1 * f1);
        int lenv = vx.length;
        int lent = tx.length;
        int nv = numv[0];
        int nt = numt[0];
        if ((double)wnd_spd >= 2.5) {
            float y2;
            float x2;
            float wsp25 = (float)Math.max((double)wnd_spd + 2.5, 5.0);
            float slant = 0.15f * scale;
            float barb = 0.4f * scale;
            float x0 = -f0 / wnd_spd;
            float y0 = -f1 / wnd_spd;
            float d = 2.0f * barb;
            float x1 = x + x0 * d;
            float y1 = y + y0 * d;
            int nbarb50 = (int)(wsp25 / 50.0f);
            int nbarb10 = (int)((wsp25 - (float)nbarb50 * 50.0f) / 10.0f);
            int nbarb5 = (int)((wsp25 - (float)nbarb50 * 50.0f - (float)nbarb10 * 10.0f) / 5.0f);
            if (nbarb5 == 1) {
                barb *= 0.6f;
                slant *= 0.6f;
                x1 = x + x0 * d;
                y1 = y + y0 * d;
                if (south) {
                    x2 = x + x0 * (d + slant) - y0 * barb;
                    y2 = y + y0 * (d + slant) + x0 * barb;
                } else {
                    x2 = x + x0 * (d + slant) + y0 * barb;
                    y2 = y + y0 * (d + slant) - x0 * barb;
                }
                vx[nv] = x1;
                vy[nv] = y1;
                vz[nv] = z;
                vx[++nv] = x2;
                vy[nv] = y2;
                vz[nv] = z;
                ++nv;
            }
            if (wsp25 >= 5.0f && wsp25 < 10.0f) {
                x1 = x + x0 * (d += pt_size);
                y1 = y + y0 * d;
            }
            barb = 0.4f * scale;
            slant = 0.15f * scale;
            for (int j = 0; j < nbarb10; ++j) {
                x1 = x + x0 * (d += pt_size);
                y1 = y + y0 * d;
                if (south) {
                    x2 = x + x0 * (d + slant) - y0 * barb;
                    y2 = y + y0 * (d + slant) + x0 * barb;
                } else {
                    x2 = x + x0 * (d + slant) + y0 * barb;
                    y2 = y + y0 * (d + slant) - x0 * barb;
                }
                vx[nv] = x1;
                vy[nv] = y1;
                vz[nv] = z;
                vx[++nv] = x2;
                vy[nv] = y2;
                vz[nv] = z;
                ++nv;
            }
            if (nbarb50 > 0) {
                d += pt_size;
            }
            float flagSpace = 0.5f * pt_size;
            float flagWidth = 1.75f * slant;
            for (int j = 0; j < nbarb50; ++j) {
                x1 = x + x0 * d;
                y1 = y + y0 * d;
                float x3 = x + x0 * (d + flagWidth);
                float y3 = y + y0 * (d + flagWidth);
                if (south) {
                    x2 = x + x0 * (d + slant) - y0 * barb;
                    y2 = y + y0 * (d + slant) + x0 * barb;
                } else {
                    x2 = x + x0 * (d + slant) + y0 * barb;
                    y2 = y + y0 * (d + slant) - x0 * barb;
                }
                d = d + flagWidth + flagSpace;
                float[] xp = new float[]{x1, x2, x3};
                float[] yp = new float[]{y1, y2, y3};
                tx[nt] = x1;
                ty[nt] = y1;
                tz[nt] = z;
                tx[++nt] = x2;
                ty[nt] = y2;
                tz[nt] = z;
                tx[++nt] = x3;
                ty[nt] = y3;
                tz[nt] = z;
                ++nt;
                x1 = x3;
                y1 = y3;
            }
            vx[nv] = x;
            vy[nv] = y;
            vz[nv] = z;
            vx[++nv] = x1;
            vy[nv] = y1;
            vz[nv] = z;
            mbarb[2] = x1;
            mbarb[3] = y1;
        } else {
            float rad = 0.7f * pt_size;
            vx[nv] = x - rad;
            vy[nv] = y;
            vz[nv] = z;
            vx[++nv] = x - 0.7f * rad;
            vy[nv] = y + 0.7f * rad;
            vz[nv] = z;
            vx[++nv] = x - 0.7f * rad;
            vy[nv] = y + 0.7f * rad;
            vz[nv] = z;
            vx[++nv] = x;
            vy[nv] = y + rad;
            vz[nv] = z;
            vx[++nv] = x;
            vy[nv] = y + rad;
            vz[nv] = z;
            vx[++nv] = x + 0.7f * rad;
            vy[nv] = y + 0.7f * rad;
            vz[nv] = z;
            vx[++nv] = x + 0.7f * rad;
            vy[nv] = y + 0.7f * rad;
            vz[nv] = z;
            vx[++nv] = x + rad;
            vy[nv] = y;
            vz[nv] = z;
            vx[++nv] = x + rad;
            vy[nv] = y;
            vz[nv] = z;
            vx[++nv] = x + 0.7f * rad;
            vy[nv] = y - 0.7f * rad;
            vz[nv] = z;
            vx[++nv] = x + 0.7f * rad;
            vy[nv] = y - 0.7f * rad;
            vz[nv] = z;
            vx[++nv] = x;
            vy[nv] = y - rad;
            vz[nv] = z;
            vx[++nv] = x;
            vy[nv] = y - rad;
            vz[nv] = z;
            vx[++nv] = x - 0.7f * rad;
            vy[nv] = y - 0.7f * rad;
            vz[nv] = z;
            vx[++nv] = x - 0.7f * rad;
            vy[nv] = y - 0.7f * rad;
            vz[nv] = z;
            vx[++nv] = x - rad;
            vy[nv] = y;
            vz[nv] = z;
            ++nv;
            mbarb[2] = x;
            mbarb[3] = y;
        }
        numv[0] = ++nv;
        numt[0] = nt;
        return mbarb;
    }

    public static float[] makeBarb(boolean south, float x, float y, float z, float scale, float pt_size, float f0, float f1, float[] vx, float[] vy, float[] vz, int[] numv, float[] tx, float[] ty, float[] tz, int[] numt) {
        return WindBarb.makeBarb(south, x, y, z, scale, pt_size, f0, f1, vx, vy, vz, numv, tx, ty, tz, numt, false);
    }

    public static float[] makeBarb(boolean south, float x, float y, float z, float scale, float pt_size, float f0, float f1, float[] vx, float[] vy, float[] vz, int[] numv, float[] tx, float[] ty, float[] tz, int[] numt, boolean rotateToGlobe) {
        float[] mbarb = new float[4];
        mbarb[0] = x;
        mbarb[1] = y;
        f0 = (float)((double)f0 * 1.9425354836481679);
        f1 = (float)((double)f1 * 1.9425354836481679);
        float wnd_spd = (float)Math.sqrt(f0 * f0 + f1 * f1);
        int lenv = vx.length;
        int lent = tx.length;
        int nv = numv[0];
        int nt = numt[0];
        int maxbas = 6;
        int nvStart = nv;
        int ntStart = nt;
        if (wnd_spd > 0.0f) {
            float y2;
            float x2;
            int j;
            float wsp25 = (float)Math.max((double)wnd_spd + 2.5, 5.0);
            float slant = 0.15f * scale;
            float barb = (double)wnd_spd <= 2.5 ? 0.0f : 0.5f * scale;
            float x0 = -f0 / wnd_spd;
            float y0 = -f1 / wnd_spd;
            int nbarb50 = (int)(wsp25 / 50.0f);
            int nbarb10 = (int)((wsp25 - (float)nbarb50 * 50.0f) / 10.0f);
            int nbarb5 = (int)((wsp25 - (float)nbarb50 * 50.0f - (float)nbarb10 * 10.0f) / 5.0f);
            int nbas = nbarb50 * 2 + nbarb10 + nbarb5;
            nbas = Math.max(nbas, maxbas);
            float barbSpace = 0.7f * pt_size;
            float d = (float)nbas * pt_size;
            float x1 = x + x0 * d;
            float y1 = y + y0 * d;
            mbarb[2] = x1;
            mbarb[3] = y1;
            float flagSpace = 0.3333f * barbSpace;
            float flagWidth = 1.6666f * barbSpace;
            float flagSlant = flagWidth - slant;
            for (j = 0; j < nbarb50; ++j) {
                x1 = x + x0 * d;
                y1 = y + y0 * d;
                float x3 = x + x0 * (d - flagWidth);
                float y3 = y + y0 * (d - flagWidth);
                if (south) {
                    x2 = x + x0 * (d - flagSlant) - y0 * barb;
                    y2 = y + y0 * (d - flagSlant) + x0 * barb;
                } else {
                    x2 = x + x0 * (d - flagSlant) + y0 * barb;
                    y2 = y + y0 * (d - flagSlant) - x0 * barb;
                }
                d = d - flagWidth - flagSpace;
                tx[nt] = x1;
                ty[nt] = y1;
                tz[nt] = z;
                tx[++nt] = x2;
                ty[nt] = y2;
                tz[nt] = z;
                tx[++nt] = x3;
                ty[nt] = y3;
                tz[nt] = z;
                ++nt;
                x1 = x3;
                y1 = y3;
            }
            if (nbarb50 > 0) {
                d -= 0.5f * barbSpace;
            }
            for (j = 0; j < nbarb10; ++j) {
                x1 = x + x0 * d;
                y1 = y + y0 * d;
                if (south) {
                    x2 = x + x0 * (d + slant) - y0 * barb;
                    y2 = y + y0 * (d + slant) + x0 * barb;
                } else {
                    x2 = x + x0 * (d + slant) + y0 * barb;
                    y2 = y + y0 * (d + slant) - x0 * barb;
                }
                d -= barbSpace;
                vx[nv] = x1;
                vy[nv] = y1;
                vz[nv] = z;
                vx[++nv] = x2;
                vy[nv] = y2;
                vz[nv] = z;
                ++nv;
            }
            if (nbarb50 == 0 && nbarb10 == 0) {
                d -= barbSpace;
            }
            if (nbarb5 == 1) {
                barb *= 0.6f;
                slant *= 0.6f;
                x1 = x + x0 * d;
                y1 = y + y0 * d;
                if (south) {
                    x2 = x + x0 * (d + slant) - y0 * barb;
                    y2 = y + y0 * (d + slant) + x0 * barb;
                } else {
                    x2 = x + x0 * (d + slant) + y0 * barb;
                    y2 = y + y0 * (d + slant) - x0 * barb;
                }
                vx[nv] = x1;
                vy[nv] = y1;
                vz[nv] = z;
                vx[++nv] = x2;
                vy[nv] = y2;
                vz[nv] = z;
                ++nv;
            }
            vx[nv] = x;
            vy[nv] = y;
            vz[nv] = z;
            vx[++nv] = mbarb[2];
            vy[nv] = mbarb[3];
            vz[nv] = z;
            ++nv;
        } else {
            float rad = 0.7f * pt_size;
            vx[nv] = x - rad;
            vy[nv] = y;
            vz[nv] = z;
            vx[++nv] = x - 0.7f * rad;
            vy[nv] = y + 0.7f * rad;
            vz[nv] = z;
            vx[++nv] = x - 0.7f * rad;
            vy[nv] = y + 0.7f * rad;
            vz[nv] = z;
            vx[++nv] = x;
            vy[nv] = y + rad;
            vz[nv] = z;
            vx[++nv] = x;
            vy[nv] = y + rad;
            vz[nv] = z;
            vx[++nv] = x + 0.7f * rad;
            vy[nv] = y + 0.7f * rad;
            vz[nv] = z;
            vx[++nv] = x + 0.7f * rad;
            vy[nv] = y + 0.7f * rad;
            vz[nv] = z;
            vx[++nv] = x + rad;
            vy[nv] = y;
            vz[nv] = z;
            vx[++nv] = x + rad;
            vy[nv] = y;
            vz[nv] = z;
            vx[++nv] = x + 0.7f * rad;
            vy[nv] = y - 0.7f * rad;
            vz[nv] = z;
            vx[++nv] = x + 0.7f * rad;
            vy[nv] = y - 0.7f * rad;
            vz[nv] = z;
            vx[++nv] = x;
            vy[nv] = y - rad;
            vz[nv] = z;
            vx[++nv] = x;
            vy[nv] = y - rad;
            vz[nv] = z;
            vx[++nv] = x - 0.7f * rad;
            vy[nv] = y - 0.7f * rad;
            vz[nv] = z;
            vx[++nv] = x - 0.7f * rad;
            vy[nv] = y - 0.7f * rad;
            vz[nv] = z;
            vx[++nv] = x - rad;
            vy[nv] = y;
            vz[nv] = z;
            ++nv;
            mbarb[2] = x;
            mbarb[3] = y;
        }
        if (rotateToGlobe) {
            // empty if block
        }
        numv[0] = nv;
        numt[0] = nt;
        return mbarb;
    }

    private static void applyTransform(Transform3D t3d, float[] xPts, float[] yPts, float[] zPts) {
        Point3f pt3f = new Point3f();
        float[] tmp = new float[3];
        for (int k = 0; k < xPts.length; ++k) {
            pt3f.set(xPts[k], yPts[k], zPts[k]);
            t3d.transform(pt3f);
            pt3f.get(tmp);
            xPts[k] = tmp[0];
            yPts[k] = tmp[1];
            zPts[k] = tmp[2];
        }
    }
}

