/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.nc2.iosp.mcidas.McIDASAreaProjection;
import ucar.nc2.time.Calendar;
import ucar.unidata.data.point.PointOb;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.ui.PropertyFilter;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlDelegate;
import ucar.unidata.xml.XmlDelegateImpl;
import ucar.unidata.xml.XmlEncoder;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.Util;
import ucar.visad.data.CalendarDateTime;
import visad.CMYCoordinateSystem;
import visad.CachingCoordinateSystem;
import visad.CartesianProductCoordinateSystem;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.CylindricalCoordinateSystem;
import visad.DateTime;
import visad.Display;
import visad.DisplayRealType;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FlowSphericalCoordinateSystem;
import visad.FunctionType;
import visad.GriddedSet;
import visad.HSVCoordinateSystem;
import visad.IdentityCoordinateSystem;
import visad.MathType;
import visad.PolarCoordinateSystem;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarMap;
import visad.ScaledUnit;
import visad.Set;
import visad.SetType;
import visad.SphericalCoordinateSystem;
import visad.Text;
import visad.TextType;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;
import visad.bom.WindPolarCoordinateSystem;
import visad.data.mcidas.AREACoordinateSystem;
import visad.data.vis5d.Vis5DCoordinateSystem;
import visad.georef.EarthLocationLite;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonTuple;
import visad.georef.NamedLocationTuple;
import visad.georef.TrivialMapProjection;
import visad.georef.TrivialNavigation;
import visad.meteorology.ImageSequenceImpl;

public class VisADPersistence {
    public static final String ATTR_AMOUNT = "amount";
    public static final String ATTR_NAME = "name";
    private static List delegates;
    private static List classes;
    private static List highPriorityDelegates;
    private static List highPriorityClasses;
    XmlEncoder myEncoder;

    private VisADPersistence(XmlEncoder encoder) {
        this.myEncoder = encoder;
        encoder.registerClassName("ucar.unidata.util.PropertyFilter", PropertyFilter.class);
        this.init();
    }

    private static void addDelegate(Class c, XmlDelegate delegate) {
        classes.add(c);
        delegates.add(delegate);
    }

    private static void addHighPriorityDelegate(Class c, XmlDelegate delegate) {
        highPriorityClasses.add(c);
        highPriorityDelegates.add(delegate);
    }

    public static void init(XmlEncoder encoder) {
        new VisADPersistence(encoder);
    }

    private void init() {
        int i;
        if (delegates == null) {
            VisADPersistence.initDelegates();
        }
        for (i = 0; i < delegates.size(); ++i) {
            this.myEncoder.addDelegateForClass((Class)classes.get(i), (XmlDelegate)delegates.get(i));
        }
        for (i = 0; i < highPriorityDelegates.size(); ++i) {
            this.myEncoder.addHighPriorityDelegateForClass((Class)highPriorityClasses.get(i), (XmlDelegate)highPriorityDelegates.get(i));
        }
    }

    private static void initDelegates() {
        delegates = new ArrayList();
        classes = new ArrayList();
        highPriorityDelegates = new ArrayList();
        highPriorityClasses = new ArrayList();
        VisADPersistence.addHighPriorityDelegate(ProjectionRect.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                ProjectionRect r = (ProjectionRect)o;
                List args = Misc.newList(new Double(r.getMinX()), new Double(r.getMinY()), new Double(r.getMaxX()), new Double(r.getMaxY()));
                List types = Misc.newList(Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        VisADPersistence.addDelegate(Real.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                Real r = (Real)o;
                List args = Misc.newList(r.getType(), new Double(r.getValue()), r.getUnit(), r.getError());
                List types = Misc.newList(RealType.class, Double.TYPE, VisADPersistence.getUnitClass(r.getUnit()), ErrorEstimate.class);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        VisADPersistence.addDelegate(SetType.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                SetType s = (SetType)o;
                List args = Misc.newList(s.getDomain());
                return e.createObjectConstructorElement(o, args);
            }
        });
        VisADPersistence.addDelegate(ErrorEstimate.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                ErrorEstimate r = (ErrorEstimate)o;
                Unit unit = r.getUnit();
                List args = Misc.newList(new Double(r.getErrorValue()), new Double(r.getMean()), new Long(r.getNumberNotMissing()), unit);
                List types = Misc.newList(Double.TYPE, Double.TYPE, Long.TYPE, VisADPersistence.getUnitClass(r.getUnit()));
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        VisADPersistence.addDelegate(DisplayRealType.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                DisplayRealType d = (DisplayRealType)o;
                double[] range = new double[]{Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY};
                boolean isRange = d.getRange(range);
                List args = Misc.newList(new Object[]{d.getName(), new Boolean(d.isSingle()), new Double(range[0]), new Double(range[1]), new Double(d.getDefaultValue()), d.getDefaultUnit()});
                Element objectElement = e.createObjectElement(o.getClass());
                Element listElement = e.createElement(args);
                objectElement.appendChild(listElement);
                return objectElement;
            }

            @Override
            public Object createObject(XmlEncoder e, Element o) {
                DisplayRealType drt;
                block5: {
                    Element listElement = XmlUtil.getFirstChild(o);
                    ArrayList args = (ArrayList)e.createObject(listElement);
                    String name = (String)args.get(0);
                    DisplayRealType bogus = Display.Animation;
                    drt = (DisplayRealType)DisplayRealType.getRealTypeByName(name);
                    if (drt != null) break block5;
                    if (name.startsWith("Display")) {
                        for (int i = 0; i < Display.DisplayRealArray.length; ++i) {
                            if (!Display.DisplayRealArray[i].getName().equals(name)) continue;
                            drt = Display.DisplayRealArray[i];
                        }
                    } else {
                        boolean single = (Boolean)args.get(1);
                        double lo = (Double)args.get(2);
                        double hi = (Double)args.get(3);
                        double def = (Double)args.get(3);
                        try {
                            drt = new DisplayRealType((String)args.get(0), single, lo, hi, def, (Unit)args.get(4));
                        }
                        catch (VisADException excp) {
                            drt = null;
                        }
                    }
                }
                return drt;
            }
        });
        VisADPersistence.addDelegate(RealType.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                RealType r = (RealType)o;
                List args = Misc.newList(r.getOriginalName(), r.getDefaultUnit(), r.getDefaultSet(), new Integer(r.getAttributeMask()));
                Element objectElement = e.createObjectElement(o.getClass());
                Element listElement = e.createElement(args);
                objectElement.appendChild(listElement);
                return objectElement;
            }

            @Override
            public Object createObject(XmlEncoder e, Element o) {
                Element listElement = XmlUtil.getFirstChild(o);
                ArrayList args = (ArrayList)e.createObject(listElement);
                RealType bogus = RealType.Time;
                if (args.size() == 3) {
                    XmlEncoder.debug = true;
                    args = (ArrayList)e.createObject(listElement);
                    XmlEncoder.debug = false;
                }
                if (args.size() != 4) {
                    throw new IllegalArgumentException("Creating RealType. Incorrect number of arguments in list: " + args.size() + "\n" + XmlUtil.toString(o));
                }
                int attrMask = (Integer)args.get(3);
                return RealType.getRealType((String)args.get(0), (Unit)args.get(1), (Set)args.get(2), attrMask);
            }
        });
        VisADPersistence.addDelegate(ErrorEstimate.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                ErrorEstimate r = (ErrorEstimate)o;
                List args = Misc.newList(new Double(r.getErrorValue()), new Double(r.getMean()), new Long(r.getNumberNotMissing()), r.getUnit());
                List types = Misc.newList(Double.TYPE, Double.TYPE, Long.TYPE, VisADPersistence.getUnitClass(r.getUnit()));
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        VisADPersistence.addDelegate(Text.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                Text t = (Text)o;
                List args = Misc.newList(t.getType(), t.getValue());
                return e.createObjectConstructorElement(o, args);
            }
        });
        VisADPersistence.addDelegate(TextType.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                TextType t = (TextType)o;
                Element objectElement = e.createObjectElement(o.getClass());
                objectElement.appendChild(e.createElement(t.getName()));
                return objectElement;
            }

            @Override
            public Object createObject(XmlEncoder e, Element o) {
                String name = (String)e.createObject(XmlUtil.getFirstChild(o));
                return TextType.getTextType(name);
            }
        });
        VisADPersistence.addDelegate(ScaledUnit.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                ScaledUnit r = (ScaledUnit)o;
                Element objectElement = e.createObjectElement(o.getClass());
                objectElement.setAttribute(VisADPersistence.ATTR_AMOUNT, r.getAmount() + "");
                objectElement.setAttribute(VisADPersistence.ATTR_NAME, r.toString());
                Element childElement = e.createElement(r.getUnit());
                objectElement.appendChild(childElement);
                return objectElement;
            }

            @Override
            public Object createObject(XmlEncoder e, Element o) {
                try {
                    Object object = e.createObject(XmlUtil.getFirstChild(o));
                    Unit scaledUnit = null;
                    if (object instanceof String) {
                        String s = (String)object;
                        try {
                            String[] toks = StringUtil.split(s, " ", 2);
                            if (toks == null || toks.length == 1) {
                                Unit unit = VisADPersistence.createUnit(e, o);
                                return unit;
                            }
                            String identifier = toks[1];
                            double amount = new Double(toks[0]);
                            Unit theUnit = Util.parseUnit(identifier);
                            scaledUnit = ScaledUnit.create(amount, theUnit);
                        }
                        catch (Exception exc) {
                            System.err.println("error creating scaled unit:" + exc);
                            Unit unit = VisADPersistence.createUnit(e, o);
                            return unit;
                        }
                    } else {
                        Unit subUnit = (Unit)object;
                        double amount = XmlUtil.getAttribute((Node)o, VisADPersistence.ATTR_AMOUNT, 1.0);
                        scaledUnit = ScaledUnit.create(amount, subUnit);
                    }
                    if (scaledUnit == null) {
                        return scaledUnit;
                    }
                    String name = o.getAttribute(VisADPersistence.ATTR_NAME);
                    if (name != null && name.length() > 0) {
                        scaledUnit = scaledUnit.clone(name);
                    }
                    return scaledUnit;
                }
                catch (Exception exc) {
                    System.err.println("Error creating unit:" + XmlUtil.toString(o));
                    exc.printStackTrace();
                    return null;
                }
            }
        });
        VisADPersistence.addDelegate(Unit.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                Unit r = (Unit)o;
                Element objectElement = e.createObjectElement(o.getClass());
                String unitString = null;
                String unitName = null;
                if (r == CommonUnit.dimensionless) {
                    unitString = "dimensionless";
                } else {
                    unitString = r.getDefinition();
                    unitName = r.toString();
                }
                Element childElement = e.createElement(unitString);
                if (unitName != null) {
                    objectElement.setAttribute(VisADPersistence.ATTR_NAME, unitName);
                }
                objectElement.appendChild(childElement);
                return objectElement;
            }

            @Override
            public Object createObject(XmlEncoder e, Element o) {
                try {
                    return VisADPersistence.createUnit(e, o);
                }
                catch (Exception exc) {
                    System.err.println("Error creating unit " + exc);
                    exc.printStackTrace();
                    return null;
                }
            }
        });
        VisADPersistence.addDelegate(CalendarDateTime.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                CalendarDateTime r = (CalendarDateTime)o;
                List args = Misc.newList(new Double(r.getValue()), (Object)r.getCalendar());
                List types = Misc.newList(Double.TYPE, Calendar.class);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        VisADPersistence.addDelegate(DateTime.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                DateTime r = (DateTime)o;
                List args = Misc.newList(new Double(r.getValue()));
                List types = Misc.newList(Double.TYPE);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        VisADPersistence.addDelegate(McIDASAreaProjection.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                McIDASAreaProjection ac = (McIDASAreaProjection)o;
                int[] dir = ac.getDirBlock();
                List args = Misc.newList(dir, ac.getNavBlock(), ac.getAuxBlock());
                List types = Misc.newList(null, null, dir.getClass());
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        VisADPersistence.addDelegate(AREACoordinateSystem.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                AREACoordinateSystem ac = (AREACoordinateSystem)o;
                int[] dir = ac.getDirBlock();
                List args = Misc.newList(dir, ac.getNavBlock(), ac.getAuxBlock(), new Boolean(ac.getUseSpline()));
                List types = Misc.newList(null, null, dir.getClass(), Boolean.TYPE);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        VisADPersistence.addDelegate(ScalarMap.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                ScalarMap s = (ScalarMap)o;
                List args = Misc.newList(s.getScalar(), s.getDisplayScalar());
                return e.createObjectConstructorElement(o, args);
            }
        });
        VisADPersistence.addDelegate(EarthLocationLite.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                try {
                    EarthLocationLite nlt = (EarthLocationLite)o;
                    Real lat = nlt.getLatitude();
                    Real lon = nlt.getLongitude();
                    Real alt = nlt.getAltitude();
                    List args = Misc.newList(lat, lon, alt);
                    return e.createObjectConstructorElement(o, args);
                }
                catch (Exception exc) {
                    System.err.println("Error persisting NamedLocationTuple:" + exc);
                    return null;
                }
            }
        });
        VisADPersistence.addDelegate(RealTuple.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                try {
                    RealTuple rt = (RealTuple)o;
                    List args = Misc.newList(rt.getType(), rt.getRealComponents(), rt.getCoordinateSystem());
                    return e.createObjectConstructorElement(o, args);
                }
                catch (Exception exc) {
                    System.err.println("Error persisting RealTuple:" + exc);
                    return null;
                }
            }
        });
        VisADPersistence.addDelegate(NamedLocationTuple.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                try {
                    NamedLocationTuple nlt = (NamedLocationTuple)o;
                    List args = Misc.newList(nlt.getIdentifier(), nlt.getLatitude(), nlt.getLongitude(), nlt.getAltitude());
                    return e.createObjectConstructorElement(o, args);
                }
                catch (Exception exc) {
                    System.err.println("Error persisting NamedLocationTuple:" + exc);
                    return null;
                }
            }
        });
        VisADPersistence.addDelegate(LatLonTuple.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                try {
                    LatLonTuple nlt = (LatLonTuple)o;
                    List args = Misc.newList(nlt.getLatitude(), nlt.getLongitude());
                    return e.createObjectConstructorElement(o, args);
                }
                catch (Exception exc) {
                    System.err.println("Error persisting LatLonTuple:" + exc);
                    return null;
                }
            }
        });
        VisADPersistence.addDelegate(EarthLocationTuple.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                try {
                    EarthLocationTuple nlt = (EarthLocationTuple)o;
                    List args = Misc.newList(nlt.getLatitude(), nlt.getLongitude(), nlt.getAltitude());
                    return e.createObjectConstructorElement(o, args);
                }
                catch (Exception exc) {
                    System.err.println("Error persisting NamedLocationTuple:" + exc);
                    return null;
                }
            }
        });
        VisADPersistence.addDelegate(UnionSet.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                UnionSet unionSet = (UnionSet)o;
                SampledSet[] sets = unionSet.getSets();
                List args = Misc.newList(unionSet.getType(), sets);
                return e.createObjectConstructorElement(o, args);
            }
        });
        VisADPersistence.addDelegate(RealTupleType.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                try {
                    RealTupleType rt = (RealTupleType)o;
                    MathType[] mt = rt.getComponents();
                    RealType[] rta = new RealType[mt.length];
                    for (int i = 0; i < mt.length; ++i) {
                        rta[i] = (RealType)mt[i];
                    }
                    List args = Misc.newList(rta, rt.getCoordinateSystem(), null);
                    List types = Misc.newList(null, CoordinateSystem.class, Set.class);
                    return e.createObjectConstructorElement(o, args, types);
                }
                catch (Exception exc) {
                    System.err.println("Error persisting RealTuple:" + exc);
                    return null;
                }
            }
        });
        VisADPersistence.addDelegate(TrivialMapProjection.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                TrivialMapProjection tmp = (TrivialMapProjection)o;
                List args = Misc.newList(tmp.getReference(), tmp.getDefaultMapArea());
                return e.createObjectConstructorElement(o, args);
            }
        });
        VisADPersistence.addDelegate(CachingCoordinateSystem.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                CachingCoordinateSystem c = (CachingCoordinateSystem)o;
                List args = Misc.newList(c.getCachedCoordinateSystem());
                return e.createObjectConstructorElement(o, args);
            }
        });
        VisADPersistence.addDelegate(CartesianProductCoordinateSystem.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                CartesianProductCoordinateSystem c = (CartesianProductCoordinateSystem)o;
                List args = Misc.newList(c.getCoordinateSystems());
                return e.createObjectConstructorElement(o, args);
            }
        });
        VisADPersistence.addDelegate(Vis5DCoordinateSystem.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                Vis5DCoordinateSystem vcs = (Vis5DCoordinateSystem)o;
                List args = Misc.newList(new Integer(vcs.getProjection()), vcs.getProjectionParams(), new Double(vcs.getRows()), new Double(vcs.getColumns()));
                List types = Misc.newList(Integer.TYPE, null, Double.TYPE, Double.TYPE);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        XmlDelegateImpl refCSDelegate = new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                CoordinateSystem c = (CoordinateSystem)o;
                List args = Misc.newList(c.getReference());
                return e.createObjectConstructorElement(o, args);
            }
        };
        VisADPersistence.addDelegate(CMYCoordinateSystem.class, refCSDelegate);
        VisADPersistence.addDelegate(CylindricalCoordinateSystem.class, refCSDelegate);
        VisADPersistence.addDelegate(FlowSphericalCoordinateSystem.class, refCSDelegate);
        VisADPersistence.addDelegate(HSVCoordinateSystem.class, refCSDelegate);
        VisADPersistence.addDelegate(IdentityCoordinateSystem.class, refCSDelegate);
        VisADPersistence.addDelegate(PolarCoordinateSystem.class, refCSDelegate);
        VisADPersistence.addDelegate(SphericalCoordinateSystem.class, refCSDelegate);
        VisADPersistence.addDelegate(TrivialNavigation.class, refCSDelegate);
        XmlDelegateImpl genCSDelegate = new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                CoordinateSystem c = (CoordinateSystem)o;
                List args = Misc.newList(c.getReference(), c.getCoordinateSystemUnits());
                return e.createObjectConstructorElement(o, args);
            }
        };
        VisADPersistence.addDelegate(WindPolarCoordinateSystem.class, genCSDelegate);
        VisADPersistence.addDelegate(GriddedSet.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                GriddedSet obj = (GriddedSet)o;
                List args = Misc.newList("foo");
                List types = Misc.newList(String.class);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        VisADPersistence.addDelegate(PointOb.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                PointOb obj = (PointOb)o;
                List args = Misc.newList("foo");
                List types = Misc.newList(String.class);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        VisADPersistence.addDelegate(ImageSequenceImpl.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                ImageSequenceImpl obj = (ImageSequenceImpl)o;
                List args = Misc.newList("foo");
                List types = Misc.newList(String.class);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        VisADPersistence.addDelegate(FlatField.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                FlatField obj = (FlatField)o;
                List args = Misc.newList("foo");
                List types = Misc.newList(String.class);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        VisADPersistence.addDelegate(FieldImpl.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                FieldImpl obj = (FieldImpl)o;
                List args = Misc.newList(obj.getType());
                List types = Misc.newList(FunctionType.class);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        VisADPersistence.addDelegate(Color3f.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                Color3f c = (Color3f)o;
                float[] rgb = c.get().getRGBComponents(null);
                List args = Misc.newList(new Float(rgb[0]), new Float(rgb[1]), new Float(rgb[2]));
                List types = Misc.newList(Float.TYPE, Float.TYPE, Float.TYPE);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        VisADPersistence.addDelegate(Vector3f.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                Vector3f v = (Vector3f)o;
                float[] xyz = new float[3];
                v.get(xyz);
                List args = Misc.newList(new Float(xyz[0]), new Float(xyz[1]), new Float(xyz[2]));
                List types = Misc.newList(Float.TYPE, Float.TYPE, Float.TYPE);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        VisADPersistence.addDelegate(Point3d.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                Point3d p = (Point3d)o;
                double[] xyz = new double[3];
                p.get(xyz);
                List args = Misc.newList(new Double(xyz[0]), new Double(xyz[1]), new Double(xyz[2]));
                List types = Misc.newList(Double.TYPE, Double.TYPE, Double.TYPE);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
    }

    public static Class getUnitClass(Unit unit) {
        if (unit == null) {
            return Unit.class;
        }
        return unit.getClass();
    }

    public static Unit createUnit(XmlEncoder e, Element o) throws VisADException {
        String identifier = (String)e.createObject(XmlUtil.getFirstChild(o));
        if (identifier == null) {
            return null;
        }
        if (identifier.equals("promiscuous") || identifier.equals(CommonUnit.promiscuous.toString())) {
            return CommonUnit.promiscuous;
        }
        if (identifier.equals("dimensionless")) {
            return CommonUnit.dimensionless;
        }
        String name = o.getAttribute(ATTR_NAME);
        if (name == null || name.length() == 0) {
            name = identifier;
        }
        Unit theUnit = Util.parseUnit(identifier, name);
        return theUnit;
    }

    public static void main(String[] args) {
        try {
            String name = "s since 1970-01-01 00:00:00.000 UTC";
            Unit theUnit = Util.parseUnit(name);
            System.err.println("Created unit" + theUnit + " id=" + theUnit.getIdentifier());
            return;
        }
        catch (Exception exc) {
            System.err.println("Error:" + exc);
            exc.printStackTrace();
            return;
        }
    }
}

