/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad;

import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Vector;
import ucar.visad.Util;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldException;
import visad.FlatField;
import visad.FloatSet;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.Irregular1DSet;
import visad.IrregularSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarType;
import visad.Set;
import visad.SetException;
import visad.SetType;
import visad.SingletonSet;
import visad.TupleType;
import visad.TypeException;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;
import visad.util.DataUtility;

public final class VisADMath {
    private static final Real one;

    private VisADMath() {
    }

    public static Data negate(Data data) throws VisADException, RemoteException {
        return data instanceof SampledSet ? VisADMath.negate((SampledSet)data) : data.negate();
    }

    static SampledSet negate(SampledSet set) throws VisADException {
        SampledSet result;
        if (set.isMissing()) {
            result = set;
        } else {
            float[][] samples = set.getSamples(true);
            for (int i = 0; i < samples.length; ++i) {
                float[] values = samples[i];
                for (int j = 0; j < values.length; ++j) {
                    values[j] = -values[j];
                }
            }
            result = set instanceof GriddedSet ? GriddedSet.create((SetType)set.getType(), samples, ((GriddedSet)set).getLengths(), set.getCoordinateSystem(), set.getSetUnits(), set.getSetErrors()) : new IrregularSet((MathType)((SetType)set.getType()), samples, set.getCoordinateSystem(), set.getSetUnits(), set.getSetErrors());
        }
        return result;
    }

    public static Data invert(Data data) throws VisADException, RemoteException {
        return data instanceof SampledSet ? VisADMath.invert((SampledSet)data) : one.divide(data);
    }

    static SampledSet invert(SampledSet set) throws SetException, VisADException {
        Unit newUnit;
        float[][] samples;
        int rank = set.getDimension();
        if (rank != 1) {
            throw new SetException("Set not 1-D");
        }
        if (set.isMissing()) {
            samples = null;
            newUnit = null;
        } else {
            samples = set.getSamples(true);
            for (int i = 0; i < samples.length; ++i) {
                float[] values = samples[i];
                for (int j = 0; j < values.length; ++j) {
                    values[j] = 1.0f / values[j];
                }
            }
            newUnit = set.getSetUnits()[0].pow(-1);
        }
        String newName = "VisADMath_Inverted_" + ((RealType)((SetType)set.getType()).getDomain().getComponent(0)).getName();
        RealType newRealType = RealType.getRealTypeByName(newName);
        if (newRealType == null) {
            newRealType = RealType.getRealType(newName, newUnit, null);
        }
        return set instanceof GriddedSet ? new Gridded1DSet((MathType)newRealType, samples, set.getLength(), (CoordinateSystem)null, new Unit[]{newUnit}, (ErrorEstimate[])null) : new Irregular1DSet((MathType)newRealType, samples, (CoordinateSystem)null, new Unit[]{newUnit}, (ErrorEstimate[])null);
    }

    public static Data exp(Data data) throws VisADException, RemoteException {
        return data instanceof SampledSet ? VisADMath.exp((SampledSet)data) : data.exp();
    }

    static SampledSet exp(SampledSet set) throws SetException, VisADException {
        Object[] newUnits;
        float[][] samples;
        if (set.isMissing()) {
            samples = null;
            newUnits = null;
        } else {
            samples = set.getSamples(true);
            int rank = samples.length;
            newUnits = new Unit[rank];
            Arrays.fill(newUnits, CommonUnit.dimensionless);
            for (int i = 0; i < rank; ++i) {
                float[] values = samples[i];
                for (int j = 0; j < values.length; ++j) {
                    values[j] = (float)Math.exp(values[j]);
                }
            }
        }
        return set instanceof GriddedSet ? GriddedSet.create(RealType.Generic, samples, ((GriddedSet)set).getLengths(), null, (Unit[])newUnits, null) : new IrregularSet((MathType)RealType.Generic, samples, (CoordinateSystem)null, (Unit[])newUnits, (ErrorEstimate[])null);
    }

    public static Data log(Data data) throws VisADException, RemoteException {
        return data instanceof SampledSet ? VisADMath.log((SampledSet)data) : data.log();
    }

    static SampledSet log(SampledSet set) throws SetException, VisADException {
        Object[] newUnits;
        float[][] samples;
        if (set.isMissing()) {
            samples = null;
            newUnits = null;
        } else {
            samples = set.getSamples(true);
            int rank = samples.length;
            newUnits = new Unit[rank];
            Arrays.fill(newUnits, CommonUnit.dimensionless);
            for (int i = 0; i < rank; ++i) {
                float[] values = samples[i];
                for (int j = 0; j < values.length; ++j) {
                    values[j] = (float)Math.log(values[j]);
                }
            }
        }
        RealTupleType newRealTupleType = (RealTupleType)((SetType)set.getType()).getDomain().unary(33, new Vector());
        return set instanceof GriddedSet ? GriddedSet.create(newRealTupleType, samples, ((GriddedSet)set).getLengths(), null, (Unit[])newUnits, null) : new IrregularSet((MathType)newRealTupleType, samples, (CoordinateSystem)null, (Unit[])newUnits, (ErrorEstimate[])null);
    }

    public static Data add(Data data1, Data data2) throws UnimplementedException, TypeException, ArithmeticException, VisADException, RemoteException {
        return data1 instanceof SampledSet ? VisADMath.add((SampledSet)data1, data2) : (data2 instanceof SampledSet ? VisADMath.add((SampledSet)data2, data1) : data1.add(data2, 101, 202));
    }

    static Data add(SampledSet set, Data data) throws UnimplementedException, TypeException, ArithmeticException, VisADException, RemoteException {
        try {
            return data instanceof Real ? VisADMath.add(set, (Real)data) : (data instanceof SampledSet ? VisADMath.add(set, (SampledSet)data) : (data instanceof Field ? VisADMath.newFlatField(set, DataUtility.simplify(DataUtility.getDomainType(set)), null).add(data, 101, 202) : set.add(data, 101, 202)));
        }
        catch (SetException e) {
            throw new ArithmeticException(e.getMessage());
        }
    }

    static SampledSet add(SampledSet set, Real real) throws VisADException {
        SetType setType = (SetType)set.getType();
        RealTupleType setTupleType = setType.getDomain();
        int rank = setTupleType.getDimension();
        RealType realType = (RealType)real.getType();
        int[] indexes = new int[setTupleType.getDimension()];
        int count = 0;
        for (int i = 0; i < indexes.length; ++i) {
            if (!realType.equalsExceptNameButUnits((RealType)setTupleType.getComponent(i))) continue;
            indexes[count++] = i;
        }
        if (count == 0) {
            throw new TypeException("realType=" + realType + "; setTupleType=" + setTupleType);
        }
        float[][] samples = set.getSamples(true);
        Unit[] setUnits = set.getSetUnits();
        ErrorEstimate[] newErrors = set.getSetErrors();
        for (int i = 0; i < count; ++i) {
            int realIndex = indexes[i];
            float[] realSamples = samples[realIndex];
            float realValue = (float)real.getValue(setUnits[realIndex]);
            int j = 0;
            while (j < realSamples.length) {
                int n = j++;
                realSamples[n] = realSamples[n] + realValue;
            }
            ErrorEstimate realError = real.getError();
            if (realError == null || newErrors[realIndex] == null) continue;
            newErrors[realIndex] = new ErrorEstimate(realSamples, setUnits[realIndex], 1, newErrors[realIndex], realError, 200);
        }
        return set instanceof GriddedSet ? GriddedSet.create(setType, samples, ((GriddedSet)set).getLengths(), set.getCoordinateSystem(), setUnits, newErrors) : new IrregularSet((MathType)setType, samples, set.getCoordinateSystem(), setUnits, newErrors);
    }

    static SampledSet add(SampledSet set1, SampledSet set2) throws SetException, VisADException {
        if (set1.getLength() != set2.getLength()) {
            throw new SetException("Sets have different lengths");
        }
        SetType set1Type = (SetType)set1.getType();
        RealTupleType set1TupleType = set1Type.getDomain();
        SetType set2Type = (SetType)set2.getType();
        RealTupleType set2TupleType = set2Type.getDomain();
        int rank = set1TupleType.getDimension();
        Vector<Integer> uniqueSet1Indexes = new Vector<Integer>();
        Vector<Integer> uniqueSet2Indexes = new Vector<Integer>();
        Vector<Integer> commonSet1Indexes = new Vector<Integer>();
        Vector<Integer> commonSet2Indexes = new Vector<Integer>();
        for (int set1Index = 0; set1Index < rank; ++set1Index) {
            int set2Index = set2TupleType.getIndex(set1TupleType.getComponent(set1Index));
            if (set2Index == -1) {
                uniqueSet1Indexes.add(new Integer(set1Index));
                continue;
            }
            commonSet1Indexes.add(new Integer(set1Index));
            commonSet2Indexes.add(new Integer(set2Index));
        }
        rank = set2TupleType.getDimension();
        for (int set2Index = 0; set2Index < rank; ++set2Index) {
            Integer set2Integer = new Integer(set2Index);
            if (commonSet2Indexes.contains(set2Integer)) continue;
            uniqueSet2Indexes.add(set2Integer);
        }
        int newComponentCount = uniqueSet1Indexes.size() + uniqueSet2Indexes.size() + commonSet1Indexes.size();
        RealType[] realTypes = new RealType[newComponentCount];
        float[][] set1Samples = set1.getSamples(false);
        float[][] set2Samples = set2.getSamples(false);
        float[][] newSamples = new float[newComponentCount][];
        Unit[] newUnits = new Unit[newComponentCount];
        Unit[] set1Units = set1.getSetUnits();
        ErrorEstimate[] newErrors = new ErrorEstimate[newComponentCount];
        ErrorEstimate[] set1Errors = set1.getSetErrors();
        int icomp = 0;
        Iterator iter = uniqueSet1Indexes.iterator();
        while (iter.hasNext()) {
            int set1Index = (Integer)iter.next();
            realTypes[icomp] = (RealType)set1TupleType.getComponent(set1Index);
            newSamples[icomp] = set1Samples[set1Index];
            newUnits[icomp] = set1Units[set1Index];
            newErrors[icomp] = set1Errors[set1Index];
            ++icomp;
        }
        Unit[] set2Units = set2.getSetUnits();
        ErrorEstimate[] set2Errors = set2.getSetErrors();
        Iterator iter2 = uniqueSet2Indexes.iterator();
        while (iter2.hasNext()) {
            int set2Index = (Integer)iter2.next();
            realTypes[icomp] = (RealType)set2TupleType.getComponent(set2Index);
            newSamples[icomp] = set2Samples[set2Index];
            newUnits[icomp] = set2Units[set2Index];
            newErrors[icomp] = set2Errors[set2Index];
            ++icomp;
        }
        Iterator iter1 = commonSet1Indexes.iterator();
        Iterator iter22 = commonSet2Indexes.iterator();
        while (icomp < newComponentCount) {
            int set1Index = (Integer)iter1.next();
            int set2Index = (Integer)iter22.next();
            realTypes[icomp] = (RealType)set1TupleType.getComponent(set1Index);
            newUnits[icomp] = set1Units[set1Index];
            float[] set1Values = set1Samples[set1Index];
            float[] set2Values = set1Units[set1Index].toThis(set2Samples[set2Index], set2Units[set2Index]);
            float[] newValues = new float[set1Values.length];
            for (int j = 0; j < newValues.length; ++j) {
                newValues[j] = set1Values[j] + set2Values[j];
            }
            newSamples[icomp] = newValues;
            ErrorEstimate set1Error = set1Errors[set1Index];
            ErrorEstimate set2Error = set2Errors[set2Index];
            newErrors[icomp] = set1Error == null || set2Error == null ? (ErrorEstimate)null : new ErrorEstimate(newSamples[icomp], newUnits[icomp], 1, set1Error, set2Error, 200);
            ++icomp;
        }
        return new IrregularSet((MathType)new SetType(new RealTupleType(realTypes)), newSamples, uniqueSet1Indexes.size() == 0 && uniqueSet2Indexes.size() == 0 ? set1.getCoordinateSystem() : (CoordinateSystem)null, newUnits, newErrors);
    }

    public static Data subtract(Data data1, Data data2) throws UnimplementedException, TypeException, ArithmeticException, VisADException, RemoteException {
        return VisADMath.add(data1, VisADMath.negate(data2));
    }

    public static Data multiply(Data data1, Data data2) throws UnimplementedException, TypeException, ArithmeticException, VisADException, RemoteException {
        return data1 instanceof SampledSet ? VisADMath.multiply((SampledSet)data1, data2) : (data2 instanceof SampledSet ? VisADMath.multiply((SampledSet)data2, data1) : data1.multiply(data2, 101, 202));
    }

    static Data multiply(SampledSet set, Data data2) throws UnimplementedException, TypeException, ArithmeticException, VisADException, RemoteException {
        try {
            return data2 instanceof Real ? VisADMath.multiply(set, (Real)data2) : (data2 instanceof Field ? VisADMath.newFlatField((SampledSet)((Field)data2).getDomainSet(), set, DataUtility.simplify(DataUtility.getDomainType(set)), null).multiply(data2, 101, 202) : set.multiply(data2, 101, 202));
        }
        catch (SetException e) {
            throw new ArithmeticException(e.getMessage());
        }
    }

    static SampledSet multiply(SampledSet set, Real real) throws VisADException {
        ErrorEstimate[] newErrors;
        Unit[] newUnits;
        float[][] samples;
        RealTupleType newRealTupleType = (RealTupleType)((SetType)set.getType()).getDomain().binary(real.getType(), 4, new Vector());
        if (set.isMissing() || real.isMissing()) {
            samples = null;
            newUnits = null;
            newErrors = null;
        } else {
            samples = set.getSamples(true);
            float realValue = (float)real.getValue();
            Unit[] setUnits = set.getSetUnits();
            Unit realUnit = real.getUnit();
            ErrorEstimate[] setErrors = set.getSetErrors();
            ErrorEstimate realError = real.getError();
            int rank = set.getDimension();
            newUnits = new Unit[rank];
            newErrors = new ErrorEstimate[rank];
            for (int i = 0; i < rank; ++i) {
                float[] values = samples[i];
                int j = 0;
                while (j < values.length) {
                    int n = j++;
                    values[n] = values[n] * realValue;
                }
                newUnits[i] = setUnits[i].multiply(realUnit);
                newErrors[i] = setErrors[i] == null || realError == null ? null : new ErrorEstimate(values, newUnits[i], 4, setErrors[i], realError, 200);
            }
        }
        return set instanceof GriddedSet ? GriddedSet.create(newRealTupleType, samples, ((GriddedSet)set).getLengths(), null, newUnits, newErrors) : new IrregularSet((MathType)newRealTupleType, samples, (CoordinateSystem)null, newUnits, newErrors);
    }

    public static Data divide(Data data1, Data data2) throws UnimplementedException, TypeException, ArithmeticException, VisADException, RemoteException {
        return VisADMath.multiply(data1, VisADMath.invert(data2));
    }

    public static Data pow(Data base, Data exponent) throws UnimplementedException, TypeException, ArithmeticException, VisADException, RemoteException {
        Data promotedBase;
        Data data = base instanceof SampledSet ? (exponent instanceof Field ? VisADMath.newFlatField((SampledSet)((Field)exponent).getDomainSet(), (SampledSet)base) : VisADMath.newFlatField((SampledSet)base)) : (promotedBase = base);
        Data promotedExponent = exponent instanceof SampledSet ? (base instanceof Field ? VisADMath.newFlatField((SampledSet)((Field)base).getDomainSet(), (SampledSet)exponent) : VisADMath.newFlatField((SampledSet)exponent)) : exponent;
        Data result = promotedBase.pow(promotedExponent);
        if (base instanceof SampledSet && !(exponent instanceof Field)) {
            FlatField flatField = (FlatField)result;
            result = Util.newSampledSet(DataUtility.getRangeType(flatField), flatField.getFloats(true), null, flatField.getRangeCoordinateSystem()[0], flatField.getRangeUnits()[0], flatField.getRangeErrors(), false);
        }
        return result;
    }

    public static Data fromReference(MathType type, Data data) throws TypeException, VisADException, RemoteException {
        DataImpl result;
        if (data instanceof Real) {
            result = VisADMath.fromReference((RealTupleType)type, new RealTuple(new Real[]{(Real)data}));
        } else if (data instanceof RealTuple) {
            result = VisADMath.fromReference((RealTupleType)type, (RealTuple)data);
        } else if (data instanceof SampledSet) {
            result = VisADMath.fromReference((SetType)type, (SampledSet)data);
        } else if (data instanceof FlatField) {
            result = VisADMath.fromReference((FunctionType)type, (FlatField)data);
        } else {
            throw new TypeException("Can't transform " + data.getClass());
        }
        return result;
    }

    public static RealTuple fromReference(RealTupleType type, RealTuple data) throws VisADException, RemoteException {
        CoordinateSystem cs = type.getCoordinateSystem();
        Unit[] referenceUnits = cs.getReferenceUnits();
        int n = data.getDimension();
        double[][] coordinates = new double[n][1];
        int i = n;
        while (--i >= 0) {
            coordinates[i][0] = ((Real)data.getComponent(i)).getValue(referenceUnits[i]);
        }
        coordinates = cs.fromReference(coordinates);
        coordinates = Unit.convertTuple(coordinates, cs.getCoordinateSystemUnits(), type.getDefaultUnits());
        n = cs.getDimension();
        double[] values = new double[n];
        int i2 = n;
        while (--i2 >= 0) {
            values[i2] = coordinates[i2][0];
        }
        return new RealTuple(type, values);
    }

    public static IrregularSet fromReference(SetType type, SampledSet data) throws VisADException {
        CoordinateSystem cs = type.getDomain().getCoordinateSystem();
        return new IrregularSet((MathType)type, cs.fromReference(Unit.convertTuple(data.getSamples(false), data.getSetUnits(), cs.getReferenceUnits())), (CoordinateSystem)null, cs.getCoordinateSystemUnits(), (ErrorEstimate[])null);
    }

    public static FlatField fromReference(FunctionType type, FlatField data) throws VisADException, RemoteException {
        CoordinateSystem cs = type.getFlatRange().getCoordinateSystem();
        FlatField result = new FlatField(type, data.getDomainSet(), (CoordinateSystem)null, (Set[])null, cs.getCoordinateSystemUnits());
        result.setSamples(cs.fromReference(Unit.convertTuple(data.getValues(false), Util.getRangeUnits(data), cs.getReferenceUnits())));
        return result;
    }

    static double[][] curveIntegralOfGradient(SampledSet set, double[][][] gradients, double[][] newRangeValues) throws VisADException {
        int componentCount = gradients.length;
        int domainDimension = set.getDimension();
        int sampleCount = set.getLength();
        int[][] neighborsIndexes = new int[sampleCount][];
        set.getNeighbors(neighborsIndexes);
        for (int icomp = 0; icomp < componentCount; ++icomp) {
            boolean needInitialPoint = true;
            double[][] gradient = gradients[icomp];
            double[] compValues = newRangeValues[icomp];
            Arrays.fill(compValues, Double.NaN);
            for (int sampleIndex = 0; sampleIndex < sampleCount; ++sampleIndex) {
                int[] neighborIndexes = neighborsIndexes[sampleIndex];
                if (neighborIndexes == null) continue;
                if (needInitialPoint) {
                    boolean isGoodInitialPoint = true;
                    for (int dimIndex = 0; dimIndex < domainDimension; ++dimIndex) {
                        if (!Double.isNaN(gradient[dimIndex][sampleIndex])) continue;
                        isGoodInitialPoint = false;
                        break;
                    }
                    if (!isGoodInitialPoint) continue;
                    compValues[sampleIndex] = 0.0;
                    needInitialPoint = false;
                    continue;
                }
                double valueSum = 0.0;
                double weightSum = 0.0;
                double infinitySum = 0.0;
                int infinityCount = 0;
                double[][] sampleCoordinates = set.indexToDouble(new int[]{sampleIndex});
                double[][] neighborCoordinates = set.indexToDouble(neighborIndexes);
                for (int i = 0; i < neighborIndexes.length; ++i) {
                    int neighborIndex = neighborIndexes[i];
                    double newRangeNeighborValue = compValues[neighborIndex];
                    if (Double.isNaN(newRangeNeighborValue)) continue;
                    double delta1 = 0.0;
                    double delta2 = 0.0;
                    for (int dimIndex = 0; dimIndex < domainDimension; ++dimIndex) {
                        double[] derivatives = gradient[dimIndex];
                        double neighborDerivative = derivatives[neighborIndex];
                        double deltaDomain = sampleCoordinates[dimIndex][0] - neighborCoordinates[dimIndex][i];
                        delta1 += neighborDerivative * deltaDomain;
                        delta2 += (derivatives[sampleIndex] + neighborDerivative) * deltaDomain;
                    }
                    double error = delta1 - (delta2 /= 2.0);
                    double weight = 1.0 / (error * error);
                    if (Double.isInfinite(weight)) {
                        infinitySum += newRangeNeighborValue + delta2;
                        ++infinityCount;
                        continue;
                    }
                    if (infinityCount != 0) continue;
                    valueSum += (newRangeNeighborValue + delta2) * weight;
                    weightSum += weight;
                }
                if (infinityCount != 0) {
                    compValues[sampleIndex] = infinitySum / (double)infinityCount;
                    continue;
                }
                if (weightSum == 0.0) continue;
                compValues[sampleIndex] = valueSum / weightSum;
            }
        }
        return newRangeValues;
    }

    static float[][] curveIntegralOfGradient(SampledSet set, float[][][] gradients, float[][] newRangeValues) throws VisADException {
        int componentCount = gradients.length;
        int domainDimension = set.getDimension();
        int sampleCount = set.getLength();
        int[][] neighborsIndexes = new int[sampleCount][];
        set.getNeighbors(neighborsIndexes);
        for (int icomp = 0; icomp < componentCount; ++icomp) {
            boolean needInitialPoint = true;
            float[][] gradient = gradients[icomp];
            float[] compValues = newRangeValues[icomp];
            Arrays.fill(compValues, Float.NaN);
            for (int sampleIndex = 0; sampleIndex < sampleCount; ++sampleIndex) {
                int[] neighborIndexes = neighborsIndexes[sampleIndex];
                if (neighborIndexes == null) continue;
                if (needInitialPoint) {
                    boolean isGoodInitialPoint = true;
                    for (int dimIndex = 0; dimIndex < domainDimension; ++dimIndex) {
                        if (!Double.isNaN(gradient[dimIndex][sampleIndex])) continue;
                        isGoodInitialPoint = false;
                        break;
                    }
                    if (!isGoodInitialPoint) continue;
                    compValues[sampleIndex] = 0.0f;
                    needInitialPoint = false;
                    continue;
                }
                double valueSum = 0.0;
                double weightSum = 0.0;
                double infinitySum = 0.0;
                int infinityCount = 0;
                float[][] sampleCoordinates = set.indexToValue(new int[]{sampleIndex});
                float[][] neighborCoordinates = set.indexToValue(neighborIndexes);
                for (int i = 0; i < neighborIndexes.length; ++i) {
                    int neighborIndex = neighborIndexes[i];
                    double newRangeNeighborValue = compValues[neighborIndex];
                    if (Double.isNaN(newRangeNeighborValue)) continue;
                    double delta1 = 0.0;
                    double delta2 = 0.0;
                    for (int dimIndex = 0; dimIndex < domainDimension; ++dimIndex) {
                        float[] derivatives = gradient[dimIndex];
                        double neighborDerivative = derivatives[neighborIndex];
                        double deltaDomain = sampleCoordinates[dimIndex][0] - neighborCoordinates[dimIndex][i];
                        delta1 += neighborDerivative * deltaDomain;
                        delta2 += ((double)derivatives[sampleIndex] + neighborDerivative) * deltaDomain;
                    }
                    double error = delta1 - (delta2 /= 2.0);
                    double weight = 1.0 / (error * error);
                    if (Double.isInfinite(weight)) {
                        infinitySum += newRangeNeighborValue + delta2;
                        ++infinityCount;
                        continue;
                    }
                    if (infinityCount != 0) continue;
                    valueSum += (newRangeNeighborValue + delta2) * weight;
                    weightSum += weight;
                }
                if (infinityCount != 0) {
                    compValues[sampleIndex] = (float)(infinitySum / (double)infinityCount);
                    continue;
                }
                if (weightSum == 0.0) continue;
                compValues[sampleIndex] = (float)(valueSum / weightSum);
            }
        }
        return newRangeValues;
    }

    static double[][] curveIntegralOfGradient(GriddedSet set, double[][][] gradients, double[][] newRangeValues) throws VisADException {
        int componentCount = gradients.length;
        int domainDimension = set.getDimension();
        int sampleCount = set.getLength();
        int[] infinityCounts = new int[componentCount];
        double[] infinitySums = new double[componentCount];
        double[] weightSums = new double[componentCount];
        double[] valueSums = new double[componentCount];
        boolean[] needInitialPoint = new boolean[componentCount];
        boolean[] isGoodInitialPoint = new boolean[componentCount];
        Arrays.fill(needInitialPoint, true);
        Arrays.fill(isGoodInitialPoint, true);
        Index index = new Index(set);
        while (index.hasPoint()) {
            int sampleIndex = index.getIndex();
            double[][] sampleCoordinates = set.indexToDouble(new int[]{sampleIndex});
            Arrays.fill(valueSums, 0.0);
            Arrays.fill(weightSums, 0.0);
            Arrays.fill(infinitySums, 0.0);
            Arrays.fill(infinityCounts, 0);
            for (int idim = 0; idim < domainDimension; ++idim) {
                int neighborIndex = index.getPreviousIndex(idim);
                if (neighborIndex < 0) continue;
                double[][] neighborCoordinates = set.indexToDouble(new int[]{neighborIndex});
                double deltaDomain = sampleCoordinates[idim][0] - neighborCoordinates[idim][0];
                for (int icomp = 0; icomp < componentCount; ++icomp) {
                    if (needInitialPoint[icomp]) {
                        if (!isGoodInitialPoint[icomp] || !Double.isNaN(gradients[icomp][idim][sampleIndex])) continue;
                        isGoodInitialPoint[icomp] = false;
                        continue;
                    }
                    double[] derivatives = gradients[icomp][idim];
                    double neighborDerivative = derivatives[neighborIndex];
                    double delta1 = deltaDomain * neighborDerivative;
                    double delta2 = deltaDomain * (derivatives[sampleIndex] + neighborDerivative) / 2.0;
                    double error = delta1 - delta2;
                    double weight = 1.0 / (error * error);
                    if (Double.isInfinite(weight)) {
                        int n = icomp;
                        infinitySums[n] = infinitySums[n] + (newRangeValues[icomp][neighborIndex] + delta2);
                        int n2 = icomp;
                        infinityCounts[n2] = infinityCounts[n2] + 1;
                        continue;
                    }
                    if (infinityCounts[icomp] != 0) continue;
                    int n = icomp;
                    valueSums[n] = valueSums[n] + (newRangeValues[icomp][neighborIndex] + delta2) * weight;
                    int n3 = icomp;
                    weightSums[n3] = weightSums[n3] + weight;
                }
            }
            for (int icomp = 0; icomp < componentCount; ++icomp) {
                if (needInitialPoint[icomp]) {
                    if (!isGoodInitialPoint[icomp]) {
                        newRangeValues[icomp][sampleIndex] = Double.NaN;
                        continue;
                    }
                    newRangeValues[icomp][sampleIndex] = 0.0;
                    needInitialPoint[icomp] = false;
                    continue;
                }
                newRangeValues[icomp][sampleIndex] = infinityCounts[icomp] != 0 ? infinitySums[icomp] / (double)infinityCounts[icomp] : (weightSums[icomp] != 0.0 ? valueSums[icomp] / weightSums[icomp] : Double.NaN);
            }
            index.increment();
        }
        return newRangeValues;
    }

    static float[][] curveIntegralOfGradient(GriddedSet set, float[][][] gradients, float[][] newRangeValues) throws VisADException {
        int componentCount = gradients.length;
        int domainDimension = set.getDimension();
        int sampleCount = set.getLength();
        int[] infinityCounts = new int[componentCount];
        double[] infinitySums = new double[componentCount];
        double[] weightSums = new double[componentCount];
        double[] valueSums = new double[componentCount];
        boolean[] needInitialPoint = new boolean[componentCount];
        boolean[] isGoodInitialPoint = new boolean[componentCount];
        Arrays.fill(needInitialPoint, true);
        Arrays.fill(isGoodInitialPoint, true);
        Index index = new Index(set);
        while (index.hasPoint()) {
            int sampleIndex = index.getIndex();
            float[][] sampleCoordinates = set.indexToValue(new int[]{sampleIndex});
            Arrays.fill(valueSums, 0.0);
            Arrays.fill(weightSums, 0.0);
            Arrays.fill(infinitySums, 0.0);
            Arrays.fill(infinityCounts, 0);
            for (int idim = 0; idim < domainDimension; ++idim) {
                int neighborIndex = index.getPreviousIndex(idim);
                if (neighborIndex < 0) continue;
                float[][] neighborCoordinates = set.indexToValue(new int[]{neighborIndex});
                float deltaDomain = sampleCoordinates[idim][0] - neighborCoordinates[idim][0];
                for (int icomp = 0; icomp < componentCount; ++icomp) {
                    if (needInitialPoint[icomp]) {
                        if (!isGoodInitialPoint[icomp] || !Double.isNaN(gradients[icomp][idim][sampleIndex])) continue;
                        isGoodInitialPoint[icomp] = false;
                        continue;
                    }
                    float[] derivatives = gradients[icomp][idim];
                    double neighborDerivative = derivatives[neighborIndex];
                    double delta1 = (double)deltaDomain * neighborDerivative;
                    double delta2 = (double)deltaDomain * ((double)derivatives[sampleIndex] + neighborDerivative) / 2.0;
                    double error = delta1 - delta2;
                    double weight = 1.0 / (error * error);
                    if (Double.isInfinite(weight)) {
                        int n = icomp;
                        infinitySums[n] = infinitySums[n] + ((double)newRangeValues[icomp][neighborIndex] + delta2);
                        int n2 = icomp;
                        infinityCounts[n2] = infinityCounts[n2] + 1;
                        continue;
                    }
                    if (infinityCounts[icomp] != 0) continue;
                    int n = icomp;
                    valueSums[n] = valueSums[n] + ((double)newRangeValues[icomp][neighborIndex] + delta2) * weight;
                    int n3 = icomp;
                    weightSums[n3] = weightSums[n3] + weight;
                }
            }
            for (int icomp = 0; icomp < componentCount; ++icomp) {
                if (needInitialPoint[icomp]) {
                    if (!isGoodInitialPoint[icomp]) {
                        newRangeValues[icomp][sampleIndex] = Float.NaN;
                        continue;
                    }
                    newRangeValues[icomp][sampleIndex] = 0.0f;
                    needInitialPoint[icomp] = false;
                    continue;
                }
                newRangeValues[icomp][sampleIndex] = infinityCounts[icomp] != 0 ? (float)(infinitySums[icomp] / (double)infinityCounts[icomp]) : (weightSums[icomp] != 0.0 ? (float)(valueSums[icomp] / weightSums[icomp]) : Float.NaN);
            }
            index.increment();
        }
        return newRangeValues;
    }

    public static FlatField curveIntegralOfGradient(Field field) throws FieldException, VisADException, RemoteException {
        FlatField newField;
        FunctionType oldFieldType = (FunctionType)field.getType();
        if (!oldFieldType.getFlat()) {
            throw new FieldException("VisADMath.curveIntegralOfGradient(Field): Non-flat range");
        }
        Unit[] integrandUnits = new Unit[oldFieldType.getFlatRange().getDimension()];
        MathType rangeType = oldFieldType.getRange();
        if (rangeType instanceof ScalarType) {
            rangeType = new RealTupleType((RealType)rangeType);
        }
        if (rangeType instanceof RealTupleType) {
            rangeType = new TupleType(new MathType[]{rangeType});
        }
        TupleType newFieldRangeType = (TupleType)rangeType;
        int newComponentCount = newFieldRangeType.getDimension();
        int domainDimension = field.getDomainDimension();
        Vector nilVector = new Vector(0);
        RealTupleType domainType = oldFieldType.getDomain();
        RealType[] newComponentTypes = new RealType[newComponentCount];
        int flatOffset = 0;
        SampledSet domainSet = (SampledSet)field.getDomainSet();
        Unit[] domainUnits = domainSet.getSetUnits();
        for (int newComponentIndex = 0; newComponentIndex < newComponentCount; ++newComponentIndex) {
            RealTupleType gradientType = (RealTupleType)newFieldRangeType.getComponent(newComponentIndex);
            int partialCount = gradientType.getDimension();
            if (partialCount != domainDimension) {
                throw new FieldException("VisADMath.curveIntegralOfGradient(): Number of partial derivatives for component " + newComponentIndex + " (" + partialCount + ')' + " != domain dimension (" + domainDimension + ')');
            }
            if (partialCount > 0) {
                RealType newComponentType = (RealType)gradientType.getComponent(0).binary(domainType.getComponent(0), 4, nilVector);
                for (int i = 1; i < partialCount; ++i) {
                    newComponentType = (RealType)newComponentType.binary(gradientType.getComponent(i).binary(domainType.getComponent(i), 4, nilVector), 1, nilVector);
                }
                newComponentTypes[newComponentIndex] = newComponentType;
                Unit outUnit = newComponentType.getDefaultUnit();
                for (int i = 0; i < partialCount; ++i) {
                    integrandUnits[flatOffset + i] = outUnit.divide(domainUnits[i]);
                }
            }
            flatOffset += partialCount;
        }
        boolean useDouble = false;
        if (field instanceof FlatField) {
            Set[] rangeSets = ((FlatField)field).getRangeSets();
            for (int i = 0; i < rangeSets.length; ++i) {
                if (!(rangeSets[i] instanceof DoubleSet)) {
                    rangeSets[i] = new FloatSet(newComponentTypes[i], null, null);
                    continue;
                }
                useDouble = true;
                rangeSets[i] = new DoubleSet(newComponentTypes[i], null, null);
            }
            newField = new FlatField(new FunctionType(domainType, DataUtility.simplify(new RealTupleType(newComponentTypes))), (Set)domainSet, (CoordinateSystem)null, rangeSets, (Unit[])null);
        } else {
            newField = new FlatField(new FunctionType(domainType, DataUtility.simplify(new RealTupleType(newComponentTypes))), domainSet);
        }
        if (useDouble) {
            double[][] integrandValues = Unit.convertTuple(field.getValues(false), field.getDefaultRangeUnits(), integrandUnits);
            if (domainSet instanceof GriddedSet) {
                newField.setSamples(VisADMath.curveIntegralOfGradient((GriddedSet)domainSet, (double[][][])new double[][][]{integrandValues}, new double[newComponentCount][domainSet.getLength()]), false);
            } else {
                newField.setSamples(VisADMath.curveIntegralOfGradient(domainSet, (double[][][])new double[][][]{integrandValues}, new double[newComponentCount][domainSet.getLength()]), false);
            }
        } else {
            float[][] integrandValues = Unit.convertTuple(field.getFloats(false), field.getDefaultRangeUnits(), integrandUnits);
            if (domainSet instanceof GriddedSet) {
                newField.setSamples(VisADMath.curveIntegralOfGradient((GriddedSet)domainSet, (float[][][])new float[][][]{integrandValues}, new float[newComponentCount][domainSet.getLength()]), false);
            } else {
                newField.setSamples(VisADMath.curveIntegralOfGradient(domainSet, (float[][][])new float[][][]{integrandValues}, new float[newComponentCount][domainSet.getLength()]), false);
            }
        }
        return newField;
    }

    public static FlatField newFlatField(SampledSet set) throws VisADException, RemoteException {
        return VisADMath.newFlatField(set, set);
    }

    public static FlatField newFlatField(SampledSet domain, SampledSet range) throws VisADException, RemoteException {
        return VisADMath.newFlatField(domain, range, ((SetType)range.getType()).getDomain(), range.getCoordinateSystem());
    }

    public static FlatField newFlatField(SampledSet set, MathType rangeType, CoordinateSystem rangeCoordinateSystem) throws VisADException, RemoteException {
        return VisADMath.newFlatField(set, set, rangeType, rangeCoordinateSystem);
    }

    public static FlatField newFlatField(SampledSet domain, SampledSet range, MathType rangeType, CoordinateSystem rangeCoordinateSystem) throws VisADException, RemoteException {
        if (domain.getLength() == 1 && !(domain instanceof SingletonSet)) {
            double[][] values = domain.getDoubles();
            double[] vals = new double[values.length];
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = values[i][0];
            }
            domain = new SingletonSet(((SetType)domain.getType()).getDomain(), vals, domain.getCoordinateSystem(), domain.getSetUnits(), domain.getSetErrors());
        }
        RealTupleType domainType = ((SetType)domain.getType()).getDomain();
        FlatField flatField = new FlatField(new FunctionType(domainType, rangeType), domain, rangeCoordinateSystem, null, null, range.getSetUnits());
        boolean useDoubles = false;
        int i = domainType.getDimension();
        while (--i >= 0) {
            if (!(((RealType)domainType.getComponent(i)).getDefaultSet() instanceof DoubleSet)) continue;
            useDoubles = true;
            break;
        }
        if (useDoubles) {
            flatField.setSamples(range.getDoubles(true), false);
        } else {
            flatField.setSamples(range.getSamples(true), false);
        }
        return flatField;
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        RealType domainType = RealType.Latitude;
        FlatField flatField1 = new FlatField(new FunctionType(domainType, domainType), new SingletonSet(new RealTuple(new Real[]{new Real(domainType, 2.0)})));
        flatField1.setSamples(new float[][]{{2.0f}});
        System.out.println("flatField1 = \n" + flatField1);
        domainType = RealType.Longitude;
        FlatField flatField2 = new FlatField(new FunctionType(domainType, domainType), new SingletonSet(new RealTuple(new Real[]{new Real(domainType, 2.0)})));
        flatField2.setSamples(new float[][]{{1.0f}});
        System.out.println("flatField2 = \n" + flatField2);
        FlatField flatField3 = (FlatField)VisADMath.divide(flatField2, VisADMath.subtract(flatField1, flatField2));
        System.out.println("flatField3 = \n" + flatField3);
        System.out.println("flatField3.getRangeUnits()[0][0] = " + flatField3.getRangeUnits()[0][0]);
    }

    static {
        Real o = null;
        try {
            o = new Real(RealType.getRealType("ucar_unidata_visad_Util_One", CommonUnit.dimensionless, null), 1.0);
        }
        catch (Exception e) {
            String reason = e.getMessage();
            System.err.println("Couldn't initialize class Util" + (reason == null ? "" : ": " + reason));
        }
        one = o;
    }

    protected static final class Index {
        private final int totalCount;
        private final int[] lengths;
        private final int[] roll;
        private int index = 0;
        private int[] indexes;

        protected Index(GriddedSet set) throws VisADException {
            this.lengths = set.getLengths();
            this.totalCount = set.getLength();
            this.roll = new int[this.lengths.length];
            if (this.lengths.length > 0) {
                this.roll[0] = 1;
            }
            for (int idim = 1; idim < this.lengths.length; ++idim) {
                this.roll[idim] = this.roll[idim - 1] * this.lengths[idim - 1];
            }
            this.indexes = new int[this.lengths.length];
            Arrays.fill(this.indexes, 0);
        }

        protected int getIndex() {
            return this.index;
        }

        protected int getPreviousIndex(int idim) {
            return this.indexes[idim] <= 0 ? -1 : this.index - this.roll[idim];
        }

        protected boolean hasPoint() {
            return this.index < this.totalCount;
        }

        protected void increment() {
            if (this.hasPoint()) {
                ++this.index;
                int idim = 0;
                while (idim < this.lengths.length) {
                    int n = idim;
                    this.indexes[n] = this.indexes[n] + 1;
                    if (this.indexes[n] < this.lengths[idim]) break;
                    this.indexes[idim++] = 0;
                }
            }
        }
    }
}

