/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad;

import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.List;
import java.util.TimeZone;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.UtcDate;
import ucar.visad.data.AreaImageFlatField;
import ucar.visad.data.CalendarDateTime;
import ucar.visad.display.ColorScaleInfo;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.Length;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DateTime;
import visad.DisplayImpl;
import visad.DisplayRenderer;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FloatSet;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.IntegerNDSet;
import visad.IntegerSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.LinearNDSet;
import visad.LinearSet;
import visad.MathType;
import visad.MouseBehavior;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.SingletonSet;
import visad.Tuple;
import visad.TupleType;
import visad.TypeException;
import visad.UnimplementedException;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.VisADRay;
import visad.browser.Convert;
import visad.data.CachedFlatField;
import visad.data.netcdf.Plain;
import visad.data.units.NoSuchUnitException;
import visad.data.units.Parser;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.MapProjection;
import visad.georef.TrivialMapProjection;
import visad.java3d.DisplayRendererJ3D;
import visad.java3d.VisADCanvasJ3D;
import visad.jmet.MetUnits;
import visad.python.JPythonMethods;
import visad.util.DataUtility;
import visad.util.ImageHelper;

public final class Util {
    private static final double TIMERANGE_DELTA = 1.0E-8;
    public static final String TEXT_IDENTIFIER = "(Text)";
    public static String REALTYPE_ROOT = "Util_RealType";
    private static int typeCnt = 0;
    private static String[] rgbaNames = new String[]{"Red", "Green", "Blue", "Alpha"};
    private static final Comparator increasingFloatComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            float v1 = ((float[])o1)[0];
            float v2 = ((float[])o2)[0];
            return v1 == v1 ? (v2 == v2 ? (v1 < v2 ? -1 : (v1 > v2 ? 1 : 0)) : 1) : (v2 == v2 ? -1 : 0);
        }
    };
    private static final Comparator decreasingFloatComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            float v1 = ((float[])o1)[0];
            float v2 = ((float[])o2)[0];
            return v1 == v1 ? (v2 == v2 ? (v1 > v2 ? -1 : (v1 < v2 ? 1 : 0)) : 1) : (v2 == v2 ? -1 : 0);
        }
    };
    private static final Comparator increasingDoubleComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            double v1 = ((double[])o1)[0];
            double v2 = ((double[])o2)[0];
            return v1 == v1 ? (v2 == v2 ? (v1 < v2 ? -1 : (v1 > v2 ? 1 : 0)) : 1) : (v2 == v2 ? -1 : 0);
        }
    };
    private static final Comparator decreasingDoubleComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            double v1 = ((double[])o1)[0];
            double v2 = ((double[])o2)[0];
            return v1 == v1 ? (v2 == v2 ? (v1 > v2 ? -1 : (v1 < v2 ? 1 : 0)) : 1) : (v2 == v2 ? -1 : 0);
        }
    };

    private Util() {
    }

    protected static Unit[] getDefaultUnits(FlatField field, int[] indexes, RealType[] types) throws IllegalArgumentException, TypeException, VisADException {
        if (field == null) {
            throw new IllegalArgumentException("Null field");
        }
        if (indexes.length != types.length) {
            throw new IllegalArgumentException("indexes.length != units.length");
        }
        RealTupleType rangeType = ((FunctionType)field.getType()).getFlatRange();
        int rangeRank = rangeType.getDimension();
        Unit[] units = new Unit[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            int index = indexes[i];
            if (index < 0 || index >= rangeRank) {
                throw new IllegalArgumentException("Index out-of-bounds");
            }
            RealType componentType = (RealType)rangeType.getComponent(index);
            if (!componentType.equalsExceptNameButUnits(types[i])) {
                throw new TypeException("Actual type (" + componentType + ") not compatible with expected type (" + types[i] + ")");
            }
            units[i] = componentType.getDefaultUnit();
        }
        return units;
    }

    public static RealType clone(RealType realType, String name) throws VisADException {
        return RealType.getRealType(name, realType.getDefaultUnit(), realType.getDefaultSet(), realType.isInterval() ? 1 : 0);
    }

    public static boolean isCompatible(Data data, MathType type) throws VisADException, RemoteException {
        MathType dataType = data.getType();
        if (dataType instanceof SetType) {
            dataType = ((SetType)dataType).getDomain();
        }
        if (dataType instanceof FunctionType && !(type instanceof FunctionType)) {
            dataType = ((FunctionType)dataType).getRange();
        }
        if (dataType instanceof TupleType) {
            dataType = DataUtility.simplify((TupleType)dataType);
        }
        if (type instanceof TupleType) {
            type = DataUtility.simplify((TupleType)type);
        }
        return type.equalsExceptNameButUnits(dataType);
    }

    public static Data vetType(MathType type, Data data) throws TypeException, VisADException, RemoteException {
        if (!Util.isCompatible(data, type)) {
            throw new TypeException("MathType of data object (" + data.getType() + ") is incompatible with required MathType (" + type + ')');
        }
        return data;
    }

    public static RealType ensureUnit(RealType type, Unit u) throws VisADException {
        if (Unit.canConvert(type.getDefaultUnit(), u)) {
            return type;
        }
        RealType newType = RealType.getRealType(type.getName() + "_" + Util.getCompatibleUnitName(u), u, type.getDefaultSet(), type.getAttributeMask());
        if (newType == null) {
            throw new VisADException("couldn't create RealType with units compatible to " + u.toString());
        }
        return newType;
    }

    public static String getCompatibleUnitName(Unit u) {
        return Util.cleanName(u.toString());
    }

    public static String cleanName(String name) {
        name = name.replace('.', '_');
        name = name.replace(",", "_");
        name = name.replace(' ', '_');
        name = name.replace('(', '[');
        name = name.replace(')', ']');
        while (name.indexOf("__") >= 0) {
            name = name.replace("__", "_");
        }
        return name;
    }

    public static RealType[] ensureUnit(RealType[] types, Unit u) throws VisADException {
        RealType[] newTypes = new RealType[types.length];
        for (int i = 0; i < types.length; ++i) {
            newTypes[i] = Util.ensureUnit(types[i], u);
        }
        return newTypes;
    }

    public static Data ensureMathType(Data data, MathType type) throws UnimplementedException, VisADException, RemoteException {
        return data.getType().equals(type) ? data : Util.clone(data, type);
    }

    public static Field ensureDomain(Field field, Set domain) throws UnimplementedException, VisADException, RemoteException {
        Set oldDomain = Util.getDomainSet(field);
        return oldDomain.equals(domain) ? field : Util.clone(field, domain);
    }

    public static Field ensureDomain(Field field, RealTupleType newDomainType, CoordinateSystem coordinateSystem) throws UnimplementedException, VisADException, RemoteException {
        return !DataUtility.getDomainType(field).equals(newDomainType) ? Util.convertDomain(field, newDomainType, coordinateSystem) : (coordinateSystem == null || coordinateSystem.equals(Util.getDomainSet(field).getCoordinateSystem()) ? field : Util.clone(field, Util.clone(Util.getDomainSet(field), coordinateSystem)));
    }

    public static Field ensureTupleRange(Field field) throws RemoteException, VisADException {
        return DataUtility.ensureRange(field, DataUtility.getRangeTupleType(field));
    }

    public static Field clone(Field field, Set domain) throws UnimplementedException, VisADException, RemoteException {
        return Util.clone(field, domain, true);
    }

    public static Field clone(Field field, Set domain, boolean copyRange) throws UnimplementedException, VisADException, RemoteException {
        FieldImpl newField;
        if (!(field instanceof FieldImpl)) {
            throw new UnimplementedException("Can't yet clone " + field.getClass());
        }
        if (field instanceof FlatField) {
            newField = Util.clone((FlatField)field, domain, copyRange);
        } else {
            FieldImpl fieldImpl = (FieldImpl)field;
            FunctionType oldFuncType = (FunctionType)fieldImpl.getType();
            RealTupleType newDomainTupleType = ((SetType)domain.getType()).getDomain();
            FunctionType newFuncType = newDomainTupleType.equalsExceptNameButUnits(oldFuncType.getDomain()) ? oldFuncType : new FunctionType(newDomainTupleType, oldFuncType.getRange());
            newField = new FieldImpl(newFuncType, domain);
            if (copyRange && !fieldImpl.isMissing()) {
                int i = fieldImpl.getLength();
                while (--i >= 0) {
                    ((FieldImpl)newField).setSample(i, fieldImpl.getSample(i), false);
                }
            }
        }
        return newField;
    }

    public static FlatField clone(FlatField flatField, Set domain, boolean copyRange) throws VisADException, RemoteException {
        CoordinateSystem rangeCoordinateSystem = Util.getRangeCoordinateSystem(flatField);
        CoordinateSystem[] rangeCoordinateSystems = Util.getRangeCoordinateSystems(flatField);
        Set[] rangeSets = flatField.getRangeSets();
        Unit[] rangeUnits = Util.getRangeUnits(flatField);
        FunctionType oldFuncType = (FunctionType)flatField.getType();
        RealTupleType newDomainTupleType = ((SetType)domain.getType()).getDomain();
        FunctionType newFuncType = newDomainTupleType.equalsExceptNameButUnits(oldFuncType.getDomain()) ? oldFuncType : new FunctionType(newDomainTupleType, oldFuncType.getRange());
        FlatField newField = new FlatField(newFuncType, domain, rangeCoordinateSystem, rangeCoordinateSystems, flatField.getRangeSets(), null);
        if (copyRange && !flatField.isMissing()) {
            newField.setSamples(flatField.getValues(true), false);
        }
        return newField;
    }

    public static Field convertDomain(Field field, RealTupleType newDomainType, CoordinateSystem coordinateSystem) throws UnimplementedException, VisADException, RemoteException {
        FieldImpl newField;
        if (!(field instanceof FieldImpl)) {
            throw new UnimplementedException("Can't yet clone " + field.getClass());
        }
        if (field instanceof FlatField) {
            newField = Util.convertDomain((FlatField)field, newDomainType, coordinateSystem);
        } else {
            FieldImpl fieldImpl = (FieldImpl)field;
            newField = new FieldImpl(new FunctionType(newDomainType, DataUtility.getRangeType(field)), Util.convertDomain((SampledSet)Util.getDomainSet(field), newDomainType, coordinateSystem));
            if (!fieldImpl.isMissing()) {
                int i = fieldImpl.getLength();
                while (--i >= 0) {
                    ((FieldImpl)newField).setSample(i, fieldImpl.getSample(i), false);
                }
            }
        }
        return newField;
    }

    public static FlatField convertDomain(FlatField field, RealTupleType newDomainType, CoordinateSystem coordinateSystem) throws VisADException, RemoteException {
        CoordinateSystem rangeCoordinateSystem = Util.getRangeCoordinateSystem(field);
        CoordinateSystem[] rangeCoordinateSystems = Util.getRangeCoordinateSystems(field);
        Set[] rangeSets = field.getRangeSets();
        Unit[] rangeUnits = Util.getRangeUnits(field);
        SampledSet oldDomain = (SampledSet)Util.getDomainSet(field);
        RealTupleType oldDomainType = ((SetType)oldDomain.getType()).getDomain();
        ErrorEstimate[] oldErrors = oldDomain.getSetErrors();
        ErrorEstimate[] newErrors = new ErrorEstimate[oldErrors.length];
        Unit[] newUnits = coordinateSystem == null ? newDomainType.getDefaultUnits() : coordinateSystem.getCoordinateSystemUnits();
        double[][] newDomainValues = CoordinateSystem.transformCoordinates(newDomainType, coordinateSystem, newUnits, newErrors, oldDomainType, oldDomain.getCoordinateSystem(), oldDomain.getSetUnits(), oldErrors, oldDomain.getDoubles());
        FlatField newField = new FlatField(new FunctionType(newDomainType, DataUtility.getRangeType(field)), Util.newSampledSet(oldDomain, newDomainType, newDomainValues, coordinateSystem, newUnits, newErrors), rangeCoordinateSystem, rangeCoordinateSystems, field.getRangeSets(), null);
        if (!field.isMissing()) {
            newField.setSamples(field.getValues(true), false);
        }
        return newField;
    }

    public static SampledSet convertDomain(SampledSet oldDomain, RealTupleType newDomainType, CoordinateSystem coordinateSystem) throws VisADException, RemoteException {
        RealTupleType oldDomainType = ((SetType)oldDomain.getType()).getDomain();
        ErrorEstimate[] oldErrors = oldDomain.getSetErrors();
        ErrorEstimate[] newErrors = new ErrorEstimate[oldErrors.length];
        Unit[] newUnits = coordinateSystem == null ? newDomainType.getDefaultUnits() : coordinateSystem.getCoordinateSystemUnits();
        double[][] newDomainValues = CoordinateSystem.transformCoordinates(newDomainType, coordinateSystem, newUnits, newErrors, oldDomainType, oldDomain.getCoordinateSystem(), oldDomain.getSetUnits(), oldErrors, oldDomain.getDoubles());
        return Util.newSampledSet(oldDomain, newDomainType, newDomainValues, coordinateSystem, newUnits, newErrors);
    }

    public static SampledSet newSampledSet(SampledSet oldSampledSet, float[][] newValues, int[] manifoldLengths) throws VisADException, RemoteException {
        return Util.newSampledSet(manifoldLengths, ((SetType)oldSampledSet.getType()).getDomain(), newValues, oldSampledSet.getCoordinateSystem(), oldSampledSet.getSetUnits(), oldSampledSet.getSetErrors());
    }

    public static SampledSet newSampledSet(SampledSet oldSampledSet, double[][] newValues, int[] manifoldLengths) throws VisADException, RemoteException {
        return Util.newSampledSet(manifoldLengths, ((SetType)oldSampledSet.getType()).getDomain(), newValues, oldSampledSet.getCoordinateSystem(), oldSampledSet.getSetUnits(), oldSampledSet.getSetErrors());
    }

    public static SampledSet newSampledSet(SampledSet oldSampledSet, RealTupleType newSampledSetType, float[][] newValues, CoordinateSystem coordinateSystem, Unit[] newUnits, ErrorEstimate[] newErrors) throws VisADException, RemoteException {
        int[] nArray;
        if (oldSampledSet instanceof GriddedSet) {
            nArray = ((GriddedSet)oldSampledSet).getLengths();
        } else if (oldSampledSet instanceof SingletonSet) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            nArray = null;
        }
        int[] manifoldLenths = nArray;
        return Util.newSampledSet(manifoldLenths, newSampledSetType, newValues, coordinateSystem, newUnits, newErrors);
    }

    public static SampledSet newSampledSet(SampledSet oldSampledSet, RealTupleType newSampledSetType, double[][] newValues, CoordinateSystem coordinateSystem, Unit[] newUnits, ErrorEstimate[] newErrors) throws VisADException, RemoteException {
        int[] nArray;
        if (oldSampledSet instanceof GriddedSet) {
            nArray = ((GriddedSet)oldSampledSet).getLengths();
        } else if (oldSampledSet instanceof SingletonSet) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            nArray = null;
        }
        int[] manifoldLenths = nArray;
        return Util.newSampledSet(manifoldLenths, newSampledSetType, newValues, coordinateSystem, newUnits, newErrors);
    }

    public static SampledSet newSampledSet(int[] manifoldLengths, RealTupleType newSampledSetType, double[][] newValues, CoordinateSystem coordinateSystem, Unit[] newUnits, ErrorEstimate[] newErrors) throws VisADException, RemoteException {
        return Util.newSampledSet(manifoldLengths, newSampledSetType, Set.doubleToFloat(newValues), coordinateSystem, newUnits, newErrors);
    }

    public static SampledSet newSampledSet(int[] manifoldLengths, RealTupleType newSampledSetType, float[][] newValues, CoordinateSystem coordinateSystem, Unit[] newUnits, ErrorEstimate[] newErrors) throws VisADException, RemoteException {
        SampledSet newSampledSet;
        if (manifoldLengths != null) {
            int product = 1;
            int i = manifoldLengths.length;
            while (--i >= 0) {
                product *= manifoldLengths[i];
            }
            if (product != 1) {
                newSampledSet = GriddedSet.create(newSampledSetType, newValues, manifoldLengths, coordinateSystem, newUnits, newErrors);
            } else {
                Real[] reals = new Real[newSampledSetType.getDimension()];
                int i2 = reals.length;
                while (--i2 >= 0) {
                    reals[i2] = new Real((RealType)newSampledSetType.getComponent(i2), (double)newValues[i2][0], newUnits[i2], newErrors[i2]);
                }
                newSampledSet = new SingletonSet(new RealTuple(newSampledSetType, reals, coordinateSystem), coordinateSystem, newUnits, newErrors);
            }
        } else {
            switch (newSampledSetType.getDimension()) {
                case 1: {
                    newSampledSet = new Irregular1DSet((MathType)newSampledSetType, newValues, coordinateSystem, newUnits, newErrors);
                    break;
                }
                case 2: {
                    newSampledSet = new Irregular2DSet(newSampledSetType, newValues, coordinateSystem, newUnits, newErrors, null);
                    break;
                }
                case 3: {
                    newSampledSet = new Irregular3DSet(newSampledSetType, newValues, coordinateSystem, newUnits, newErrors, null);
                    break;
                }
                default: {
                    newSampledSet = new IrregularSet(newSampledSetType, newValues, coordinateSystem, newUnits, newErrors, null);
                }
            }
        }
        return newSampledSet;
    }

    public static CoordinateSystem getRangeCoordinateSystem(Field field) throws VisADException, RemoteException {
        return ((FunctionType)field.getType()).getReal() ? field.getRangeCoordinateSystem()[0] : null;
    }

    public static CoordinateSystem[] getRangeCoordinateSystems(Field field) throws VisADException, RemoteException {
        CoordinateSystem[] coordSyses;
        FunctionType funcType = (FunctionType)field.getType();
        if (funcType.getReal()) {
            coordSyses = null;
        } else {
            int componentCount = ((TupleType)funcType.getRange()).getDimension();
            coordSyses = new CoordinateSystem[componentCount];
            int i = componentCount;
            while (--i >= 0) {
                coordSyses[i] = field.getRangeCoordinateSystem(i)[0];
            }
        }
        return coordSyses;
    }

    public static Unit[] getRangeUnits(FlatField field) {
        Unit[][] units = field.getRangeUnits();
        Unit[] result = new Unit[units.length];
        int i = result.length;
        while (--i >= 0) {
            result[i] = units[i][0];
        }
        return result;
    }

    public static Unit[] getDefaultRangeUnits(FieldImpl field) {
        return ((FunctionType)field.getType()).getFlatRange().getDefaultUnits();
    }

    public static Data clone(Data data, MathType type) throws UnimplementedException, VisADException, RemoteException {
        return Util.clone(data, type, false, true);
    }

    public static Set getDomainSet(Field field) {
        try {
            return field.getDomainSet();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public static Set getDomainSetForClone(Field field) {
        try {
            if (field instanceof AreaImageFlatField) {
                return ((AreaImageFlatField)field).getDomainSetNoRead();
            }
            return field.getDomainSet();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public static Data clone(Data data, MathType type, boolean unitOverride, boolean copy) throws UnimplementedException, VisADException, RemoteException {
        return Util.clone(data, type, unitOverride, copy, copy);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Data clone(Data data, MathType type, boolean unitOverride, boolean copy, boolean copyDomain) throws UnimplementedException, VisADException, RemoteException {
        void var5_41;
        if (data instanceof Field) {
            Field field = (Field)data;
            if (!(type instanceof FunctionType)) {
                type = new FunctionType(((FunctionType)field.getType()).getDomain(), type);
            }
            FunctionType funcType = (FunctionType)type;
            if (data instanceof FlatField) {
                FlatField newFlatField;
                FlatField oldFlatField = (FlatField)data;
                Set newDomain = (Set)Util.ensureMathType(Util.getDomainSetForClone(oldFlatField), copyDomain ? funcType.getDomain() : new SetType(funcType.getDomain()));
                Set[] oldRangeSets = oldFlatField.getRangeSets();
                Unit[] oldUnits = oldFlatField.getDefaultRangeUnits();
                Unit[] newUnits = funcType.getFlatRange().getDefaultUnits();
                CoordinateSystem oldCS = Util.getRangeCoordinateSystem(oldFlatField);
                CoordinateSystem[] oldRangeCS = Util.getRangeCoordinateSystems(oldFlatField);
                Set[] newRangeSets = oldRangeSets;
                if (unitOverride && !Unit.canConvertArray(oldUnits, newUnits)) {
                    oldUnits = newUnits;
                }
                if (!funcType.getRange().equalsExceptNameButUnits(((FunctionType)oldFlatField.getType()).getRange())) {
                    oldCS = null;
                    oldRangeCS = null;
                    RealTupleType flatRange = funcType.getFlatRange();
                    newRangeSets = new Set[oldRangeSets.length];
                    for (int i = 0; i < flatRange.getDimension(); ++i) {
                        newRangeSets[i] = ((RealType)flatRange.getComponent(i)).getDefaultSet();
                        if (newRangeSets[i] != null) continue;
                        newRangeSets[i] = oldRangeSets[i] instanceof DoubleSet ? new DoubleSet(new SetType(flatRange.getComponent(i))) : new FloatSet(new SetType(flatRange.getComponent(i)));
                    }
                }
                if (oldFlatField instanceof CachedFlatField) {
                    newFlatField = ((CachedFlatField)oldFlatField).cloneMe(copy, funcType, newDomain, oldCS, oldRangeCS, newRangeSets, oldUnits);
                } else {
                    newFlatField = new FlatField(funcType, newDomain, oldCS, oldRangeCS, newRangeSets, oldUnits);
                    if (!oldFlatField.isMissing()) {
                        boolean useFloats = true;
                        int i = oldRangeSets.length;
                        while (--i >= 0) {
                            if (!(oldRangeSets[i] instanceof DoubleSet)) continue;
                            useFloats = false;
                            break;
                        }
                        if (useFloats) {
                            newFlatField.setSamples(oldFlatField.getFloats(copy), false);
                        } else {
                            newFlatField.setSamples(oldFlatField.getValues(copy), false);
                        }
                    }
                }
                FlatField flatField = newFlatField;
                return var5_41;
            } else {
                Data data2 = data.changeMathType(funcType);
            }
            return var5_41;
        } else if (data instanceof Set) {
            Set set = (Set)((Set)data).cloneButType(type);
            return var5_41;
        } else if (data instanceof Real) {
            Real real = (Real)data;
            if (type instanceof RealType) {
                Real real2 = new Real((RealType)type, real.getValue(), real.getUnit(), real.getError());
                return var5_41;
            } else {
                if (!(type instanceof RealTupleType)) throw new UnimplementedException("Util.clone(Data,MathType): Can't yet convert Real into type \"" + type + "\"");
                RealTupleType realTupleType = (RealTupleType)type;
                RealTuple realTuple = new RealTuple((RealTupleType)type, new Real[]{(Real)Util.clone(real, realTupleType.getComponent(0), unitOverride, copy)}, null);
            }
            return var5_41;
        } else {
            if (!(data instanceof Tuple)) throw new UnimplementedException("Cloning " + data.getClass() + " data object with change of MathType not yet supported");
            Tuple tuple = (Tuple)data;
            if (type instanceof RealType) {
                RealType realType = (RealType)type;
                if (tuple.getDimension() != 1) {
                    throw new TypeException("Util.clone(Data,MathType): Can't convert multi-dimensional Tuple into Real");
                }
                Data data3 = Util.clone(tuple.getComponent(0), realType, unitOverride, copy);
                return var5_41;
            } else {
                if (!(type instanceof TupleType)) throw new UnimplementedException("Util.clone(Data,MathType): Can't yet convert Tuple into type \"" + type + "\"");
                TupleType tupleType = (TupleType)type;
                int rank = tuple.getDimension();
                if (rank != tupleType.getDimension()) {
                    throw new TypeException("Util.clone(Data,MathType): Can't convert rank " + rank + " Tuple into rank " + tupleType.getDimension() + " Tuple");
                }
                if (tupleType instanceof RealTupleType) {
                    RealTupleType realTupleType = (RealTupleType)tupleType;
                    Real[] reals = new Real[rank];
                    for (int i = 0; i < rank; ++i) {
                        reals[i] = (Real)Util.clone(tuple.getComponent(i), (RealType)realTupleType.getComponent(i), unitOverride, copy);
                    }
                    RealTuple realTuple = new RealTuple(realTupleType, reals, tuple instanceof RealTuple ? ((RealTuple)tuple).getCoordinateSystem() : (CoordinateSystem)null);
                    return var5_41;
                } else {
                    Data[] datums = new Data[rank];
                    for (int i = 0; i < rank; ++i) {
                        datums[i] = Util.clone(tuple.getComponent(i), tupleType.getComponent(i), unitOverride, copy);
                    }
                    Tuple tuple2 = new Tuple(tupleType, datums, false);
                }
            }
        }
        return var5_41;
    }

    public static Set ensureCoordinateSystem(Set set, CoordinateSystem coordSys) throws UnimplementedException, VisADException, RemoteException {
        CoordinateSystem origCoordSys = set.getCoordinateSystem();
        return coordSys == null && origCoordSys == null || coordSys != null && coordSys.equals(origCoordSys) ? set : Util.clone(set, coordSys);
    }

    public static Set clone(Set set, CoordinateSystem coordSys) throws UnimplementedException, VisADException, RemoteException {
        Set clone;
        if (set instanceof IntegerSet) {
            GriddedSet griddedSet = (GriddedSet)set;
            clone = IntegerNDSet.create(set.getType(), griddedSet.getLengths(), coordSys, set.getSetUnits(), set.getSetErrors());
        } else if (set instanceof LinearSet) {
            GriddedSet griddedSet = (GriddedSet)set;
            int rank = griddedSet.getDimension();
            double[] firsts = new double[rank];
            double[] lasts = new double[rank];
            LinearSet linearSet = (LinearSet)((Object)set);
            for (int i = 0; i < rank; ++i) {
                Linear1DSet linear1DSet = linearSet.getLinear1DComponent(i);
                firsts[i] = linear1DSet.getFirst();
                lasts[i] = linear1DSet.getLast();
            }
            clone = (Set)((Object)LinearNDSet.create(set.getType(), firsts, lasts, griddedSet.getLengths(), coordSys, set.getSetUnits(), set.getSetErrors()));
        } else if (set instanceof SampledSet) {
            clone = Util.newSampledSet((SampledSet)set, ((SetType)set.getType()).getDomain(), set.getDoubles(true), coordSys, set.getSetUnits(), set.getSetErrors());
        } else {
            throw new UnimplementedException("Util.clone(Set,CoordinateSystem): Can't clone class " + set.getClass());
        }
        return clone;
    }

    public static SampledSet getRangeSampledSet(Field field, MathType type) throws VisADException, RemoteException {
        Field componentField = DataUtility.ensureRange(field, type);
        return Util.newSampledSet(type, componentField.getFloats(true), null, componentField.getRangeCoordinateSystem()[0], componentField.getDefaultRangeUnits(), componentField instanceof FlatField ? ((FlatField)componentField).getRangeErrors() : (ErrorEstimate[])null, false);
    }

    public static FlatField ensureFlatFieldRangeType(FlatField flatField, RealType realType) throws VisADException, RemoteException {
        if (!DataUtility.getRangeType(flatField).equals(realType)) {
            FlatField newFlatField = new FlatField(new FunctionType(DataUtility.getDomainType(flatField), realType), Util.getDomainSet(flatField), Util.getRangeCoordinateSystem(flatField), Util.getRangeCoordinateSystems(flatField), flatField.getRangeSets(), flatField.getDefaultRangeUnits());
            newFlatField.setSamples(flatField.getValues(true), false);
            newFlatField.setRangeErrors(flatField.getRangeErrors());
            flatField = newFlatField;
        }
        return flatField;
    }

    public static SampledSet newSampledSet(MathType type, float[][] values, int[] manifoldLengths, CoordinateSystem coordinateSystem, Unit[] units, ErrorEstimate[] errors, boolean copy) throws VisADException, RemoteException {
        SampledSet sampledSet;
        if (values.length < 1) {
            throw new VisADException("no sample values");
        }
        int i = values.length;
        while (--i >= 1) {
            if (values[i].length == values[0].length) continue;
            throw new VisADException("values[i].lengths differ");
        }
        if (values[0].length == 1) {
            RealTuple realTuple;
            if (type instanceof RealType) {
                if (values.length != 1) {
                    throw new VisADException("values/type mismatch");
                }
                realTuple = new RealTuple(new Real[]{new Real((RealType)type, (double)values[0][0])});
            } else if (type instanceof RealTupleType) {
                double[] samples = new double[values.length];
                int i2 = values.length;
                while (--i2 >= 0) {
                    samples[i2] = values[i2][0];
                }
                realTuple = new RealTuple((RealTupleType)type, samples);
            } else {
                throw new VisADException("type neither RealType nor RealTupleType");
            }
            sampledSet = new SingletonSet(realTuple, coordinateSystem, units, errors);
        } else {
            sampledSet = manifoldLengths != null ? GriddedSet.create(type, values, manifoldLengths, coordinateSystem, units, errors) : (values.length == 1 ? new Irregular1DSet(type, values, coordinateSystem, units, errors) : (values.length == 2 ? new Irregular2DSet(type, values, coordinateSystem, units, errors, null) : (values.length == 3 ? new Irregular3DSet(type, values, coordinateSystem, units, errors, null) : new IrregularSet(type, values, coordinateSystem, units, errors, null))));
        }
        return sampledSet;
    }

    public static RealTuple getSample(Set set, int index) throws VisADException, RemoteException {
        return DataUtility.getSample(set, index);
    }

    public static float[] take(float[] values, int[] indexes) {
        float[] newValues = new float[indexes.length];
        int i = indexes.length;
        while (--i >= 0) {
            newValues[i] = values[indexes[i]];
        }
        return newValues;
    }

    public static double[] take(double[] values, int[] indexes) {
        double[] newValues = new double[indexes.length];
        int i = indexes.length;
        while (--i >= 0) {
            newValues[i] = values[indexes[i]];
        }
        return newValues;
    }

    public static boolean isSorted(float[] values) {
        boolean isSorted = true;
        if (values.length >= 3) {
            boolean increasing = true;
            boolean haveDirection = false;
            float previous = values[0];
            for (int i = 1; i < values.length; ++i) {
                float value = values[i];
                if (haveDirection) {
                    if (increasing && value < previous || !increasing && value > previous) {
                        isSorted = false;
                        break;
                    }
                } else if (value != previous) {
                    haveDirection = true;
                    increasing = value > previous;
                }
                previous = value;
            }
        }
        return isSorted;
    }

    public static boolean isSorted(double[] values) {
        boolean isSorted = true;
        if (values.length >= 3) {
            boolean increasing = true;
            boolean haveDirection = false;
            double previous = values[0];
            for (int i = 1; i < values.length; ++i) {
                double value = values[i];
                if (haveDirection) {
                    if (increasing && value < previous || !increasing && value > previous) {
                        isSorted = false;
                        break;
                    }
                } else if (value != previous) {
                    haveDirection = true;
                    increasing = value > previous;
                }
                previous = value;
            }
        }
        return isSorted;
    }

    public static boolean isStrictlySorted(float[] values) {
        boolean isSorted = true;
        if (values.length >= 2) {
            boolean increasing = true;
            boolean haveDirection = false;
            float previous = values[0];
            for (int i = 1; i < values.length; ++i) {
                float value = values[i];
                if (haveDirection) {
                    if (increasing && value <= previous || !increasing && value >= previous) {
                        isSorted = false;
                        break;
                    }
                } else {
                    if (value == previous) {
                        isSorted = false;
                        break;
                    }
                    haveDirection = true;
                    increasing = value > previous;
                }
                previous = value;
            }
        }
        return isSorted;
    }

    public static boolean isStrictlySorted(double[] values) {
        boolean isSorted = true;
        if (values.length >= 2) {
            boolean increasing = true;
            boolean haveDirection = false;
            double previous = values[0];
            for (int i = 1; i < values.length; ++i) {
                double value = values[i];
                if (haveDirection) {
                    if (increasing && value <= previous || !increasing && value >= previous) {
                        isSorted = false;
                        break;
                    }
                } else {
                    if (value == previous) {
                        isSorted = false;
                        break;
                    }
                    haveDirection = true;
                    increasing = value > previous;
                }
                previous = value;
            }
        }
        return isSorted;
    }

    public static int[] sortedIndexes(float[] values, boolean increasing) {
        float[][] pairs = new float[values.length][2];
        int i = values.length;
        while (--i >= 0) {
            pairs[i][0] = values[i];
            pairs[i][1] = i;
        }
        Arrays.sort(pairs, increasing ? increasingFloatComparator : decreasingFloatComparator);
        int[] indexes = new int[pairs.length];
        int i2 = indexes.length;
        while (--i2 >= 0) {
            indexes[i2] = (int)pairs[i2][1];
        }
        return indexes;
    }

    public static int[] sortedIndexes(double[] values, boolean increasing) {
        double[][] pairs = new double[values.length][2];
        int i = values.length;
        while (--i >= 0) {
            pairs[i][0] = values[i];
            pairs[i][1] = i;
        }
        Arrays.sort(pairs, increasing ? increasingDoubleComparator : decreasingDoubleComparator);
        int[] indexes = new int[pairs.length];
        int i2 = indexes.length;
        while (--i2 >= 0) {
            indexes[i2] = (int)pairs[i2][1];
        }
        return indexes;
    }

    public static int[] strictlySortedIndexes(float[] values, boolean increasing) {
        int i;
        int[] indexes = Util.sortedIndexes(values, increasing);
        for (i = 0; i < indexes.length && values[indexes[i]] != values[indexes[i]]; ++i) {
        }
        if (i > 0) {
            int[] tmp = new int[indexes.length - i];
            System.arraycopy(indexes, i, tmp, 0, tmp.length);
            indexes = tmp;
        }
        boolean[] takeMask = new boolean[indexes.length];
        Arrays.fill(takeMask, true);
        int n = 0;
        int i2 = indexes.length;
        while (--i2 > 0) {
            if (values[indexes[i2]] != values[indexes[i2 - 1]]) continue;
            ++n;
            takeMask[i2] = false;
        }
        if (n > 0) {
            int[] tmp = new int[indexes.length - n];
            int j = 0;
            for (int i3 = 0; i3 < indexes.length; ++i3) {
                if (!takeMask[i3]) continue;
                tmp[j++] = indexes[i3];
            }
            indexes = tmp;
        }
        return indexes;
    }

    public static int[] strictlySortedIndexes(double[] values, boolean increasing) {
        int i;
        int[] indexes = Util.sortedIndexes(values, increasing);
        for (i = 0; i < indexes.length && values[indexes[i]] != values[indexes[i]]; ++i) {
        }
        if (i > 0) {
            int[] tmp = new int[indexes.length - i];
            System.arraycopy(indexes, i, tmp, 0, tmp.length);
            indexes = tmp;
        }
        boolean[] takeMask = new boolean[indexes.length];
        Arrays.fill(takeMask, true);
        int n = 0;
        int i2 = indexes.length;
        while (--i2 > 0) {
            if (values[indexes[i2]] != values[indexes[i2 - 1]]) continue;
            ++n;
            takeMask[i2] = false;
        }
        if (n > 0) {
            int[] tmp = new int[indexes.length - n];
            int j = 0;
            for (int i3 = 0; i3 < indexes.length; ++i3) {
                if (!takeMask[i3]) continue;
                tmp[j++] = indexes[i3];
            }
            indexes = tmp;
        }
        return indexes;
    }

    public static RealType getRealType(RealTupleType type, String start) throws VisADException {
        RealType[] rTypes = type.getRealComponents();
        for (int i = 0; i < rTypes.length; ++i) {
            if (!rTypes[i].getName().toLowerCase().startsWith(start)) continue;
            return rTypes[i];
        }
        return null;
    }

    public static Unit parseUnit(String unitIdentifier) throws VisADException {
        return Util.parseUnit(unitIdentifier, unitIdentifier);
    }

    public static Unit parseUnit(String unitIdentifier, String unitName) throws VisADException {
        Unit u;
        block10: {
            if (unitIdentifier == null) {
                return null;
            }
            if (unitName == null) {
                unitName = unitIdentifier;
            }
            u = null;
            unitIdentifier = unitIdentifier.replaceAll("\\*\\*", "");
            unitIdentifier = unitIdentifier.replaceAll("\\u00c2", "");
            try {
                try {
                    String realUnitName = MetUnits.makeSymbol(unitIdentifier);
                    u = Parser.parse(realUnitName);
                }
                catch (NoSuchUnitException nsu) {
                    if (unitIdentifier.indexOf("_") >= 0) {
                        unitIdentifier = unitIdentifier.replace('_', ' ');
                        String realUnitName = MetUnits.makeSymbol(unitIdentifier);
                        u = Parser.parse(realUnitName);
                        break block10;
                    }
                    if (unitIdentifier.endsWith(".true")) {
                        unitIdentifier = unitIdentifier.replace(".true", "_north");
                        String realUnitName = MetUnits.makeSymbol(unitIdentifier);
                        u = Parser.parse(realUnitName);
                        break block10;
                    }
                    throw new VisADException("No such unit:" + nsu);
                }
            }
            catch (Exception exc) {
                throw new VisADException("Error parsing unit:" + exc);
            }
        }
        try {
            u = u.clone(unitName);
        }
        catch (UnitException unitException) {
            // empty catch block
        }
        return u;
    }

    public static String formatUtcDate(DateTime dt, String pattern) {
        return UtcDate.formatUtcDate(dt, pattern);
    }

    public static Date makeDate(DateTime dttm) throws VisADException {
        return new Date((long)dttm.getValue(CommonUnit.secondsSinceTheEpoch) * 1000L);
    }

    public static DateTime getGregorianDateTime(TimeZone zone, int year, int month, int day, int hour, int min, int sec) throws VisADException {
        if (zone == null) {
            zone = TimeZone.getDefault();
        }
        GregorianCalendar convertCal = new GregorianCalendar(zone);
        convertCal.clear();
        convertCal.set(1, year);
        convertCal.set(2, month - 1);
        convertCal.set(5, day);
        convertCal.set(11, hour);
        convertCal.set(12, min);
        convertCal.set(13, sec);
        return new DateTime(convertCal.getTime());
    }

    public static List<Date> makeDates(DateTime[] timesArray) throws VisADException {
        ArrayList<Date> dates = new ArrayList<Date>();
        if (timesArray != null) {
            for (int i = 0; i < timesArray.length; ++i) {
                dates.add(Util.makeDate(timesArray[i]));
            }
        }
        return dates;
    }

    public static Real toReal(String value) throws Exception {
        if (value.indexOf("(") >= 0 && value.indexOf(")") >= 0) {
            return Util.toReal(value, "(", ")");
        }
        if (value.indexOf("{") >= 0 && value.indexOf("}") >= 0) {
            return Util.toReal(value, "{", "}");
        }
        if (value.indexOf("<") >= 0 && value.indexOf(">") >= 0) {
            return Util.toReal(value, "<", ">");
        }
        return Util.toReal(value, "[", "]");
    }

    public static Real toReal(String value, String unitOpener, String unitCloser) throws Exception {
        int idx = (value = value.trim()).indexOf(unitOpener);
        if (idx < 0) {
            idx = value.indexOf(" ");
        }
        if (idx > 0) {
            String valueString = value.substring(0, idx).trim();
            String unitString = value.substring(idx).trim();
            if ((idx = unitString.indexOf(unitOpener)) >= 0) {
                unitString = unitString.substring(1);
                unitString = unitString.substring(0, unitString.length() - 1);
            }
            Unit unit = Util.parseUnit(unitString);
            String rtName = "util_" + unit.toString();
            return new Real(RealType.getRealType(rtName, unit), Misc.parseValue(valueString), unit);
        }
        return new Real(Double.valueOf(value));
    }

    public static double distance(visad.georef.LatLonPoint p1, visad.georef.LatLonPoint p2) {
        double x1 = p1.getLongitude().getValue();
        double y1 = p1.getLatitude().getValue();
        double x2 = p2.getLongitude().getValue();
        double y2 = p2.getLatitude().getValue();
        if (x1 < 0.0) {
            x1 = -x1;
        }
        if (x2 < 0.0) {
            x2 = -x2;
        }
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
    }

    public static LatLonPointImpl toLatLonPoint(visad.georef.LatLonPoint llp) throws VisADException {
        return new LatLonPointImpl(llp.getLatitude().getValue(CommonUnit.degree), llp.getLongitude().getValue(CommonUnit.degree));
    }

    public static Bearing calculateBearing(visad.georef.LatLonPoint pt1, visad.georef.LatLonPoint pt2, Bearing result) throws VisADException {
        Unit latUnit = pt1.getLatitude().getUnit();
        Unit lonUnit = pt1.getLongitude().getUnit();
        return Bearing.calculateBearing(pt1.getLatitude().getValue(), pt1.getLongitude().getValue(), pt2.getLatitude().getValue(latUnit), pt2.getLongitude().getValue(lonUnit), result);
    }

    public static Bearing calculateBearing(visad.georef.LatLonPoint pt1, visad.georef.LatLonPoint pt2) throws VisADException {
        Unit latUnit = pt1.getLatitude().getUnit();
        Unit lonUnit = pt1.getLongitude().getUnit();
        return Bearing.calculateBearing(pt1.getLatitude().getValue(), pt1.getLongitude().getValue(), pt2.getLatitude().getValue(latUnit), pt2.getLongitude().getValue(lonUnit));
    }

    public static String formatReal(Real r) {
        return Misc.format(r.getValue());
    }

    public static TwoFacedObject labeledReal(Real r) {
        return Util.labeledReal(r, false);
    }

    public static TwoFacedObject labeledReal(Real r, boolean includeUnit) {
        if (r == null) {
            return null;
        }
        String label = Util.formatReal(r);
        if (includeUnit) {
            label = label + " " + r.getUnit();
        }
        return new TwoFacedObject((Object)label, r);
    }

    public static FieldImpl indexedField(Data[] datas, boolean copy) throws VisADException, RemoteException {
        if (datas == null) {
            throw new NullPointerException("indexedField: datas is null");
        }
        MathType mt = datas[0].getType();
        RealType index = RealType.getRealType("index");
        FunctionType ft = new FunctionType(index, mt);
        Integer1DSet domain = new Integer1DSet((MathType)index, datas.length);
        FieldImpl fi = new FieldImpl(ft, domain);
        fi.setSamples(datas, false);
        return fi;
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            try {
                Real r = Util.toReal(args[i]);
                System.err.println("" + r + ":" + r.getType());
                continue;
            }
            catch (Exception exc) {
                System.err.println("error:" + args[i] + " " + exc);
            }
        }
    }

    public static Real bearingDistance(EarthLocation el1, EarthLocation el2) throws Exception {
        visad.georef.LatLonPoint lllp = el1.getLatLonPoint();
        visad.georef.LatLonPoint rllp = el2.getLatLonPoint();
        Unit latUnit = lllp.getLatitude().getUnit();
        Unit lonUnit = lllp.getLongitude().getUnit();
        Bearing result = Bearing.calculateBearing(Util.toLatLonPoint(lllp), (LatLonPoint)Util.toLatLonPoint(rllp), null);
        return new Real(Length.getRealType(), result.getDistance(), CommonUnits.KILOMETER);
    }

    public static double getValueAs(Real r, String unitString) throws VisADException, RemoteException {
        try {
            Unit unit = Util.parseUnit(unitString);
            return r.getValue(unit);
        }
        catch (Exception exc) {
            throw new VisADException("Error parsing unit:" + exc);
        }
    }

    public static Real getReal(double value, String unitString) throws VisADException, RemoteException {
        Unit unit = Util.parseUnit(unitString);
        return Util.getReal(value, unit);
    }

    public static Real getReal(double value, Unit unit) throws VisADException, RemoteException {
        try {
            return new Real(Util.getRealType(unit), value, unit);
        }
        catch (RuntimeException rexc) {
            throw rexc;
        }
        catch (Exception exc) {
            throw new VisADException("Error parsing unit:" + exc);
        }
    }

    public static RealType getRealType(Unit unit) throws VisADException, RemoteException {
        return Util.makeRealType(REALTYPE_ROOT, unit);
    }

    public static double[] getRayPositionAtZ(VisADRay ray, double zValue) {
        if (Double.isNaN(zValue) || zValue == ray.position[2]) {
            return ray.position;
        }
        if (ray.vector[2] == 0.0) {
            return ray.position;
        }
        double r = (zValue - ray.position[2]) / ray.vector[2];
        return new double[]{ray.position[0] + r * ray.vector[0], ray.position[1] + r * ray.vector[1], zValue};
    }

    public static String cleanTypeName(String name) {
        int index = name.indexOf("[unit:");
        if (index >= 0) {
            name = name.substring(0, index);
        }
        if ((index = name.indexOf("_unitsuffix_")) >= 0) {
            name = name.substring(0, index);
        }
        name = StringUtil.replace(name, TEXT_IDENTIFIER, "");
        return name;
    }

    public static String cleanTypeName(MathType mathType) {
        return Util.cleanTypeName(mathType.toString());
    }

    public static int getIndex(TupleType tupleType, String lookingFor) {
        MathType[] comps = tupleType.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            String name = Util.cleanTypeName(comps[i]);
            if (!name.equals(lookingFor)) continue;
            return i;
        }
        return -1;
    }

    public static RealType makeRealType(String name, Unit unit) throws VisADException {
        return Util.makeRealType(name, null, unit);
    }

    public static RealType makeRealType(String name, String alias, Unit unit) throws VisADException {
        RealType type = null;
        String newname = Util.cleanName(name) + "[unit:" + (unit == null ? "null" : Util.cleanName(unit.toString())) + "]";
        type = RealType.getRealType(newname, unit);
        if (type == null) {
            type = RealType.getRealType(newname + "_" + typeCnt++, unit);
        }
        if (type == null) {
            throw new VisADException("couldn't create RealType with units compatible to " + unit.toString());
        }
        if (alias != null) {
            type.alias(alias);
        }
        return type;
    }

    public static String formatLatLonPoint(visad.georef.LatLonPoint llp) {
        StringBuffer buf = new StringBuffer();
        buf.append("Lat: ");
        try {
            buf.append(Convert.shortString(llp.getLatitude().getValue()));
        }
        catch (Exception e) {
            buf.append(" ");
        }
        buf.append(" Lon: ");
        try {
            buf.append(Convert.shortString(llp.getLongitude().getValue()));
        }
        catch (Exception e) {
            buf.append(" ");
        }
        return buf.toString();
    }

    public static EarthLocation makeEarthLocation(double lat, double lon) throws Exception {
        return new EarthLocationTuple(new Real(RealType.Latitude, lat), new Real(RealType.Longitude, lon), new Real(RealType.Altitude, 0.0));
    }

    public static EarthLocation makeEarthLocation(visad.georef.LatLonPoint llp) throws Exception {
        return Util.makeEarthLocation(llp.getLatitude().getValue(), llp.getLongitude().getValue());
    }

    public static String formatEarthLocation(EarthLocation el, boolean includeAlt) {
        StringBuffer buf = new StringBuffer();
        try {
            buf.append(Util.formatLatLonPoint(el.getLatLonPoint()));
        }
        catch (Exception e) {
            return "";
        }
        if (includeAlt) {
            buf.append(" Alt: ");
            try {
                buf.append(Util.formatAltitude(el.getAltitude()));
            }
            catch (Exception e) {
                buf.append(" ");
            }
        }
        return buf.toString();
    }

    public static String formatAltitude(Real alt) {
        return Convert.shortString(alt.getValue()) + " " + alt.getUnit();
    }

    public static void dumpTypes(Data d) throws VisADException {
        try {
            JPythonMethods.dumpTypes(d);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public static double[] getVWorldCoords(DisplayImpl display, int x, int y, double[] retVals) {
        if (retVals == null) {
            retVals = new double[3];
        }
        if (display == null) {
            return retVals;
        }
        MouseBehavior behavior = display.getMouseBehavior();
        DisplayRenderer renderer = display.getDisplayRenderer();
        if (renderer != null) {
            boolean isPerspective;
            boolean bl = isPerspective = display.getGraphicsModeControl().getProjectionPolicy() == 1;
            if (renderer instanceof DisplayRendererJ3D) {
                DisplayRendererJ3D j3drend = (DisplayRendererJ3D)renderer;
                VisADCanvasJ3D canvas = j3drend.getCanvas();
                if (canvas != null) {
                    Point3d position1 = new Point3d();
                    canvas.getPixelLocationInImagePlate(x, y, position1);
                    Transform3D t = new Transform3D();
                    canvas.getImagePlateToVworld(t);
                    t.transform(position1);
                    double scaleFactor = renderer.getMode2D() ? 0.65 : 0.5;
                    retVals[0] = position1.x / scaleFactor;
                    retVals[1] = position1.y / scaleFactor;
                    retVals[2] = position1.z / scaleFactor;
                }
            } else {
                double[] matrix = display.getProjectionControl().getMatrix();
                boolean is2D = renderer.getMode2D();
                double[] rot = new double[3];
                double[] scale = new double[3];
                double[] trans = new double[3];
                behavior.instance_unmake_matrix(rot, scale, trans, matrix);
                double defScale = is2D ? 0.65 : 0.5;
                double scalex = scale[0] / defScale;
                double scaley = scale[1] / defScale;
                double transx = trans[0] / defScale;
                double transy = trans[1] / defScale;
                double[] ray = Util.getRayPositionAtZ(behavior.findRay(x, y), -1.0);
                retVals[0] = ray[0] * scalex + transx;
                retVals[1] = ray[1] * scaley + transy;
                retVals[2] = 0.0;
            }
        }
        return retVals;
    }

    public static FlatField makeField(Image image, boolean makeNansForAnyAlpha) throws IOException, VisADException {
        return Util.makeField(image, makeNansForAnyAlpha ? 0.0f : -1.0f);
    }

    public static FlatField makeField(Image image, float alphaThreshold) throws IOException, VisADException {
        return Util.makeField(image, alphaThreshold, false);
    }

    public static FlatField makeField(Image image, float alphaThreshold, boolean makeAlpha) throws IOException, VisADException {
        return Util.makeField(image, alphaThreshold, false, false);
    }

    public static FlatField makeField(Image image, float alphaThreshold, boolean makeAlpha, boolean incNames) throws IOException, VisADException {
        float[][] fArrayArray;
        RealType[] realTypeArray;
        String[] rtNames;
        if (image == null) {
            throw new VisADException("image cannot be null");
        }
        ImageHelper ih = new ImageHelper();
        int width = -1;
        int height = -1;
        while (true) {
            if (width < 0) {
                width = image.getWidth(ih);
            }
            if (height < 0) {
                height = image.getHeight(ih);
            }
            if (ih.badImage || width >= 0 && height >= 0) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (ih.badImage) {
            throw new IOException("Not an image");
        }
        int numPixels = width * height;
        int[] words = new int[numPixels];
        PixelGrabber grabber = new PixelGrabber(image.getSource(), 0, 0, width, height, words, 0, width);
        try {
            grabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel cm = grabber.getColorModel();
        float[] red_pix = new float[numPixels];
        float[] green_pix = new float[numPixels];
        float[] blue_pix = new float[numPixels];
        float[] alpha_pix = new float[numPixels];
        boolean hasAlpha = cm.hasAlpha();
        for (int i = 0; i < numPixels; ++i) {
            red_pix[i] = cm.getRed(words[i]);
            green_pix[i] = cm.getGreen(words[i]);
            blue_pix[i] = cm.getBlue(words[i]);
            alpha_pix[i] = hasAlpha ? (float)cm.getAlpha(words[i]) : 0.0f;
        }
        int alphaCnt = 0;
        boolean opaque = true;
        if (alphaThreshold >= 0.0f) {
            for (int i = 0; i < numPixels; ++i) {
                float alphaValue = hasAlpha ? (float)cm.getAlpha(words[i]) : 255.0f;
                if (!(alphaValue <= alphaThreshold)) continue;
                ++alphaCnt;
                red_pix[i] = Float.NaN;
                green_pix[i] = Float.NaN;
                blue_pix[i] = Float.NaN;
                opaque = false;
            }
        }
        if (incNames) {
            rtNames = new String[rgbaNames.length];
            int cnt = typeCnt++;
            for (int i = 0; i < rtNames.length; ++i) {
                rtNames[i] = rgbaNames[i] + "_" + cnt;
            }
        } else {
            rtNames = rgbaNames;
        }
        RealType line = RealType.getRealType("ImageLine");
        RealType element = RealType.getRealType("ImageElement");
        RealType c_red = RealType.getRealType(rtNames[0]);
        RealType c_green = RealType.getRealType(rtNames[1]);
        RealType c_blue = RealType.getRealType(rtNames[2]);
        RealType c_alpha = RealType.getRealType(rtNames[3]);
        if (makeAlpha) {
            RealType[] realTypeArray2 = new RealType[4];
            realTypeArray2[0] = c_red;
            realTypeArray2[1] = c_green;
            realTypeArray2[2] = c_blue;
            realTypeArray = realTypeArray2;
            realTypeArray2[3] = c_alpha;
        } else {
            RealType[] realTypeArray3 = new RealType[3];
            realTypeArray3[0] = c_red;
            realTypeArray3[1] = c_green;
            realTypeArray = realTypeArray3;
            realTypeArray3[2] = c_blue;
        }
        RealType[] c_all = realTypeArray;
        RealTupleType radiance = new RealTupleType(c_all);
        RealType[] domain_components = new RealType[]{element, line};
        RealTupleType image_domain = new RealTupleType(domain_components);
        Linear2DSet domain_set = new Linear2DSet((MathType)image_domain, 0.0, (float)((double)width - 1.0), width, (float)((double)height - 1.0), 0.0, height);
        FunctionType image_type = new FunctionType(image_domain, radiance);
        FlatField field = new FlatField(image_type, domain_set);
        if (makeAlpha) {
            float[][] fArrayArray2 = new float[4][];
            fArrayArray2[0] = red_pix;
            fArrayArray2[1] = green_pix;
            fArrayArray2[2] = blue_pix;
            fArrayArray = fArrayArray2;
            fArrayArray2[3] = alpha_pix;
        } else {
            float[][] fArrayArray3 = new float[3][];
            fArrayArray3[0] = red_pix;
            fArrayArray3[1] = green_pix;
            fArrayArray = fArrayArray3;
            fArrayArray3[2] = blue_pix;
        }
        float[][] samples = fArrayArray;
        try {
            field.setSamples(samples, false);
        }
        catch (RemoteException e) {
            throw new VisADException("Couldn't finish image initialization");
        }
        return field;
    }

    public static MapProjection makeMapProjection(double lat1, double lon1, double lat2, double lon2) throws VisADException {
        return Util.makeMapProjection(lat1, lon1, lat2, lon2, true);
    }

    public static MapProjection makeMapProjection(double lat1, double lon1, double lat2, double lon2, boolean makeSquare) throws VisADException {
        int lonMax = 180;
        int lonMin = -180;
        if (lon1 > 180.0 || lon2 > 180.0) {
            lonMin = 0;
            lonMax = 360;
        }
        double minX = Math.max((double)lonMin, Math.min(lon1, lon2));
        double maxX = Math.min((double)lonMax, Math.max(lon1, lon2));
        double minY = Math.max(-90.0, Math.min(lat1, lat2));
        double maxY = Math.min(90.0, Math.max(lat1, lat2));
        double degX = maxX - minX;
        double degY = maxY - minY;
        if (makeSquare) {
            double delta;
            if (degY > degX) {
                delta = degY - degX;
                minX -= delta / 2.0;
                maxX += delta / 2.0;
            } else if (degX > degY) {
                delta = degX - degY;
                minY -= delta / 2.0;
                maxY += delta / 2.0;
            }
        }
        minX = Math.max((double)lonMin, minX);
        maxX = Math.min((double)lonMax, maxX);
        minY = Math.max(-90.0, minY);
        maxY = Math.min(90.0, maxY);
        double maxDegrees = Math.max(maxX - minX, maxY - minY);
        Rectangle2D.Float rect = new Rectangle2D.Float((float)minX, (float)minY, (float)(maxX - minX), (float)(maxY - minY));
        return new TrivialMapProjection(RealTupleType.SpatialEarth2DTuple, rect);
    }

    public static boolean propertySet(Object object, String name, Object value, boolean ignoreError) throws Exception {
        if (Misc.setProperty(object, name, value, true)) {
            return true;
        }
        String methodName = "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
        Method method = Misc.findMethod(object.getClass(), methodName, new Class[]{null});
        if (method == null) {
            if (!ignoreError) {
                System.err.println("could not find method:" + methodName + ": on class:" + object.getClass().getName());
            }
            return false;
        }
        Object argument = null;
        Class<?> paramType = method.getParameterTypes()[0];
        if (paramType.equals(Real.class)) {
            argument = Util.toReal(value.toString());
        } else if (paramType.equals(Unit.class)) {
            argument = Util.parseUnit(value.toString());
        } else if (paramType.equals(ColorScaleInfo.class)) {
            argument = new ColorScaleInfo(value.toString(), true);
        } else if (paramType.equals(EarthLocation.class)) {
            List<String> toks = StringUtil.split(value.toString(), ",", true, true);
            if (toks.size() != 2) {
                throw new IllegalArgumentException("Bad EarthLocation value:" + value);
            }
            double lat = Double.parseDouble(toks.get(0));
            double lon = Double.parseDouble(toks.get(1));
            EarthLocation earthLocation = Util.makeEarthLocation(lat, lon);
            argument = earthLocation;
        } else if (paramType.equals(RealTuple.class) && (name.endsWith("StartPoint") || name.endsWith("EndPoint"))) {
            List<String> toks = StringUtil.split(value.toString(), ",", true, true);
            if (toks.size() == 2) {
                double lat = Double.parseDouble(toks.get(0));
                double lon = Double.parseDouble(toks.get(1));
                argument = new RealTuple(RealTupleType.SpatialEarth3DTuple, new double[]{lon, lat, 0.0});
            } else if (toks.size() == 1) {
                double laz = Double.parseDouble(toks.get(0));
                Real lar = new Real(laz);
                argument = new RealTuple(new Real[]{lar});
            } else {
                throw new IllegalArgumentException("Bad EarthLocation value:" + value);
            }
        }
        if (argument != null) {
            method.invoke(object, argument);
            return true;
        }
        return false;
    }

    public static Data makeTimeField(Data range, List times) throws VisADException, RemoteException {
        if (times == null || times.size() == 0) {
            return range;
        }
        FieldImpl fi = null;
        Set timeSet = Util.makeTimeSet(times);
        for (int i = 0; i < times.size(); ++i) {
            if (fi == null) {
                DateTime dttm;
                Object obj = times.get(i);
                if (obj instanceof DateTime) {
                    dttm = (DateTime)obj;
                } else if (obj instanceof Date) {
                    dttm = new CalendarDateTime((Date)obj);
                } else {
                    throw new IllegalArgumentException("Unknown date type:" + obj);
                }
                fi = new FieldImpl(new FunctionType(dttm.getType(), range.getType()), timeSet);
            }
            fi.setSample(i, range, false, false);
        }
        return fi;
    }

    public static FieldImpl makeTimeField(List ranges, List times) throws VisADException, RemoteException {
        FieldImpl fi = null;
        Hashtable timeToData = new Hashtable();
        for (int i = 0; i < times.size(); ++i) {
            Data range = (Data)ranges.get(i);
            if (range == null) continue;
            timeToData.put(times.get(i), ranges.get(i));
        }
        Set timeSet = Util.makeTimeSet(times);
        int setSize = timeSet.getLength();
        Object obj = times.get(0);
        DateTime dttm = null;
        if (obj instanceof DateTime) {
            dttm = (DateTime)obj;
        } else if (obj instanceof Date) {
            dttm = new CalendarDateTime((Date)obj);
        } else {
            throw new IllegalArgumentException("Unknown date type:" + obj);
        }
        for (int i = 0; i < setSize; ++i) {
            Data time = timeSet.__getitem__(i);
            Data range = (Data)timeToData.get(time);
            if (range == null) continue;
            if (fi == null) {
                fi = new FieldImpl(new FunctionType(dttm.getType(), range.getType()), timeSet);
            }
            fi.setSample(i, range, false, false);
        }
        return fi;
    }

    public static Data makeTimeRangeField(Data range, List times) throws VisADException, RemoteException {
        if (times == null || times.size() == 0) {
            return range;
        }
        times = new ArrayList<DateTime>(times);
        FieldImpl fi = null;
        Real minDate = null;
        DateTime maxDate = null;
        for (int i = 0; i < times.size(); ++i) {
            DateTime dttm = (DateTime)times.get(i);
            if (minDate == null || dttm.getValue() < minDate.getValue()) {
                minDate = dttm;
            }
            if (maxDate != null && !(dttm.getValue() > maxDate.getValue())) continue;
            maxDate = dttm;
        }
        times.add(0, new DateTime(minDate.getValue() - 1.0E-8, minDate.getUnit()));
        times.add(times.size(), new DateTime(maxDate.getValue() + 1.0E-8, maxDate.getUnit()));
        Set timeSet = Util.makeTimeSet(times);
        for (int i = 0; i < times.size(); ++i) {
            if (fi == null) {
                DateTime dttm = (DateTime)times.get(i);
                fi = new FieldImpl(new FunctionType(dttm.getType(), range.getType()), timeSet);
            }
            if (i == 0 || i == times.size() - 1) continue;
            fi.setSample(i, range, false, false);
        }
        return fi;
    }

    public static int findIndex(Set set, Real value) throws VisADException, RemoteException {
        Unit setUnit = set.getSetUnits()[0];
        if (Unit.canConvert(value.getUnit(), setUnit)) {
            double valueVal = value.getValue(setUnit);
            int index = set.doubleToIndex(new double[][]{{valueVal}})[0];
            return index;
        }
        return -1;
    }

    public static List toList(Set set) throws VisADException, RemoteException {
        ArrayList<Data> l = new ArrayList<Data>();
        if (set == null) {
            return l;
        }
        for (int i = 0; i < set.getLength(); ++i) {
            l.add(set.__getitem__(i));
        }
        return l;
    }

    public static Set makeTimeSet(List times) throws VisADException, RemoteException {
        return CalendarDateTime.makeTimeSet(times.toArray(new DateTime[times.size()]));
    }

    public static boolean exportAsNetcdf(Data data) throws Exception {
        String filename = FileManager.getWriteFile(FileManager.FILTER_NETCDF, ".nc");
        if (filename == null) {
            return false;
        }
        Plain p = new Plain();
        p.save(filename, data, true);
        return true;
    }

    public static FlatField makeField(float lon1, float lon2, int length1, float lat1, float lat2, int length2, float fill, String unitString) throws VisADException, RemoteException {
        Unit unit = Util.parseUnit(unitString);
        FunctionType type = new FunctionType(RealTupleType.SpatialEarth2DTuple, Util.getRealType(unit));
        Linear2DSet domain = new Linear2DSet((MathType)type.getDomain(), lon1, lon2, length1, lat1, lat2, length2);
        FlatField field = new FlatField(type, domain);
        float[][] data = new float[1][length1 * length2];
        for (int i = 0; i < length1; ++i) {
            for (int j = 0; j < length2; ++j) {
                data[0][i + length1 * j] = fill;
            }
        }
        field.setSamples(data, false);
        return field;
    }

    public static GriddedSet makeEarthDomainSet(float[] lats, float[] lons, float[] alts) throws VisADException {
        float[][] values = new float[alts != null ? 3 : 2][];
        values[0] = lats;
        values[1] = lons;
        if (alts != null) {
            values[2] = alts;
            return new Gridded3DSet((MathType)RealTupleType.LatitudeLongitudeAltitude, (float[][])values, values[0].length);
        }
        return new Gridded2DSet((MathType)RealTupleType.LatitudeLongitudeTuple, (float[][])values, values[0].length);
    }

    public static GriddedSet makeEarthDomainSet(float[] lats, float[] lons, float[] alts, Unit[] units) throws VisADException {
        float[][] values = new float[alts != null ? 3 : 2][];
        values[0] = lats;
        values[1] = lons;
        if (alts != null) {
            values[2] = alts;
            return new Gridded3DSet((MathType)RealTupleType.LatitudeLongitudeAltitude, (float[][])values, values[0].length, null, units, null);
        }
        return new Gridded2DSet((MathType)RealTupleType.LatitudeLongitudeTuple, (float[][])values, values[0].length, null, units, null);
    }

    public static LatLonPoint toLLP(EarthLocation el) {
        return Util.toLLP(el.getLatLonPoint());
    }

    public static LatLonPoint toLLP(visad.georef.LatLonPoint llp) {
        return new LatLonPointImpl(llp.getLatitude().getValue(), llp.getLongitude().getValue());
    }

    public static Range convertRange(Range range, Unit rangeUnit, Unit outUnit) {
        if (range != null && !Misc.equals(rangeUnit, outUnit) && rangeUnit != null && outUnit != null) {
            try {
                range = new Range(outUnit.toThis(range.getMin(), rangeUnit), outUnit.toThis(range.getMax(), rangeUnit));
            }
            catch (Exception e) {
                range = null;
            }
        }
        return range;
    }

    public static boolean allMissing(RealTuple rt) {
        if (rt == null || rt.isMissing()) {
            return true;
        }
        try {
            Data[] reals = rt.getComponents(false);
            for (int i = 0; i < reals.length; ++i) {
                if (reals[i].isMissing()) continue;
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static double[] performRotationAboutArbitraryVector(MouseBehavior mouse, double[] initialTransFormMatrix, double angle, double axisIComp, double axisJComp, double axisKComp, double offsetIComp, double offsetJComp, double offsetKComp) {
        double cosPhi;
        double sinPhi;
        double cosAlpha;
        double sinAlpha;
        double[] rotAlpha = new double[16];
        double[] rotPhi = new double[16];
        double[] rotTheta = new double[16];
        double[] rotAlphaRev = new double[16];
        double[] rotPhiRev = new double[16];
        double[] undoOldtransMat = new double[16];
        double[] redoOldtransMat = new double[16];
        double[] tempT1 = new double[16];
        double[] tempT2 = new double[16];
        undoOldtransMat = mouse.make_translate(offsetIComp, offsetJComp, offsetKComp);
        redoOldtransMat = mouse.make_translate(-offsetIComp, -offsetJComp, -offsetKComp);
        rotAlpha[0] = 1.0;
        rotAlpha[5] = 1.0;
        rotAlpha[10] = 1.0;
        rotAlpha[15] = 1.0;
        double a = axisIComp;
        double b = axisJComp;
        double c = axisKComp;
        double dProj = Math.sqrt(b * b + c * c);
        double len = Math.sqrt(a * a + b * b + c * c);
        if (dProj == 0.0) {
            sinAlpha = 0.0;
            cosAlpha = 1.0;
            sinPhi = 1.0;
            cosPhi = 0.0;
        } else {
            sinAlpha = b / dProj;
            cosAlpha = c / dProj;
            sinPhi = a / len;
            cosPhi = dProj / len;
        }
        rotAlpha[5] = cosAlpha;
        rotAlpha[6] = sinAlpha;
        rotAlpha[9] = -sinAlpha;
        rotAlpha[10] = cosAlpha;
        rotAlphaRev[0] = 1.0;
        rotAlphaRev[5] = 1.0;
        rotAlphaRev[10] = 1.0;
        rotAlphaRev[15] = 1.0;
        rotAlphaRev[5] = cosAlpha;
        rotAlphaRev[6] = -sinAlpha;
        rotAlphaRev[9] = sinAlpha;
        rotAlphaRev[10] = cosAlpha;
        rotPhi[0] = 1.0;
        rotPhi[5] = 1.0;
        rotPhi[10] = 1.0;
        rotPhi[15] = 1.0;
        rotPhi[0] = cosPhi;
        rotPhi[2] = sinPhi;
        rotPhi[8] = -sinPhi;
        rotPhi[10] = cosPhi;
        rotPhiRev[0] = 1.0;
        rotPhiRev[5] = 1.0;
        rotPhiRev[10] = 1.0;
        rotPhiRev[15] = 1.0;
        rotPhiRev[0] = cosPhi;
        rotPhiRev[2] = -sinPhi;
        rotPhiRev[8] = sinPhi;
        rotPhiRev[10] = cosPhi;
        tempT1 = initialTransFormMatrix == null ? mouse.make_matrix(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0) : initialTransFormMatrix;
        tempT2 = mouse.make_matrix(0.0, 0.0, angle, 1.0, 0.0, 0.0, 0.0);
        tempT1 = mouse.multiply_matrix(undoOldtransMat, tempT1);
        tempT1 = mouse.multiply_matrix(rotAlpha, tempT1);
        tempT1 = mouse.multiply_matrix(rotPhi, tempT1);
        tempT1 = mouse.multiply_matrix(tempT2, tempT1);
        tempT1 = mouse.multiply_matrix(rotPhiRev, tempT1);
        tempT1 = mouse.multiply_matrix(rotAlphaRev, tempT1);
        tempT1 = mouse.multiply_matrix(redoOldtransMat, tempT1);
        return tempT1;
    }

    public static boolean isEarthCoordinates(RealTuple position) {
        RealTupleType rttype = (RealTupleType)position.getType();
        if (rttype.equals(RealTupleType.SpatialEarth2DTuple)) {
            return true;
        }
        return rttype.equals(RealTupleType.SpatialEarth3DTuple);
    }

    public static void setGlobeRadius(float[] position, float radius) {
        float x = position[0];
        float y = position[1];
        float z = position[2];
        double length = new Point3d(0.0, 0.0, 0.0).distance(new Point3d((double)x, (double)y, (double)z));
        if (length != 0.0) {
            double newx = (double)x * ((double)radius / length);
            double newy = (double)y * ((double)radius / length);
            double newz = (double)z * ((double)radius / length);
            position[0] = (float)newx;
            position[1] = (float)newy;
            position[2] = (float)newz;
        }
    }

    public static void printData(Data d) {
        try {
            JPythonMethods.dumpTypes(d);
        }
        catch (Exception e) {
            System.out.println("Unable to print data " + e.getMessage());
        }
    }

    public static void printDataType(Data d) {
        try {
            JPythonMethods.dumpType(d);
        }
        catch (Exception e) {
            System.out.println("Unable to print data type " + e.getMessage());
        }
    }
}

