/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad;

import java.util.TimeZone;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.util.StringUtil;
import ucar.visad.data.CalendarDateTime;
import visad.CommonUnit;
import visad.DateTime;
import visad.Gridded1DSet;
import visad.RealTupleType;
import visad.SetType;
import visad.VisADException;

public final class UtcDate {
    public static final String MACRO_TIMESTAMP = "%timestamp%";
    public static final String TEMPLATE_TIMEFORMAT = "time:";
    public static final String YMD_FORMAT = "yyyy-MM-dd";
    public static final String HMS_FORMAT = "HH:mm:ss";
    public static final String HH_MM_FORMAT = "HH:mm";
    public static final String HH_FORMAT = "HH";
    public static final String IYD_FORMAT = "yyyyDDD";
    public static final String JDAY_FORMAT = "DDD";
    public static final TimeZone GMT = DateTime.DEFAULT_TIMEZONE;
    public static final String DEFAULT_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public static String getHH(DateTime dt) {
        return UtcDate.getHH(dt, GMT);
    }

    public static String getHH(DateTime dt, TimeZone tz) {
        return UtcDate.formatUtcDate(dt, HH_FORMAT, tz);
    }

    public static boolean containsTimeMacro(String s) {
        return UtcDate.containsTimeMacro(s, "%");
    }

    public static boolean containsTimeMacro(String s, String prefix) {
        return s.indexOf(MACRO_TIMESTAMP) >= 0 || s.indexOf(prefix + TEMPLATE_TIMEFORMAT) >= 0;
    }

    public static String applyTimeMacro(String template, DateTime dttm) {
        return UtcDate.applyTimeMacro(template, dttm, GMT);
    }

    public static String applyTimeMacro(String template, DateTime dttm, TimeZone tz) {
        return UtcDate.applyTimeMacro(template, dttm, "", "%", "%", tz);
    }

    public static String applyTimeMacro(String template, DateTime dttm, String noTimeLabel) {
        return UtcDate.applyTimeMacro(template, dttm, noTimeLabel, "%", "%");
    }

    public static String applyTimeMacro(String template, DateTime dttm, String noTimeLabel, String prefix, String suffix) {
        return UtcDate.applyTimeMacro(template, dttm, noTimeLabel, prefix, suffix, GMT);
    }

    public static String applyTimeMacro(String template, DateTime dttm, String noTimeLabel, String prefix, String suffix, TimeZone tz) {
        int idx2;
        template = dttm != null ? StringUtil.replace(template, MACRO_TIMESTAMP, dttm.toString()) : StringUtil.replace(template, MACRO_TIMESTAMP, noTimeLabel);
        prefix = prefix + TEMPLATE_TIMEFORMAT;
        int prefixLength = prefix.length();
        int suffixLength = suffix.length();
        int idx1 = template.indexOf(prefix);
        if (idx1 >= 0 && (idx2 = template.indexOf(suffix, idx1 + suffixLength)) > idx1) {
            String formatString = template.substring(idx1 + prefixLength, idx2);
            String tmp = dttm == null ? noTimeLabel : UtcDate.formatUtcDate(dttm, formatString, tz);
            template = StringUtil.replace(template, prefix + formatString + suffix, tmp);
        }
        return template;
    }

    public static String getHHMM(DateTime dt) {
        return UtcDate.getHHMM(dt, GMT);
    }

    public static String getHHMM(DateTime dt, TimeZone tz) {
        return UtcDate.formatUtcDate(dt, HH_MM_FORMAT, tz);
    }

    public static String getYMD(DateTime dt) {
        return UtcDate.getYMD(dt, GMT);
    }

    public static String getYMD(DateTime dt, TimeZone tz) {
        return UtcDate.formatUtcDate(dt, YMD_FORMAT, tz);
    }

    public static String getHMS(DateTime dt) {
        return UtcDate.getHMS(dt, GMT);
    }

    public static String getHMS(DateTime dt, TimeZone tz) {
        return UtcDate.formatUtcDate(dt, HMS_FORMAT);
    }

    public static String getUtcDate(DateTime dt) {
        return UtcDate.formatUtcDate(dt, DEFAULT_PATTERN, GMT);
    }

    public static String getIYD(DateTime dt) {
        return UtcDate.getIYD(dt, GMT);
    }

    public static String getIYD(DateTime dt, TimeZone tz) {
        return UtcDate.formatUtcDate(dt, IYD_FORMAT, tz);
    }

    public static String formatUtcDate(DateTime dt, String pattern) {
        return UtcDate.formatUtcDate(dt, pattern, GMT);
    }

    public static String formatUtcDate(DateTime dt, String pattern, TimeZone tz) {
        if (dt == null) {
            return "null";
        }
        try {
            CalendarDateTime cdt;
            CalendarDateTime calendarDateTime = cdt = dt instanceof CalendarDateTime ? (CalendarDateTime)dt : new CalendarDateTime(dt);
            if (pattern == null) {
                return cdt.toString();
            }
            return cdt.formattedString(pattern, tz);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static int[] convertDateTimeToJulianDay(DateTime[] dates) {
        int[] jdays = new int[dates.length];
        for (int i = 0; i < dates.length; ++i) {
            jdays[i] = Integer.parseInt(UtcDate.formatUtcDate(dates[i], JDAY_FORMAT, GMT));
        }
        return jdays;
    }

    public static int[] convertDateTimeToJulianDay(Gridded1DSet timeSet) throws VisADException {
        if (!((SetType)timeSet.getType()).getDomain().equals(RealTupleType.Time1DTuple)) {
            throw new VisADException("Set must have type of RealType.Time");
        }
        DateTime[] dates = CalendarDateTime.timeSetToArray(timeSet);
        return UtcDate.convertDateTimeToJulianDay(dates);
    }

    public static DateTime createDateTime(String dateString) throws VisADException {
        return UtcDate.createDateTime(dateString, DEFAULT_PATTERN, DateTime.DEFAULT_TIMEZONE);
    }

    public static DateTime createDateTime(String dateString, String pattern) throws VisADException {
        return UtcDate.createDateTime(dateString, pattern, DateTime.DEFAULT_TIMEZONE);
    }

    public static DateTime createDateTime(String dateString, String pattern, TimeZone tz) throws VisADException {
        return UtcDate.createDateTime(dateString, pattern, tz, null);
    }

    public static DateTime createDateTime(String dateString, String pattern, TimeZone tz, Calendar cal) throws VisADException {
        DateTime dt = DateTime.createDateTime(dateString, pattern, tz);
        CalendarDate cd = CalendarDate.of(cal, (long)(dt.getValue(CommonUnit.secondsSinceTheEpoch) * 1000.0));
        return new CalendarDateTime(cd);
    }
}

