/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad;

import java.awt.geom.Rectangle2D;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ucar.unidata.gis.shapefile.DbaseFile;
import ucar.unidata.gis.shapefile.EsriShapefile;
import ucar.unidata.idv.control.drawing.ShapeGlyph;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlUtil;
import ucar.visad.data.MapSet;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;
import visad.python.JPythonMethods;

public class ShapefileAdapter {
    public static final String TAG_POLYGON = "polygon";
    public static final String ATTR_POINTS = "points";
    private DbaseFile dbFile;
    protected EsriShapefile shapefile;
    protected UnionSet mapLines;

    public ShapefileAdapter(String filename) throws IOException, VisADException {
        this(filename, null, 0.0);
    }

    public ShapefileAdapter(URL url) throws IOException, VisADException {
        this(url.toString(), null, 0.0);
    }

    public ShapefileAdapter(URL url, Rectangle2D bBox) throws IOException, VisADException {
        this(url.toString(), bBox, 0.0);
    }

    public ShapefileAdapter(String filename, Rectangle2D bBox) throws IOException, VisADException {
        this(filename, bBox, 0.0);
    }

    public ShapefileAdapter(String filename, double coarseness) throws IOException, VisADException {
        this(filename, null, coarseness);
    }

    public ShapefileAdapter(URL url, double coarseness) throws IOException, VisADException {
        this(url, null, coarseness);
    }

    public ShapefileAdapter(URL url, Rectangle2D bBox, double coarseness) throws IOException, VisADException {
        this(url.toString(), bBox, coarseness);
    }

    public ShapefileAdapter(String filename, Rectangle2D bBox, double coarseness) throws IOException, VisADException {
        this.readSource(filename, null, bBox, coarseness);
    }

    public ShapefileAdapter(InputStream iStream) throws IOException, VisADException {
        this(iStream, null, 0.0);
    }

    public ShapefileAdapter(InputStream iStream, Rectangle2D bBox) throws IOException, VisADException {
        this(iStream, bBox, 0.0);
    }

    public ShapefileAdapter(InputStream iStream, String filename) throws IOException, VisADException {
        this.readSource(filename, iStream, null, 0.0);
    }

    public ShapefileAdapter(InputStream iStream, String filename, Rectangle2D dBox, double coarseness) throws IOException, VisADException {
        this.readSource(filename, iStream, dBox, coarseness);
    }

    public ShapefileAdapter(InputStream iStream, Rectangle2D bBox, double coarseness) throws IOException, VisADException {
        this(new EsriShapefile(iStream, bBox, coarseness));
    }

    public ShapefileAdapter(EsriShapefile shapefile) throws VisADException {
        this.mapLines = ShapefileAdapter.makeSet(this.doRead(shapefile, null));
    }

    private void readSource(String name, InputStream iStream, Rectangle2D bBox, double coarseness) throws IOException, VisADException {
        try {
            List sets = null;
            String lcName = name.toLowerCase();
            if (lcName.endsWith(".gsf") || lcName.endsWith(".nws") || lcName.endsWith(".cia") || lcName.endsWith(".usg") || lcName.endsWith(".ncp") || lcName.endsWith(".rfc") || lcName.endsWith(".cpc")) {
                sets = this.doReadSSF(name, iStream);
            } else if (name.endsWith(".xml")) {
                sets = this.doReadXml(name, iStream);
            } else if (name.endsWith(".xgrf")) {
                sets = this.doReadXml(name, iStream);
            } else {
                try {
                    if (iStream == null) {
                        iStream = new DataInputStream(new URL(name).openStream());
                    }
                }
                catch (MalformedURLException exc) {
                    iStream = new FileInputStream(name);
                }
                sets = this.doRead(new EsriShapefile(iStream, null, coarseness), bBox);
            }
            this.mapLines = ShapefileAdapter.makeSet(sets);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public static UnionSet makeSet(List sets) throws VisADException {
        if (sets == null) {
            return null;
        }
        SampledSet[] ss = new SampledSet[sets.size()];
        System.arraycopy(sets.toArray(), 0, ss, 0, sets.size());
        if (ss.length > 0) {
            return new UnionSet(ss[0].getType(), ss, null, null, null, false);
        }
        return null;
    }

    private List doReadXml(String name, InputStream iStream) {
        ArrayList<MapSet> sets = new ArrayList<MapSet>();
        try {
            String xml;
            Element root;
            if (iStream == null) {
                iStream = IOUtil.getInputStream(name);
            }
            if ((root = XmlUtil.getRoot(xml = IOUtil.readContents(iStream))) == null) {
                return sets;
            }
            NodeList elements = XmlUtil.getElements(root);
            for (int i = 0; i < elements.getLength(); ++i) {
                Element child = (Element)elements.item(i);
                if (!XmlUtil.hasAttribute(child, ATTR_POINTS)) continue;
                double[] points = Misc.parseDoubles(XmlUtil.getAttribute(child, ATTR_POINTS));
                boolean isRect = false;
                if (!child.getTagName().equals(TAG_POLYGON)) {
                    if (!child.getTagName().equals("shape") || !XmlUtil.getAttribute(child, "shapetype").toLowerCase().equals("rectangle")) continue;
                    isRect = true;
                }
                if (XmlUtil.hasAttribute(child, "coordtype")) {
                    String coord = XmlUtil.getAttribute(child, "coordtype");
                    if (!coord.startsWith("LATLON")) continue;
                    if (coord.equals("LATLONALT")) {
                        double[] tmp = new double[2 * points.length / 3];
                        int tmpCnt = 0;
                        for (int ptIdx = 0; ptIdx < points.length; ptIdx += 3) {
                            tmp[tmpCnt++] = points[ptIdx];
                            tmp[tmpCnt++] = points[ptIdx + 1];
                        }
                        points = tmp;
                    }
                }
                RealTupleType coordMathType = new RealTupleType(RealType.Longitude, RealType.Latitude);
                float[][] part = new float[2][points.length / 2];
                for (int ptIdx = 0; ptIdx < points.length / 2; ++ptIdx) {
                    part[1][ptIdx] = (float)points[ptIdx * 2];
                    part[0][ptIdx] = (float)points[ptIdx * 2 + 1];
                }
                if (isRect) {
                    part = ShapeGlyph.makeRectangle(part);
                }
                MapSet mapSet = new MapSet(coordMathType, part, part[0].length, (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null, false);
                sets.add(mapSet);
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return sets;
    }

    private List doReadGmap(String name, InputStream iStream) {
        ArrayList<MapSet> sets = new ArrayList<MapSet>();
        try {
            if (iStream == null) {
                iStream = IOUtil.getInputStream(name);
            }
            DataInputStream dis = new DataInputStream(iStream);
            int numBlks = dis.readShort();
            System.err.println("numBlks:" + numBlks);
            dis.skipBytes(252);
            for (int blockIdx = 0; blockIdx < numBlks; ++blockIdx) {
                int numSegments = dis.readShort();
                System.err.println("segs=" + numSegments);
                dis.skipBytes(4);
                for (int segIdx = 0; segIdx < numSegments; ++segIdx) {
                    int nPts = dis.readShort();
                    System.err.println("  pts=" + nPts);
                    dis.skipBytes(20);
                    for (int ptIdx = 0; ptIdx < nPts; ++ptIdx) {
                        float lat = Float.intBitsToFloat(dis.readShort());
                        float f = Float.intBitsToFloat(dis.readShort());
                    }
                }
            }
            double[] points = new double[]{-107.0, 40.0};
            RealTupleType coordMathType = new RealTupleType(RealType.Longitude, RealType.Latitude);
            float[][] part = new float[2][points.length / 2];
            for (int ptIdx = 0; ptIdx < points.length / 2; ++ptIdx) {
                part[1][ptIdx] = (float)points[ptIdx * 2];
                part[0][ptIdx] = (float)points[ptIdx * 2 + 1];
            }
            sets.add(new MapSet(coordMathType, part, points.length / 2, (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null, false));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return sets;
    }

    private List doReadSSF(String name, InputStream iStream) {
        ArrayList<MapSet> sets = new ArrayList<MapSet>();
        try {
            if (iStream == null) {
                iStream = IOUtil.getInputStream(name);
            }
            List<String> toks = StringUtil.split(IOUtil.readContents(iStream), " ", true, true);
            int xcnt = 0;
            int cnt = 0;
            while (cnt < toks.size()) {
                int size = Integer.parseInt(toks.get(cnt));
                cnt += 5;
                double[] points = new double[size];
                for (int i = 0; i < size; ++i) {
                    points[i] = Double.parseDouble(toks.get(cnt));
                    ++cnt;
                }
                RealTupleType coordMathType = new RealTupleType(RealType.Longitude, RealType.Latitude);
                float[][] part = new float[2][points.length / 2];
                for (int ptIdx = 0; ptIdx < points.length / 2; ++ptIdx) {
                    part[1][ptIdx] = (float)points[ptIdx * 2];
                    part[0][ptIdx] = (float)points[ptIdx * 2 + 1];
                }
                ++xcnt;
                sets.add(new MapSet(coordMathType, part, points.length / 2, (CoordinateSystem)null, (Unit[])null, (ErrorEstimate[])null, false));
            }
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return sets;
    }

    private List doRead(EsriShapefile shapefile, Rectangle2D bbox) {
        this.shapefile = shapefile;
        List features = shapefile.getFeatures();
        Iterator si = features.iterator();
        this.dbFile = shapefile.getDbFile();
        ArrayList<SampledSet> s0 = new ArrayList<SampledSet>();
        int pointCnt = 0;
        int i = 0;
        while (si.hasNext()) {
            EsriShapefile.EsriFeature gf = (EsriShapefile.EsriFeature)si.next();
            SampledSet mapLines = gf.getMapLines(bbox);
            pointCnt += gf.getPointCount();
            if (mapLines != null) {
                s0.add(mapLines);
            }
            ++i;
        }
        return s0;
    }

    public int getFeatureType() {
        if (this.shapefile != null) {
            return this.shapefile.getFeatureType();
        }
        return 5;
    }

    public DbaseFile getDbFile() {
        return this.dbFile;
    }

    public UnionSet getData() {
        return this.mapLines;
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("need to supply a filename");
            System.exit(1);
        }
        ShapefileAdapter sfa = new ShapefileAdapter(args[0]);
        UnionSet data = sfa.getData();
        JPythonMethods.dumpTypes(data);
    }
}

