/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import ucar.unidata.util.TwoFacedObject;
import ucar.visad.WxSymbolGroup;
import visad.PlotText;
import visad.ShadowType;
import visad.VisADGeometryArray;
import visad.VisADLineArray;
import visad.VisADQuadArray;
import visad.VisADTriangleArray;
import visad.meteorology.WeatherSymbols;

public class ShapeUtility {
    public static final double[] TEXT_START = new double[]{0.0, 0.0, 0.0};
    public static final double[] TEXT_BASE = new double[]{1.0, 0.0, 0.0};
    public static final double[] TEXT_UP = new double[]{0.0, 1.0, 0.0};
    public static final String PLUS = "PLUS";
    public static final String MINUS = "MINUS";
    public static final String DOWNLINE = "DOWNLINE";
    public static final String RIGHTARROW = "RIGHTARROW";
    public static final String LEFTARROW = "LEFTARROW";
    public static final String UPARROW = "UPARROW";
    public static final String DOWNARROW = "DOWNARROW";
    public static final String HORLINE = "HORLINE";
    public static final String VERTLINE = "VERTLINE";
    public static final String CROSS = "CROSS";
    public static final String SQUARE = "SQUARE";
    public static final String NONE = "NONE";
    public static final String FILLED_SQUARE = "FILLED_SQUARE";
    public static final String CUBE = "CUBE";
    public static final String PYRAMID_4FACE = "PYRAMID_4FACE";
    public static final String PYRAMID_5FACE = "PYRAMID_5FACE";
    public static final String TRIANGLE = "TRIANGLE";
    public static final String FILLED_TRIANGLE = "FILLED_TRIANGLE";
    public static final String FILLED_SPHERE = "FILLED_SPHERE";
    public static final String AIRPLANE = "AIRPLANE";
    public static final String AIRPLANE3D = "AIRPLANE3D";
    public static final String PIN = "PIN";
    public static final String HURRICANE = "HURRICANE";
    public static final String TROPICALSTORM = "TROPICALSTORM";
    public static final int MISC_ID_SQUARE = 0;
    public static final int MISC_ID_FILLED_SQUARE = 1;
    public static final int MISC_ID_CIRCLE = 2;
    public static final int MISC_ID_FILLED_CIRCLE = 3;
    public static final int MISC_ID_TRIANGLE = 4;
    public static final int MISC_ID_FILLED_TRIANGLE = 5;
    public static final int MISC_ID_DIAMOND = 6;
    public static final int MISC_ID_FILLED_DIAMOND = 7;
    public static final int MISC_ID_STAR = 8;
    public static final int MISC_ID_FILLED_STAR = 9;
    public static final int MISC_ID_PLUS = 14;
    public static final int MISC_ID_PIN = 15;
    public static final int MISC_ID_MINUS = 15;
    public static final int MISC_ID_TROPICALSTORM = 16;
    public static final int MISC_ID_HURRICANE = 17;
    public static final String CIRCLE = "CIRCLE";
    public static final String FILLED_CIRCLE = "FILLED_CIRCLE";
    public static final String DIAMOND = "DIAMOND";
    public static final String FILLED_DIAMOND = "FILLED_DIAMOND";
    public static final String STAR = "STAR";
    public static final String FILLED_STAR = "FILLED_STAR";
    public static final String[] MISC_NAMES = new String[]{"CIRCLE", "FILLED_CIRCLE", "DIAMOND", "FILLED_DIAMOND", "STAR", "FILLED_STAR", "TROPICALSTORM", "HURRICANE"};
    public static final int[] MISC_IDS = new int[]{2, 3, 6, 7, 8, 9, 16, 17};
    public static final TwoFacedObject[] SHAPES = new TwoFacedObject[]{new TwoFacedObject((Object)"Pin", "PIN"), new TwoFacedObject((Object)"Plus", "PLUS"), new TwoFacedObject((Object)"Minus", "MINUS"), new TwoFacedObject((Object)"Cross", "CROSS"), new TwoFacedObject((Object)"Square", "SQUARE"), new TwoFacedObject((Object)"Filled Square", "FILLED_SQUARE"), new TwoFacedObject((Object)"Triangle", "TRIANGLE"), new TwoFacedObject((Object)"Filled Triangle", "FILLED_TRIANGLE"), new TwoFacedObject((Object)"Circle", "CIRCLE"), new TwoFacedObject((Object)"Filled Circle", "FILLED_CIRCLE"), new TwoFacedObject((Object)"Diamond", "DIAMOND"), new TwoFacedObject((Object)"Filled Diamond", "FILLED_DIAMOND"), new TwoFacedObject((Object)"Star", "STAR"), new TwoFacedObject((Object)"Filled Star", "FILLED_STAR"), new TwoFacedObject((Object)"Hor. Line", "HORLINE"), new TwoFacedObject((Object)"Vert. Line", "VERTLINE"), new TwoFacedObject((Object)"Left Arrow", "LEFTARROW"), new TwoFacedObject((Object)"Right Arrow", "RIGHTARROW"), new TwoFacedObject((Object)"Up Arrow", "UPARROW"), new TwoFacedObject((Object)"Down Arrow", "DOWNARROW"), new TwoFacedObject((Object)"Cube", "CUBE"), new TwoFacedObject((Object)"Down Line", "DOWNLINE"), new TwoFacedObject((Object)"4 Face Pyramid", "PYRAMID_4FACE"), new TwoFacedObject((Object)"5 Face Pyramid", "PYRAMID_5FACE"), new TwoFacedObject((Object)"Sphere", "FILLED_SPHERE"), new TwoFacedObject((Object)"2-D Airplane", "AIRPLANE"), new TwoFacedObject((Object)"3-D Airplane", "AIRPLANE3D"), new TwoFacedObject((Object)"Hurricane", "HURRICANE"), new TwoFacedObject((Object)"Tropical Storm", "TROPICALSTORM"), new TwoFacedObject((Object)"None", "NONE")};
    public static final float L_X = -1.0f;
    public static final float ML_X = -0.5f;
    public static final float C_X = 0.0f;
    public static final float MR_X = 0.5f;
    public static final float R_X = 1.0f;
    public static final float T_Y = -1.0f;
    public static final float MT_Y = -0.5f;
    public static final float C_Y = 0.0f;
    public static final float MB_Y = 0.5f;
    public static final float B_Y = 1.0f;
    public static final float D_Z = -1.0f;
    public static final float C_Z = 0.0f;
    public static final float U_Z = 1.0f;
    private static Matrix3f rotateZMatrix = new Matrix3f();
    private static Matrix3f rotateXMatrix = new Matrix3f();
    private static Matrix3f rotateYMatrix = new Matrix3f();
    private static float[] rotateArray = new float[3];
    private static Vector3f rotateVector = new Vector3f();

    public static VisADGeometryArray makeShape(String s) {
        VisADGeometryArray[] result = ShapeUtility.createShape(s);
        if (s == null) {
            return null;
        }
        return result[0];
    }

    public static VisADGeometryArray[] createShape(String s) {
        int symbolIndex = WxSymbolGroup.getIndex(s);
        if (symbolIndex >= 0) {
            return ShapeUtility.setSize(new VisADGeometryArray[]{WeatherSymbols.getSymbol(symbolIndex)}, 6.0f);
        }
        float scale = 1.0f;
        VisADGeometryArray shape = null;
        VisADGeometryArray[] shapes = null;
        if (s.equals(NONE)) {
            shape = new VisADLineArray();
            shape.coordinates = new float[0];
        } else if (s.equals(PIN)) {
            VisADGeometryArray circle = WeatherSymbols.getMiscSymbol(3);
            circle = ShapeUtility.offset(circle, 1.0f, 1.0f, 0.0f);
            VisADLineArray dart = new VisADLineArray();
            dart.coordinates = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f};
            shapes = new VisADGeometryArray[]{circle, dart};
        } else if (s.equals(PLUS)) {
            shape = new VisADLineArray();
            shape.coordinates = new float[]{-1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        } else if (s.equals(MINUS)) {
            shape = new VisADLineArray();
            shape.coordinates = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        } else if (s.equals(VERTLINE)) {
            shape = new VisADLineArray();
            shape.coordinates = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        } else if (s.equals(HORLINE)) {
            shape = new VisADLineArray();
            shape.coordinates = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        } else if (s.equals(LEFTARROW)) {
            scale = 1.2f;
            shape = new VisADLineArray();
            shape.coordinates = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f, -0.25f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f, 0.25f, 0.0f};
        } else if (s.equals(RIGHTARROW)) {
            scale = 1.2f;
            shape = new VisADLineArray();
            shape.coordinates = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -0.25f, -0.25f, 0.0f, 0.0f, 0.0f, 0.0f, -0.25f, 0.25f, 0.0f};
        } else if (s.equals(DOWNARROW)) {
            scale = 1.2f;
            shape = new VisADLineArray();
            shape.coordinates = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -0.25f, 0.25f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f, 0.25f, 0.0f};
        } else if (s.equals(UPARROW)) {
            scale = 1.2f;
            shape = new VisADLineArray();
            shape.coordinates = new float[]{0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -0.25f, -0.25f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f, -0.25f, 0.0f};
        } else if (s.equals(CROSS)) {
            shape = new VisADLineArray();
            shape.coordinates = new float[]{1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f};
        } else if (s.equals(DOWNLINE)) {
            shape = new VisADLineArray();
            shape.coordinates = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -20.0f};
        } else if (s.equals(SQUARE)) {
            shape = new VisADLineArray();
            shape.coordinates = new float[]{1.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, -1.0f, -1.0f, 0.0f, -1.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f};
        } else if (s.equals(TRIANGLE)) {
            shape = new VisADLineArray();
            shape.coordinates = new float[]{-1.0f, -0.5f, 0.0f, 1.0f, -0.5f, 0.0f, -1.0f, -0.5f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, -0.5f, 0.0f, 0.0f, 1.0f, 0.0f};
        } else if (s.equals(FILLED_TRIANGLE)) {
            shape = new VisADTriangleArray();
            shape.coordinates = new float[]{-1.0f, -0.5f, 0.0f, 1.0f, -0.5f, 0.0f, 0.0f, 1.0f, 0.0f};
        } else if (s.equals(FILLED_SQUARE)) {
            shape = new VisADQuadArray();
            shape.coordinates = new float[]{1.0f, 1.0f, 0.0f, 1.0f, -1.0f, 0.0f, -1.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f};
            shape.normals = new float[12];
            for (int i = 0; i < 12; i += 3) {
                shape.normals[i] = 0.0f;
                shape.normals[i + 1] = 0.0f;
                shape.normals[i + 2] = 1.0f;
            }
        } else if (s.equals(PYRAMID_4FACE)) {
            shape = new VisADQuadArray();
            shape.coordinates = new float[]{0.0f, 0.0f, 1.0f, -1.0f, 1.0f, -0.5f, -1.0f, 1.0f, -0.5f, 1.0f, 0.0f, -0.5f, 1.0f, 0.0f, -0.5f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, -0.5f, 1.0f, 0.0f, -0.5f, -1.0f, -1.0f, -0.5f, -1.0f, -1.0f, -0.5f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, -1.0f, 1.0f, -0.5f, -1.0f, 1.0f, -0.5f, -1.0f, -1.0f, -0.5f, -1.0f, -1.0f, -0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, -0.5f, -1.0f, 1.0f, -0.5f, -1.0f, 1.0f, -0.5f, -1.0f, -1.0f, -0.5f, -1.0f, -1.0f, -0.5f, 1.0f, 0.0f, -0.5f};
            shape.normals = new float[72];
            for (int i = 0; i < 12; i += 3) {
                shape.normals[i] = 0.33f;
                shape.normals[i + 1] = 0.66f;
                shape.normals[i + 2] = 0.66f;
                shape.normals[i + 12] = 0.33f;
                shape.normals[i + 13] = -0.66f;
                shape.normals[i + 14] = 0.66f;
                shape.normals[i + 24] = -1.0f;
                shape.normals[i + 25] = 0.0f;
                shape.normals[i + 26] = 0.666f;
                shape.normals[i + 36] = 0.0f;
                shape.normals[i + 37] = 0.0f;
                shape.normals[i + 38] = -1.0f;
            }
        } else if (s.equals(PYRAMID_5FACE)) {
            shape = new VisADQuadArray();
            shape.coordinates = new float[]{0.0f, 0.0f, 1.41f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.41f, 0.0f, 0.0f, 1.41f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.41f, 0.0f, 0.0f, 1.41f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.41f, 0.0f, 0.0f, 1.41f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.41f, 1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f, 0.0f};
            shape.normals = new float[96];
            for (int i = 0; i < 18; i += 3) {
                shape.normals[i] = 0.5f;
                shape.normals[i + 1] = 0.5f;
                shape.normals[i + 2] = 0.33f;
                shape.normals[i + 18] = 0.5f;
                shape.normals[i + 19] = -0.5f;
                shape.normals[i + 20] = 0.33f;
                shape.normals[i + 36] = -0.5f;
                shape.normals[i + 37] = -0.5f;
                shape.normals[i + 38] = 0.33f;
                shape.normals[i + 54] = -0.5f;
                shape.normals[i + 55] = 0.5f;
                shape.normals[i + 56] = 0.33f;
                shape.normals[i + 72] = 0.0f;
                shape.normals[i + 73] = 0.0f;
                shape.normals[i + 74] = -1.0f;
            }
            shape.normals[90] = 0.0f;
            shape.normals[91] = 0.0f;
            shape.normals[92] = -1.0f;
            shape.normals[93] = 0.0f;
            shape.normals[94] = 0.0f;
            shape.normals[95] = -1.0f;
        } else if (!s.equals(PIN)) {
            if (s.equals(CUBE)) {
                shape = new VisADQuadArray();
                shape.coordinates = new float[]{1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f};
                shape.normals = new float[144];
                for (int i = 0; i < 24; i += 3) {
                    shape.normals[i] = 0.0f;
                    shape.normals[i + 1] = 0.0f;
                    shape.normals[i + 2] = -1.0f;
                    shape.normals[i + 24] = 0.0f;
                    shape.normals[i + 25] = 0.0f;
                    shape.normals[i + 26] = 1.0f;
                    shape.normals[i + 48] = 1.0f;
                    shape.normals[i + 49] = 0.0f;
                    shape.normals[i + 50] = 0.0f;
                    shape.normals[i + 72] = -1.0f;
                    shape.normals[i + 73] = 0.0f;
                    shape.normals[i + 74] = 0.0f;
                    shape.normals[i + 96] = 0.0f;
                    shape.normals[i + 97] = 1.0f;
                    shape.normals[i + 98] = 0.0f;
                    shape.normals[i + 120] = 0.0f;
                    shape.normals[i + 121] = -1.0f;
                    shape.normals[i + 122] = 0.0f;
                }
            } else if (s.equals(FILLED_SPHERE)) {
                shape = new VisADTriangleArray();
                shape.coordinates = new float[]{1.0f, 0.0f, 0.0f, 0.707107f, 0.0f, 0.707107f, 0.707107f, 0.707107f, 0.0f, 0.707107f, 0.0f, 0.707107f, 0.0f, 0.0f, 1.0f, 0.0f, 0.707107f, 0.707107f, 0.707107f, 0.707107f, 0.0f, 0.707107f, 0.0f, 0.707107f, 0.0f, 0.707107f, 0.707107f, 0.707107f, 0.707107f, 0.0f, 0.0f, 0.707107f, 0.707107f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.707107f, 0.707107f, -0.707107f, 0.707107f, 0.0f, 0.0f, 0.707107f, 0.707107f, 0.0f, 0.0f, 1.0f, -0.707107f, 0.0f, 0.707107f, -0.707107f, 0.707107f, 0.0f, 0.0f, 0.707107f, 0.707107f, -0.707107f, 0.0f, 0.707107f, -0.707107f, 0.707107f, 0.0f, -0.707107f, 0.0f, 0.707107f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -0.707107f, 0.0f, 0.707107f, -0.707107f, -0.707107f, 0.0f, -0.707107f, 0.0f, 0.707107f, 0.0f, 0.0f, 1.0f, 0.0f, -0.707107f, 0.707107f, -0.707107f, -0.707107f, 0.0f, -0.707107f, 0.0f, 0.707107f, 0.0f, -0.707107f, 0.707107f, -0.707107f, -0.707107f, 0.0f, 0.0f, -0.707107f, 0.707107f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -0.707107f, 0.707107f, 0.707107f, -0.707107f, 0.0f, 0.0f, -0.707107f, 0.707107f, 0.0f, 0.0f, 1.0f, 0.707107f, 0.0f, 0.707107f, 0.707107f, -0.707107f, 0.0f, 0.0f, -0.707107f, 0.707107f, 0.707107f, 0.0f, 0.707107f, 0.707107f, -0.707107f, 0.0f, 0.707107f, 0.0f, 0.707107f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.707107f, 0.707107f, 0.0f, 0.707107f, 0.0f, -0.707107f, 0.707107f, 0.707107f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.707107f, -0.707107f, 0.707107f, 0.0f, -0.707107f, 0.707107f, 0.707107f, 0.0f, 0.0f, 0.707107f, -0.707107f, 0.707107f, 0.0f, -0.707107f, 0.0f, 0.707107f, -0.707107f, 0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f, -0.707107f, 0.707107f, 0.0f, 0.0f, 0.707107f, -0.707107f, -0.707107f, 0.707107f, 0.0f, -1.0f, 0.0f, 0.0f, -0.707107f, 0.0f, -0.707107f, 0.0f, 0.707107f, -0.707107f, -0.707107f, 0.707107f, 0.0f, -0.707107f, 0.0f, -0.707107f, 0.0f, 0.707107f, -0.707107f, -0.707107f, 0.0f, -0.707107f, 0.0f, 0.0f, -1.0f, -1.0f, 0.0f, 0.0f, -0.707107f, -0.707107f, 0.0f, -0.707107f, 0.0f, -0.707107f, -0.707107f, -0.707107f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -0.707107f, -0.707107f, -0.707107f, 0.0f, -0.707107f, -0.707107f, -0.707107f, 0.0f, 0.0f, -0.707107f, -0.707107f, -0.707107f, 0.0f, -0.707107f, 0.0f, -0.707107f, -0.707107f, 0.0f, 0.0f, -1.0f, 0.0f, -1.0f, 0.0f, 0.707107f, -0.707107f, 0.0f, 0.0f, -0.707107f, -0.707107f, 0.707107f, -0.707107f, 0.0f, 1.0f, 0.0f, 0.0f, 0.707107f, 0.0f, -0.707107f, 0.0f, -0.707107f, -0.707107f, 0.707107f, -0.707107f, 0.0f, 0.707107f, 0.0f, -0.707107f, 0.0f, -0.707107f, -0.707107f, 0.707107f, 0.0f, -0.707107f, 0.0f, 0.0f, -1.0f};
            } else if (s.equals(AIRPLANE)) {
                scale = 1.2f;
                shape = new VisADTriangleArray();
                shape.coordinates = new float[]{0.0f, -1.0f, 0.0f, 0.1f, 0.8f, 0.0f, -0.1f, 0.8f, 0.0f, 0.0f, -0.9f, 0.0f, 0.1f, 0.8f, 0.0f, -0.1f, 0.8f, 0.0f, -0.025f, -0.9f, 0.0f, 0.025f, -0.9f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.35f, 0.0f, 0.0f, 0.05f, 0.0f, 0.8f, 0.0f, 0.0f, 0.0f, 0.35f, 0.0f, 0.0f, 0.05f, 0.0f, -0.8f, 0.0f, 0.0f, 0.0f, -0.75f, 0.0f, 0.0f, -0.85f, 0.0f, 0.25f, -0.85f, 0.0f, 0.0f, -0.75f, 0.0f, 0.0f, -0.85f, 0.0f, -0.25f, -0.85f, 0.0f};
            } else if (s.equals(AIRPLANE3D)) {
                scale = 1.2f;
                shape = new VisADQuadArray();
                shape.coordinates = new float[]{0.0f, 0.6f, 0.2f, 0.1f, 0.6f, 0.0f, 0.1f, -0.6f, 0.0f, 0.0f, -0.6f, 0.2f, 0.1f, 0.6f, 0.0f, 0.0f, 0.6f, -0.2f, 0.0f, -0.6f, -0.2f, -0.1f, -0.6f, 0.0f, 0.0f, 0.6f, -0.2f, -0.1f, 0.6f, 0.0f, -0.1f, -0.6f, 0.0f, 0.0f, -0.6f, -0.2f, -0.1f, 0.6f, 0.0f, 0.0f, 0.6f, 0.2f, 0.0f, -0.6f, 0.2f, -0.1f, -0.6f, 0.0f, 0.0f, 0.6f, 0.2f, 0.1f, 0.6f, 0.0f, 0.0125f, 0.7f, 0.0f, 0.0f, 0.7f, 0.0125f, 0.1f, 0.6f, 0.0f, 0.0f, 0.6f, -0.2f, 0.0f, 0.7f, -0.0125f, 0.0125f, 0.7f, 0.0f, 0.0f, 0.6f, -0.2f, -0.1f, 0.6f, 0.0f, 0.0125f, 0.7f, 0.0f, 0.0f, 0.7f, -0.0125f, -0.1f, 0.6f, 0.0f, 0.0f, 0.6f, 0.2f, 0.0f, 0.7f, 0.0125f, -0.0125f, 0.7f, 0.0f, 0.0f, 0.7f, 0.0125f, 0.0125f, 0.7f, 0.0f, 0.0f, 0.7f, -0.0125f, -0.0125f, 0.7f, 0.0f, 0.0f, -0.6f, 0.2f, 0.1f, -0.6f, 0.0f, 0.0125f, -0.7f, 0.0f, 0.0f, -0.7f, 0.0125f, 0.1f, -0.6f, 0.0f, 0.0f, -0.6f, -0.2f, 0.0f, -0.7f, -0.0125f, 0.0125f, -0.7f, 0.0f, 0.0f, -0.6f, -0.2f, -0.1f, -0.6f, 0.0f, 0.0125f, -0.7f, 0.0f, 0.0f, -0.7f, -0.0125f, -0.1f, -0.6f, 0.0f, 0.0f, -0.6f, 0.2f, 0.0f, -0.7f, 0.0125f, -0.0125f, -0.7f, 0.0f, 0.0f, -0.7f, 0.0125f, 0.0125f, -0.7f, 0.0f, 0.0f, -0.7f, -0.0125f, -0.0125f, -0.7f, 0.0f, 0.0125f, -0.5f, 0.1f, 0.0125f, -0.7f, 0.0125f, 0.0125f, -0.8f, 0.6f, 0.0125f, -0.7f, 0.6f, -0.0125f, -0.5f, 0.1f, -0.0125f, -0.7f, 0.0125f, -0.0125f, -0.8f, 0.6f, -0.0125f, -0.7f, 0.6f, 0.0125f, -0.7f, 0.6f, 0.0125f, -0.8f, 0.6f, -0.0125f, -0.8f, 0.6f, -0.0125f, -0.7f, 0.6f, 0.0125f, -0.5f, 0.1f, -0.0125f, -0.5f, 0.1f, -0.0125f, -0.7f, 0.6f, 0.0125f, -0.7f, 0.6f, 0.0125f, -0.7f, 0.0125f, -0.0125f, -0.7f, 0.0125f, -0.0125f, -0.8f, 0.6f, 0.0125f, -0.8f, 0.6f, 0.0125f, -0.6f, 0.0125f, 0.4f, -0.7f, 0.0125f, 0.4f, -0.8f, 0.0125f, 0.0f, -0.75f, 0.0125f, 0.0125f, -0.6f, -0.0125f, 0.4f, -0.7f, -0.0125f, 0.4f, -0.8f, -0.0125f, 0.0f, -0.75f, -0.0125f, 0.0125f, -0.6f, 0.0125f, 0.4f, -0.7f, 0.0125f, 0.4f, -0.7f, -0.0125f, 0.09f, -0.6f, -0.0125f, 0.0f, -0.75f, 0.0125f, 0.4f, -0.8f, 0.0125f, 0.4f, -0.8f, -0.0125f, 0.0f, -0.75f, -0.0125f, -0.0125f, -0.6f, 0.0125f, -0.4f, -0.7f, 0.0125f, -0.4f, -0.8f, 0.0125f, -0.0f, -0.75f, 0.0125f, -0.0125f, -0.6f, -0.0125f, -0.4f, -0.7f, -0.0125f, -0.4f, -0.8f, -0.0125f, -0.0f, -0.75f, -0.0125f, -0.0125f, -0.6f, 0.0125f, -0.4f, -0.7f, 0.0125f, -0.4f, -0.7f, -0.0125f, -0.09f, -0.6f, -0.0125f, -0.0f, -0.75f, 0.0125f, -0.4f, -0.8f, 0.0125f, -0.4f, -0.8f, -0.0125f, -0.0f, -0.75f, -0.0125f, 0.09f, 0.1f, 0.0125f, 0.8f, -0.2f, 0.0125f, 0.8f, -0.3f, 0.0125f, 0.09f, -0.2f, 0.0125f, 0.09f, 0.1f, -0.0125f, 0.8f, -0.2f, -0.0125f, 0.8f, -0.3f, -0.0125f, 0.09f, -0.2f, -0.0125f, 0.09f, 0.1f, 0.0125f, 0.8f, -0.2f, 0.0125f, 0.8f, -0.2f, -0.0125f, 0.09f, 0.1f, -0.0125f, 0.8f, -0.2f, 0.0125f, 0.8f, -0.3f, 0.0125f, 0.8f, -0.3f, -0.0125f, 0.8f, -0.2f, -0.0125f, 0.09f, -0.2f, 0.0125f, 0.8f, -0.3f, 0.0125f, 0.8f, -0.3f, -0.0125f, 0.09f, -0.2f, -0.0125f, -0.09f, 0.1f, 0.0125f, -0.8f, -0.2f, 0.0125f, -0.8f, -0.3f, 0.0125f, -0.09f, -0.2f, 0.0125f, -0.09f, 0.1f, -0.0125f, -0.8f, -0.2f, -0.0125f, -0.8f, -0.3f, -0.0125f, -0.09f, -0.2f, -0.0125f, -0.09f, 0.1f, 0.0125f, -0.8f, -0.2f, 0.0125f, -0.8f, -0.2f, -0.0125f, -0.09f, 0.1f, -0.0125f, -0.8f, -0.2f, 0.0125f, -0.8f, -0.3f, 0.0125f, -0.8f, -0.3f, -0.0125f, -0.8f, -0.2f, -0.0125f, -0.09f, -0.2f, 0.0125f, -0.8f, -0.3f, 0.0125f, -0.8f, -0.3f, -0.0125f, -0.09f, -0.2f, -0.0125f};
            } else {
                for (int i = 0; i < MISC_NAMES.length; ++i) {
                    if (!s.equals(MISC_NAMES[i])) continue;
                    shape = WeatherSymbols.getMiscSymbol(MISC_IDS[i]);
                    break;
                }
                scale = 2.5f;
            }
        }
        if (shapes == null && shape == null) {
            throw new IllegalArgumentException("unsupported shape " + s);
        }
        if (shapes == null) {
            shapes = new VisADGeometryArray[]{shape};
        }
        if (scale != 1.0f) {
            shapes = ShapeUtility.setSize(shapes, scale);
        }
        for (int i = 0; i < shapes.length; ++i) {
            shapes[i].vertexCount = shapes[i].coordinates.length / 3;
        }
        return shapes;
    }

    public static VisADGeometryArray shapeText(String s) {
        return ShapeUtility.shapeText(s, false);
    }

    public static VisADGeometryArray shapeText(String s, boolean center) {
        return PlotText.render_label(s, TEXT_START, TEXT_BASE, TEXT_UP, center);
    }

    public static VisADGeometryArray shapeText(String s, int fontSize, boolean center) {
        try {
            VisADGeometryArray result = PlotText.render_label(s, TEXT_START, TEXT_BASE, TEXT_UP, center);
            if (fontSize != 12) {
                result = ShapeUtility.setSize(result, (float)fontSize / 12.0f);
            }
            return result;
        }
        catch (Exception exc) {
            VisADGeometryArray result = PlotText.render_label("BAD TEXT", TEXT_START, TEXT_BASE, TEXT_UP, center);
            if (fontSize != 12) {
                result = ShapeUtility.setSize(result, (float)fontSize / 12.0f);
            }
            return result;
        }
    }

    public static VisADGeometryArray shapeFont(String s, Font f) {
        return ShapeUtility.shapeFont(s, f, false);
    }

    public static VisADGeometryArray shapeFont(String s, Font f, boolean center) {
        return PlotText.render_font(s, f, TEXT_START, TEXT_BASE, TEXT_UP, center);
    }

    public static VisADGeometryArray[] setSize(VisADGeometryArray[] shapes, float size) {
        for (int i = 0; i < shapes.length; ++i) {
            ShapeUtility.setSize(shapes[i], size);
        }
        return shapes;
    }

    public static VisADGeometryArray setSize(VisADGeometryArray shape, float size) {
        return ShapeUtility.setSize(shape, size, size, size);
    }

    public static VisADGeometryArray setSize(VisADGeometryArray shape, float x, float y, float z) {
        if (shape.coordinates != null) {
            for (int i = 0; i < shape.coordinates.length; i += 3) {
                int n = i + 0;
                shape.coordinates[n] = shape.coordinates[n] * x;
                int n2 = i + 1;
                shape.coordinates[n2] = shape.coordinates[n2] * y;
                int n3 = i + 2;
                shape.coordinates[n3] = shape.coordinates[n3] * z;
            }
        }
        return shape;
    }

    public static VisADGeometryArray offset(VisADGeometryArray shape, float[] off) {
        return ShapeUtility.offset(shape, off[0], off[1], off[2]);
    }

    public static VisADGeometryArray offset(VisADGeometryArray shape, float dx, float dy, float dz) {
        if (dx == 0.0f && dy == 0.0f && dz == 0.0f) {
            return shape;
        }
        for (int i = 0; i < shape.coordinates.length; i += 3) {
            int n = i;
            shape.coordinates[n] = shape.coordinates[n] + dx;
            int n2 = i + 1;
            shape.coordinates[n2] = shape.coordinates[n2] + dy;
            int n3 = i + 2;
            shape.coordinates[n3] = shape.coordinates[n3] + dz;
        }
        return shape;
    }

    public static Rectangle2D bounds2d(VisADGeometryArray shape) {
        return ShapeUtility.bounds2d(shape, null);
    }

    public static Rectangle2D bounds2d(VisADGeometryArray shape, Rectangle2D rect) {
        if (rect == null) {
            rect = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
        } else {
            rect.setRect(0.0, 0.0, 0.0, 0.0);
        }
        if (shape != null && shape.coordinates != null) {
            for (int i = 0; i < shape.coordinates.length; i += 3) {
                if (i == 0) {
                    if (rect == null) {
                        rect = new Rectangle2D.Float();
                    }
                    rect.setRect(shape.coordinates[i], shape.coordinates[i + 1], 0.0, 0.0);
                    continue;
                }
                rect.add(shape.coordinates[i], shape.coordinates[i + 1]);
            }
        }
        return rect;
    }

    public static Rectangle2D bounds2d(VisADGeometryArray[] shapes) {
        Rectangle2D.Float rect = null;
        if (shapes != null) {
            for (int j = 0; j < shapes.length; ++j) {
                VisADGeometryArray shape = shapes[j];
                if (shape == null || shape.coordinates == null) continue;
                for (int i = 0; i < shape.coordinates.length; i += 3) {
                    if (rect == null) {
                        rect = new Rectangle2D.Float(shape.coordinates[i], shape.coordinates[i + 1], 0.0f, 0.0f);
                        continue;
                    }
                    rect.add(shape.coordinates[i], shape.coordinates[i + 1]);
                }
            }
        }
        if (rect == null) {
            rect = new Rectangle2D.Float(0.0f, 0.0f, 0.0f, 0.0f);
        }
        return rect;
    }

    public static void setColor(VisADGeometryArray[] shapes, Color color) {
        for (int i = 0; i < shapes.length; ++i) {
            ShapeUtility.setColor(shapes[i], color);
        }
    }

    public static void setColor(VisADGeometryArray[] shapes, float[] RGB) {
        for (int i = 0; i < shapes.length; ++i) {
            ShapeUtility.setColor(shapes[i], RGB);
        }
    }

    public static void setColor(VisADGeometryArray shape, Color color) {
        ShapeUtility.setColor(shape, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
    }

    public static void setColor(VisADGeometryArray shape, float[] RGB) {
        if (RGB.length > 3) {
            ShapeUtility.setColor(shape, RGB[0], RGB[1], RGB[2], RGB[3]);
        } else {
            ShapeUtility.setColor(shape, RGB[0], RGB[1], RGB[2]);
        }
    }

    public static void setColor(VisADGeometryArray shape, float R, float G, float B) {
        ShapeUtility.setColor(shape, R, G, B, 1.0f);
    }

    public static void setColor(VisADGeometryArray shape, float R, float G, float B, float A) {
        int colorLength = 4;
        int vertexCount = shape.coordinates.length / 3;
        byte[] colors = new byte[vertexCount * colorLength];
        for (int ic = 0; ic < colors.length; ic += colorLength) {
            colors[ic] = ShadowType.floatToByte(R);
            colors[ic + 1] = ShadowType.floatToByte(G);
            colors[ic + 2] = ShadowType.floatToByte(B);
            if (colorLength != 4) continue;
            colors[ic + 3] = ShadowType.floatToByte(A);
        }
        shape.colors = colors;
    }

    public static void blendColor(VisADGeometryArray shape, Color color) {
        ShapeUtility.blendColor(shape, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f);
    }

    public static void blendColor(VisADGeometryArray shape, float R, float G, float B) {
        if (shape.colors == null) {
            shape.colors = new byte[shape.coordinates.length];
        }
        for (int ic = 0; ic < shape.coordinates.length; ic += 3) {
            float f = ShadowType.byteToFloat(shape.colors[ic]);
            shape.colors[ic] = ShadowType.floatToByte(R * f);
            f = ShadowType.byteToFloat(shape.colors[ic + 1]);
            shape.colors[ic + 1] = ShadowType.floatToByte(G * f);
            f = ShadowType.byteToFloat(shape.colors[ic + 2]);
            shape.colors[ic + 2] = ShadowType.floatToByte(B * f);
        }
    }

    public static void reScale(VisADGeometryArray[] shapes, double scale) {
        for (int i = 0; i < shapes.length; ++i) {
            ShapeUtility.reScale(shapes[i], scale);
        }
    }

    public static void reScale(VisADGeometryArray shape, double scale) {
        if (shape.coordinates != null) {
            int i = 0;
            while (i < shape.coordinates.length) {
                int n = i++;
                shape.coordinates[n] = shape.coordinates[n] * (float)scale;
            }
        }
    }

    public static void reScale(VisADGeometryArray[] shapes, double[] scale) {
        for (int i = 0; i < shapes.length; ++i) {
            ShapeUtility.reScale(shapes[i], scale);
        }
    }

    public static void reScale(VisADGeometryArray[] shapes, double[] scaleArray, double scale) {
        for (int i = 0; i < shapes.length; ++i) {
            ShapeUtility.reScale(shapes[i], scaleArray, scale);
        }
    }

    public static VisADGeometryArray[] clone(VisADGeometryArray[] shapes) {
        VisADGeometryArray[] newShapes = new VisADGeometryArray[shapes.length];
        for (int i = 0; i < shapes.length; ++i) {
            newShapes[i] = (VisADGeometryArray)shapes[i].clone();
        }
        return newShapes;
    }

    public static void reScale(VisADGeometryArray shape, double[] scale) {
        for (int i = 0; i < shape.coordinates.length; i += 3) {
            int n = i;
            shape.coordinates[n] = shape.coordinates[n] * (float)scale[0];
            int n2 = i + 1;
            shape.coordinates[n2] = shape.coordinates[n2] * (float)scale[1];
            int n3 = i + 2;
            shape.coordinates[n3] = shape.coordinates[n3] * (float)scale[2];
        }
    }

    public static void reScale(VisADGeometryArray shape, double[] scaleArray, double scale) {
        for (int i = 0; i < shape.coordinates.length; i += 3) {
            int n = i;
            shape.coordinates[n] = (float)((double)shape.coordinates[n] * ((double)((float)scaleArray[0]) * scale));
            int n2 = i + 1;
            shape.coordinates[n2] = (float)((double)shape.coordinates[n2] * ((double)((float)scaleArray[1]) * scale));
            int n3 = i + 2;
            shape.coordinates[n3] = (float)((double)shape.coordinates[n3] * ((double)((float)scaleArray[2]) * scale));
        }
    }

    public static void rotate(VisADGeometryArray shape, float angle) {
        ShapeUtility.rotateZ(shape, angle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rotateZ(VisADGeometryArray shape, float angle) {
        Matrix3f matrix3f = rotateZMatrix;
        synchronized (matrix3f) {
            rotateZMatrix.rotZ(angle);
            for (int i = 0; i < shape.coordinates.length; i += 3) {
                rotateVector.set(shape.coordinates[i], shape.coordinates[i + 1], shape.coordinates[i + 2]);
                rotateZMatrix.transform((Tuple3f)rotateVector);
                rotateVector.get(rotateArray);
                shape.coordinates[i] = rotateArray[0];
                shape.coordinates[i + 1] = rotateArray[1];
            }
        }
    }

    public static void rotate(VisADGeometryArray shape, Transform3D transform) {
        ShapeUtility.rotate(shape, transform, 0.0f, 0.0f, 0.0f);
    }

    public static void rotate(VisADGeometryArray shape, Transform3D transform, float deltax, float deltay, float deltaz) {
        Point3f point3f = new Point3f();
        for (int i = 0; i < shape.coordinates.length; i += 3) {
            point3f.x = shape.coordinates[i + 0] + deltax;
            point3f.y = shape.coordinates[i + 1] + deltay;
            point3f.z = shape.coordinates[i + 2] + deltaz;
            transform.transform(point3f);
            shape.coordinates[i + 0] = point3f.x - deltax;
            shape.coordinates[i + 1] = point3f.y - deltay;
            shape.coordinates[i + 2] = point3f.z - deltaz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rotateX(VisADGeometryArray shape, float angle) {
        Matrix3f matrix3f = rotateXMatrix;
        synchronized (matrix3f) {
            rotateXMatrix.rotX(angle);
            for (int i = 0; i < shape.coordinates.length; i += 3) {
                rotateVector.set(shape.coordinates[i], shape.coordinates[i + 1], shape.coordinates[i + 2]);
                rotateXMatrix.transform((Tuple3f)rotateVector);
                rotateVector.get(rotateArray);
                shape.coordinates[i + 1] = rotateArray[1];
                shape.coordinates[i + 2] = rotateArray[2];
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void rotateY(VisADGeometryArray shape, float angle) {
        Matrix3f matrix3f = rotateYMatrix;
        synchronized (matrix3f) {
            rotateYMatrix.rotY(angle);
            for (int i = 0; i < shape.coordinates.length; i += 3) {
                rotateVector.set(shape.coordinates[i], shape.coordinates[i + 1], shape.coordinates[i + 2]);
                rotateYMatrix.transform((Tuple3f)rotateVector);
                rotateVector.get(rotateArray);
                shape.coordinates[i] = rotateArray[0];
                shape.coordinates[i + 2] = rotateArray[2];
            }
        }
    }
}

