/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad;

import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import ucar.visad.Segment;

public class SegmentSet {
    private final SortedSet set = new TreeSet(new Comparator(){

        public int compare(Object obj1, Object obj2) {
            return ((Segment)obj1).getIndex() - ((Segment)obj2).getIndex();
        }

        public boolean equals(Object obj1, Object obj2) {
            return this.compare(obj1, obj2) == 0;
        }
    });
    private int totalCount = 0;

    protected void add(Segment segment) {
        this.set.add(segment);
        this.totalCount += segment.getCount();
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public Iterator iterator() {
        return new Iterator(){
            private final Iterator iter;
            private Object current;
            {
                this.iter = SegmentSet.this.set.iterator();
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            public Object next() {
                this.current = this.iter.next();
                return this.current;
            }

            @Override
            public void remove() {
                if (this.current != null) {
                    SegmentSet.this.totalCount = SegmentSet.this.totalCount - ((Segment)this.current).getCount();
                }
                this.iter.remove();
            }
        };
    }

    public double[][] take(double[][] values) {
        double[][] newValues = new double[values.length][this.getTotalCount()];
        int toIndex = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Segment segment = (Segment)iter.next();
            int fromIndex = segment.getIndex();
            int count = segment.getCount();
            int j = values.length;
            while (--j >= 0) {
                System.arraycopy(values[j], fromIndex, newValues[j], toIndex, count);
            }
            toIndex += count;
        }
        return newValues;
    }

    public float[][] take(float[][] values) {
        float[][] newValues = new float[values.length][this.getTotalCount()];
        int toIndex = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            Segment segment = (Segment)iter.next();
            int fromIndex = segment.getIndex();
            int count = segment.getCount();
            int j = values.length;
            while (--j >= 0) {
                System.arraycopy(values[j], fromIndex, newValues[j], toIndex, count);
            }
            toIndex += count;
        }
        return newValues;
    }
}

