/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad;

import java.rmi.RemoteException;
import ucar.visad.Quantity;
import visad.CoordinateSystem;
import visad.DataImpl;
import visad.ErrorEstimate;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Set;
import visad.SetType;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public abstract class ScalarQuantity
extends Quantity {
    private final RealType realType;

    protected ScalarQuantity(String name, Unit unit) throws TypeException, VisADException {
        this(name, unit, (Set)null);
    }

    protected ScalarQuantity(String name, Unit unit, Set set) throws VisADException {
        this(name, unit, set, 0);
    }

    protected ScalarQuantity(String name, Unit unit, Set set, int attrMask) throws VisADException {
        this(RealType.getRealType(name, unit, set, attrMask));
    }

    protected ScalarQuantity(RealType realType) throws TypeException, VisADException {
        this(realType, (CoordinateSystem)null);
    }

    protected ScalarQuantity(RealType realType, CoordinateSystem coordSys) throws TypeException, VisADException {
        this(realType, coordSys, (Set)null);
    }

    protected ScalarQuantity(RealType realType, CoordinateSystem coordSys, Set domain) throws TypeException, VisADException {
        super(realType.getName(), new RealTupleType(realType, coordSys, domain));
        this.realType = realType;
    }

    public final RealType getRealType() {
        return this.realType;
    }

    @Override
    public final MathType getMathType() {
        return this.getRealType();
    }

    public final Real newReal(double amount) throws VisADException {
        return this.newReal(amount, this.realType.getDefaultUnit());
    }

    public final Real newReal(double amount, Unit unit) throws VisADException {
        return this.newReal(amount, unit, null);
    }

    public Real newReal(double amount, Unit unit, ErrorEstimate error) throws VisADException {
        return new Real(this.realType, amount, unit, error);
    }

    public final RealTuple newRealTuple(double amount, Unit unit) throws VisADException, RemoteException {
        return this.newRealTuple(new double[]{amount}, new Unit[]{unit});
    }

    public final RealTuple newRealTuple(double amount, Unit unit, CoordinateSystem coordSys) throws VisADException, RemoteException {
        return this.newRealTuple(new double[]{amount}, new Unit[]{unit}, coordSys);
    }

    public RealTuple newRealTuple(double amount, Unit unit, ErrorEstimate error, CoordinateSystem coordSys) throws VisADException, RemoteException {
        return this.newRealTuple(new double[]{amount}, new Unit[]{unit}, new ErrorEstimate[]{error}, coordSys);
    }

    public RealTuple newRealTuple(Real value, CoordinateSystem coordSys) throws VisADException, RemoteException {
        return this.newRealTuple(new Real[]{value}, coordSys);
    }

    @Override
    public DataImpl newValue(double[] amounts, Unit[] units, ErrorEstimate[] errors, CoordinateSystem coordSys) throws VisADException {
        if (amounts.length != 1) {
            throw new TypeException(this.getClass().getName() + ".newData: Bad amount-array length");
        }
        if (units != null && units.length != 1) {
            throw new TypeException(this.getClass().getName() + ".newData: Bad units-array length");
        }
        if (errors != null && errors.length != 1) {
            throw new TypeException(this.getClass().getName() + ".newData: Bad errors-array length");
        }
        if (coordSys != null) {
            throw new TypeException(this.getClass().getName() + ".newData: Non-null CoordinateSystem");
        }
        return this.newReal(amounts[0], units == null ? null : units[0], errors == null ? null : errors[0]);
    }

    @Override
    public boolean isCompatible(MathType type) throws VisADException {
        boolean isCompatible;
        if (type instanceof RealType) {
            isCompatible = ((RealType)type).equalsExceptNameButUnits(this.realType) && this.getRealTupleType().getCoordinateSystem() == null;
        } else if (type instanceof RealTupleType) {
            RealTupleType thatTupleType = (RealTupleType)type;
            RealTupleType thisTupleType = this.getRealTupleType();
            if (!thatTupleType.equalsExceptNameButUnits(thisTupleType)) {
                isCompatible = false;
            } else {
                CoordinateSystem thisCS = thisTupleType.getCoordinateSystem();
                CoordinateSystem thatCS = thatTupleType.getCoordinateSystem();
                isCompatible = thisCS == null ? thatCS == null : thisCS.getReference().equalsExceptNameButUnits(thatCS.getReference());
            }
        } else {
            isCompatible = type instanceof SetType ? this.isCompatible(((SetType)type).getDomain()) : (type instanceof FunctionType ? this.isCompatible(((FunctionType)type).getRange()) : false);
        }
        return isCompatible;
    }
}

