/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad;

import edu.wisc.ssec.mcidas.McIDASUtil;
import java.util.List;
import org.w3c.dom.Element;
import ucar.unidata.util.Misc;
import ucar.unidata.xml.XmlEncoder;
import ucar.unidata.xml.XmlPersistable;
import visad.CommonUnit;
import visad.VisADException;
import visad.data.mcidas.AREACoordinateSystem;
import visad.georef.LatLonPoint;

public class RadarMapProjection
extends AREACoordinateSystem
implements XmlPersistable {
    private static final int DEFAULT_WIDTH = 520;
    private static final int DEFAULT_HEIGHT = 520;
    private double lat;
    private double lon;
    private int width;
    private int height;

    public RadarMapProjection(LatLonPoint ll) throws VisADException {
        this(ll.getLatitude().getValue(CommonUnit.degree), ll.getLongitude().getValue(CommonUnit.degree));
    }

    public RadarMapProjection(LatLonPoint ll, int width, int height) throws VisADException {
        this(ll.getLatitude().getValue(CommonUnit.degree), ll.getLongitude().getValue(CommonUnit.degree), width, height);
    }

    public RadarMapProjection(double lat, double lon) throws VisADException {
        this(lat, lon, 520, 520);
    }

    public RadarMapProjection(double lat, double lon, int width, int height) throws VisADException {
        this(lat, lon, width, height, 1);
    }

    public RadarMapProjection(double lat, double lon, int width, int height, int res) throws VisADException {
        super(RadarMapProjection.makeDir(height, width), RadarMapProjection.makeNav(lat, lon, height, width, res), null, false);
        this.lat = lat;
        this.lon = lon;
        this.width = width;
        this.height = height;
    }

    private static int[] makeNav(double lat, double lon, int lines, int eles, int res) {
        int[] nav = new int[128];
        nav[0] = 1380009042;
        nav[1] = lines / 2;
        nav[2] = eles / 2;
        nav[3] = McIDASUtil.doubleLatLonToInteger(lat);
        nav[4] = McIDASUtil.doubleLatLonToInteger(-lon);
        nav[5] = 1000 * res;
        return nav;
    }

    private static int[] makeDir(int lines, int elements) {
        int[] dir = new int[64];
        dir[1] = 4;
        dir[2] = 7;
        dir[5] = 1;
        dir[6] = 1;
        dir[8] = lines;
        dir[9] = elements;
        dir[10] = 1;
        dir[11] = 1;
        dir[12] = 1;
        dir[13] = 1;
        return dir;
    }

    @Override
    public String toString() {
        return "Radar Projection (" + Misc.format(this.lat) + " " + Misc.format(this.lon) + ")";
    }

    @Override
    public Element createElement(XmlEncoder encoder) {
        List args = Misc.newList(new Double(this.lat), new Double(this.lon), new Integer(this.width), new Integer(this.height));
        List types = Misc.newList(Double.TYPE, Double.TYPE, Integer.TYPE, Integer.TYPE);
        Element result = encoder.createObjectElement(this.getClass());
        Element ctorElement = encoder.createConstructorElement(args, types);
        result.appendChild(ctorElement);
        return result;
    }

    @Override
    public boolean initFromXml(XmlEncoder encoder, Element node) {
        return true;
    }
}

