/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad;

import ucar.unidata.geoloc.Bearing;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import visad.CommonUnit;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;
import visad.bom.Radar3DCoordinateSystem;
import visad.georef.EarthLocation;
import visad.georef.NavigatedCoordinateSystem;

public class RadarGridCoordinateSystem
extends NavigatedCoordinateSystem {
    private static Unit[] units = new Unit[]{CommonUnit.degree, CommonUnit.degree, CommonUnit.degree};
    private Radar3DCoordinateSystem rcs = null;
    private LatLonPointImpl center = null;
    private LatLonPointImpl workLL = new LatLonPointImpl();

    public RadarGridCoordinateSystem(EarthLocation radLocation) throws VisADException {
        this(radLocation.getLatitude().getValue(CommonUnit.degree), radLocation.getLongitude().getValue(CommonUnit.degree), radLocation.getAltitude().getValue(CommonUnit.meter));
    }

    public RadarGridCoordinateSystem(double lat, double lon, double alt) throws VisADException {
        super(RealTupleType.SpatialEarth3DTuple, units);
        this.center = new LatLonPointImpl(lat, lon);
        this.rcs = new Radar3DCoordinateSystem((float)lat, (float)lon, (float)alt);
    }

    @Override
    public double[][] toReference(double[][] lonlatelev) throws VisADException {
        int numPoints = lonlatelev[0].length;
        double[][] latlonalt = new double[3][numPoints];
        for (int i = 0; i < numPoints; ++i) {
            this.workLL.setLatitude(lonlatelev[1][i]);
            this.workLL.setLongitude(lonlatelev[0][i]);
            Bearing result = Bearing.calculateBearing(this.center, (LatLonPoint)this.workLL, null);
            latlonalt[0][i] = result.getDistance() * 1000.0;
            latlonalt[1][i] = result.getAngle();
            latlonalt[2][i] = lonlatelev[2][i];
        }
        latlonalt = this.rcs.toReference(latlonalt);
        return new double[][]{latlonalt[1], latlonalt[0], latlonalt[2]};
    }

    @Override
    public double[][] fromReference(double[][] lonlatalt) throws VisADException {
        int numPoints = lonlatalt[0].length;
        double[][] lonlatelev = this.rcs.fromReference(new double[][]{lonlatalt[1], lonlatalt[0], lonlatalt[2]});
        for (int i = 0; i < numPoints; ++i) {
            lonlatelev[0][i] = lonlatalt[0][i];
            lonlatelev[1][i] = lonlatalt[1][i];
        }
        return lonlatelev;
    }

    @Override
    public float[][] toReference(float[][] lonlatelev) throws VisADException {
        int numPoints = lonlatelev[0].length;
        float[][] latlonalt = new float[3][numPoints];
        for (int i = 0; i < numPoints; ++i) {
            this.workLL.setLatitude(lonlatelev[1][i]);
            this.workLL.setLongitude(lonlatelev[0][i]);
            Bearing result = Bearing.calculateBearing(this.center, (LatLonPoint)this.workLL, null);
            latlonalt[0][i] = (float)(result.getDistance() * 1000.0);
            latlonalt[1][i] = (float)result.getAngle();
            latlonalt[2][i] = lonlatelev[2][i];
        }
        latlonalt = this.rcs.toReference(latlonalt);
        return new float[][]{latlonalt[1], latlonalt[0], latlonalt[2]};
    }

    @Override
    public float[][] fromReference(float[][] lonlatalt) throws VisADException {
        int numPoints = lonlatalt[0].length;
        float[][] lonlatelev = this.rcs.fromReference(new float[][]{lonlatalt[1], lonlatalt[0], lonlatalt[2]});
        for (int i = 0; i < numPoints; ++i) {
            lonlatelev[0][i] = lonlatalt[0][i];
            lonlatelev[1][i] = lonlatalt[1][i];
        }
        return lonlatelev;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof RadarGridCoordinateSystem)) {
            return false;
        }
        RadarGridCoordinateSystem that = (RadarGridCoordinateSystem)obj;
        return this == that || this.center.equals(that.center);
    }
}

