/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad;

import java.rmi.RemoteException;
import java.util.Map;
import java.util.TreeMap;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.ErrorEstimate;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SetType;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public abstract class Quantity {
    public final DependenceMode DEPENDENT = new DependenceMode();
    public final DependenceMode INDEPENDENT = new DependenceMode();
    public final DependenceMode UNIMPORTANT = new DependenceMode();
    private final String name;
    private final RealTupleType realTupleType;
    private static Map map = new TreeMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Quantity(String name, RealTupleType realTupleType) throws TypeException, VisADException {
        Map map = Quantity.map;
        synchronized (map) {
            RealTupleType oldQuantity = (RealTupleType)Quantity.map.get(name);
            if (oldQuantity != null) {
                throw new TypeException(this.getClass().getName() + ".<init>: " + "Desired quantity <<" + name + ">> already exists as <<" + oldQuantity + ">>");
            }
            Quantity.map.put(name, realTupleType);
        }
        this.name = name;
        this.realTupleType = realTupleType;
    }

    public final String getName() {
        return this.name;
    }

    public final RealTupleType getRealTupleType() {
        return this.realTupleType;
    }

    public MathType getMathType() {
        return this.getRealTupleType();
    }

    public final RealTuple newRealTuple(double[] amounts, Unit[] units) throws VisADException, RemoteException {
        return this.newRealTuple(amounts, units, null);
    }

    public final RealTuple newRealTuple(double[] amounts, Unit[] units, CoordinateSystem coordSys) throws VisADException, RemoteException {
        return this.newRealTuple(amounts, units, null, coordSys);
    }

    public RealTuple newRealTuple(double[] amounts, Unit[] units, ErrorEstimate[] errors, CoordinateSystem coordSys) throws VisADException, RemoteException {
        Real[] values = new Real[amounts.length];
        for (int i = 0; i < amounts.length; ++i) {
            values[i] = new Real((RealType)this.realTupleType.getComponent(i), amounts[i], units == null ? null : units[i], errors == null ? null : errors[i]);
        }
        return this.newRealTuple(values, coordSys);
    }

    public RealTuple newRealTuple(Real[] values, CoordinateSystem coordSys) throws VisADException, RemoteException {
        return new RealTuple(this.realTupleType, values, coordSys);
    }

    public DataImpl newValue(double[] amounts, Unit[] units, ErrorEstimate[] errors, CoordinateSystem coordSys) throws VisADException, RemoteException {
        return this.newRealTuple(amounts, units, errors, coordSys);
    }

    public boolean isCompatible(Data data) throws VisADException, RemoteException {
        return this.isCompatible(data.getType());
    }

    public boolean isCompatible(MathType type) throws VisADException {
        boolean isCompatible;
        if (type instanceof RealTupleType) {
            RealTupleType thatTupleType = (RealTupleType)type;
            RealTupleType thisTupleType = this.getRealTupleType();
            if (!thatTupleType.equalsExceptNameButUnits(thisTupleType)) {
                isCompatible = false;
            } else {
                CoordinateSystem thisCS = thisTupleType.getCoordinateSystem();
                CoordinateSystem thatCS = thatTupleType.getCoordinateSystem();
                isCompatible = thisCS == null ? thatCS == null : thisCS.getReference().equalsExceptNameButUnits(thatCS.getReference());
            }
        } else {
            isCompatible = type instanceof SetType ? this.isCompatible(((SetType)type).getDomain()) : (type instanceof FunctionType ? this.isCompatible(((FunctionType)type).getRange()) : false);
        }
        return isCompatible;
    }

    public final void vet(Data data) throws TypeException, VisADException, RemoteException {
        this.vet(data.getType());
    }

    public final void vet(MathType type) throws VisADException {
        if (!this.isCompatible(type)) {
            throw new TypeException(this.getClass().getName() + ".vet(MathType): Incompatible type: " + type);
        }
    }

    private class DependenceMode {
        private DependenceMode() {
        }
    }
}

