/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.w3c.dom.Element;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Trace;
import ucar.unidata.xml.XmlEncoder;
import ucar.unidata.xml.XmlPersistable;
import visad.CommonUnit;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.MapProjection;

public class ProjectionCoordinateSystem
extends MapProjection
implements XmlPersistable {
    private ProjectionImpl projection;
    private ProjectionPointImpl workP = new ProjectionPointImpl();
    private LatLonPointImpl workL = new LatLonPointImpl();
    public static boolean debug = false;

    public ProjectionCoordinateSystem(ProjectionImpl projection) throws VisADException {
        this(projection, new Unit[]{CommonUnit.meter.scale(1000.0), CommonUnit.meter.scale(1000.0)});
    }

    public ProjectionCoordinateSystem(ProjectionImpl projection, Unit[] units) throws VisADException {
        super(RealTupleType.LatitudeLongitudeTuple, units);
        if (projection == null) {
            throw new NullPointerException();
        }
        this.projection = projection;
    }

    @Override
    public String toString() {
        return this.projection.getName().equals("") ? this.projection.getClass().toString() : this.projection.getName();
    }

    @Override
    public Rectangle2D getDefaultMapArea() {
        ProjectionRect projRect = this.projection.getDefaultMapArea();
        double x = projRect.getX();
        double y = projRect.getY();
        double width = projRect.getWidth();
        double height = projRect.getHeight();
        return new Rectangle2D.Double(x, y, width, height);
    }

    public ProjectionImpl getProjection() {
        return this.projection;
    }

    private void debug(String what, double[][] array, long t1, long t2) {
        if (debug && array[0].length > 100) {
            System.err.println(what + " projection:" + this.projection.getClass().getName() + " time:" + (t2 - t1) + " size:" + array[0].length);
            Misc.printStack(what);
        }
    }

    private void debug(String what, float[][] array, long t1, long t2) {
        if (debug && array[0].length > 100) {
            Misc.printStack(what + " projection:" + this.projection.getClass().getName() + " time:" + (t2 - t1) + " size:" + array[0].length);
        }
    }

    @Override
    public double[][] toReference(double[][] world) throws VisADException {
        long t1 = System.currentTimeMillis();
        double[][] result = this.projection.projToLatLon(world, world);
        long t2 = System.currentTimeMillis();
        this.debug("toReference(double)", result, t1, t2);
        return result;
    }

    @Override
    public double[][] fromReference(double[][] latlon) throws VisADException {
        long t1 = System.currentTimeMillis();
        double[][] result = this.projection.latLonToProj(latlon, latlon, this.getLatitudeIndex(), this.getLongitudeIndex());
        long t2 = System.currentTimeMillis();
        this.debug("fromReference(double)", result, t1, t2);
        return result;
    }

    @Override
    public float[][] toReference(float[][] world) throws VisADException {
        long t1 = System.currentTimeMillis();
        float[][] result = this.projection.projToLatLon(world, world);
        long t2 = System.currentTimeMillis();
        this.debug("toReference(float)", result, t1, t2);
        return result;
    }

    @Override
    public float[][] fromReference(float[][] latlon) throws VisADException {
        Trace.msg("ProjectionCoordinateSystem.fromReference " + this.projection.getClass().getName());
        long t1 = System.currentTimeMillis();
        float[][] result = this.projection.latLonToProj(latlon, latlon, this.getLatitudeIndex(), this.getLongitudeIndex());
        long t2 = System.currentTimeMillis();
        this.debug("fromReference(float)", result, t1, t2);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ProjectionCoordinateSystem)) {
            return false;
        }
        ProjectionCoordinateSystem that = (ProjectionCoordinateSystem)obj;
        return that.projection.equals(this.projection);
    }

    @Override
    public Element createElement(XmlEncoder encoder) {
        ArrayList<Object> args = new ArrayList<Object>(1);
        args.add(this.projection);
        args.add(this.getCoordinateSystemUnits());
        Element result = encoder.createObjectElement(this.getClass());
        Element ctorElement = encoder.createConstructorElement(args);
        result.appendChild(ctorElement);
        return result;
    }

    @Override
    public boolean initFromXml(XmlEncoder encoder, Element node) {
        return true;
    }
}

