/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.swing.JSVGCanvas;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.image.TIFFTranscoder;
import org.apache.fop.render.ps.PSTranscoder;
import org.apache.fop.svg.PDFTranscoder;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class Plotter {
    public static final int SVG = 0;
    public static final int PNG = 1;
    public static final int JPG = 2;
    public static final int PS = 3;
    public static final int PDF = 4;
    public static final int TIFF = 5;
    public static final int DIFAX = 6;
    public static final String[] FORMATS = new String[]{"svg", "png", "jpg", "ps", "pdf", "tiff", "difax"};
    Object document;
    private int format;
    private String filename;
    private boolean svgCompress = false;
    Color[] colours = null;
    private int colourDepth = 8;

    public Plotter(int format, String filename) {
        this.format = format;
        this.setFilename(filename);
    }

    public Plotter(String filename) {
        String tmp = filename.toLowerCase();
        boolean foundIt = false;
        for (int i = 0; i < FORMATS.length; ++i) {
            if (!tmp.endsWith("." + FORMATS[i])) continue;
            this.format = i;
            foundIt = true;
            break;
        }
        if (!foundIt) {
            throw new IllegalArgumentException("Unknown file format:" + filename);
        }
        this.setFilename(filename);
    }

    public Plotter(int format, String filename, boolean monochrome) {
        this(format, filename);
        if (monochrome) {
            this.setColourDepth(1);
        }
    }

    public void handleError(Exception exc) throws Exception {
        throw exc;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setMonochrome(boolean monochrome) {
        if (monochrome) {
            this.setColourDepth(1);
        }
    }

    public void setColourDepth(int colourDepth) {
        this.colourDepth = colourDepth;
    }

    public int getFormat() {
        return this.format;
    }

    public void plot(Plottable plottable) throws FileNotFoundException, IOException, Exception {
        if (this.colourDepth > 1) {
            this.colours = plottable.getColours();
        }
        Graphics2D graphics = this.initialiseDocument(plottable);
        plottable.plot(graphics);
        this.finaliseDocument(graphics);
        graphics.dispose();
    }

    public JComponent getPreview(Plottable plottable) throws FileNotFoundException, IOException {
        int MAX_WIDTH = 800;
        int MAX_HEIGHT = 600;
        Graphics2D graphics = this.initialiseDocument(plottable);
        plottable.plot(graphics);
        SVGDocument svgDocument = (SVGDocument)this.document;
        Element docRoot = svgDocument.getDocumentElement();
        Element svgRoot = ((SVGGraphics2D)graphics).getRoot(docRoot);
        int[] chartSize = plottable.getSize();
        int viewWidth = chartSize[0];
        int viewHeight = chartSize[1];
        if (viewWidth > 800) {
            viewWidth = 800;
        }
        if (viewHeight > 600) {
            viewHeight = 600;
        }
        Dimension preferredSize = new Dimension(viewWidth, viewHeight);
        JSVGCanvas canvas = null;
        if (this.document instanceof SVGDocument) {
            canvas = new JSVGCanvas();
            canvas.setPreferredSize(preferredSize);
            canvas.setSVGDocument(svgDocument);
            canvas.setDoubleBufferedRendering(true);
        }
        return canvas;
    }

    private Graphics2D initialiseDocument(Plottable plottable) throws FileNotFoundException, IOException {
        Graphics2D graphics = null;
        if (this.format == 0) {
            graphics = this.initialiseSVG(plottable);
        } else if (this.format == 1) {
            graphics = this.initialisePNG(plottable);
        } else if (this.format == 2) {
            graphics = this.initialiseJPG(plottable);
        } else if (this.format == 4) {
            graphics = this.initialisePDF(plottable);
        } else if (this.format == 3) {
            graphics = this.initialisePS2(plottable);
        } else if (this.format == 5) {
            graphics = this.initialiseTIFF(plottable);
        } else if (this.format == 6) {
            graphics = this.initialiseDIFAX(plottable);
        } else {
            System.err.println("Bad Format: " + this.format);
        }
        return graphics;
    }

    private void finaliseDocument(Graphics2D graphics) throws IOException, Exception {
        if (this.format == 0) {
            this.finaliseSVG(graphics);
        } else if (this.format == 1) {
            this.finalisePNG(graphics);
        } else if (this.format == 2) {
            this.finaliseJPG(graphics);
        } else if (this.format == 4) {
            this.finalisePDF(graphics);
        } else if (this.format == 3) {
            this.finalisePS2(graphics);
        } else if (this.format == 5) {
            this.finaliseTIFF(graphics);
        } else if (this.format == 6) {
            this.finaliseDIFAX(graphics);
        }
    }

    private Graphics2D initialiseSVG(Plottable plottable) {
        int[] chartSize = plottable.getSize();
        int width = chartSize[0];
        int height = chartSize[1];
        Dimension size = new Dimension(width, height);
        DOMImplementation domImpl = SVGDOMImplementation.getDOMImplementation();
        String nameSpace = "http://www.w3.org/2000/svg";
        this.document = domImpl.createDocument(nameSpace, "svg", null);
        SVGGraphics2D graphics2d = new SVGGraphics2D((Document)this.document);
        graphics2d.setSVGCanvasSize(size);
        return graphics2d;
    }

    private void finaliseSVG(Graphics2D graphics) throws Exception {
        Document svgDocument = (Document)this.document;
        Element docRoot = svgDocument.getDocumentElement();
        Element svgRoot = ((SVGGraphics2D)graphics).getRoot(docRoot);
        int viewWidth = 800;
        int viewHeight = 600;
        Rectangle size = graphics.getClipBounds();
        if (size != null) {
            viewWidth = (int)size.getWidth();
            viewHeight = (int)size.getHeight();
        }
        svgRoot.setAttributeNS(null, "viewBox", "0, 0, " + String.valueOf(viewWidth) + ", " + String.valueOf(viewHeight));
        svgRoot.setAttributeNS(null, "color-rendering", "optimizeSpeed");
        try {
            OutputStreamWriter outWriter = null;
            BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(this.filename));
            if (this.svgCompress) {
                GZIPOutputStream gzipStream = new GZIPOutputStream(outStream);
                outWriter = new OutputStreamWriter((OutputStream)gzipStream, "UTF-8");
            } else {
                outWriter = new OutputStreamWriter((OutputStream)outStream, "UTF-8");
            }
            ((SVGGraphics2D)graphics).stream(docRoot, (Writer)outWriter);
            ((Writer)outWriter).flush();
            ((Writer)outWriter).close();
            outStream.flush();
            outStream.close();
        }
        catch (FileNotFoundException e) {
            this.handleError(e);
            System.err.println("VectorPlotter.generateSVGFile: " + e);
        }
        catch (IOException e) {
            this.handleError(e);
            System.err.println("VectorPlotter.generateSVGFile: " + e);
        }
    }

    private Graphics2D initialisePNG(Plottable plottable) {
        Graphics2D graphics2d = this.initialiseSVG(plottable);
        return graphics2d;
    }

    private Graphics2D initialiseTIFF(Plottable plottable) {
        Graphics2D graphics2d = this.initialiseSVG(plottable);
        return graphics2d;
    }

    private Graphics2D initialiseJPG(Plottable plottable) {
        Graphics2D graphics2d = this.initialiseSVG(plottable);
        return graphics2d;
    }

    private Graphics2D initialisePDF(Plottable plottable) {
        Graphics2D graphics2d = this.initialiseSVG(plottable);
        return graphics2d;
    }

    private Graphics2D initialisePS2(Plottable plottable) {
        Graphics2D graphics2d = this.initialiseSVG(plottable);
        return graphics2d;
    }

    private Graphics2D initialiseDIFAX(Plottable plottable) {
        Graphics2D graphics2d = this.initialiseSVG(plottable);
        return graphics2d;
    }

    private void finalisePNG(Graphics2D graphics) throws Exception {
        Document svgDocument = (Document)this.document;
        Element docRoot = svgDocument.getDocumentElement();
        Element svgRoot = ((SVGGraphics2D)graphics).getRoot(docRoot);
        try {
            BufferedOutputStream pngStream = new BufferedOutputStream(new FileOutputStream(this.filename));
            TranscoderInput transcoderIn = new TranscoderInput(svgDocument);
            TranscoderOutput transcoderOut = new TranscoderOutput((OutputStream)pngStream);
            PNGTranscoder pngTranscoder = new PNGTranscoder();
            pngTranscoder.addTranscodingHint(ImageTranscoder.KEY_MEDIA, (Object)"screen");
            pngTranscoder.transcode(transcoderIn, transcoderOut);
            pngStream.flush();
            pngStream.close();
            if (this.colourDepth < 16) {
                File file = new File(this.filename);
                this.indexImage(this.colourDepth, file, "png");
            }
        }
        catch (FileNotFoundException e) {
            this.handleError(e);
            System.err.println("Plotter.finalisePNG: " + e);
        }
        catch (IOException e) {
            this.handleError(e);
            System.err.println("Plotter.finalisePNG: " + e);
        }
        catch (TranscoderException e) {
            this.handleError((Exception)((Object)e));
            System.err.println("Plotter.finalisePNG: " + (Object)((Object)e));
        }
    }

    private void finaliseTIFF(Graphics2D graphics) throws Exception {
        Document svgDocument = (Document)this.document;
        Element docRoot = svgDocument.getDocumentElement();
        Element svgRoot = ((SVGGraphics2D)graphics).getRoot(docRoot);
        try {
            BufferedOutputStream tiffStream = new BufferedOutputStream(new FileOutputStream(this.filename));
            TranscoderInput transcoderIn = new TranscoderInput(svgDocument);
            TranscoderOutput transcoderOut = new TranscoderOutput((OutputStream)tiffStream);
            TIFFTranscoder tiffTranscoder = new TIFFTranscoder();
            PNGTranscoder pngTranscoder = new PNGTranscoder();
            pngTranscoder.transcode(transcoderIn, transcoderOut);
            tiffStream.flush();
            tiffStream.close();
        }
        catch (FileNotFoundException e) {
            this.handleError(e);
            System.err.println("Plotter.finaliseTIFF: " + e);
        }
        catch (IOException e) {
            this.handleError(e);
            System.err.println("Plotter.finaliseTIFF: " + e);
        }
        catch (TranscoderException e) {
            this.handleError((Exception)((Object)e));
            System.err.println("Plotter.finaliseTIFF: " + (Object)((Object)e));
        }
    }

    private void finaliseJPG(Graphics2D graphics) throws Exception {
        Document svgDocument = (Document)this.document;
        Element docRoot = svgDocument.getDocumentElement();
        Element svgRoot = ((SVGGraphics2D)graphics).getRoot(docRoot);
        try {
            BufferedOutputStream jpgStream = new BufferedOutputStream(new FileOutputStream(this.filename));
            TranscoderInput transcoderIn = new TranscoderInput(svgDocument);
            TranscoderOutput transcoderOut = new TranscoderOutput((OutputStream)jpgStream);
            JPEGTranscoder jpgTranscoder = new JPEGTranscoder();
            jpgTranscoder.transcode(transcoderIn, transcoderOut);
            jpgStream.flush();
            jpgStream.close();
        }
        catch (FileNotFoundException e) {
            this.handleError(e);
            System.err.println("Plotter.finaliseJPG: " + e);
        }
        catch (IOException e) {
            this.handleError(e);
            System.err.println("Plotter.finaliseJPG: " + e);
        }
        catch (TranscoderException e) {
            this.handleError((Exception)((Object)e));
            System.err.println("Plotter.finaliseJPG: " + (Object)((Object)e));
        }
    }

    private void finalisePDF(Graphics2D graphics) throws Exception {
        Document svgDocument = (Document)this.document;
        Element docRoot = svgDocument.getDocumentElement();
        Element svgRoot = ((SVGGraphics2D)graphics).getRoot(docRoot);
        try {
            BufferedOutputStream pdfStream = new BufferedOutputStream(new FileOutputStream(this.filename));
            TranscoderInput transcoderIn = new TranscoderInput(svgDocument);
            TranscoderOutput transcoderOut = new TranscoderOutput((OutputStream)pdfStream);
            PDFTranscoder pdfTranscoder = new PDFTranscoder();
            pdfTranscoder.transcode(transcoderIn, transcoderOut);
            pdfStream.flush();
            pdfStream.close();
        }
        catch (FileNotFoundException e) {
            this.handleError(e);
            System.err.println("Plotter.finalisePDF: " + e);
        }
        catch (IOException e) {
            this.handleError(e);
            System.err.println("Plotter.finalisePDF: " + e);
        }
        catch (TranscoderException e) {
            this.handleError((Exception)((Object)e));
            System.err.println("Plotter.finalisePDF: " + (Object)((Object)e));
        }
    }

    private void finalisePS2(Graphics2D graphics) throws Exception {
        Document svgDocument = (Document)this.document;
        Element docRoot = svgDocument.getDocumentElement();
        Element svgRoot = ((SVGGraphics2D)graphics).getRoot(docRoot);
        Rectangle size = graphics.getClipBounds();
        int viewWidth = 800;
        int viewHeight = 600;
        if (size != null) {
            viewWidth = (int)size.getWidth();
            viewHeight = (int)size.getHeight();
        }
        svgRoot.setAttributeNS(null, "viewBox", "0, 0, " + String.valueOf(viewWidth) + ", " + String.valueOf(viewHeight));
        try {
            BufferedOutputStream psStream = new BufferedOutputStream(new FileOutputStream(this.filename));
            TranscoderInput transcoderIn = new TranscoderInput(svgDocument);
            TranscoderOutput transcoderOut = new TranscoderOutput((OutputStream)psStream);
            PSTranscoder psTranscoder = new PSTranscoder();
            psTranscoder.addTranscodingHint(PSTranscoder.KEY_WIDTH, (Object)new Float(viewWidth));
            psTranscoder.addTranscodingHint(PSTranscoder.KEY_HEIGHT, (Object)new Float(viewHeight));
            psTranscoder.transcode(transcoderIn, transcoderOut);
            psStream.flush();
            psStream.close();
        }
        catch (FileNotFoundException e) {
            this.handleError(e);
            System.err.println("Plotter.finalisePS2: " + e);
        }
        catch (IOException e) {
            this.handleError(e);
            System.err.println("Plotter.finalisePS2: " + e);
        }
        catch (TranscoderException e) {
            this.handleError((Exception)((Object)e));
            System.err.println("Plotter.finalisePS2: " + (Object)((Object)e));
        }
    }

    private void finaliseDIFAX(Graphics2D graphics) throws Exception {
        Document svgDocument = (Document)this.document;
        Element docRoot = svgDocument.getDocumentElement();
        Element svgRoot = ((SVGGraphics2D)graphics).getRoot(docRoot);
        try {
            BufferedOutputStream pngStream = new BufferedOutputStream(new FileOutputStream(this.filename));
            TranscoderInput transcoderIn = new TranscoderInput(svgDocument);
            TranscoderOutput transcoderOut = new TranscoderOutput((OutputStream)pngStream);
            PNGTranscoder pngTranscoder = new PNGTranscoder();
            pngTranscoder.addTranscodingHint(ImageTranscoder.KEY_MEDIA, (Object)"screen");
            pngTranscoder.addTranscodingHint(PNGTranscoder.KEY_INDEXED, (Object)new Integer(1));
            svgRoot.setAttributeNS(null, "shape-rendering", "crispEdges");
            svgRoot.setAttributeNS(null, "text-rendering", "optimizeSpeed");
            pngTranscoder.transcode(transcoderIn, transcoderOut);
            pngStream.flush();
            pngStream.close();
            File file = new File(this.filename);
            this.indexImage(1, file, "png");
        }
        catch (FileNotFoundException e) {
            this.handleError(e);
            System.err.println("Plotter.finaliseDIFAX: " + e);
        }
        catch (IOException e) {
            this.handleError(e);
            System.err.println("Plotter.finaliseDIFAX: " + e);
        }
        catch (TranscoderException e) {
            this.handleError((Exception)((Object)e));
            System.err.println("Plotter.finaliseDIFAX: " + (Object)((Object)e));
        }
    }

    private void indexImage(int depth, File file, String format) throws Exception {
        try {
            BufferedImage image32 = ImageIO.read(file);
            BufferedImage indexed = this.indexImage(image32, depth);
            ImageIO.write((RenderedImage)indexed, format, file);
        }
        catch (Exception e) {
            this.handleError(e);
            e.printStackTrace();
        }
    }

    private static byte[] splitRGB(int rgb) {
        byte[] bytes = new byte[]{(byte)(rgb >> 16 & 0xFF), (byte)(rgb >> 8 & 0xFF), (byte)(rgb >> 0 & 0xFF)};
        return bytes;
    }

    private static byte[][] makeIndexTable(ArrayList colours, int depth) {
        int i;
        int numColours = colours.size();
        int tableSize = 1 << depth;
        byte[][] table = new byte[3][tableSize];
        for (i = 0; i < numColours; ++i) {
            int rgbInt = (Integer)colours.get(i);
            byte[] rgb = Plotter.splitRGB(rgbInt);
            if (i >= tableSize) continue;
            table[0][i] = rgb[0];
            table[1][i] = rgb[1];
            table[2][i] = rgb[2];
        }
        if (tableSize > numColours) {
            for (i = numColours; i < tableSize; ++i) {
                table[0][i] = -1;
                table[1][i] = -1;
                table[2][i] = -1;
            }
        }
        return table;
    }

    private ArrayList reduceColours(Hashtable weightTable, int newSize) {
        ArrayList<Object> reduced = new ArrayList<Object>();
        Enumeration keys = weightTable.keys();
        int numColours = weightTable.size();
        Object[] sorted = new Integer[numColours];
        if (numColours <= newSize) {
            while (keys.hasMoreElements()) {
                reduced.add(keys.nextElement());
            }
            return reduced;
        }
        for (int i = 0; i < numColours; ++i) {
            Integer rgb = (Integer)keys.nextElement();
            Integer count = (Integer)weightTable.get(rgb);
            sorted[i] = count;
        }
        Arrays.sort(sorted);
        int sortedLen = sorted.length;
        if (sortedLen == 0) {
            return reduced;
        }
        for (int i = 0; i < newSize; ++i) {
            Object tableWeight = sorted[sortedLen - i - 1];
            keys = weightTable.keys();
            boolean found = false;
            for (int j = 0; j < weightTable.size(); ++j) {
                Integer rgb = (Integer)keys.nextElement();
                Integer weight = (Integer)weightTable.get(rgb);
                if (found || !weight.equals(tableWeight)) continue;
                reduced.add(rgb);
                weightTable.remove(rgb);
                found = true;
            }
        }
        return reduced;
    }

    private void monochromatise(BufferedImage imageDepthN) {
        int xSize = imageDepthN.getWidth();
        int ySize = imageDepthN.getHeight();
        int WHITE = 0xFFFFFF;
        int GRAY = 0xBBBBBB;
        int BLACK = 0;
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                int rgb = imageDepthN.getRGB(i, j) & 0xFFFFFF;
                if (rgb < GRAY) {
                    rgb = BLACK;
                }
                imageDepthN.setRGB(i, j, rgb);
            }
        }
    }

    private BufferedImage indexImage(BufferedImage image32, int depth) throws IOException {
        int numColours;
        int PALETTE_SIZE = 1 << depth;
        ArrayList colourList = new ArrayList();
        ArrayList<Integer> reservedList = new ArrayList<Integer>();
        Hashtable<Integer, Integer> colourWeights = new Hashtable<Integer, Integer>();
        if (this.colours != null) {
            for (int i = 0; i < this.colours.length; ++i) {
                int rgbInt = this.colours[i].getRGB() & 0xFFFFFF;
                Integer rgb = new Integer(rgbInt);
                colourList.add(rgb);
                reservedList.add(rgb);
            }
        }
        int xSize = image32.getWidth();
        int ySize = image32.getHeight();
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                Integer count;
                int rgb = image32.getRGB(i, j) & 0xFFFFFF;
                Integer rgbInteger = new Integer(rgb);
                if (!colourList.contains(rgbInteger)) {
                    colourList.add(rgbInteger);
                }
                int weight = 1;
                if (reservedList.contains(rgbInteger)) {
                    weight = 1000;
                }
                if ((count = (Integer)colourWeights.get(rgbInteger)) == null) {
                    colourWeights.put(rgbInteger, new Integer(weight));
                    continue;
                }
                int countInt = count + weight;
                colourWeights.remove(rgbInteger);
                colourWeights.put(rgbInteger, new Integer(countInt));
            }
        }
        if (depth > 1) {
            colourList = this.reduceColours(colourWeights, PALETTE_SIZE);
        }
        if ((numColours = colourList.size()) > 1 << depth) {
            numColours = 1 << depth;
        }
        byte[][] table = Plotter.makeIndexTable(colourList, depth);
        BufferedImage indexImage = null;
        if (depth < 2) {
            this.monochromatise(image32);
            indexImage = new BufferedImage(xSize, ySize, 12);
        } else {
            IndexColorModel colorModel = new IndexColorModel(depth, numColours, table[0], table[1], table[2]);
            indexImage = new BufferedImage(xSize, ySize, 13, colorModel);
        }
        for (int i = 0; i < xSize; ++i) {
            for (int j = 0; j < ySize; ++j) {
                int rgb = image32.getRGB(i, j);
                indexImage.setRGB(i, j, rgb);
            }
        }
        return indexImage;
    }

    public static interface Plottable {
        public void plot(Graphics2D var1);

        public Color[] getColours();

        public int[] getSize();
    }
}

