/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad;

import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.ProjectionPointImpl;
import visad.VisADException;
import visad.georef.MapProjection;
import visad.georef.TrivialMapProjection;

public class MapProjectionProjection
extends ProjectionImpl {
    private int xIndex = 0;
    private int yIndex = 1;
    private MapProjection mapProjection;

    @Override
    public ProjectionImpl constructCopy() {
        return new MapProjectionProjection(this.getMapProjection());
    }

    public MapProjectionProjection() {
        this(null);
    }

    public MapProjectionProjection(MapProjection mapProjection) {
        super("", false);
        if (mapProjection == null) {
            try {
                mapProjection = new TrivialMapProjection();
            }
            catch (VisADException visADException) {
                // empty catch block
            }
        }
        this.mapProjection = mapProjection;
        this.xIndex = mapProjection.isXYOrder() ? 0 : 1;
        this.yIndex = mapProjection.isXYOrder() ? 1 : 0;
        this.addParameter("grid_mapping_name", "visad_mapprojection");
    }

    public Object clone() {
        return this.constructCopy();
    }

    @Override
    public boolean equals(Object proj) {
        if (!(proj instanceof MapProjectionProjection)) {
            return false;
        }
        MapProjectionProjection oo = (MapProjectionProjection)proj;
        return true;
    }

    @Override
    public String getProjectionTypeLabel() {
        return "MapProjectionProjection";
    }

    @Override
    public String paramsToString() {
        return this.mapProjection.toString();
    }

    @Override
    public ProjectionPoint latLonToProj(LatLonPoint latLon, ProjectionPointImpl result) {
        double fromLat = latLon.getLatitude();
        double fromLon = latLon.getLongitude();
        double[][] point = new double[2][1];
        point[0][0] = fromLat;
        point[1][0] = fromLon;
        point = this.latLonToProj(point, 0, 1);
        result.setLocation(point[this.xIndex][0], point[this.yIndex][0]);
        return result;
    }

    @Override
    public LatLonPoint projToLatLon(ProjectionPoint world, LatLonPointImpl result) {
        double x = world.getX();
        double y = world.getY();
        double[][] point = new double[2][1];
        point[this.xIndex][0] = x;
        point[this.yIndex][0] = y;
        point = this.projToLatLon(point);
        result.setLatitude(point[0][0]);
        result.setLongitude(point[1][0]);
        return result;
    }

    @Override
    public float[][] latLonToProj(float[][] from, float[][] to, int latIndex, int lonIndex) {
        Object temp = new float[2][];
        temp[this.mapProjection.getLatitudeIndex()] = from[latIndex];
        temp[this.mapProjection.getLongitudeIndex()] = from[lonIndex];
        try {
            temp = this.mapProjection.fromReference((float[][])temp);
            to[0] = temp[this.xIndex];
            to[1] = temp[this.yIndex];
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        return to;
    }

    @Override
    public boolean crossSeam(ProjectionPoint pt1, ProjectionPoint pt2) {
        return ProjectionPointImpl.isInfinite(pt1) || ProjectionPointImpl.isInfinite(pt2);
    }

    @Override
    public float[][] projToLatLon(float[][] from, float[][] to) {
        Object temp = new float[2][];
        temp[this.xIndex] = from[0];
        temp[this.yIndex] = from[1];
        try {
            temp = this.mapProjection.toReference((float[][])temp);
            to[0] = temp[this.mapProjection.getLatitudeIndex()];
            to[1] = temp[this.mapProjection.getLongitudeIndex()];
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        return to;
    }

    @Override
    public double[][] latLonToProj(double[][] from, double[][] to, int latIndex, int lonIndex) {
        Object temp = new double[2][];
        temp[this.mapProjection.getLatitudeIndex()] = from[latIndex];
        temp[this.mapProjection.getLongitudeIndex()] = from[lonIndex];
        try {
            temp = this.mapProjection.fromReference((double[][])temp);
            to[0] = temp[this.xIndex];
            to[1] = temp[this.yIndex];
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        return to;
    }

    @Override
    public double[][] projToLatLon(double[][] from, double[][] to) {
        Object temp = new double[2][];
        temp[this.xIndex] = from[0];
        temp[this.yIndex] = from[1];
        try {
            temp = this.mapProjection.toReference((double[][])temp);
            to[0] = temp[this.mapProjection.getLatitudeIndex()];
            to[1] = temp[this.mapProjection.getLongitudeIndex()];
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        return to;
    }

    public MapProjection getMapProjection() {
        return this.mapProjection;
    }

    public static void main(String[] args) {
        MapProjectionProjection a = new MapProjectionProjection();
        ProjectionPoint p = a.latLonToProj(89.0, -101.0);
        System.out.println("proj point = " + p);
        LatLonPoint ll = a.projToLatLon(p);
        System.out.println("ll = " + ll);
    }
}

