/*
 * Decompiled with CFR 0.152.
 */
package ucar.visad;

import java.awt.Component;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Element;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.Range;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.XmlUtil;
import visad.LinearLatLonSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;
import visad.georef.EarthLocation;
import visad.georef.EarthLocationTuple;
import visad.georef.LatLonPoint;

public class GeoUtils {
    public static String lastAddress = "";
    private static List addresses = new ArrayList();
    private static Hashtable addressMap = new Hashtable();
    public static final String addressToolTip = "Examples:<br>12345 oak street, my town, my state<br>Or: my town, my state<br>Or: 80303 (zip code)<br>Or: latitude longitude<br>Or: \"ip\" for the location of this computer";

    private GeoUtils() {
    }

    public static EarthLocation toEarthLocation(LatLonPoint llp) throws VisADException, RemoteException {
        return new EarthLocationTuple(llp.getLatitude(), llp.getLongitude(), new Real(RealType.Altitude, 0.0));
    }

    public static LatLonPoint getLocationOfAddress() {
        return GeoUtils.getLocationOfAddress(null);
    }

    public static LinearLatLonSet latLonRectToSet(LatLonRect rect) throws VisADException {
        LinearLatLonSet bounds = new LinearLatLonSet((MathType)RealTupleType.LatitudeLongitudeTuple, rect.getLatMin(), rect.getLatMin() + rect.getHeight(), 11, rect.getLonMin(), rect.getLonMin() + rect.getWidth(), 11);
        return bounds;
    }

    public static LatLonPoint getLocationOfAddress(JComponent extraComp) {
        String address = lastAddress;
        JComponent bottom = new JLabel("<html>Examples:<br>12345 oak street, my town, my state<br>Or: my town, my state<br>Or: 80303 (zip code)<br>Or: latitude longitude<br>Or: \"ip\" for the location of this computer</html>");
        if (extraComp != null) {
            bottom = GuiUtils.vbox(bottom, extraComp);
        }
        if (!addresses.contains("ipaddress")) {
            // empty if block
        }
        JComboBox addressBox = new JComboBox(new Vector(addresses));
        addressBox.setToolTipText("<html>Examples:<br>12345 oak street, my town, my state<br>Or: my town, my state<br>Or: 80303 (zip code)<br>Or: latitude longitude<br>Or: \"ip\" for the location of this computer</html>");
        addressBox.setEditable(true);
        JPanel contents = GuiUtils.label("Address: ", addressBox);
        contents = GuiUtils.inset((Component)contents, 5);
        if (extraComp != null) {
            contents = GuiUtils.vbox((Component)contents, extraComp);
            contents = GuiUtils.inset((Component)contents, 5);
        }
        do {
            if (!GuiUtils.showOkCancelDialog(null, "Go To Address", contents, null, Misc.newList(addressBox))) {
                return null;
            }
            address = (String)addressBox.getSelectedItem();
            if (address == null) {
                address = (String)addressBox.getEditor().getItem();
            }
            if (address == null) {
                return null;
            }
            lastAddress = address;
            LatLonPoint llp = GeoUtils.getLocationFromAddress(address, null);
            if (llp == null) continue;
            return llp;
        } while (GuiUtils.askYesNo("Address lookup error", "<html>Could not find the given address.<p>Do you want to try again?</html>"));
        return null;
    }

    public static LatLonPoint getLocationFromAddress(String address, int[] master) {
        try {
            String tmp;
            int timestamp = 0;
            if (master != null) {
                timestamp = master[0];
            }
            if (address == null) {
                return null;
            }
            if ((address = address.trim()).length() == 0) {
                return null;
            }
            while (address.indexOf(" ,") >= 0) {
                address = StringUtil.replace(address, " ,", ",");
            }
            while (address.indexOf(", ") >= 0) {
                address = StringUtil.replace(address, ", ", ",");
            }
            LatLonPoint llp = (LatLonPoint)addressMap.get(address);
            if (llp != null) {
                return llp;
            }
            String latString = null;
            String lonString = null;
            String encodedAddress = StringUtil.replace(address, " ", "%20");
            if (latString == null || lonString == null) {
                tmp = address;
                while (tmp.indexOf(",") >= 0) {
                    tmp = StringUtil.replace(address, ",", " ");
                }
                while (tmp.indexOf("  ") >= 0) {
                    tmp = StringUtil.replace(tmp, "  ", " ");
                }
                List<String> toks = StringUtil.split(tmp, " ");
                if (toks != null && toks.size() == 2) {
                    try {
                        double latValue = Misc.decodeLatLon(toks.get(0));
                        double lonValue = Misc.decodeLatLon(toks.get(1));
                        if (!Double.isNaN(latValue) && !Double.isNaN(lonValue)) {
                            latString = "" + latValue;
                            lonString = "" + lonValue;
                        }
                    }
                    catch (NumberFormatException latValue) {
                        // empty catch block
                    }
                }
            }
            if (latString == null || lonString == null) {
                try {
                    tmp = address;
                    while (tmp.indexOf(" ") >= 0) {
                        tmp = StringUtil.replace(address, " ", "+");
                    }
                    String url = "http://maps.googleapis.com/maps/api/geocode/xml?sensor=false&address=" + tmp;
                    String result = IOUtil.readContents(url, GeoUtils.class);
                    if (master != null && master[0] != timestamp) {
                        return null;
                    }
                    Element root = XmlUtil.getRoot(result);
                    Element locele = XmlUtil.findDescendantFromPath(root, "result.geometry.location");
                    Element latNode = XmlUtil.findDescendant(locele, "lat");
                    Element lonNode = XmlUtil.findDescendant(locele, "lng");
                    if (latNode != null && lonNode != null) {
                        latString = XmlUtil.getChildText(latNode);
                        lonString = XmlUtil.getChildText(lonNode);
                    }
                }
                catch (Exception tmp2) {
                    // empty catch block
                }
            }
            if (latString != null && lonString != null) {
                double lat = Misc.decodeLatLon(latString.trim());
                double lon = Misc.decodeLatLon(lonString.trim());
                EarthLocationTuple el = new EarthLocationTuple(new Real(RealType.Latitude, lat), new Real(RealType.Longitude, lon), new Real(RealType.Altitude, 0.0));
                lastAddress = address;
                addresses.remove(address);
                addresses.add(0, address);
                addressMap.put(address, el.getLatLonPoint());
                while (addresses.size() > 20) {
                    addresses.remove(addresses.size() - 1);
                }
                return el.getLatLonPoint();
            }
        }
        catch (Exception exc) {
            LogUtil.logException("An error occurred reading address location", exc);
            return null;
        }
        return null;
    }

    public static List getSavedAddresses() {
        return addresses;
    }

    public static void setSavedAddresses(List add) {
        if (add == null) {
            return;
        }
        addresses = new ArrayList(add);
    }

    public static void initAddressBox(JComboBox box) {
        Object selected = box.getSelectedItem();
        GuiUtils.setListData(box, new Vector(addresses));
        if (selected != null) {
            box.setSelectedItem(selected);
        }
    }

    public static void main(String[] args) {
        for (String arg : args) {
            System.err.println(arg + " " + GeoUtils.getLocationFromAddress(arg, null));
        }
    }

    public static double normalizeLongitude(double lonValue) {
        if (lonValue == lonValue) {
            while (lonValue < -180.0 || lonValue > 180.0) {
                lonValue = Math.IEEEremainder(lonValue, 360.0);
            }
        }
        return lonValue;
    }

    public static double[] normalizeLongitude(double[] lonValues) {
        for (int i = 0; i < lonValues.length; ++i) {
            lonValues[i] = GeoUtils.normalizeLongitude(lonValues[i]);
        }
        return lonValues;
    }

    public static double normalizeLongitude(Range lonRange, double value) {
        if (value > 180.0 && (lonRange.getMin() < 0.0 || lonRange.getMax() < 0.0)) {
            return GeoUtils.normalizeLongitude(value);
        }
        if (value < 0.0 && (lonRange.getMin() > 180.0 || lonRange.getMax() > 180.0)) {
            return GeoUtils.normalizeLongitude360(value);
        }
        return value;
    }

    public static float normalizeLongitude(Range lonRange, float value) {
        if (value > 180.0f && (lonRange.getMin() < 0.0 || lonRange.getMax() < 0.0)) {
            return (float)GeoUtils.normalizeLongitude(value);
        }
        if (value < 0.0f && (lonRange.getMin() > 180.0 || lonRange.getMax() > 180.0)) {
            return (float)GeoUtils.normalizeLongitude360(value);
        }
        return value;
    }

    public static float[] normalizeLongitude(float[] lonValues) {
        for (int i = 0; i < lonValues.length; ++i) {
            lonValues[i] = (float)GeoUtils.normalizeLongitude(lonValues[i]);
        }
        return lonValues;
    }

    public static double normalizeLongitude360(double lonValue) {
        if (lonValue == lonValue) {
            while (lonValue < 0.0 || lonValue > 361.0) {
                lonValue = 180.0 + Math.IEEEremainder(lonValue - 180.0, 360.0);
            }
        }
        return lonValue;
    }

    public static double[] normalizeLongitude360(double[] lonValues) {
        for (int i = 0; i < lonValues.length; ++i) {
            lonValues[i] = GeoUtils.normalizeLongitude360(lonValues[i]);
        }
        return lonValues;
    }

    public static float[] normalizeLongitude360(float[] lonValues) {
        for (int i = 0; i < lonValues.length; ++i) {
            lonValues[i] = (float)GeoUtils.normalizeLongitude360(lonValues[i]);
        }
        return lonValues;
    }
}

