/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.xml;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.xerces.impl.dv.util.Base64;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.util.Trace;
import ucar.unidata.xml.XmlNodeList;

public abstract class XmlUtil {
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>";
    public static final String TAG_WILDCARD = "*";
    private static final Map<String, XPathExpression> pathMap = new ConcurrentHashMap<String, XPathExpression>();
    public static final String NULL_STRING = null;
    private static final String HMAC_SHA1_ALGORITHM = "HmacSHA1";

    public static String quote(String value) {
        return "\"" + value + "\"";
    }

    public static String encodeBase64(byte[] b) {
        return Base64.encode((byte[])b);
    }

    public static byte[] decodeBase64(String s) {
        return Base64.decode((String)s);
    }

    public static String comment(String value) {
        return "<!-- " + value + "-->\n";
    }

    public static void attr(Appendable buff, String name, String value, String tab) {
        try {
            buff.append(" ");
            buff.append(name);
            buff.append("=\"");
            value = value.trim();
            for (int i = 0; i < 5; ++i) {
                value = StringUtil.replace(value, "  ", " ");
            }
            buff.append(XmlUtil.encodeString(value));
            buff.append("\"");
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static String attr(String name, String value) {
        return " " + name + "=" + XmlUtil.quote(XmlUtil.encodeString(value)) + " ";
    }

    public static String attrs(String[] attrs) {
        StringBuffer a = new StringBuffer();
        for (int i = 0; i < attrs.length; i += 2) {
            a.append(XmlUtil.attr(attrs[i], attrs[i + 1]));
        }
        return a.toString();
    }

    public static String attrs(String name, String value) {
        return " " + name + "=" + XmlUtil.quote(XmlUtil.encodeString(value)) + " ";
    }

    public static String attrs(String n1, String v1, String n2, String v2) {
        return XmlUtil.attr(n1, v1) + XmlUtil.attr(n2, v2);
    }

    public static String attrs(String n1, String v1, String n2, String v2, String n3, String v3) {
        return XmlUtil.attrs(n1, v1, n2, v2) + XmlUtil.attr(n3, v3);
    }

    public static String attrs(String n1, String v1, String n2, String v2, String n3, String v3, String n4, String v4) {
        return XmlUtil.attrs(n1, v1, n2, v2, n3, v3) + XmlUtil.attr(n4, v4);
    }

    public static String tag(String name, String attrs, String contents) {
        return "<" + name + (attrs.length() > 0 ? " " : "") + attrs + ">" + contents + "</" + name + ">\n";
    }

    public static String tag(String name, String attrs) {
        return "<" + name + (attrs.length() > 0 ? " " : "") + attrs + "/>";
    }

    public static String openTag(String name, String attrs) {
        return "<" + name + (attrs.length() > 0 ? " " : "") + attrs + ">";
    }

    public static String openTag(String name) {
        return "<" + name + ">";
    }

    public static String closeTag(String name) {
        return "</" + name + ">\n";
    }

    public static String getAttributeFromTree(Node element, String name) {
        return XmlUtil.getAttributeFromTree(element, name, null);
    }

    public static String getAttributeFromTree(Node element, String name, String dflt) {
        Node parent;
        if (element == null) {
            return dflt;
        }
        String value = XmlUtil.getAttribute(element, name, (String)null);
        if (value == null && (parent = element.getParentNode()) != null) {
            value = XmlUtil.getAttributeFromTree(parent, name, dflt);
        }
        if (value == null) {
            return dflt;
        }
        return value;
    }

    public static int getAttributeFromTree(Node element, String name, int dflt) {
        if (element == null) {
            return dflt;
        }
        String value = XmlUtil.getAttributeFromTree(element, name);
        if (value == null) {
            return dflt;
        }
        return Integer.decode(value);
    }

    public static boolean getAttributeFromTree(Node element, String name, boolean dflt) {
        if (element == null) {
            return dflt;
        }
        String value = XmlUtil.getAttributeFromTree(element, name);
        if (value == null) {
            return dflt;
        }
        return new Boolean(value);
    }

    public static List getAttributesFromTree(Node element, String name, Hashtable tags) {
        return XmlUtil.getAttributesFromTree(element, name, tags, null);
    }

    public static List getAttributesFromTree(Node element, String name, Hashtable tags, List listOfValues) {
        String value;
        String tag;
        if (tags != null && element instanceof Element && tags.get(tag = XmlUtil.getLocalName((Element)element)) == null) {
            return listOfValues;
        }
        Node parent = element.getParentNode();
        if (parent != null) {
            listOfValues = XmlUtil.getAttributesFromTree(parent, name, tags, listOfValues);
        }
        if ((value = XmlUtil.getAttribute(element, name, (String)null)) != null) {
            if (listOfValues == null) {
                listOfValues = new ArrayList<String>();
            }
            listOfValues.add(value);
        }
        return listOfValues;
    }

    public static boolean hasAttribute(Node element, String attributeName) {
        return XmlUtil.getAttribute(element, attributeName, (String)null) != null;
    }

    public static String getAttribute(Node element, String name) {
        return XmlUtil.getAttribute(element.getAttributes(), name);
    }

    public static void ensureAttributes(Node element, String[] attrs) {
        for (int i = 0; i < attrs.length; ++i) {
            XmlUtil.getAttribute(element, attrs[i]);
        }
    }

    public static String getAttribute(Node element, String name, String dflt) {
        if (element == null) {
            return dflt;
        }
        return XmlUtil.getAttribute(element.getAttributes(), name, dflt);
    }

    public static boolean getAttribute(Node element, String name, boolean dflt) {
        if (element == null) {
            return dflt;
        }
        return XmlUtil.getAttribute(element.getAttributes(), name, dflt);
    }

    public static int getAttribute(Node element, String name, int dflt) {
        if (element == null) {
            return dflt;
        }
        return XmlUtil.getAttribute(element.getAttributes(), name, dflt);
    }

    public static float getAttribute(Node element, String name, float dflt) {
        if (element == null) {
            return dflt;
        }
        return XmlUtil.getAttribute(element.getAttributes(), name, dflt);
    }

    public static double getAttribute(Node element, String name, double dflt) {
        if (element == null) {
            return dflt;
        }
        return XmlUtil.getAttribute(element.getAttributes(), name, dflt);
    }

    public static Color getAttribute(Node element, String name, Color dflt) {
        if (element == null) {
            return dflt;
        }
        return XmlUtil.getAttribute(element.getAttributes(), name, dflt);
    }

    public static String getAttribute(NamedNodeMap attrs, String name) {
        String value = XmlUtil.getAttribute(attrs, name, (String)null);
        if (value == null) {
            throw new IllegalArgumentException("Could not find xml attribute:" + name);
        }
        return value;
    }

    public static String getAttribute(NamedNodeMap attrs, String name, String dflt) {
        if (attrs == null) {
            return dflt;
        }
        Node n = attrs.getNamedItem(name);
        return n == null ? dflt : n.getNodeValue();
    }

    public static int getAttribute(NamedNodeMap attrs, String name, int dflt) {
        if (attrs == null) {
            return dflt;
        }
        Node n = attrs.getNamedItem(name);
        return n == null ? dflt : new Integer(n.getNodeValue());
    }

    public static float getAttribute(NamedNodeMap attrs, String name, float dflt) {
        if (attrs == null) {
            return dflt;
        }
        Node n = attrs.getNamedItem(name);
        return n == null ? dflt : new Float(n.getNodeValue()).floatValue();
    }

    public static double getAttribute(NamedNodeMap attrs, String name, double dflt) {
        if (attrs == null) {
            return dflt;
        }
        Node n = attrs.getNamedItem(name);
        return n == null ? dflt : new Double(n.getNodeValue());
    }

    public static boolean getAttribute(NamedNodeMap attrs, String name, boolean dflt) {
        if (attrs == null) {
            return dflt;
        }
        Node n = attrs.getNamedItem(name);
        return n == null ? dflt : new Boolean(n.getNodeValue());
    }

    public static Color getAttribute(NamedNodeMap attrs, String name, Color dflt) {
        if (attrs == null) {
            return dflt;
        }
        Node n = attrs.getNamedItem(name);
        if (n == null) {
            return dflt;
        }
        return GuiUtils.decodeColor(n.getNodeValue(), dflt);
    }

    public static void setAttribute(Element node, String name, Color value) {
        node.setAttribute(name, "" + value.getRed() + "," + value.getGreen() + "," + value.getBlue());
    }

    public static void mergeAttributes(Element n1, Element n2) {
        if (n1 == null || n2 == null) {
            return;
        }
        NamedNodeMap nnm = n2.getAttributes();
        if (nnm == null) {
            return;
        }
        for (int i = 0; i < nnm.getLength(); ++i) {
            Attr attr = (Attr)nnm.item(i);
            n1.setAttribute(attr.getNodeName(), attr.getNodeValue());
        }
    }

    public static void setAttributes(Element node, String[] attrs) {
        for (int i = 0; i < attrs.length; i += 2) {
            node.setAttribute(attrs[i], attrs[i + 1]);
        }
    }

    public static Element findChild(Node parent, String tag) {
        List found = XmlUtil.findChildren(parent, tag);
        if (found.size() > 0) {
            return (Element)found.get(0);
        }
        return null;
    }

    public static List findChildrenRecurseUp(Node parent, String tag) {
        List results = XmlUtil.findChildren(parent, tag);
        if ((parent = parent.getParentNode()) != null) {
            results.addAll(XmlUtil.findChildrenRecurseUp(parent, tag));
        }
        return results;
    }

    public static Element findChildRecurseUp(Node parent, String tag) {
        Element child = XmlUtil.findChild(parent, tag);
        if (child != null) {
            return child;
        }
        if ((parent = parent.getParentNode()) == null) {
            return null;
        }
        return XmlUtil.findChildRecurseUp(parent, tag);
    }

    public static List findChildren(Node parent, String tag) {
        ArrayList<Node> found = new ArrayList<Node>();
        NodeList children = parent.getChildNodes();
        boolean doAll = tag == null || tag.equals(TAG_WILDCARD);
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!doAll && !XmlUtil.isTag(child, tag)) continue;
            found.add(child);
        }
        return found;
    }

    public static void addChildren(Element element, List children) {
        for (int i = 0; i < children.size(); ++i) {
            element.appendChild((Element)children.get(i));
        }
    }

    public static Element findDescendant(Node parent, String tag) {
        ArrayList found = new ArrayList();
        XmlUtil.findDescendants(parent, tag, found);
        if (found.size() == 0) {
            return null;
        }
        return (Element)found.get(0);
    }

    public static List findDescendants(Node parent, String tag) {
        ArrayList found = new ArrayList();
        XmlUtil.findDescendants(parent, tag, found);
        return found;
    }

    public static Element findDescendantFromPath(Element parent, String path) {
        ArrayList results = new ArrayList();
        List<String> tags = StringUtil.split(path, ".");
        XmlUtil.findDescendantsFromPath(parent, tags, 0, results, "\t");
        if (results.size() > 0) {
            return (Element)results.get(0);
        }
        return null;
    }

    public static List findDescendantsFromPath(Element parent, String path) {
        ArrayList results = new ArrayList();
        List<String> tags = StringUtil.split(path, ".");
        XmlUtil.findDescendantsFromPath(parent, tags, 0, results, "\t");
        return results;
    }

    private static void findDescendantsFromPath(Element parent, List tags, int tagIdx, List results, String tab) {
        String tag = (String)tags.get(tagIdx);
        boolean lastTag = tagIdx == tags.size() - 1;
        NodeList elements = XmlUtil.getElements(parent);
        tab = tab + "\t";
        for (int i = 0; i < elements.getLength(); ++i) {
            Element child = (Element)elements.item(i);
            if (!tag.equals(TAG_WILDCARD) && !XmlUtil.isTag(child, tag)) continue;
            if (lastTag) {
                results.add(child);
                continue;
            }
            XmlUtil.findDescendantsFromPath(child, tags, tagIdx + 1, results, tab);
        }
    }

    private static void findDescendants(Node parent, String tag, List found) {
        if (XmlUtil.getNodeName(parent).equals(tag)) {
            found.add(parent);
        }
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            XmlUtil.findDescendants(child, tag, found);
        }
    }

    public static Element getRoot(String xml) throws Exception {
        return XmlUtil.getDocument(xml).getDocumentElement();
    }

    public static Element create(String tag, Element parent) throws Exception {
        return XmlUtil.create(parent.getOwnerDocument(), tag, parent);
    }

    public static Element create(String tag, Element parent, List attrs) throws Exception {
        return XmlUtil.create(parent.getOwnerDocument(), tag, parent, attrs);
    }

    public static Element create(Document doc, String tag) throws Exception {
        return XmlUtil.create(doc, tag, (String[])null);
    }

    public static Element create(Document doc, String tag, Element parent) throws Exception {
        Element child = doc.createElement(tag);
        if (parent != null) {
            parent.appendChild(child);
        }
        return child;
    }

    public static Element create(Document doc, String tag, Element parent, List attrs) throws Exception {
        Element child = XmlUtil.create(doc, tag, parent);
        if (attrs != null) {
            XmlUtil.setAttributes(child, Misc.listToStringArray(attrs));
        }
        return child;
    }

    public static Element create(Document doc, String tag, String[] attrs) throws Exception {
        return XmlUtil.create(doc, tag, (Element)null, attrs);
    }

    public static Element create(Document doc, String tag, Element parent, String[] attrs) throws Exception {
        Element child = XmlUtil.create(doc, tag, parent);
        if (attrs != null) {
            XmlUtil.setAttributes(child, attrs);
        }
        return child;
    }

    public static Element create(Document doc, String tag, Element parent, String text, String[] attrs) throws Exception {
        Element child = XmlUtil.create(doc, tag, parent, attrs);
        if (text != null) {
            Text textNode = doc.createTextNode(text);
            child.appendChild(textNode);
        }
        return child;
    }

    public static Element create(Document doc, String tag, Element parent, String text) throws Exception {
        return XmlUtil.create(doc, tag, parent, text, null);
    }

    public static Element create(String tag, Element parent, String[] attrs) throws Exception {
        return XmlUtil.create(parent.getOwnerDocument(), tag, parent, attrs);
    }

    public static Element create(String tag, Element parent, String text, String[] attrs) throws Exception {
        return XmlUtil.create(parent.getOwnerDocument(), tag, parent, text, attrs);
    }

    public static Element create(String tag, Element parent, String text) throws Exception {
        return XmlUtil.create(parent.getOwnerDocument(), tag, parent, text);
    }

    public static Element getRoot(String filename, Class originClass) throws Exception {
        Document doc = XmlUtil.getDocument(filename, originClass);
        if (doc == null) {
            return null;
        }
        return doc.getDocumentElement();
    }

    public static Element getRoot(InputStream stream) throws Exception {
        return XmlUtil.getDocument(stream).getDocumentElement();
    }

    public static Document getDocument(String filename, Class originClass) throws Exception {
        ArrayList errors = new ArrayList();
        if (!filename.startsWith("xml:")) {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputStream is = null;
            try {
                is = IOUtil.getInputStream(filename, XmlUtil.class);
            }
            catch (Exception exc) {
                return null;
            }
            MyErrorHandler errorHandler = new MyErrorHandler();
            builder.setErrorHandler(errorHandler);
            try {
                Trace.call1("XmlUtil.getDocument");
                Document doc = builder.parse(is);
                Trace.call2("XmlUtil.getDocument");
                return doc;
            }
            catch (Exception exc) {
                throw new IllegalStateException("Error parsing xml: " + filename + "\n" + exc.getMessage() + "\n" + errorHandler.errors);
            }
        }
        String xml = filename.substring(4);
        if (xml == null) {
            return null;
        }
        return XmlUtil.getDocument(xml);
    }

    public static Element findRoot(Element child) {
        Node parent = child.getParentNode();
        while (parent != null && parent instanceof Element) {
            child = (Element)parent;
            parent = child.getParentNode();
        }
        return child;
    }

    public static boolean isTag(Node node, String name) {
        if (name == null || name.equals(TAG_WILDCARD)) {
            return true;
        }
        String nodeName = node.getNodeName();
        if (XmlUtil.isFullyQualified(name)) {
            return nodeName.equals(name);
        }
        if (XmlUtil.isFullyQualified(nodeName)) {
            return Misc.equals(XmlUtil.getLocalName(node), name);
        }
        return Misc.equals(nodeName, name);
    }

    public static String getLocalName(Node element) {
        String localName = element.getLocalName();
        if (localName != null) {
            return localName;
        }
        String name = element.getNodeName();
        int idx = name.indexOf(":");
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        return name;
    }

    public static boolean isFullyQualified(String tagName) {
        return tagName.indexOf(":") >= 0;
    }

    public static String getNodeName(Node node) {
        String localName = node.getLocalName();
        if (localName != null) {
            return localName;
        }
        String name = node.getNodeName();
        int idx = name.indexOf(":");
        if (idx >= 0) {
            name = name.substring(idx + 1);
        }
        return name;
    }

    public static Element findAncestor(Element child, String tagName) {
        Node parentObj = child.getParentNode();
        if (!(parentObj instanceof Element)) {
            return null;
        }
        Element parent = (Element)parentObj;
        while (parent != null) {
            if (XmlUtil.isTag(parent, tagName)) {
                return parent;
            }
            parentObj = parent.getParentNode();
            if (!(parentObj instanceof Element)) {
                return null;
            }
            parent = (Element)parentObj;
        }
        return null;
    }

    public static Document makeDocument() {
        try {
            return XmlUtil.getDocument("");
        }
        catch (Exception exc) {
            System.err.println("Error making document: " + exc);
            return null;
        }
    }

    public static Document getDocument(String xml) throws Exception {
        xml = xml.trim();
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        if (xml.length() == 0) {
            return builder.newDocument();
        }
        MyErrorHandler errorHandler = new MyErrorHandler();
        builder.setErrorHandler(errorHandler);
        try {
            return builder.parse(new ByteArrayInputStream(xml.getBytes()));
        }
        catch (Exception exc) {
            throw new IllegalStateException("Error parsing xml: " + exc.getMessage() + "\n" + errorHandler.errors);
        }
    }

    public static Document getDocument(InputStream stream) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return builder.parse(stream);
    }

    public static Element getFirstChild(Element parent) {
        NodeList nodeList = XmlUtil.getElements(parent);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return (Element)nodeList.item(0);
    }

    public static NodeList getElements(Element parent) {
        return XmlUtil.getElements(parent, new XmlNodeList());
    }

    public static NodeList getElements(Element parent, XmlNodeList nodeList) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node o = children.item(i);
            if (!(o instanceof Element)) continue;
            nodeList.add(o);
        }
        return nodeList;
    }

    public static NodeList getGrandChildren(Element parent) {
        XmlNodeList nodeList = new XmlNodeList();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node o = children.item(i);
            if (!(o instanceof Element)) continue;
            XmlUtil.getElements((Element)o, nodeList);
        }
        return nodeList;
    }

    public static String getGrandChildText(Node parent, String childTag, String dflt) {
        String text = XmlUtil.getGrandChildText(parent, childTag);
        if (text == null) {
            return dflt;
        }
        if (text.length() == 0) {
            return dflt;
        }
        return text;
    }

    public static double getGrandChildValue(Node parent, String childTag, double dflt) {
        String text = XmlUtil.getGrandChildText(parent, childTag);
        if (text == null) {
            return dflt;
        }
        if ((text = text.trim()).length() == 0) {
            return dflt;
        }
        return new Double(text);
    }

    public static String getGrandChildText(Node parent, String childTag) {
        Element child = XmlUtil.findChild(parent, childTag);
        if (child != null) {
            return XmlUtil.getChildText(child);
        }
        return null;
    }

    public static void appendCdataBytes(StringBuffer sb, byte[] bytes) {
        sb.append("<![CDATA[");
        sb.append(XmlUtil.encodeBase64(bytes));
        sb.append("]]>");
    }

    public static void appendCdata(StringBuffer sb, String s) {
        sb.append("<![CDATA[");
        sb.append(s);
        sb.append("]]>");
    }

    public static String getCdata(String s) {
        return "<![CDATA[" + s + "]]>";
    }

    public static CDATASection makeCDataNode(Document doc, String text) {
        return XmlUtil.makeCDataNode(doc, text, true);
    }

    public static void createCDataNode(Element parent, String text) {
        parent.appendChild(XmlUtil.makeCDataNode(parent.getOwnerDocument(), text));
    }

    public static CDATASection makeCDataNode(Document doc, String text, boolean andEncode) {
        if (andEncode) {
            return doc.createCDATASection(XmlUtil.encodeBase64(text.getBytes()));
        }
        return doc.createCDATASection(text);
    }

    public static String getChildText(Node parent) {
        if (parent == null) {
            return null;
        }
        NodeList children = parent.getChildNodes();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3 && child.getNodeType() != 4) continue;
            sb.append(child.getNodeValue());
        }
        return sb.toString();
    }

    public static XmlNodeList getElements(Element parent, String tagName) {
        XmlNodeList nodeList = new XmlNodeList();
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node o = children.item(i);
            if (!(o instanceof Element)) continue;
            Element e = (Element)o;
            if (tagName != null && !XmlUtil.isTag(e, tagName)) continue;
            nodeList.add(e);
        }
        return nodeList;
    }

    public static Element getElement(Element parent, String tagName) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Element e;
            Node o = children.item(i);
            if (!(o instanceof Element) || !XmlUtil.isTag(e = (Element)o, tagName)) continue;
            return e;
        }
        return null;
    }

    public static List getListOfElements(Element parent) {
        NodeList elements = XmlUtil.getElements(parent);
        ArrayList<Node> result = new ArrayList<Node>();
        for (int i = 0; i < elements.getLength(); ++i) {
            result.add(elements.item(i));
        }
        return result;
    }

    public static String getHeader() {
        return XML_HEADER;
    }

    public static String toString(Node node) {
        return XmlUtil.toString(node, "  ", "\n");
    }

    public static String toStringNoChildren(Node node) {
        return XmlUtil.toString(node, "  ", "\n", false);
    }

    public static String toStringWithHeader(Node node) {
        return XmlUtil.toStringWithHeader(node, "  ", "\n");
    }

    public static String toString(Node node, boolean prettyPrint) {
        if (prettyPrint) {
            return XmlUtil.toString(node);
        }
        return XmlUtil.toString(node, "", "");
    }

    public static String toString(Node node, String tabSpacing, String newLine) {
        return XmlUtil.toString(node, tabSpacing, newLine, true);
    }

    public static String toString(Node node, String tabSpacing, String newLine, boolean recurse) {
        StringBuffer xml = new StringBuffer();
        XmlUtil.toString(xml, node, "", tabSpacing, newLine, false, recurse);
        return xml.toString();
    }

    public static String toStringWithHeader(Node node, String tabSpacing, String newLine) {
        return XmlUtil.toStringWithHeader(node, tabSpacing, newLine, false);
    }

    public static void toString(Node node, Appendable appendable) {
        XmlUtil.toString(appendable, node, "", "", "", false, true);
    }

    public static String toStringWithHeader(Node node, String tabSpacing, String newLine, boolean prettifyAttrs) {
        StringBuffer xml = new StringBuffer(XmlUtil.getHeader() + "\n");
        XmlUtil.toString(xml, node, "", tabSpacing, newLine, prettifyAttrs, true);
        return xml.toString();
    }

    private static void toString(Appendable xml, Node node, String currentTab, String tabSpacing, String newLine, boolean prettifyAttrs, boolean recurse) {
        try {
            short type = node.getNodeType();
            switch (type) {
                case 9: {
                    xml.append(XmlUtil.getHeader());
                    break;
                }
                case 1: {
                    String nextTab;
                    xml.append(currentTab);
                    xml.append('<');
                    xml.append(node.getNodeName());
                    NamedNodeMap nnm = node.getAttributes();
                    String attrTab = nextTab = currentTab + tabSpacing;
                    if (nnm != null) {
                        for (int i = 0; i < nnm.getLength(); ++i) {
                            Attr attr = (Attr)nnm.item(i);
                            if (prettifyAttrs && nnm.getLength() > 2) {
                                xml.append("\n");
                                xml.append(attrTab);
                            }
                            XmlUtil.attr(xml, attr.getNodeName(), attr.getNodeValue(), attrTab);
                        }
                    }
                    boolean wasText = false;
                    int cnt = 0;
                    NodeList children = node.getChildNodes();
                    int numChildren = children.getLength();
                    if (recurse) {
                        for (int i = 0; i < children.getLength(); ++i) {
                            Node child = children.item(i);
                            boolean bl = wasText = child.getNodeType() == 3 || child.getNodeType() == 4;
                            if (cnt == 0) {
                                xml.append(">");
                                if (!wasText || numChildren > 1) {
                                    xml.append(newLine);
                                }
                            }
                            XmlUtil.toString(xml, child, nextTab, tabSpacing, newLine, prettifyAttrs, true);
                            ++cnt;
                        }
                    }
                    if (cnt == 0) {
                        xml.append("/>");
                        xml.append(newLine);
                        break;
                    }
                    if (!wasText || cnt > 1) {
                        xml.append(currentTab);
                    }
                    xml.append("</");
                    xml.append(node.getNodeName());
                    xml.append(">");
                    xml.append(newLine);
                    break;
                }
                case 5: {
                    xml.append('&' + node.getNodeName() + ';');
                    break;
                }
                case 4: {
                    String value = node.getNodeValue();
                    if (value == null) break;
                    if (value.startsWith("XmlUtil.COMMENT:")) {
                        xml.append("\n<!--" + value.substring(16) + " -->\n");
                        break;
                    }
                    xml.append("<![CDATA[" + value + "]]>");
                    break;
                }
                case 3: {
                    String v = node.getNodeValue();
                    if (v == null) break;
                    xml.append(XmlUtil.encodeString(v));
                    break;
                }
                case 7: {
                    xml.append("<?" + node.getNodeName());
                    String data = node.getNodeValue();
                    if (data != null && data.length() > 0) {
                        xml.append(" " + data);
                    }
                    xml.append("?>");
                    break;
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public static void toHtml(StringBuffer html, Node node) {
        switch (node.getNodeType()) {
            case 1: {
                NodeList children = node.getChildNodes();
                int numChildren = children.getLength();
                html.append("<b>" + node.getNodeName().replace("_", " ") + "</b>");
                html.append(": ");
                for (int i = 0; i < numChildren; ++i) {
                    String v;
                    Node child = children.item(i);
                    if (child.getNodeType() != 3 && child.getNodeType() != 4 || (v = child.getNodeValue()) == null || v.trim().length() == 0) continue;
                    html.append(v);
                    html.append(" ");
                }
                boolean didone = false;
                NamedNodeMap nnm = node.getAttributes();
                if (nnm != null) {
                    for (int i = 0; i < nnm.getLength(); ++i) {
                        Attr attr = (Attr)nnm.item(i);
                        String attrName = attr.getNodeName();
                        if (attrName.startsWith("xmlns") || attrName.startsWith("xsi:")) continue;
                        if (!didone) {
                            html.append("<ul>");
                            didone = true;
                        }
                        html.append(attrName.replace("_", " ") + "=" + attr.getNodeValue());
                        html.append("<br>\n");
                    }
                }
                int cnt = 0;
                for (int i = 0; i < numChildren; ++i) {
                    Node child = children.item(i);
                    if (child.getNodeType() == 3 || child.getNodeType() == 4) continue;
                    if (!didone) {
                        html.append("<ul>");
                        didone = true;
                    }
                    if (cnt > 0) {
                        html.append("<br>");
                    }
                    XmlUtil.toHtml(html, child);
                    ++cnt;
                }
                if (!didone) break;
                html.append("</ul>");
                break;
            }
        }
    }

    public static String encodeString(String v) {
        return StringUtil.replaceList(v, new String[]{"&", "\"", "<", ">"}, new String[]{"&amp;", "&quot;", "&lt;", "&gt;"});
    }

    public static Element findElement(NodeList elements, String attributeName, String attributeValue) {
        for (int i = 0; i < elements.getLength(); ++i) {
            Element element = (Element)elements.item(i);
            String attr = element.getAttribute(attributeName);
            if (attr == null || !attr.equals(attributeValue)) continue;
            return element;
        }
        return null;
    }

    public static Element findElement(Element root, String tag, String attributeName, String attributeValue) {
        Element child;
        int i;
        if (tag == null || XmlUtil.isTag(root, tag)) {
            // empty if block
        }
        NodeList elements = XmlUtil.getElements(root);
        for (i = 0; i < elements.getLength(); ++i) {
            String attr;
            child = (Element)elements.item(i);
            if (tag != null && !XmlUtil.isTag(child, tag) || (attr = child.getAttribute(attributeName)) == null || !attr.equals(attributeValue)) continue;
            return child;
        }
        for (i = 0; i < elements.getLength(); ++i) {
            child = (Element)elements.item(i);
            Element found = XmlUtil.findElement(child, tag, attributeName, attributeValue);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static void removeChildren(Element parent) {
        Node child;
        while ((child = parent.getFirstChild()) != null) {
            parent.removeChild(child);
        }
    }

    public static Element findUrlRefNode(Element node, String urlAttr) {
        String url = XmlUtil.getAttribute((Node)node, urlAttr, (String)null);
        if (url == null) {
            return node;
        }
        try {
            return XmlUtil.getRoot(url, XmlUtil.class);
        }
        catch (Exception exc) {
            LogUtil.logException("Creating xml:" + url, exc);
            return node;
        }
    }

    public static Element findUrlRefNode(Element node) {
        return XmlUtil.findUrlRefNode(node, "url");
    }

    public static void main(String[] args) throws Exception {
        HashSet<String> seen = new HashSet<String>();
        boolean doFormat = true;
        boolean printTags = false;
        boolean generateCode = false;
        String packageName = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-format")) {
                doFormat = true;
                continue;
            }
            if (args[i].equals("-printtags")) {
                printTags = true;
                continue;
            }
            if (args[i].equals("-package")) {
                packageName = args[++i];
                continue;
            }
            if (args[i].equals("-generate")) {
                generateCode = true;
                continue;
            }
            if (generateCode) {
                XmlUtil.generateCode(args[i], packageName);
                continue;
            }
            if (printTags) {
                XmlUtil.printTags(args[i], seen);
                continue;
            }
            XmlUtil.format(args[i]);
        }
    }

    private static void printTags(Element node, HashSet<String> seen, StringBuffer tagBuff, StringBuffer attrBuff, StringBuffer topBuff) {
        NamedNodeMap nnm;
        String tagName = node.getTagName();
        if (!seen.contains("tag:" + tagName)) {
            seen.add("tag:" + tagName);
            String tmp = tagName.replace(":", "_").toUpperCase();
            tagBuff.append("public static final String TAG_" + tmp + " = \"" + tagName + "\";\n");
        }
        if ((nnm = node.getAttributes()) != null) {
            for (int i = 0; i < nnm.getLength(); ++i) {
                Attr attr = (Attr)nnm.item(i);
                String attrName = attr.getName();
                if (attrName.startsWith("xmlns")) {
                    seen.add("attr:" + attrName);
                    String value = attr.getNodeValue();
                    attrName = attrName.replace(":", "_");
                    topBuff.append("public static final String XMLNS_" + attrName.toUpperCase() + " = \"" + value + "\";\n");
                    continue;
                }
                if (attrName.indexOf(":") >= 0 || seen.contains("attr:" + attrName)) continue;
                seen.add("attr:" + attrName);
                attrBuff.append("public static final String ATTR_" + attrName.toUpperCase() + " = \"" + attrName + "\";\n");
            }
        }
        NodeList elements = XmlUtil.getElements(node);
        for (int i = 0; i < elements.getLength(); ++i) {
            Element child = (Element)elements.item(i);
            XmlUtil.printTags(child, seen, tagBuff, attrBuff, topBuff);
        }
    }

    private static void printTags(String f, HashSet<String> seen) {
        try {
            String xml = IOUtil.readContents(f, XmlUtil.class);
            Element root = XmlUtil.getRoot(xml);
            StringBuffer tagBuff = new StringBuffer();
            StringBuffer attrBuff = new StringBuffer();
            StringBuffer topBuff = new StringBuffer();
            XmlUtil.printTags(root, seen, tagBuff, attrBuff, topBuff);
            System.out.println(topBuff);
            System.out.println(tagBuff);
            System.out.println(attrBuff);
        }
        catch (Exception exc) {
            System.err.println("Error processing:" + f);
            exc.printStackTrace();
        }
    }

    private static void generateCode(String f, String packageName) throws Exception {
        HashSet<String> seen = new HashSet<String>();
        String xml = IOUtil.readContents(f, XmlUtil.class);
        Element root = XmlUtil.getRoot(xml);
        XmlUtil.generateCode(root, seen, packageName);
    }

    private static void generateCode(Element element, HashSet<String> seen, String packageName) throws Exception {
        String className = element.getTagName();
        if (!seen.contains(className)) {
            // empty if block
        }
    }

    private static void format(String f) {
        try {
            String xml;
            String origXml = xml = IOUtil.readContents(f, XmlUtil.class);
            StringBuffer buff = new StringBuffer();
            while (true) {
                int idx1;
                if ((idx1 = xml.indexOf("<!--")) < 0) {
                    buff.append(xml);
                    break;
                }
                int idx2 = xml.indexOf("-->");
                if (idx2 < 0 || idx2 < idx1) {
                    buff.append(xml);
                    break;
                }
                buff.append(xml.substring(0, idx1));
                String commentBlock = xml.substring(idx1 + 4, idx2);
                xml = xml.substring(idx2 + 3);
                buff.append("<![CDATA[XmlUtil.COMMENT:" + commentBlock + "]]>");
            }
            Element root = XmlUtil.getRoot(buff.toString());
            String xmlString = XmlUtil.toStringWithHeader(root, "  ", "\n", true);
            IOUtil.writeFile(new File(f), xmlString);
        }
        catch (Exception exc) {
            System.err.println("Error processing:" + f);
            exc.printStackTrace();
        }
    }

    public static String calculateRFC2104HMAC(String data, String key) throws SignatureException {
        String result;
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), HMAC_SHA1_ALGORITHM);
            Mac mac = Mac.getInstance(HMAC_SHA1_ALGORITHM);
            mac.init(signingKey);
            byte[] rawHmac = mac.doFinal(data.getBytes());
            result = XmlUtil.encodeBase64(rawHmac);
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
        return result;
    }

    public static ElementListIterator elements(String xmlFile, String xPath) {
        return new ElementListIterator(XmlUtil.eval(xmlFile, xPath));
    }

    public static NodeList eval(String xmlFile, String xPath) {
        try {
            return (NodeList)XmlUtil.expr(xPath).evaluate(XmlUtil.loadXml(xmlFile), XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("Error evaluation xpath", e);
        }
    }

    public static Document loadXml(String xmlFile) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(xmlFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading XML file: " + e.getMessage(), e);
        }
    }

    public static XPathExpression expr(String xPath) {
        XPathExpression expr = pathMap.get(xPath);
        if (expr == null) {
            try {
                expr = XPathFactory.newInstance().newXPath().compile(xPath);
                pathMap.put(xPath, expr);
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException("Error compiling xpath", e);
            }
        }
        return expr;
    }

    public static class ElementListIterator
    implements Iterable<Element>,
    Iterator<Element> {
        private final NodeList nodeList;
        private int index = 0;

        public ElementListIterator(NodeList nodeList) {
            this.nodeList = nodeList;
        }

        @Override
        public Iterator<Element> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.nodeList.getLength();
        }

        @Override
        public Element next() {
            return (Element)this.nodeList.item(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        StringBuffer errors = new StringBuffer();

        @Override
        public void error(SAXParseException exception) {
            this.handleError(exception);
        }

        @Override
        public void fatalError(SAXParseException exception) {
            this.handleError(exception);
        }

        @Override
        public void warning(SAXParseException exception) {
        }

        private void handleError(SAXParseException e) {
            this.errors.append(e.getMessage() + " line:" + e.getLineNumber() + (e.getColumnNumber() >= 0 ? " column:" + e.getColumnNumber() : "") + "\n");
        }
    }
}

