/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.xml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.ResourceCollection;
import ucar.unidata.xml.XmlUtil;

public class XmlResourceCollection
extends ResourceCollection {
    private Document writableDocument;
    private Element writableRoot;
    private Hashtable roots = new Hashtable();

    public XmlResourceCollection(String id) {
        this(id, id);
    }

    public XmlResourceCollection(String id, XmlResourceCollection that) {
        super(id, that);
    }

    public XmlResourceCollection(String id, String description) {
        super(id, description);
    }

    public XmlResourceCollection(String id, List resources) {
        super(id, resources);
    }

    public XmlResourceCollection(String id, String writableResource, List resources) {
        super(id, writableResource, resources);
    }

    @Override
    public void clearCache() {
        this.roots = new Hashtable();
        super.clearCache();
    }

    private void createWritableXml(String dfltXml) {
        String writableXml = null;
        try {
            writableXml = this.read(this.writableIndex);
            if (writableXml == null) {
                writableXml = dfltXml;
            }
            this.writableDocument = XmlUtil.getDocument(writableXml);
            this.writableRoot = this.writableDocument.getDocumentElement();
            if (this.writableIndex >= 0) {
                this.roots.put(this.get(this.writableIndex), this.writableRoot);
            }
        }
        catch (RuntimeException npe) {
            throw npe;
        }
        catch (Exception exc) {
            throw new IllegalArgumentException("Error parsing resource xml file:" + this.writableResource + "\n" + exc);
        }
    }

    @Override
    public void writeWritableResource(String contents) throws FileNotFoundException, IOException {
        super.writeWritableResource(contents);
        this.writableDocument = null;
        this.writableRoot = null;
        if (this.writableIndex >= 0) {
            this.roots.remove(this.get(this.writableIndex));
        }
    }

    public void writeWritable() throws FileNotFoundException, IOException {
        if (this.writableDocument == null) {
            throw new IllegalStateException("No writable document");
        }
        this.writeWritableResource(XmlUtil.toStringWithHeader(this.writableRoot));
    }

    public Element getWritableRoot(String dfltXml) {
        if (this.writableRoot == null) {
            this.createWritableXml(dfltXml);
        }
        return this.writableRoot;
    }

    public Document getWritableDocument(String dfltXml) {
        if (this.writableRoot == null) {
            this.createWritableXml(dfltXml);
        }
        return this.writableDocument;
    }

    public void setWritableDocument(Document d, Element root) {
        this.writableRoot = root;
        this.writableDocument = d;
        if (this.writableIndex >= 0) {
            this.roots.put(this.get(this.writableIndex), this.writableRoot);
        }
    }

    @Override
    public void removeWritable() {
        this.roots.remove(this.get(this.writableIndex));
        super.removeWritable();
        this.writableDocument = null;
        this.writableRoot = null;
    }

    private Element getRoot(String xml, int resourceIndex, boolean lookAtCache) {
        try {
            Element root = lookAtCache ? this.roots.get(this.get(resourceIndex)) : null;
            if (root == null) {
                Document doc = XmlUtil.getDocument(xml);
                root = doc.getDocumentElement();
                this.roots.put(this.get(resourceIndex), root);
                if (resourceIndex == this.writableIndex) {
                    this.setWritableDocument(doc, root);
                }
            }
            return root;
        }
        catch (Exception exc) {
            if (Misc.isHtml(xml)) {
                return null;
            }
            LogUtil.logException("Error: parsing resource xml file:" + this.get(resourceIndex), exc);
            return null;
        }
    }

    public Element getRoot(int resourceIndex) {
        return this.getRoot(resourceIndex, true);
    }

    public Element getRoot(int resourceIndex, boolean lookAtCache) {
        Element root;
        if (lookAtCache && (root = (Element)this.roots.get(this.get(resourceIndex))) != null) {
            return root;
        }
        String xml = this.read(resourceIndex, lookAtCache);
        if (xml == null) {
            return null;
        }
        if ((xml = xml.trim()).length() == 0) {
            return null;
        }
        return this.getRoot(xml, resourceIndex, lookAtCache);
    }
}

