/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.xml;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.w3c.dom.Element;
import ucar.unidata.util.IOUtil;
import ucar.unidata.util.PersistentStore;
import ucar.unidata.xml.XmlEncoder;
import ucar.unidata.xml.XmlResourceCollection;

public class XmlObjectStore
implements PersistentStore {
    private XmlEncoder encoder;
    private XmlResourceCollection resources;
    private File userDirectory;
    private Hashtable table = new Hashtable();
    private boolean inNeedOfSaving = false;
    protected List tmpFiles = new ArrayList();
    private String tmpDirOverride;

    public XmlObjectStore(XmlEncoder encoder) {
        this.encoder = encoder;
    }

    protected void setEncoder(XmlEncoder encoder) {
        this.encoder = encoder;
    }

    protected XmlEncoder getEncoder() {
        if (this.encoder == null) {
            this.encoder = new XmlEncoder();
        }
        return this.encoder;
    }

    public File getUserDirectory() {
        if (this.resources == null) {
            return null;
        }
        if (this.userDirectory == null) {
            this.userDirectory = new File(this.resources.getWritable()).getParentFile();
        }
        return this.userDirectory;
    }

    public boolean userDirectoryOk() {
        File userDirectory = this.getUserDirectory();
        return userDirectory.exists() && userDirectory.canWrite();
    }

    public void setTmpDir(String dir) {
        this.tmpDirOverride = dir;
    }

    public String getUserTmpDirectory() {
        String tmpDir = null;
        tmpDir = this.tmpDirOverride == null ? IOUtil.joinDir(this.getUserDirectory().toString(), "tmp") : this.tmpDirOverride;
        IOUtil.makeDir(tmpDir);
        return tmpDir;
    }

    public String getTmpFile(String tail) {
        String filename = IOUtil.joinDir(this.getUserTmpDirectory(), tail);
        if (!this.tmpFiles.contains(filename)) {
            this.tmpFiles.add(filename);
        }
        return filename;
    }

    public void cleanupTmpDirectory() {
        if (!this.userDirectoryOk()) {
            return;
        }
        File dir = new File(this.getUserTmpDirectory());
        this.cleanupTmpDirectory(dir);
    }

    private void cleanupTmpDirectory(File dir) {
        long ONEDAY = 86400000L;
        try {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                long hoursOld = (System.currentTimeMillis() - f.lastModified()) / 1000L / 60L / 60L;
                if (f.isDirectory()) {
                    this.cleanupTmpDirectory(f);
                    File[] subfiles = f.listFiles();
                    if (subfiles.length != 0 || hoursOld <= 23L) continue;
                    f.delete();
                    continue;
                }
                if (hoursOld <= 23L) continue;
                f.delete();
            }
        }
        catch (Exception exc) {
            System.err.println("Error cleaning up files:" + exc);
        }
    }

    public File getUniqueTmpDirectory() {
        String file = null;
        File tmpDir = new File(this.getUserTmpDirectory());
        int cnt = 0;
        while (new File(file = IOUtil.joinDir(tmpDir, "tmpdir" + cnt)).exists()) {
            ++cnt;
        }
        IOUtil.makeDir(file);
        return new File(file);
    }

    public String getUniqueTmpFile(String prefix, String suffix) {
        int cnt = 0;
        String file = null;
        while (new File(file = this.getTmpFile(prefix + cnt + suffix)).exists()) {
            ++cnt;
        }
        return file;
    }

    public void cleanupTmpFiles() {
        for (int i = 0; i < this.tmpFiles.size(); ++i) {
            File f = new File(this.tmpFiles.get(i).toString());
            if (!f.exists()) continue;
            try {
                f.delete();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.tmpFiles = new ArrayList();
    }

    public int init(XmlResourceCollection rc) {
        this.resources = rc;
        return this.append(rc, false);
    }

    public int append(XmlResourceCollection rc, boolean onlyAddIfNotExists) {
        int cnt = 0;
        for (int i = rc.size() - 1; i >= 0; --i) {
            try {
                Object object;
                Element root = rc.getRoot(i);
                if (root == null || !((object = this.getEncoder().toObject(root)) instanceof Hashtable)) continue;
                ++cnt;
                Hashtable newTable = (Hashtable)object;
                newTable = this.processTable(newTable);
                if (!onlyAddIfNotExists) {
                    this.table.putAll(newTable);
                    continue;
                }
                Enumeration keys = newTable.keys();
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    if (this.table.containsKey(key)) continue;
                    this.table.put(key, newTable.get(key));
                }
                continue;
            }
            catch (Exception exc) {
                System.err.println("Error reading resources" + exc);
                exc.printStackTrace();
            }
        }
        return cnt;
    }

    protected Hashtable processTable(Hashtable newTable) {
        return newTable;
    }

    public Object getEncodedFile(String filename) {
        String contents = this.getFileContents(filename);
        if (contents == null) {
            return null;
        }
        try {
            this.getEncoder().clear();
            return this.getEncoder().toObject(contents);
        }
        catch (Exception exc) {
            System.err.println("Error reading file: " + filename + "\n" + exc);
            return null;
        }
    }

    public void putEncodedFile(String filename, Object o) {
        this.getEncoder().clear();
        String contents = this.getEncoder().toXml(o);
        if (contents == null) {
            System.err.println("Failed to write file:" + filename);
            return;
        }
        this.putFile(filename, contents);
    }

    public String getFileContents(String filename) {
        if (!this.userDirectoryOk()) {
            return null;
        }
        String filePath = IOUtil.joinDir(this.getUserDirectory(), filename);
        try {
            return IOUtil.readContents(filePath);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void putFile(String filename, String contents) {
        if (!this.userDirectoryOk()) {
            return;
        }
        String filePath = IOUtil.joinDir(this.getUserDirectory(), filename);
        try {
            IOUtil.writeFile(filePath, contents);
        }
        catch (Exception exc) {
            System.err.println("Error reading file: " + filePath + "\n" + exc);
        }
    }

    public synchronized Object get(String key) {
        return this.table.get(key);
    }

    public void put(String key, boolean value) {
        this.put(key, (Object)new Boolean(value));
    }

    public void put(String key, char value) {
        this.put(key, (Object)new Character(value));
    }

    public void put(String key, short value) {
        this.put(key, (Object)new Short(value));
    }

    public void put(String key, int value) {
        this.put(key, (Object)new Integer(value));
    }

    public void put(String key, float value) {
        this.put(key, (Object)new Float(value));
    }

    public void put(String key, long value) {
        this.put(key, (Object)new Long(value));
    }

    public void put(String key, double value) {
        this.put(key, (Object)new Double(value));
    }

    @Override
    public void put(Object key, Object value) {
        this.put(key.toString(), value);
    }

    public synchronized void put(String key, Object value) {
        if (value == null) {
            this.table.remove(key);
        } else {
            this.table.put(key, value);
        }
        this.inNeedOfSaving = true;
    }

    public String get(String key, String dflt) {
        Object value = this.get(key);
        if (value == null) {
            return dflt;
        }
        return value.toString();
    }

    public Color get(String key, Color dflt) {
        Object value = this.get(key);
        if (value == null) {
            return dflt;
        }
        return (Color)value;
    }

    public Font get(String key, Font dflt) {
        Object value = this.get(key);
        if (value == null) {
            return dflt;
        }
        return (Font)value;
    }

    public boolean get(String key, boolean dflt) {
        Object value = this.get(key);
        if (value == null || value.toString().isEmpty()) {
            return dflt;
        }
        return new Boolean(value.toString());
    }

    public char get(String key, char dflt) {
        Object value = this.get(key);
        if (value == null || value.toString().isEmpty()) {
            return dflt;
        }
        return value.toString().charAt(0);
    }

    public short get(String key, short dflt) {
        Object value = this.get(key);
        if (value == null || value.toString().isEmpty()) {
            return dflt;
        }
        return new Short(value.toString());
    }

    public int get(String key, int dflt) {
        Object value = this.get(key);
        if (value == null || value.toString().isEmpty()) {
            return dflt;
        }
        return new Integer(value.toString());
    }

    public float get(String key, float dflt) {
        Object value = this.get(key);
        if (value == null || value.toString().isEmpty()) {
            return dflt;
        }
        return new Float(value.toString()).floatValue();
    }

    public long get(String key, long dflt) {
        Object value = this.get(key);
        if (value == null || value.toString().isEmpty()) {
            return dflt;
        }
        return new Long(value.toString());
    }

    public double get(String key, double dflt) {
        Object value = this.get(key);
        if (value == null || value.toString().isEmpty()) {
            return dflt;
        }
        return new Double(value.toString());
    }

    @Override
    public Object get(Object key) {
        return this.get(key.toString());
    }

    public synchronized void remove(String key) {
        this.table.remove(key);
        this.inNeedOfSaving = true;
    }

    public void saveIfNeeded() {
        if (this.inNeedOfSaving) {
            this.save();
        }
    }

    @Override
    public void save() {
        try {
            if (!this.userDirectoryOk()) {
                return;
            }
            String encodedString = this.getEncoder().toXml(this.table);
            File file = new File(this.resources.getWritable());
            if (encodedString == null || encodedString.trim().length() == 0) {
                System.err.println("Error: trying to write 0 bytes to:" + file);
                this.inNeedOfSaving = false;
                return;
            }
            File bakFile = new File(this.resources.getWritable() + ".bak");
            if (file.exists()) {
                IOUtil.copyFile(file, bakFile);
            }
            IOUtil.writeFile(this.resources.getWritable(), encodedString);
            this.inNeedOfSaving = false;
        }
        catch (Exception exc) {
            System.out.println("XmlObjectStore save failed writing to:" + this.resources.getWritable());
            exc.printStackTrace();
            return;
        }
    }

    public static void main(String[] args) {
    }
}

