/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.xml;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.xml.ObjectClass;
import ucar.unidata.xml.XmlDelegate;
import ucar.unidata.xml.XmlDelegateImpl;
import ucar.unidata.xml.XmlObjectFactory;
import ucar.unidata.xml.XmlPersistable;
import ucar.unidata.xml.XmlUtil;

public class XmlEncoder
extends XmlUtil {
    private Object MUTEX = new Object();
    private Hashtable prototypes = new Hashtable();
    private static Object NO_PROTOTYPE = new Object();
    public static boolean debug = false;
    public static final String METHOD_INIT = "initAfterXml";
    private static Hashtable classCtorsOk = new Hashtable();
    private static final Class[] ENCODER_ARRAY = new Class[]{XmlEncoder.class};
    public static final String METHOD_PUT = "put";
    public static final String METHOD_ADD = "add";
    public static final String NAME_STRING = "string";
    public static final String TAG_ARRAY = "array";
    public static final String TAG_ENUM = "enum";
    public static final String TAG_PARRAY = "parray";
    public static final String TAG_CONSTRUCTOR = "constructor";
    public static final String TAG_FACTORY = "factory";
    public static final String TAG_FIELD = "field";
    public static final String TAG_IGNORE = "ignore";
    public static final String TAG_METHOD = "method";
    public static final String TAG_NULL = "null";
    public static final String TAG_OBJECT = "object";
    public static final String TAG_PROPERTY = "property";
    public static final String TAG_SERIAL = "serial";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_ENCODING = "encode";
    public static final String VALUE_BASE64 = "base64";
    public static final String ATTR_ID = "id";
    public static final String ATTR_IDREF = "idref";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_NULL = "null";
    public static final String ATTR_STRINGVALUE = "stringvalue";
    public static final String ATTR_LENGTH = "length";
    public static final String ATTR_VALUE = "value";
    protected Document document;
    protected ArrayList delegateClasses = new ArrayList();
    protected ArrayList delegates;
    private Hashtable okMethods;
    private Hashtable seedTable;
    private Hashtable primitiveClassToName;
    private Hashtable nameToPrimitiveClass;
    private Hashtable primitiveClassToCtor;
    private Hashtable primitiveClasses;
    private int nextObjectId;
    private Hashtable idToObject;
    private Hashtable objectToId;
    private Hashtable objectToElement;
    private Hashtable<String, Class> classNameToClass = new Hashtable();
    private Hashtable<String, String> newClassNames = new Hashtable();
    private List<String[]> patterns = new ArrayList<String[]>();
    private ArrayList exceptions;
    private ArrayList errorMessages;
    private static Map<MethodKey, Method> methodCache = new ConcurrentHashMap<MethodKey, Method>();

    public XmlEncoder() {
        this.addDefaultDelegates();
    }

    protected void addDefaultDelegates() {
        this.addDelegateForClass(Color.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                Color color = (Color)o;
                List args = Misc.newList(new Integer(color.getRed()), new Integer(color.getGreen()), new Integer(color.getBlue()));
                List types = Misc.newList(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        this.addDelegateForClass(Rectangle.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                Rectangle r = (Rectangle)o;
                List args = Misc.newList(new Integer(r.x), new Integer(r.y), new Integer(r.width), new Integer(r.height));
                List types = Misc.newList(Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        this.addDelegateForClass(Rectangle2D.Double.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                Rectangle2D.Double r = (Rectangle2D.Double)o;
                List args = Misc.newList(new Double(r.x), new Double(r.y), new Double(r.width), new Double(r.height));
                List types = Misc.newList(Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        this.addDelegateForClass(Rectangle2D.Float.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                Rectangle2D.Float r = (Rectangle2D.Float)o;
                List args = Misc.newList(new Float(r.x), new Float(r.y), new Float(r.width), new Float(r.height));
                List types = Misc.newList(Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        this.addDelegateForClass(Point.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                Point p = (Point)o;
                List args = Misc.newList(new Integer(p.x), new Integer(p.y));
                List types = Misc.newList(Integer.TYPE, Integer.TYPE);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        this.addDelegateForClass(Dimension.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                Dimension p = (Dimension)o;
                List args = Misc.newList(new Integer(p.width), new Integer(p.height));
                List types = Misc.newList(Integer.TYPE, Integer.TYPE);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        this.addDelegateForClass(Font.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                Font f = (Font)o;
                List args = Misc.newList(f.getName(), new Integer(f.getStyle()), new Integer(f.getSize()));
                List types = Misc.newList(String.class, Integer.TYPE, Integer.TYPE);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
        this.addDelegateForClass(Date.class, new XmlDelegateImpl(){

            @Override
            public Element createElement(XmlEncoder e, Object o) {
                Date p = (Date)o;
                List args = Misc.newList(new Long(p.getTime()));
                List types = Misc.newList(Long.TYPE);
                return e.createObjectConstructorElement(o, args, types);
            }
        });
    }

    public String toXml(Object theObject) {
        return this.toXml(theObject, true);
    }

    public String toXml(Object theObject, boolean formatXml) {
        long t1 = System.currentTimeMillis();
        String result = this.toXmlInner(theObject, formatXml);
        long t2 = System.currentTimeMillis();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toXmlInner(Object o, boolean formatXml) {
        Object object = this.MUTEX;
        synchronized (object) {
            this.init();
            String xml = null;
            try {
                Element element = this.toElement(o);
                if (element != null) {
                    xml = XmlUtil.toStringWithHeader(element, formatXml ? "    " : "", formatXml ? "\n" : "");
                }
            }
            catch (Exception exc) {
                this.logException("Error:", exc);
            }
            LogUtil.printExceptions(this.errorMessages, this.exceptions);
            this.clear();
            return xml;
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public List getErrorMessages() {
        return this.errorMessages;
    }

    public Element toElement(Object theObject) {
        return this.createElement(theObject);
    }

    public static Object decodeXml(String xml) throws Exception {
        return new XmlEncoder().toObject(xml);
    }

    public static String encodeObject(Object object) throws Exception {
        String s = new XmlEncoder().toXml(object, false);
        return s;
    }

    public Object toObject(String xml) throws Exception {
        return this.toObject(xml, true);
    }

    public Object toObject(String xml, boolean catchAndLogError) throws Exception {
        if (xml == null || xml.length() == 0) {
            return null;
        }
        try {
            Element root = XmlUtil.getRoot(xml);
            if (root == null) {
                return null;
            }
            return this.toObjectInner(root, catchAndLogError);
        }
        catch (Exception exc) {
            if (!catchAndLogError) {
                throw exc;
            }
            this.logException("Error:", exc);
            return null;
        }
    }

    public Object toObject(Element node) {
        try {
            return this.toObjectInner(node, true);
        }
        catch (Exception exc) {
            this.logException("Error:", exc);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object toObjectInner(Element node, boolean catchAndLogError) throws Exception {
        Object object = this.MUTEX;
        synchronized (object) {
            Object object2 = null;
            this.init();
            try {
                object2 = this.createObject(node);
            }
            catch (Exception exc) {
                if (!catchAndLogError) {
                    throw exc;
                }
                this.logException("Error:", exc);
            }
            if (this.exceptions != null && this.exceptions.size() > 0 && !catchAndLogError) {
                throw (Exception)this.exceptions.get(0);
            }
            LogUtil.printExceptions(this.errorMessages, this.exceptions);
            this.clear();
            return object2;
        }
    }

    public void clear() {
        this.nextObjectId = 0;
        this.idToObject = null;
        this.objectToId = null;
        this.objectToElement = null;
    }

    protected void init() {
        if (this.idToObject != null) {
            return;
        }
        this.nextObjectId = 0;
        this.idToObject = new Hashtable();
        this.objectToId = new Hashtable();
        this.objectToElement = new Hashtable();
    }

    public boolean methodOk(String methodName) {
        if (this.okMethods == null) {
            this.okMethods = new Hashtable();
            this.okMethods.put(METHOD_ADD, METHOD_ADD);
            this.okMethods.put(METHOD_PUT, METHOD_PUT);
        }
        return this.okMethods.get(methodName) != null;
    }

    public void addDelegateForClass(Class theClass, XmlDelegate delegate) {
        if (this.delegates == null) {
            this.delegates = new ArrayList();
        }
        this.delegateClasses.add(theClass);
        this.delegates.add(delegate);
    }

    public void addHighPriorityDelegateForClass(Class theClass, XmlDelegate delegate) {
        if (this.delegates == null) {
            this.delegates = new ArrayList();
        }
        this.delegateClasses.add(0, theClass);
        this.delegates.add(0, delegate);
    }

    protected XmlDelegate getDelegate(Class theClass) {
        Class c;
        int i;
        if (this.delegates == null) {
            return null;
        }
        for (i = 0; i < this.delegates.size(); ++i) {
            c = (Class)this.delegateClasses.get(i);
            if (!c.equals(theClass)) continue;
            return (XmlDelegate)this.delegates.get(i);
        }
        for (i = 0; i < this.delegates.size(); ++i) {
            c = (Class)this.delegateClasses.get(i);
            if (!c.isAssignableFrom(theClass)) continue;
            return (XmlDelegate)this.delegates.get(i);
        }
        return null;
    }

    public Document getDocument() {
        if (this.document == null) {
            this.document = XmlUtil.makeDocument();
        }
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    protected String getNextId() {
        return ATTR_ID + ++this.nextObjectId;
    }

    protected Object getObjectFromId(String id) {
        if (id == null) {
            return null;
        }
        return this.idToObject.get(id);
    }

    public void addSeedObject(Object seedObject) {
        if (this.seedTable == null) {
            this.seedTable = new Hashtable();
        }
        this.seedTable.put(seedObject, seedObject);
    }

    private Object getSeedObject(Object newlyCreatedObject) {
        if (this.seedTable == null) {
            return null;
        }
        return this.seedTable.get(newlyCreatedObject);
    }

    private Object getObject(Hashtable ht, Object key) {
        return ht.get(new KeyWrapper(key));
    }

    private void putObject(Hashtable ht, Object key, Object value) {
        ht.put(new KeyWrapper(key), value);
    }

    protected void setObject(String id, Object theObject) {
        if (id == null || theObject == null) {
            return;
        }
        this.init();
        this.idToObject.put(id, theObject);
    }

    protected String getObjectId(Object theObject) {
        if (theObject == null) {
            return null;
        }
        this.init();
        return (String)this.getObject(this.objectToId, theObject);
    }

    protected Element getElementForObject(Object theObject) {
        if (theObject == null) {
            return null;
        }
        return (Element)this.getObject(this.objectToElement, theObject);
    }

    public void defineObjectId(Object theObject, String theId) {
        this.init();
        this.putObject(this.objectToId, theObject, theId);
        this.idToObject.put(theId, theObject);
    }

    protected String setObjectId(Object theObject) {
        String nextId = this.getNextId();
        this.defineObjectId(theObject, nextId);
        return nextId;
    }

    public String setObjectId(Object theObject, Element element) {
        if (element == null || theObject == null) {
            return null;
        }
        this.putObject(this.objectToElement, theObject, element);
        return this.setObjectId(theObject);
    }

    protected void initPrimitiveName() {
        Constructor ctor;
        int i;
        if (this.primitiveClassToName != null) {
            return;
        }
        this.primitiveClassToName = new Hashtable();
        this.nameToPrimitiveClass = new Hashtable();
        this.primitiveClassToCtor = new Hashtable();
        this.primitiveClasses = new Hashtable();
        Class[] bclasses = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};
        Class[] wclasses = new Class[]{Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class};
        for (i = 0; i < bclasses.length; ++i) {
            this.primitiveClassToName.put(bclasses[i], bclasses[i].getName());
            this.nameToPrimitiveClass.put(bclasses[i].getName(), bclasses[i]);
            this.primitiveClasses.put(bclasses[i], bclasses[i]);
            ctor = Misc.findConstructor(wclasses[i], new Class[]{String.class});
            if (ctor == null) continue;
            this.primitiveClassToCtor.put(bclasses[i], ctor);
        }
        for (i = 0; i < wclasses.length; ++i) {
            this.primitiveClassToName.put(wclasses[i], wclasses[i].getName());
            this.nameToPrimitiveClass.put(wclasses[i].getName(), wclasses[i]);
            ctor = Misc.findConstructor(wclasses[i], new Class[]{String.class});
            if (ctor == null) continue;
            this.primitiveClassToCtor.put(wclasses[i], ctor);
        }
        this.primitiveClassToName.put(String.class, NAME_STRING);
        this.nameToPrimitiveClass.put(NAME_STRING, String.class);
    }

    public boolean isPrimitive(Class theClass) {
        this.initPrimitiveName();
        return this.primitiveClasses.get(theClass) != null;
    }

    public String getPrimitiveName(Class primitiveClass) {
        this.initPrimitiveName();
        return (String)this.primitiveClassToName.get(primitiveClass);
    }

    public Class getPrimitiveClass(String name) {
        this.initPrimitiveName();
        return (Class)this.nameToPrimitiveClass.get(name);
    }

    public Constructor getPrimitiveCtor(Class primitiveClass) {
        this.initPrimitiveName();
        return (Constructor)this.primitiveClassToCtor.get(primitiveClass);
    }

    public void registerClassName(String theName, Class theClass) {
        this.classNameToClass.put(theName, theClass);
    }

    public void registerNewClassName(String oldName, String newName) {
        this.newClassNames.put(oldName, newName);
    }

    public void addClassPatternReplacement(String pattern, String replace) {
        this.patterns.add(new String[]{pattern, replace});
    }

    public Class getClass(String className) throws ClassNotFoundException {
        Class type = this.getPrimitiveClass(className);
        if (type != null) {
            return type;
        }
        String newClassName = this.newClassNames.get(className);
        if (newClassName != null) {
            className = newClassName;
        }
        for (String[] patternTuple : this.patterns) {
            className = className.replace(patternTuple[0], patternTuple[1]);
        }
        type = this.classNameToClass.get(className);
        if (type != null) {
            return type;
        }
        type = Misc.findClass(className);
        this.classNameToClass.put(className, type);
        return type;
    }

    public String getClassName(Class theClass) {
        String name = this.getPrimitiveName(theClass);
        if (name != null) {
            return name;
        }
        return theClass.getName();
    }

    public Element newElement(String tagName) {
        return this.getDocument().createElement(tagName);
    }

    public Element createArrayElement(Object arrayObject) {
        Class<?> theClass = arrayObject.getClass();
        int length = Array.getLength(arrayObject);
        if (this.isPrimitive(theClass.getComponentType())) {
            return this.createPrimitiveArrayElement(arrayObject);
        }
        Element arrayElement = this.newElement(TAG_ARRAY);
        arrayElement.setAttribute(ATTR_CLASS, this.getClassName(theClass.getComponentType()));
        arrayElement.setAttribute(ATTR_LENGTH, "" + length);
        for (int i = 0; i < length; ++i) {
            arrayElement.appendChild(this.createElement(Array.get(arrayObject, i)));
        }
        return arrayElement;
    }

    public <E extends Enum<E>> Element createEnumElement(E e) {
        Element enumElement = this.newElement(TAG_ENUM);
        enumElement.setAttribute(ATTR_CLASS, this.getClassName(e.getClass()));
        enumElement.setAttribute(ATTR_VALUE, e.name());
        return enumElement;
    }

    public Element createPrimitiveArrayElement(Object primitiveArray) {
        String contents;
        Class<?> theClass = primitiveArray.getClass();
        int length = Array.getLength(primitiveArray);
        Element arrayElement = this.newElement(TAG_PARRAY);
        arrayElement.setAttribute(ATTR_CLASS, this.getClassName(theClass.getComponentType()));
        if (length < 20) {
            StringBuffer buff = new StringBuffer();
            arrayElement.setAttribute(ATTR_LENGTH, "" + length);
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buff.append(",");
                }
                buff.append(Array.get(primitiveArray, i).toString());
            }
            contents = buff.toString();
        } else {
            try {
                contents = new String(XmlUtil.encodeBase64(XmlEncoder.serialize((Serializable)primitiveArray)));
            }
            catch (Exception exc) {
                this.logException("Error primitive creating array", exc);
                contents = null;
            }
        }
        arrayElement.appendChild(this.getDocument().createTextNode(contents));
        return arrayElement;
    }

    public Node createTextNode(String contents) {
        return this.getDocument().createTextNode(contents);
    }

    public static Object deserialize(byte[] bytes) throws Exception {
        ByteArrayInputStream istream = new ByteArrayInputStream(bytes);
        ObjectInputStream p = new ObjectInputStream(istream);
        return p.readObject();
    }

    public static byte[] serialize(Serializable object) throws Exception {
        ByteArrayOutputStream ostream = new ByteArrayOutputStream();
        ObjectOutputStream p = new ObjectOutputStream(ostream);
        p.writeObject(object);
        p.flush();
        ostream.close();
        return ostream.toByteArray();
    }

    public Element createMethodElement(String methodName, List argumentElements) {
        Element n = this.createMethodElement(methodName);
        XmlUtil.addChildren(n, argumentElements);
        return n;
    }

    public Element createMethodElement(String methodName, Element contents) {
        Element element = this.createMethodElement(methodName);
        element.appendChild(contents);
        return element;
    }

    public Element createMethodElement(String methodName) {
        Element n = this.newElement(TAG_METHOD);
        n.setAttribute(ATTR_NAME, methodName);
        return n;
    }

    public Element createSerialElement(Class theClass, String serialRepresentation) {
        Element element = this.newElement(TAG_SERIAL);
        element.setAttribute(ATTR_CLASS, theClass.getName());
        element.appendChild(this.getDocument().createCDATASection(serialRepresentation));
        return element;
    }

    public Element createPropertyElement(String propertyName, Element value) {
        Element element = this.newElement(TAG_PROPERTY);
        element.setAttribute(ATTR_NAME, propertyName);
        element.appendChild(value);
        return element;
    }

    public Element createReferenceElement(String id) {
        Element element = this.newElement(TAG_OBJECT);
        element.setAttribute(ATTR_IDREF, id);
        return element;
    }

    public Element createPrimitiveElement(String primitiveName, Object value) {
        Element element = this.newElement(primitiveName);
        if (value != null) {
            Text child = null;
            String svalue = value.toString();
            if (primitiveName.equals(NAME_STRING)) {
                if (svalue.length() == 0) {
                    element.setAttribute(ATTR_STRINGVALUE, "");
                } else {
                    if (svalue.indexOf("<") >= 0) {
                        svalue = XmlUtil.encodeBase64(svalue.getBytes());
                        element.setAttribute(ATTR_ENCODING, VALUE_BASE64);
                    }
                    child = this.getDocument().createCDATASection(svalue);
                }
            } else {
                child = this.getDocument().createTextNode(svalue);
            }
            if (child != null) {
                element.appendChild(child);
            }
        } else {
            element.setAttribute("null", "true");
        }
        return element;
    }

    public Element createNullElement(Class type) {
        Element element = this.newElement("null");
        if (type != null) {
            element.setAttribute(ATTR_CLASS, this.getClassName(type));
        }
        return element;
    }

    public Element createNullElement() {
        return this.createNullElement(null);
    }

    public Element createObjectElement(Class objectClass) {
        Element element = this.newElement(TAG_OBJECT);
        element.setAttribute(ATTR_CLASS, this.getClassName(objectClass));
        return element;
    }

    public Element createFactoryElement(Class factoryClass) {
        Element element = this.newElement(TAG_FACTORY);
        element.setAttribute(ATTR_CLASS, this.getClassName(factoryClass));
        return element;
    }

    public Element createObjectConstructorElement(Object object, List arguments) {
        return this.createObjectConstructorElement(object, arguments, null);
    }

    public Element createObjectConstructorElement(Object object, List arguments, List types) {
        Element result = this.createObjectElement(object.getClass());
        Element ctorElement = this.createConstructorElement(arguments, types);
        result.appendChild(ctorElement);
        return result;
    }

    public Element createConstructorElement(List arguments) {
        return this.createConstructorElement(arguments, null);
    }

    public Element createConstructorElement(List arguments, List types) {
        Element element = this.newElement(TAG_CONSTRUCTOR);
        if (arguments != null) {
            for (int i = 0; i < arguments.size(); ++i) {
                if (types != null) {
                    Class<Object> type = (Class<Object>)types.get(i);
                    Object arg = arguments.get(i);
                    element.appendChild(this.createElement(arg, type != null ? type : (arg != null ? arg.getClass() : Object.class)));
                    continue;
                }
                element.appendChild(this.createElement(arguments.get(i)));
            }
        }
        return element;
    }

    public static List findPropertyMethods(Class c) {
        return XmlEncoder.findPropertyMethods(c, true);
    }

    public static List findPropertyMethods(Class c, boolean returnGetters) {
        Method[] methods = c.getMethods();
        ArrayList<Method> v = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            Method propMethod = methods[i];
            String name = propMethod.getName();
            if (!name.startsWith("get") && !name.startsWith("is")) continue;
            String propertyName = XmlEncoder.getPropString(propMethod);
            Class<?>[] getterParams = propMethod.getParameterTypes();
            if (getterParams.length != 0) continue;
            Class[] setterParams = new Class[]{propMethod.getReturnType()};
            Method setter = null;
            try {
                setter = c.getMethod("set" + propertyName, setterParams);
                if (returnGetters) {
                    v.add(propMethod);
                    continue;
                }
                v.add(setter);
                continue;
            }
            catch (NoSuchMethodException nsme) {
                // empty catch block
            }
        }
        return v;
    }

    public Object createObject(Element element) {
        ObjectClass oc = this.createObjectInner(element);
        return oc == null ? null : oc.object;
    }

    public Object createObjectDontCheckDelegate(Element element) {
        ObjectClass oc = this.createObjectInner(element, false);
        return oc == null ? null : oc.object;
    }

    public ObjectClass createArrayObject(Element element) {
        try {
            Class arrayType = this.getClass(element.getAttribute(ATTR_CLASS));
            int length = new Integer(element.getAttribute(ATTR_LENGTH));
            Object array = Array.newInstance(arrayType, length);
            NodeList children = XmlUtil.getElements(element);
            for (int i = 0; i < children.getLength(); ++i) {
                Node o = children.item(i);
                Element child = (Element)children.item(i);
                ObjectClass oc = this.createObjectInner(child);
                if (oc == null) continue;
                Array.set(array, i, oc.object);
            }
            return new ObjectClass(array);
        }
        catch (Exception exc) {
            this.logException("Error creating array", exc);
            return null;
        }
    }

    public ObjectClass createEnumObject(Element element) {
        try {
            Class enumType = this.getClass(element.getAttribute(ATTR_CLASS));
            String value = element.getAttribute(ATTR_VALUE);
            return new ObjectClass(Enum.valueOf(enumType, value));
        }
        catch (Exception exc) {
            this.logException("Error creating enum", exc);
            return null;
        }
    }

    public String getTextFromChild(Element parent) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 3) continue;
            return n.getNodeValue();
        }
        return null;
    }

    public ObjectClass createPrimitiveArrayObject(Element element) {
        try {
            Class arrayType = this.getClass(element.getAttribute(ATTR_CLASS));
            String lengthStr = element.getAttribute(ATTR_LENGTH);
            String value = this.getTextFromChild(element);
            if (lengthStr == null || lengthStr.length() == 0) {
                return new ObjectClass(XmlEncoder.deserialize(XmlUtil.decodeBase64(value)));
            }
            int length = new Integer(lengthStr);
            Object array = Array.newInstance(arrayType, length);
            List<String> strings = StringUtil.split(value, ",");
            Object object = null;
            for (int i = 0; i < length; ++i) {
                String arrayValue = strings.get(i);
                object = this.createPrimitiveObject(arrayType, arrayValue);
                Array.set(array, i, object);
            }
            return new ObjectClass(array);
        }
        catch (Exception exc) {
            this.logException("Error creating primitive array.", exc);
            return null;
        }
    }

    public ObjectClass createPrimitiveObject(Class primitiveClass, Element element) {
        Object object;
        Node n;
        int i;
        String stringValue;
        String tagName = element.getTagName();
        String value = null;
        NodeList children = element.getChildNodes();
        if (XmlEncoder.getAttribute((Node)element, "null", false)) {
            return new ObjectClass(null, primitiveClass);
        }
        boolean isString = primitiveClass.equals(String.class);
        if (isString && (stringValue = XmlEncoder.getAttribute((Node)element, ATTR_STRINGVALUE, NULL_STRING)) != null) {
            return new ObjectClass(stringValue, primitiveClass);
        }
        for (i = 0; i < children.getLength(); ++i) {
            n = children.item(i);
            if (n.getNodeType() != 4) continue;
            value = n.getNodeValue();
            break;
        }
        if (value == null) {
            for (i = 0; i < children.getLength(); ++i) {
                n = children.item(i);
                if (n.getNodeType() != 3) continue;
                value = n.getNodeValue();
                break;
            }
        }
        if (value == null) {
            if (isString) {
                return new ObjectClass("", primitiveClass);
            }
            return new ObjectClass(null, primitiveClass);
        }
        String encodingValue = XmlEncoder.getAttribute((Node)element, ATTR_ENCODING, NULL_STRING);
        if (encodingValue != null && encodingValue.equals(VALUE_BASE64)) {
            value = new String(XmlUtil.decodeBase64(value));
        }
        if ((object = this.createPrimitiveObject(primitiveClass, value)) == null) {
            System.err.println("NULL: " + primitiveClass.getName() + " " + value);
            return null;
        }
        return new ObjectClass(object, primitiveClass);
    }

    public Object createPrimitiveObject(Class primitiveClass, String value) {
        try {
            if (primitiveClass.equals(String.class)) {
                return value;
            }
            Constructor ctor = this.getPrimitiveCtor(primitiveClass);
            if (ctor != null) {
                return ctor.newInstance(value);
            }
            String className = primitiveClass.getName();
            if (className.equals("char") || className.equals("java.lang.Character")) {
                return new Character(value.charAt(0));
            }
        }
        catch (Exception exc) {
            if (exc instanceof InvocationTargetException) {
                if (value.equals("NaN")) {
                    if (primitiveClass.equals(Double.class)) {
                        return new Double(Double.NaN);
                    }
                    if (primitiveClass.equals(Float.class)) {
                        return new Float(Float.NaN);
                    }
                } else if (value.equals("Infinity")) {
                    if (primitiveClass.equals(Double.class)) {
                        return new Double(Double.POSITIVE_INFINITY);
                    }
                    if (primitiveClass.equals(Float.class)) {
                        return new Float(Float.POSITIVE_INFINITY);
                    }
                } else if (value.equals("-Infinity")) {
                    if (primitiveClass.equals(Double.class)) {
                        return new Double(Double.NEGATIVE_INFINITY);
                    }
                    if (primitiveClass.equals(Float.class)) {
                        return new Float(Float.NEGATIVE_INFINITY);
                    }
                }
            }
            this.logException("Error creating primitive type: " + primitiveClass.getName(), exc);
        }
        return null;
    }

    public ObjectClass createSerializedObject(Element parent) {
        NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 4) continue;
            byte[] bytes = XmlUtil.decodeBase64(child.getNodeValue());
            try {
                ByteArrayInputStream istream = new ByteArrayInputStream(bytes);
                ObjectInputStream p = new ObjectInputStream(istream);
                Object theObject = p.readObject();
                String id = XmlEncoder.getAttribute((Node)parent, ATTR_ID, NULL_STRING);
                if (id != null) {
                    this.setObject(id, theObject);
                }
                return new ObjectClass(theObject);
            }
            catch (Exception exc) {
                this.logException("Error deserializing object.", exc);
                return null;
            }
        }
        System.err.println("No CDATA node found in serial tag");
        return null;
    }

    public ObjectClass createObjectInner(Element element) {
        return this.createObjectInner(element, true);
    }

    public ObjectClass createObjectInner(Element element, boolean checkDelegate) {
        boolean okToProceed;
        String tagName = element.getTagName();
        if (tagName.equals("null")) {
            try {
                String nullClassName = XmlEncoder.getAttribute((Node)element, ATTR_CLASS, NULL_STRING);
                if (nullClassName != null) {
                    return new ObjectClass(null, this.getClass(nullClassName));
                }
            }
            catch (Exception nullClassName) {
                // empty catch block
            }
            return new ObjectClass(null, null);
        }
        Class primitiveClass = this.getPrimitiveClass(tagName);
        if (primitiveClass != null) {
            return this.createPrimitiveObject(primitiveClass, element);
        }
        String idref = XmlEncoder.getAttribute((Node)element, ATTR_IDREF, NULL_STRING);
        if (idref != null) {
            Object object = this.getObjectFromId(idref);
            if (object == null) {
                // empty if block
            }
            return new ObjectClass(object);
        }
        if (tagName.equals(TAG_ARRAY)) {
            return this.createArrayObject(element);
        }
        if (tagName.equals(TAG_ENUM)) {
            return this.createEnumObject(element);
        }
        if (tagName.equals(TAG_PARRAY)) {
            return this.createPrimitiveArrayObject(element);
        }
        if (tagName.equals(TAG_SERIAL)) {
            return this.createSerializedObject(element);
        }
        if (!(tagName.equals(TAG_OBJECT) || tagName.equals("o") || tagName.equals(TAG_FACTORY))) {
            this.logException("Unknown tag: " + tagName, new IllegalArgumentException(""));
            return null;
        }
        Object newObject = null;
        String className = element.getAttribute(ATTR_CLASS);
        try {
            if (tagName.equals(TAG_FACTORY)) {
                XmlObjectFactory factory = (XmlObjectFactory)this.getClass(className).newInstance();
                newObject = factory.getObject(this, element);
            } else {
                Element constructorNode = XmlUtil.findChild(element, TAG_CONSTRUCTOR);
                if (constructorNode != null) {
                    NodeList children = XmlUtil.getElements(constructorNode);
                    Object[] args = new Object[children.getLength()];
                    Object[] types = new Class[children.getLength()];
                    for (int i = 0; i < children.getLength(); ++i) {
                        ObjectClass oc = this.createObjectInner((Element)children.item(i));
                        if (oc != null) {
                            args[i] = oc.object;
                            types[i] = oc.type;
                            continue;
                        }
                        args[i] = null;
                        types[i] = Object.class;
                    }
                    Class theClass = this.getClass(className);
                    Constructor ctor = Misc.findConstructor(this.getClass(className), (Class[])types);
                    if (ctor == null) {
                        System.err.println("Error: Unable to find constructor for class: " + className + " with types:" + StringUtil.toString(types) + "\n" + XmlUtil.toString(element));
                        return null;
                    }
                    newObject = ctor.newInstance(args);
                } else {
                    XmlDelegate delegate;
                    Class theClass = this.getClass(className);
                    XmlDelegate xmlDelegate = delegate = checkDelegate ? this.getDelegate(theClass) : null;
                    if (delegate != null) {
                        newObject = delegate.createObject(this, element);
                        if (newObject == null) {
                            return new ObjectClass(newObject, theClass);
                        }
                    } else {
                        newObject = this.getClass(className).newInstance();
                    }
                }
            }
        }
        catch (Exception exc) {
            this.logException("Error creating object: " + className, exc);
            return null;
        }
        if (newObject == null) {
            return null;
        }
        String id = XmlEncoder.getAttribute((Node)element, ATTR_ID, NULL_STRING);
        if (id != null) {
            this.setObject(id, newObject);
        }
        if (newObject instanceof XmlPersistable && !(okToProceed = ((XmlPersistable)newObject).initFromXml(this, element))) {
            return new ObjectClass(newObject);
        }
        NodeList children = XmlUtil.getElements(element);
        for (int i = 0; i < children.getLength(); ++i) {
            Element child = (Element)children.item(i);
            String childName = child.getTagName();
            if (childName.equals(TAG_METHOD)) {
                String methodName = child.getAttribute(ATTR_NAME);
                if (!this.methodOk(methodName)) {
                    this.logException("Unknown method: " + methodName, new IllegalArgumentException());
                    return null;
                }
                this.invokeMethod(newObject, methodName, child);
                continue;
            }
            if (childName.equals(TAG_FIELD)) {
                this.invokeField(newObject, child.getAttribute(ATTR_NAME), child);
                continue;
            }
            if (childName.equals(TAG_PROPERTY)) {
                this.invokeMethod(newObject, "set" + child.getAttribute(ATTR_NAME), child);
                continue;
            }
            if (!childName.equals(TAG_CONSTRUCTOR) && child.getAttribute(TAG_IGNORE) != null) continue;
        }
        try {
            Method theMethod = newObject.getClass().getMethod(METHOD_INIT, ENCODER_ARRAY);
            if (theMethod != null) {
                theMethod.invoke(newObject, this);
            }
        }
        catch (NoSuchMethodException theMethod) {
        }
        catch (Exception exc) {
            this.logException("Error calling method: initAfterXml", exc);
        }
        Object seedObject = this.getSeedObject(newObject);
        if (seedObject != null) {
            newObject = seedObject;
            if (id != null) {
                this.setObject(id, newObject);
            }
        }
        return new ObjectClass(newObject);
    }

    protected void invokeMethod(Object object, String methodName, Element element) {
        NodeList children = XmlEncoder.getElements(element);
        Class[] paramTypes = new Class[children.getLength()];
        Object[] params = new Object[children.getLength()];
        XmlEncoder.pr("invokeMethod:" + methodName);
        for (int i = 0; i < params.length; ++i) {
            Element child = (Element)children.item(i);
            ObjectClass oc = this.createObjectInner(child);
            if (oc == null) {
                XmlEncoder.pr("InvokeMethod - child is null");
                return;
            }
            paramTypes[i] = oc.type;
            params[i] = oc.object;
        }
        try {
            MethodKey mk = new MethodKey(object.getClass(), methodName, paramTypes);
            Method theMethod = methodCache.get(mk);
            if (theMethod == null) {
                theMethod = Misc.findMethod(object.getClass(), methodName, paramTypes);
                if (theMethod == null) {
                    throw new IllegalArgumentException("Unable to find method: " + object.getClass().getName() + "." + methodName);
                }
                theMethod.invoke(object, params);
                methodCache.put(mk, theMethod);
            } else {
                theMethod.invoke(object, params);
            }
        }
        catch (Exception exc) {
            String paramString = "";
            for (int i = 0; i < paramTypes.length; ++i) {
                if (i > 0) {
                    paramString = paramString + ", ";
                }
                paramString = paramTypes[i] == null ? paramString + "null" : paramString + paramTypes[i].getName();
            }
            this.logException("Error invoking method: " + this.getClassName(object.getClass()) + "." + methodName + "(" + paramString + ")", exc);
        }
    }

    protected void invokeField(Object object, String fieldName, Element parent) {
        try {
            Element child = XmlEncoder.getFirstChild(parent);
            Field field = object.getClass().getField(fieldName);
            if (field == null) {
                return;
            }
            ObjectClass oc = this.createObjectInner(child);
            if (oc == null) {
                return;
            }
            field.set(object, oc.object);
        }
        catch (NoSuchFieldException child) {
        }
        catch (IllegalAccessException child) {
        }
        catch (Exception exc) {
            this.logException("Error invoking field: " + fieldName, exc);
        }
    }

    public Element createElement(Object object) {
        return this.createElement(object, true);
    }

    public Element createElementDontCheckPersistable(Object object) {
        return this.createElement(object, object.getClass(), false, true);
    }

    public Element createElementDontCheckDelegate(Object object) {
        return this.createElement(object, false);
    }

    public Element createElement(Object object, boolean checkDelegate) {
        if (object == null) {
            return this.createNullElement();
        }
        return this.createElement(object, object.getClass(), true, checkDelegate);
    }

    protected Element createElement(Object object, Class theClass) {
        return this.createElement(object, theClass, true, true);
    }

    protected Element createElement(Object object, Class theClass, boolean checkPersistable, boolean checkDelegate) {
        if (object == null) {
            return this.createNullElement(theClass);
        }
        String primitiveName = this.getPrimitiveName(theClass);
        if (primitiveName != null) {
            return this.createPrimitiveElement(primitiveName, object);
        }
        if (theClass.isEnum()) {
            return this.createEnumElement((Enum)object);
        }
        if (theClass.isArray()) {
            return this.createArrayElement(object);
        }
        String id = this.getObjectId(object);
        if (id != null) {
            Element oldElement = this.getElementForObject(object);
            if (oldElement != null && !oldElement.hasAttribute(ATTR_ID)) {
                oldElement.setAttribute(ATTR_ID, id);
            }
            return this.createReferenceElement(id);
        }
        Element newElement = null;
        if (checkPersistable && object instanceof XmlPersistable) {
            newElement = ((XmlPersistable)object).createElement(this);
            this.setObjectId(object, newElement);
        } else {
            XmlDelegate delegate;
            XmlDelegate xmlDelegate = delegate = checkDelegate ? this.getDelegate(theClass) : null;
            if (delegate != null) {
                newElement = delegate.createElement(this, object);
                if (newElement == null) {
                    return null;
                }
                this.setObjectId(object, newElement);
            } else {
                newElement = this.createElementForObject(object, theClass);
            }
        }
        return newElement;
    }

    private boolean isClassCtorOk(Class theClass) {
        Boolean ok = (Boolean)classCtorsOk.get(theClass);
        if (ok != null) {
            return ok;
        }
        boolean ctorOk = true;
        try {
            theClass.newInstance();
        }
        catch (InstantiationException ie) {
            ctorOk = false;
        }
        catch (IllegalAccessException iae) {
            ctorOk = false;
        }
        classCtorsOk.put(theClass, new Boolean(ctorOk));
        return ctorOk;
    }

    public Element createElementForObject(Object object, Class theClass) {
        Element newElement = null;
        boolean ctorOk = this.isClassCtorOk(theClass);
        if (!ctorOk && object instanceof Serializable) {
            try {
                System.err.println("Serializing: " + theClass.getName());
                ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                ObjectOutputStream p = new ObjectOutputStream(ostream);
                p.writeObject(object);
                p.flush();
                ostream.close();
                byte[] bytes = ostream.toByteArray();
                newElement = this.createSerialElement(theClass, new String(XmlUtil.encodeBase64(bytes)));
                ctorOk = true;
            }
            catch (Exception exc) {
                this.logException("Error serializing class: " + theClass.getName(), exc);
            }
        }
        if (!ctorOk) {
            Misc.printStack("Invalid constructor for: " + this.getClassName(theClass), 10, null);
            return this.createElementForObject("INVALID", String.class);
        }
        if (newElement == null) {
            newElement = this.createObjectElement(theClass);
        }
        this.setObjectId(object, newElement);
        Hashtable propertyNames = new Hashtable();
        XmlUtil.addChildren(newElement, this.getPropertyElements(object, propertyNames));
        XmlUtil.addChildren(newElement, this.getFieldElements(object, propertyNames));
        List specialCaseElements = this.getSpecialCaseElements(object);
        if (specialCaseElements != null) {
            XmlUtil.addChildren(newElement, specialCaseElements);
        }
        return newElement;
    }

    public List getFieldElements(Object object, Hashtable propertyNames) {
        ArrayList<Element> elements = new ArrayList<Element>();
        Field[] fields = object.getClass().getFields();
        for (int i = 0; i < fields.length; ++i) {
            int modifiers = fields[i].getModifiers();
            if (!Modifier.isPublic(modifiers) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers) || propertyNames.get(fields[i].getName().toLowerCase()) != null) continue;
            try {
                Element element = this.newElement(TAG_FIELD);
                element.setAttribute(ATTR_NAME, fields[i].getName());
                element.appendChild(this.createElement(fields[i].get(object)));
                elements.add(element);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return elements;
    }

    public List getPropertyElements(Object object, Hashtable propertyNames) {
        ArrayList<Element> elements = new ArrayList<Element>();
        Class<?> theClass = object.getClass();
        Object prototype = this.prototypes.get(theClass);
        if (prototype == null) {
            if (this.getDelegate(theClass) != null) {
                prototype = NO_PROTOTYPE;
            } else {
                try {
                    prototype = theClass.newInstance();
                }
                catch (Exception exc) {
                    prototype = NO_PROTOTYPE;
                }
            }
            this.prototypes.put(theClass, prototype);
        }
        if (prototype == NO_PROTOTYPE) {
            prototype = null;
        }
        List methods = XmlEncoder.findPropertyMethods(theClass);
        for (int i = 0; i < methods.size(); ++i) {
            Method propMethod = (Method)methods.get(i);
            try {
                Object value = propMethod.invoke(object, new Object[0]);
                if (prototype != null) {
                    try {
                        Object protoTypeValue = propMethod.invoke(prototype, new Object[0]);
                        if (Misc.equals(value, protoTypeValue)) {
                            continue;
                        }
                    }
                    catch (Exception protoTypeValue) {
                        // empty catch block
                    }
                }
                Class<?> returnType = propMethod.getReturnType();
                String primitiveName = this.getPrimitiveName(returnType);
                String methodName = propMethod.getName();
                Element valueElement = primitiveName != null ? this.createPrimitiveElement(primitiveName, value) : (value == null ? this.createNullElement(returnType) : this.createElement(value));
                if (valueElement == null) continue;
                String propertyName = XmlEncoder.getPropString(propMethod);
                if (propertyNames != null) {
                    propertyNames.put(propertyName.toLowerCase(), propertyName);
                }
                elements.add(this.createPropertyElement(propertyName, valueElement));
                continue;
            }
            catch (Exception exc) {
                this.logException("Error evaluating method: " + propMethod.getName() + "\n", exc);
            }
        }
        return elements;
    }

    private static String getPropString(Method method) {
        String methodName = method.getName();
        if (methodName.startsWith("get")) {
            return methodName.substring(3);
        }
        if (methodName.startsWith("is") && method.getReturnType().equals(Boolean.TYPE)) {
            return methodName.substring(2);
        }
        return null;
    }

    public List getSpecialCaseElements(Object object) {
        if (object instanceof List) {
            List v = (List)object;
            ArrayList<Element> elements = new ArrayList<Element>(v.size());
            for (int i = 0; i < v.size(); ++i) {
                Element argumentElement = this.createElement(v.get(i));
                if (argumentElement == null) continue;
                elements.add(this.createMethodElement(METHOD_ADD, argumentElement));
            }
            return elements;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            ArrayList<Element> elements = new ArrayList<Element>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                Element methodElement = this.createMethodElement(METHOD_PUT);
                methodElement.appendChild(this.createElement(entry.getKey()));
                methodElement.appendChild(this.createElement(entry.getValue()));
                elements.add(methodElement);
            }
            return elements;
        }
        if (object instanceof Set) {
            Set s = (Set)object;
            ArrayList<Element> elements = new ArrayList<Element>(s.size());
            for (Object o : s) {
                Element methodElement = this.createMethodElement(METHOD_ADD);
                methodElement.appendChild(this.createElement(o));
                elements.add(methodElement);
            }
            return elements;
        }
        return null;
    }

    private static void recurse(Node r, String tab) {
        System.err.println(tab + "Node:" + r);
        NodeList children = r.getChildNodes();
        int numChildren = children.getLength();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            XmlEncoder.recurse(child, tab + "  ");
        }
    }

    private void logException(String message, Exception exc) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList();
            this.errorMessages = new ArrayList();
        }
        this.errorMessages.add(message);
        this.exceptions.add(exc);
    }

    public static void pr(String msg) {
        if (debug) {
            System.err.println(msg);
        }
    }

    public boolean test(Object o, boolean printXml) throws Exception {
        String xml1 = this.toXml(o);
        if (printXml) {
            System.out.println(xml1);
            return true;
        }
        String xml2 = this.toXml(this.toObject(xml1));
        boolean ok = xml1.equals(xml2);
        if (!ok) {
            System.out.println("Not ok");
            System.out.println("First xml:");
            System.out.println(xml1);
            System.out.println("******************\nSecond xml:");
            System.out.println(xml2);
        } else if (printXml) {
            System.out.println(xml2);
        } else {
            System.out.println("Ok");
        }
        return ok;
    }

    public static void main(String[] args) {
        try {
            XmlEncoder enc1 = new XmlEncoder();
            String xml = enc1.toXml(new Date());
            Date date = (Date)enc1.toObject(xml);
            System.err.println("Date:" + date);
        }
        catch (Exception exc) {
            System.err.println("OOps:" + exc);
        }
    }

    private static class KeyWrapper {
        private Object key;

        public KeyWrapper(Object key) {
            this.key = key;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof KeyWrapper) {
                o = ((KeyWrapper)o).key;
            }
            return this.key == o;
        }
    }

    private static class MethodKey {
        private Class<?> clazz;
        private String method;
        private Class<?>[] paramTypes;

        public MethodKey(Class<?> clazz, String method, Class<?>[] paramTypes) {
            this.clazz = clazz;
            this.method = method;
            this.paramTypes = paramTypes;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            result = 31 * result + Arrays.hashCode(this.paramTypes);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MethodKey other = (MethodKey)obj;
            if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
                return false;
            }
            if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
                return false;
            }
            return Arrays.equals(this.paramTypes, other.paramTypes);
        }
    }
}

