/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.station;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import ucar.unidata.ui.symbol.MetSymbol;
import ucar.unidata.ui.symbol.TextSymbol;

public class StationModelView
implements Cloneable,
Serializable {
    private ArrayList metsym = new ArrayList(20);
    private String name;
    private boolean debug = false;
    private MetSymbol selected = null;
    private int size = 20;

    public StationModelView(String name) {
        this.name = name;
    }

    public void addSymbol(MetSymbol ms) {
        this.metsym.add(ms);
    }

    public void removeSymbol(MetSymbol ms) {
        this.metsym.remove(ms);
    }

    public void changeTextSize(boolean incr) {
        if (this.debug) {
            System.out.println("StationModel changeTextSize");
        }
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            MetSymbol ms = (MetSymbol)iter.next();
            if (this.debug) {
                System.out.println(" changeTextSize " + ms);
            }
            if (!(ms instanceof TextSymbol)) continue;
            if (incr) {
                ((TextSymbol)ms).incrFontSize();
                continue;
            }
            ((TextSymbol)ms).decrFontSize();
        }
    }

    public Iterator iterator() {
        return this.metsym.iterator();
    }

    public MetSymbol findSymbolByName(String name) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            MetSymbol ms = (MetSymbol)iter.next();
            if (0 != name.compareTo(ms.getName())) continue;
            return ms;
        }
        return null;
    }

    public MetSymbol findSymbolByIndex(int idx) {
        return (MetSymbol)this.metsym.get(idx);
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAllMissing(boolean missing) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            MetSymbol ms = (MetSymbol)iter.next();
            ms.setMissing(missing);
        }
    }

    public void draw(Graphics2D g, Point2D loc) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            MetSymbol ms = (MetSymbol)iter.next();
            if (!ms.getActive() || ms.getMissing()) continue;
            ms.draw(g, loc);
        }
    }

    public MetSymbol getSelected() {
        return this.selected;
    }

    public void setSelected(MetSymbol ms) {
        this.selected = ms;
    }

    public void setColor(Color c) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            MetSymbol ms = (MetSymbol)iter.next();
            ms.setForeground(c);
        }
    }

    public Rectangle getBounds() {
        return this.getBounds(new Point(0, 0));
    }

    public Rectangle getBounds(Point2D loc) {
        Rectangle bounds = null;
        boolean cnt = false;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            MetSymbol ms = (MetSymbol)iter.next();
            if (!ms.getActive() || ms.getMissing()) continue;
            if (bounds == null) {
                bounds = new Rectangle(ms.getBounds(loc));
                continue;
            }
            bounds.add(ms.getBounds(loc));
        }
        if (bounds == null) {
            return new Rectangle();
        }
        return bounds;
    }

    public String toString() {
        return this.name;
    }

    public Object clone() {
        StationModelView cl;
        try {
            cl = (StationModelView)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        cl.name = new String(this.name);
        cl.metsym = new ArrayList(this.metsym.size());
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            cl.addSymbol((MetSymbol)((MetSymbol)iter.next()).cloneMe());
        }
        return cl;
    }
}

