/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.station;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.gis.SpatialGrid;
import ucar.unidata.metdata.Station;
import ucar.unidata.ui.symbol.CloudCoverageSymbol;
import ucar.unidata.ui.symbol.TextSymbol;
import ucar.unidata.util.Misc;
import ucar.unidata.util.StringUtil;
import ucar.unidata.view.Renderer;
import ucar.unidata.view.station.StationModelView;

public class StationLocationRenderer
implements Renderer {
    private ArrayList stations = new ArrayList(0);
    private Color color = Color.black;
    private SpatialGrid stationGrid;
    private StationModelView smv;
    private ProjectionImpl project = null;
    private boolean posWasCalc = false;
    private boolean declutter = true;
    private String template = "%ID%";
    private popupDisplay popup = null;
    private AffineTransform world2Normal;
    private StringBuffer sbuff = new StringBuffer(200);
    private Point2D.Double ptN = new Point2D.Double();
    private Rectangle markerSize;
    private boolean debug = false;
    private boolean debugInput = false;
    private boolean debugClosest = false;
    private boolean multipleSelect = false;
    private CloudCoverageSymbol cloudSymbol;
    private TextSymbol stationSymbol;
    private Properties stationNameMap;
    private boolean readStationNameMap = false;

    public StationLocationRenderer() {
        this("%ID%");
    }

    public StationLocationRenderer(String template) {
        this(false, template);
    }

    public StationLocationRenderer(boolean multipleSelect) {
        this(multipleSelect, "%ID%");
    }

    public StationLocationRenderer(boolean multipleSelect, String template) {
        this.multipleSelect = multipleSelect;
        this.stationGrid = new SpatialGrid(30, 30);
        this.template = template;
        this.smv = new StationModelView("Station");
        this.cloudSymbol = new CloudCoverageSymbol(0, 0, "cc", "cloud coverage");
        this.cloudSymbol.setSize(6, 6);
        this.cloudSymbol.setActive(true);
        this.cloudSymbol.setCoverage(0.0);
        this.markerSize = this.cloudSymbol.getBounds();
        this.smv.addSymbol(this.cloudSymbol);
        this.stationSymbol = new TextSymbol(0, -12, "name", "Station Name");
        this.stationSymbol.setSize(0, 9);
        this.stationSymbol.setActive(true);
        this.smv.addSymbol(this.stationSymbol);
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public LatLonRect getPreferredArea() {
        return null;
    }

    public void setStations(List stns, boolean declut) {
        this.setStations(stns, null, declut);
    }

    public void setStations(List stns, List selectedStations, boolean declut) {
        this.declutter = declut;
        this.stations.clear();
        for (int i = 0; i < stns.size(); ++i) {
            Station station = (Station)stns.get(i);
            SLStation slStation = new SLStation(station);
            if (selectedStations != null && selectedStations.contains(station)) {
                slStation.setSelected(true);
            } else {
                slStation.setSelected(false);
            }
            this.stations.add(slStation);
        }
    }

    public List getStations() {
        return new ArrayList(this.stations);
    }

    public void setSelectedStations(List selectedStations) {
        for (int i = 0; i < this.stations.size(); ++i) {
            SLStation slStation = (SLStation)this.stations.get(i);
            slStation.setSelected(selectedStations.contains(slStation.getStation()));
        }
    }

    public void setDeclutter(boolean declut) {
        this.declutter = declut;
    }

    public boolean getDeclutter() {
        return this.declutter;
    }

    @Override
    public void draw(Graphics2D g, AffineTransform normal2Device) {
        if (this.smv == null || this.project == null || !this.posWasCalc) {
            return;
        }
        AffineTransform world2Device = g.getTransform();
        g.setTransform(normal2Device);
        try {
            this.world2Normal = normal2Device.createInverse();
            this.world2Normal.concatenate(world2Device);
        }
        catch (NoninvertibleTransformException e) {
            System.out.println(" RendSurfObs: NoninvertibleTransformException on " + normal2Device);
            return;
        }
        g.setColor(this.color);
        Object saveHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(1.0f));
        Rectangle typicalBounds = null;
        Rectangle2D bbox = (Rectangle2D)g.getClip();
        this.stationGrid.clear();
        for (int i = 0; i < this.stations.size(); ++i) {
            SLStation s = (SLStation)this.stations.get(i);
            Point2D.Double worldPosP2D = new Point2D.Double(s.worldPos.getX(), s.worldPos.getY());
            this.world2Normal.transform(worldPosP2D, s.screenPos);
            s.resetBounds();
            if (s.screenPos.getX() == Double.POSITIVE_INFINITY || s.screenPos.getX() == Double.NEGATIVE_INFINITY || s.screenPos.getY() == Double.POSITIVE_INFINITY || s.screenPos.getY() == Double.NEGATIVE_INFINITY) continue;
            if (typicalBounds == null) {
                typicalBounds = this.declutter ? this.smv.getBounds() : this.markerSize;
                this.stationGrid.setGrid(bbox, typicalBounds);
            }
            boolean passDeclutter = this.stationGrid.markIfClear(s.getBounds(), s);
            if (s.getSelected() || !this.declutter || passDeclutter) {
                s.setVisible(true);
                s.draw(g);
                continue;
            }
            s.setVisible(false);
        }
        g.setTransform(world2Device);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, saveHint);
    }

    @Override
    public void setProjection(ProjectionImpl project) {
        this.project = project;
        this.calcWorldPos();
    }

    public StationModelView getStationModelView() {
        return this.smv;
    }

    private void calcWorldPos() {
        for (int i = 0; i < this.stations.size(); ++i) {
            SLStation s = (SLStation)this.stations.get(i);
            s.worldPos.setLocation(this.project.latLonToProj(s.latlonPos));
        }
        this.posWasCalc = true;
    }

    public SLStation find(Point2D pickPt) {
        if (this.world2Normal == null || pickPt == null || this.stations.isEmpty()) {
            return null;
        }
        this.world2Normal.transform(pickPt, this.ptN);
        double distance = Double.MAX_VALUE;
        SLStation closest = null;
        for (int i = 0; i < this.stations.size(); ++i) {
            Rectangle bounds;
            double tmpDistance;
            SLStation s = (SLStation)this.stations.get(i);
            if (!s.getVisible() || !((tmpDistance = this.ptN.distance(((RectangularShape)(bounds = s.getBounds())).getX() + ((RectangularShape)bounds).getWidth() / 2.0, ((RectangularShape)bounds).getY() + ((RectangularShape)bounds).getHeight() / 2.0)) < distance)) continue;
            distance = tmpDistance;
            closest = s;
        }
        return closest;
    }

    class popupDisplay
    extends JDialog {
        private JTextArea info;
        private LatLonPointImpl posLatLon = new LatLonPointImpl();

        popupDisplay() {
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            this.getContentPane().add(mainPanel);
            this.setTitle("Selected Station Info");
            this.info = new JTextArea();
            this.info.setLineWrap(true);
            this.info.setColumns(50);
            this.info.setRows(10);
            mainPanel.add((Component)this.info, "Center");
            this.pack();
            this.setLocation(200, 200);
        }

        public void show(SLStation s) {
            if (StationLocationRenderer.this.debugClosest) {
                System.out.println("selected = " + s + " " + this.info);
            }
            this.posLatLon.setLatitude(s.latlonPos.getLatitude());
            this.posLatLon.setLongitude(s.latlonPos.getLongitude());
            this.info.setText("Station: " + s.name + "\n");
            this.info.append("  pos: " + this.posLatLon + "\n");
            super.setVisible(true);
        }
    }

    public class SLStation {
        String name;
        LatLonPointImpl latlonPos = new LatLonPointImpl();
        ProjectionPointImpl worldPos = new ProjectionPointImpl();
        Point2D.Double screenPos = new Point2D.Double();
        Rectangle bounds = new Rectangle();
        private boolean selected = false;
        private boolean visible = true;
        Station myStation;

        SLStation(Station stn) {
            String displayName;
            this.myStation = stn;
            String stationName = stn.toString();
            if (StationLocationRenderer.this.stationNameMap == null && !StationLocationRenderer.this.readStationNameMap) {
                StationLocationRenderer.this.readStationNameMap = true;
                try {
                    StationLocationRenderer.this.stationNameMap = Misc.readProperties("/ucar/unidata/view/station/station.properties", null, this.getClass());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (StationLocationRenderer.this.stationNameMap != null && (displayName = (String)StationLocationRenderer.this.stationNameMap.get(stn.toString())) != null) {
                stationName = displayName;
            }
            this.name = StationLocationRenderer.this.template;
            this.name = StringUtil.replace(this.name, "%ID%", stn.getIdentifier());
            this.name = StringUtil.replace(this.name, "%NAME%", stationName);
            this.name = StringUtil.replace(this.name, "%LAT%", "" + stn.getLatitude());
            this.name = StringUtil.replace(this.name, "%LON%", "" + stn.getLongitude());
            this.latlonPos.setLatitude(stn.getLatitude());
            this.latlonPos.setLongitude(stn.getLongitude());
            this.worldPos.setLocation(StationLocationRenderer.this.project.latLonToProj(this.latlonPos));
        }

        public Station getStation() {
            return this.myStation;
        }

        public ProjectionPointImpl getLocation() {
            return this.worldPos;
        }

        public boolean getSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public boolean getVisible() {
            return this.visible;
        }

        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public void resetBounds() {
            StationLocationRenderer.this.stationSymbol.setValue(this.name);
            this.bounds = StationLocationRenderer.this.smv.getBounds(this.screenPos);
        }

        void draw(Graphics2D g) {
            StationLocationRenderer.this.smv.setColor(this.selected ? Color.red : StationLocationRenderer.this.color);
            try {
                StationLocationRenderer.this.stationSymbol.setValue(this.name);
                StationLocationRenderer.this.cloudSymbol.setCoverage(this.selected ? 100.0 : 0.0);
                StationLocationRenderer.this.smv.draw(g, this.screenPos);
            }
            catch (Exception exc) {
                System.err.println("error:" + this);
            }
        }

        public String toString() {
            return this.myStation.toString();
        }
    }
}

