/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.station;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import ucar.unidata.beans.NonVetoableProperty;
import ucar.unidata.beans.Property;
import ucar.unidata.beans.PropertySet;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionRect;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.gis.mcidasmap.McidasMap;
import ucar.unidata.metdata.Station;
import ucar.unidata.view.Renderer;
import ucar.unidata.view.geoloc.NavigatedPanel;
import ucar.unidata.view.geoloc.NewMapAreaEvent;
import ucar.unidata.view.geoloc.NewMapAreaListener;
import ucar.unidata.view.geoloc.PickEvent;
import ucar.unidata.view.geoloc.PickEventListener;
import ucar.unidata.view.station.StationLocationRenderer;

public class StationLocationMap
extends JPanel {
    public static final String SELECTED_PROPERTY = "selectedStation";
    public static final String UNSELECTED_PROPERTY = "unselectedStation";
    public static final String ALL_UNSELECTED_PROPERTY = "unselectedAll";
    public static final String DEFAULT_MAP = "/auxdata/maps/OUTLSUPW";
    public static final String LABEL_ID = "%ID%";
    public static final String LABEL_NAME = "%NAME%";
    public static final String LABEL_LAT = "%LAT%";
    public static final String LABEL_LON = "%LON%";
    public static final String TEMPLATE_ID = "%ID%";
    public static final String TEMPLATE_NAME = "%NAME%";
    public static final String TEMPLATE_NAME_AND_ID = "%ID%(%NAME%)";
    private NavigatedPanel navigatedPanel;
    private Renderer mapRender = null;
    private StationLocationRenderer stnRender = null;
    private ProjectionImpl project;
    private AffineTransform atI = new AffineTransform();
    private Property selectedStationProperty;
    private Property unselectedStationProperty;
    private Property unselectAllProperty;
    private PropertySet propertySet;
    private boolean multipleSelect = false;
    private boolean wasDoubleClick = false;
    private boolean debugTime = false;

    public StationLocationMap() {
        this(false);
    }

    public StationLocationMap(String template) {
        this(false, (String)null, template);
    }

    public StationLocationMap(boolean multipleSelect) {
        this(multipleSelect, (String)null, "%ID%");
    }

    public StationLocationMap(boolean multipleSelect, String defaultMap) {
        this(multipleSelect, defaultMap, "%ID%");
    }

    public StationLocationMap(boolean multipleSelect, String defaultMap, String template) {
        this(multipleSelect, new McidasMap(defaultMap != null ? defaultMap : DEFAULT_MAP), template);
    }

    public StationLocationMap(boolean multipleSelect, Renderer theMapRender) {
        this(multipleSelect, theMapRender, "%ID%");
    }

    public StationLocationMap(boolean multipleSelect, Renderer theMapRender, String template) {
        this.mapRender = theMapRender;
        this.multipleSelect = multipleSelect;
        this.selectedStationProperty = new NonVetoableProperty(this, SELECTED_PROPERTY);
        this.getPropertySet().addProperty(this.selectedStationProperty);
        this.unselectedStationProperty = new NonVetoableProperty(this, UNSELECTED_PROPERTY);
        this.getPropertySet().addProperty(this.unselectedStationProperty);
        this.unselectAllProperty = new NonVetoableProperty(this, ALL_UNSELECTED_PROPERTY);
        this.getPropertySet().addProperty(this.unselectAllProperty);
        this.navigatedPanel = new NavigatedPanel();
        this.stnRender = new StationLocationRenderer(multipleSelect, template);
        this.project = this.navigatedPanel.getProjectionImpl();
        this.mapRender.setProjection(this.project);
        this.stnRender.setProjection(this.project);
        this.navigatedPanel.addNewMapAreaListener(new NewMapAreaListener(){

            @Override
            public void actionPerformed(NewMapAreaEvent e) {
                if (StationLocationMap.this.project.isLatLon()) {
                    ProjectionRect boundingBox = StationLocationMap.this.navigatedPanel.getMapArea();
                    double wx0 = boundingBox.getX() + boundingBox.getWidth() / 2.0;
                    LatLonProjection llproj = (LatLonProjection)StationLocationMap.this.project;
                    if (llproj.getCenterLon() != wx0) {
                        llproj.setCenterLon(wx0);
                        wx0 = llproj.getCenterLon();
                        StationLocationMap.this.navigatedPanel.setWorldCenterX(wx0);
                        StationLocationMap.this.mapRender.setProjection(StationLocationMap.this.project);
                        StationLocationMap.this.stnRender.setProjection(StationLocationMap.this.project);
                    }
                }
                StationLocationMap.this.redraw();
            }
        });
        this.navigatedPanel.addPickEventListener(new PickEventListener(){

            @Override
            public void actionPerformed(PickEvent e) {
                if (e.isPointSelect()) {
                    StationLocationMap.this.doPickPoint(e);
                } else {
                    StationLocationMap.this.doPickRegion(e);
                }
            }
        });
        this.navigatedPanel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (StationLocationMap.this.getMultipleSelect() && e.getKeyCode() == 65 && e.isControlDown()) {
                    StationLocationMap.this.selectAll();
                } else if (e.getKeyCode() == 82 && e.isControlDown()) {
                    StationLocationMap.this.navigatedPanel.resetZoom();
                }
            }
        });
        this.navigatedPanel.setBorder(BorderFactory.createEtchedBorder());
        this.navigatedPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                StationLocationMap.this.navigatedPanel.requestFocus();
                if (!StationLocationMap.this.getMultipleSelect()) {
                    return;
                }
                if (!SwingUtilities.isRightMouseButton(e)) {
                    return;
                }
                JPopupMenu popup = new JPopupMenu();
                JMenuItem mi = new JMenuItem("Select All");
                mi.setAccelerator(KeyStroke.getKeyStroke(new Character('A'), 2));
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StationLocationMap.this.selectAll();
                    }
                });
                popup.add(mi);
                mi = new JMenuItem("Clear Selection");
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        StationLocationMap.this.unselectSelected();
                        StationLocationMap.this.redraw();
                    }
                });
                popup.add(mi);
                popup.show(StationLocationMap.this.navigatedPanel, e.getX(), e.getY());
            }
        });
        this.setLayout(new BorderLayout());
        this.navigatedPanel.setPreferredSize(new Dimension(400, 300));
        JPanel toolPanel = new JPanel(new FlowLayout(0));
        JCheckBox declutCB = new JCheckBox("Declutter", true);
        declutCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StationLocationMap.this.setDeclutter(((JCheckBox)e.getSource()).isSelected());
            }
        });
        toolPanel.add(declutCB);
        toolPanel.add(this.navigatedPanel.getNavToolBar());
        toolPanel.add(this.navigatedPanel.getMoveToolBar());
        JPanel statusPanel = new JPanel(new BorderLayout());
        statusPanel.setBorder(new EtchedBorder());
        JLabel positionLabel = new JLabel("position");
        statusPanel.add((Component)positionLabel, "Center");
        this.navigatedPanel.setPositionLabel(positionLabel);
        this.add((Component)toolPanel, "South");
        this.add((Component)this.navigatedPanel, "Center");
    }

    private void select(StationLocationRenderer.SLStation s) {
        this.select(s, false);
    }

    private void select(StationLocationRenderer.SLStation s, boolean wasDoubleClick) {
        this.wasDoubleClick = wasDoubleClick;
        s.setSelected(true);
        try {
            this.selectedStationProperty.setValueAndNotifyListeners(s.getStation());
            this.selectedStationProperty.clearValue();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.wasDoubleClick = false;
    }

    private void unselect(StationLocationRenderer.SLStation s) {
        s.setSelected(false);
        try {
            this.unselectedStationProperty.setValueAndNotifyListeners(s.getStation());
            this.unselectedStationProperty.clearValue();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private void doPickRegion(PickEvent pickEvent) {
        if (!this.isMultipleSelect()) {
            return;
        }
        boolean isAdditivePick = true;
        if (!isAdditivePick) {
            this.unselectSelected();
        }
        Rectangle2D pickBounds = pickEvent.getBounds();
        List stations = this.stnRender.getStations();
        for (int i = 0; i < stations.size(); ++i) {
            Rectangle stationBounds;
            StationLocationRenderer.SLStation station = (StationLocationRenderer.SLStation)stations.get(i);
            if (station.getSelected() || !station.getVisible() || !(stationBounds = station.getBounds()).intersects(pickBounds.getX(), pickBounds.getY(), pickBounds.getWidth(), pickBounds.getHeight())) continue;
            this.select(station);
        }
        this.redraw();
    }

    protected void doPickPoint(PickEvent e) {
        StationLocationRenderer.SLStation closest = this.stnRender.find(e.getLocation());
        if (closest == null) {
            return;
        }
        MouseEvent mouseEvent = e.getMouseEvent();
        boolean isAdditivePick = true;
        boolean closestWasSelected = closest.getSelected();
        if (!this.multipleSelect || !isAdditivePick) {
            this.unselectSelected();
        }
        if (this.multipleSelect) {
            if (closestWasSelected) {
                this.unselect(closest);
            } else {
                this.select(closest);
            }
        } else {
            this.select(closest, mouseEvent.getClickCount() > 1);
        }
        this.redraw();
    }

    private void unselectSelected() {
        this.setSelectedStations(new ArrayList());
        this.unselectAllProperty.notifyListeners();
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    protected void selectAll() {
        List stations = this.stnRender.getStations();
        for (int i = 0; i < stations.size(); ++i) {
            StationLocationRenderer.SLStation station = (StationLocationRenderer.SLStation)stations.get(i);
            if (station.getSelected()) continue;
            this.select(station);
        }
        this.redraw();
    }

    public boolean isMultipleSelect() {
        return this.multipleSelect;
    }

    public List getSelectedStations() {
        ArrayList<Station> selectedStations = new ArrayList<Station>();
        List stations = this.stnRender.getStations();
        for (int i = 0; i < stations.size(); ++i) {
            StationLocationRenderer.SLStation station = (StationLocationRenderer.SLStation)stations.get(i);
            if (!station.getSelected()) continue;
            selectedStations.add(station.getStation());
        }
        return selectedStations;
    }

    public NavigatedPanel getNavigatedPanel() {
        return this.navigatedPanel;
    }

    public void setMapRenderer(Renderer r) {
        this.mapRender = r;
        this.mapRender.setProjection(this.project);
        this.redraw();
    }

    public Renderer getMapRender() {
        return this.mapRender;
    }

    public StationLocationRenderer getStationLocationRenderer() {
        return this.stnRender;
    }

    public void setStationRenderer(Renderer r) {
        this.stnRender = (StationLocationRenderer)r;
        this.stnRender.setProjection(this.project);
        this.redraw();
    }

    public void setSelectedStations(List stns) {
        this.stnRender.setSelectedStations(stns);
        this.redraw();
    }

    public void setStations(List stns) {
        this.setStations(stns, true);
    }

    public void setStations(List stns, boolean declutter) {
        this.setStations(stns, null, declutter);
    }

    public void setStations(List stns, List selectedStations, boolean declutter) {
        this.stnRender.setStations(stns, selectedStations, declutter);
        this.redraw();
    }

    public List getStations() {
        return this.stnRender.getStations();
    }

    public void setDeclutter(boolean declut) {
        this.stnRender.setDeclutter(declut);
        this.redraw();
    }

    public void clearStations() {
        this.setStations(new ArrayList(0));
    }

    public boolean getDeclutter() {
        return this.stnRender.getDeclutter();
    }

    public void setProjectionImpl(ProjectionImpl p) {
        this.mapRender.setProjection(p);
        this.stnRender.setProjection(p);
        this.navigatedPanel.setProjectionImpl(p);
        this.project = p;
        this.redraw();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertySet().addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertySet().removePropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.getPropertySet().addPropertyChangeListener(name, listener);
    }

    @Override
    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.getPropertySet().removePropertyChangeListener(name, listener);
    }

    public void redraw() {
        Graphics2D gNP = this.navigatedPanel.getBufferedImageGraphics();
        if (gNP == null) {
            return;
        }
        gNP.setBackground(this.navigatedPanel.getBackgroundColor());
        Rectangle r = gNP.getClipBounds();
        gNP.clearRect(r.x, r.y, r.width, r.height);
        this.mapRender.draw(gNP, this.atI);
        this.stnRender.draw(gNP, this.atI);
        gNP.dispose();
        this.navigatedPanel.repaint();
    }

    public boolean getMultipleSelect() {
        return this.multipleSelect;
    }

    public static void main(String[] args) {
        StationLocationMap slm = new StationLocationMap();
        JFrame frame = new JFrame("Station Location Map Test");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.getContentPane().add(slm);
        frame.pack();
        frame.setVisible(true);
    }

    public boolean getWasDoubleClick() {
        return this.wasDoubleClick;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PropertySet getPropertySet() {
        if (this.propertySet == null) {
            StationLocationMap stationLocationMap = this;
            synchronized (stationLocationMap) {
                if (this.propertySet == null) {
                    this.propertySet = new PropertySet();
                }
            }
        }
        return this.propertySet;
    }
}

