/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import ucar.unidata.view.sounding.WindProfile;
import ucar.visad.display.CompositeDisplayable;
import ucar.visad.quantities.GeopotentialAltitude;
import ucar.visad.quantities.Speed;
import visad.Gridded1DSet;
import visad.LocalDisplay;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.VisADException;

public class WindProfileSet
extends CompositeDisplayable {
    public static String ACTIVE_WIND_PROFILE = "activeWindProfile";
    public static String GEOPOTENTIAL_ALTITUDE = "altitude";
    public static String PRESSURE = "pressure";
    public static String SPEED = "speed";
    public static String DIRECTION = "direction";
    public static String GEOPOTENTIAL_ALTITUDE_EXTENT = "geopotentialAltitudeExtent";
    public static String MAXIMUM_SPEED = "maximumSpeed";
    private static RealTuple missingAltitudeExtent;
    private static Real missingSpeed;
    private static Real missingAltitude;
    private Real altitude;
    private Real pressure;
    private Real maxSpeed;
    private Real speed;
    private Real direction;
    private WindProfile activeWindProfile;
    private RealTuple altitudeExtent;
    private WindProfile missingWindProfile;
    private PropertyChangeListener speedListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            WindProfileSet.this.speed = (Real)event.getNewValue();
            PropertyChangeEvent newEvent = new PropertyChangeEvent(WindProfileSet.this, SPEED, event.getOldValue(), WindProfileSet.this.speed);
            newEvent.setPropagationId(event.getPropagationId());
            WindProfileSet.this.firePropertyChange(newEvent);
        }
    };
    private PropertyChangeListener directionListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            WindProfileSet.this.direction = (Real)event.getNewValue();
            PropertyChangeEvent newEvent = new PropertyChangeEvent(WindProfileSet.this, DIRECTION, event.getOldValue(), WindProfileSet.this.direction);
            newEvent.setPropagationId(event.getPropagationId());
            WindProfileSet.this.firePropertyChange(newEvent);
        }
    };

    public WindProfileSet(WindProfile missingWindProfile, LocalDisplay display) throws VisADException, RemoteException {
        super(display);
        this.maxSpeed = missingSpeed;
        this.altitude = missingAltitude;
        this.altitudeExtent = missingAltitudeExtent;
        this.missingWindProfile = missingWindProfile;
        this.activeWindProfile = missingWindProfile;
        this.speed = this.activeWindProfile.getSpeed();
        this.direction = this.activeWindProfile.getDirection();
    }

    public synchronized void addWindProfile(WindProfile windProfile) throws RemoteException, VisADException {
        this.addWindProfile(this.displayableCount(), windProfile);
    }

    public synchronized void addWindProfile(int index, WindProfile windProfile) throws RemoteException, VisADException {
        this.setDisplayable(index, windProfile);
        Real thisMax = this.getMaximumSpeed();
        Real thatMax = windProfile.getMaximumSpeed();
        if (thisMax.isMissing()) {
            this.setMaximumSpeed(thatMax);
        } else if (!thatMax.isMissing()) {
            this.setMaximumSpeed((Real)thisMax.max(thatMax));
        }
    }

    public synchronized void removeWindProfile(int index) throws IndexOutOfBoundsException, RemoteException, VisADException {
        WindProfile windProfile = (WindProfile)this.getDisplayable(index);
        if (windProfile == null) {
            return;
        }
        if (windProfile == this.activeWindProfile) {
            this.removeListeners(windProfile);
        }
        this.removeDisplayable(windProfile);
        if (this.displayableCount() == 0 || windProfile == this.activeWindProfile) {
            this.setActiveWindProfile(this.missingWindProfile);
            this.setMaximumSpeed(missingSpeed);
        }
    }

    public void setActiveWindProfile(int index) throws RemoteException, VisADException {
        WindProfile active;
        WindProfile windProfile = active = index < 0 ? this.missingWindProfile : (WindProfile)this.getDisplayable(index);
        if (active == null) {
            active = this.missingWindProfile;
        }
        this.setActiveWindProfile(active);
    }

    protected void setActiveWindProfile(WindProfile profile) throws RemoteException, VisADException {
        if (profile == null) {
            profile = this.missingWindProfile;
        }
        this.removeListeners(this.activeWindProfile);
        WindProfile old = this.activeWindProfile;
        this.activeWindProfile = profile;
        this.activeWindProfile.setGeopotentialAltitude(this.altitude);
        this.activeWindProfile.setPressure(this.activeWindProfile.getPressure());
        this.setSpeed(this.activeWindProfile.getSpeed());
        this.setDirection(this.activeWindProfile.getDirection());
        this.setGeopotentialAltitudeExtent();
        this.addListeners(this.activeWindProfile);
        this.firePropertyChange(ACTIVE_WIND_PROFILE, old, this.activeWindProfile);
    }

    public WindProfile getActiveWindProfile() {
        return this.activeWindProfile;
    }

    public void setOriginalProfile(int index) throws VisADException, RemoteException {
        WindProfile profile = (WindProfile)this.getDisplayable(index);
        if (profile != null) {
            profile.setOriginalProfile();
        }
    }

    public void setGeopotentialAltitude(Real geoAlt) throws RemoteException, VisADException {
        Real oldAltitude = this.altitude;
        this.altitude = geoAlt;
        this.activeWindProfile.setGeopotentialAltitude(this.altitude);
        this.firePropertyChange(GEOPOTENTIAL_ALTITUDE, oldAltitude, this.altitude);
    }

    public Real getGeopotentialAltitude() {
        return this.altitude;
    }

    protected void setGeopotentialAltitudeExtent() throws RemoteException, VisADException {
        WindProfile windProfile = this.getActiveWindProfile();
        RealTuple thisExtent = windProfile.getGeopotentialAltitudeExtent();
        this.setGeopotentialAltitudeExtent(new RealTuple(new Real[]{(Real)this.altitudeExtent.getComponent(0).min(thisExtent.getComponent(0)), (Real)this.altitudeExtent.getComponent(1).max(thisExtent.getComponent(1))}));
    }

    protected void setGeopotentialAltitudeExtent(RealTuple extent) {
        RealTuple old = this.altitudeExtent;
        this.altitudeExtent = extent;
        this.firePropertyChange(GEOPOTENTIAL_ALTITUDE_EXTENT, old, this.altitudeExtent);
    }

    public RealTuple getGeopotentialAltitudeExtent() {
        return this.altitudeExtent;
    }

    public synchronized void setWindLevels(Gridded1DSet levels) throws VisADException, RemoteException {
        for (int i = 0; i < this.displayableCount(); ++i) {
            WindProfile windProfile = (WindProfile)this.getDisplayable(i);
            if (windProfile == null) continue;
            windProfile.setWindLevels(levels);
        }
    }

    public synchronized void setPressure(Real pressure) throws RemoteException, VisADException {
        Real oldPressure = this.pressure;
        this.pressure = pressure;
        this.activeWindProfile.setPressure(pressure);
        this.firePropertyChange(PRESSURE, oldPressure, this.pressure);
    }

    protected void setSpeed(Real spd) {
        Real old = this.speed;
        this.speed = spd;
        this.firePropertyChange(SPEED, old, this.speed);
    }

    public Real getSpeed() {
        return this.speed;
    }

    protected void setDirection(Real dir) {
        Real old = this.direction;
        this.direction = dir;
        this.firePropertyChange(DIRECTION, old, this.direction);
    }

    public Real getDirection() {
        return this.direction;
    }

    public RealType getGeopotentialAltitudeRealType() throws VisADException, RemoteException {
        return GeopotentialAltitude.getRealType();
    }

    protected void setMaximumSpeed(Real speed) {
        Real old = this.maxSpeed;
        this.maxSpeed = speed;
        this.firePropertyChange(MAXIMUM_SPEED, old, this.maxSpeed);
    }

    public Real getMaximumSpeed() {
        return this.maxSpeed;
    }

    public RealType getWesterlyWindRealType() throws VisADException, RemoteException {
        return WindProfile.getWesterlyWindRealType();
    }

    public RealType getSoutherlyWindRealType() throws VisADException, RemoteException {
        return WindProfile.getSoutherlyWindRealType();
    }

    public synchronized void clear() throws VisADException, RemoteException {
        for (int i = 0; i < this.displayableCount(); ++i) {
            this.removeWindProfile(i);
        }
    }

    private void addListeners(WindProfile windProfile) {
        windProfile.addPropertyChangeListener(WindProfile.SPEED, this.speedListener);
        windProfile.addPropertyChangeListener(WindProfile.DIRECTION, this.directionListener);
    }

    private void removeListeners(WindProfile windProfile) {
        windProfile.removePropertyChangeListener(WindProfile.SPEED, this.speedListener);
        windProfile.removePropertyChangeListener(WindProfile.DIRECTION, this.directionListener);
    }

    static {
        try {
            RealType geoAltType = GeopotentialAltitude.getRealType();
            missingAltitudeExtent = new RealTuple(new RealTupleType(geoAltType, geoAltType));
            missingSpeed = new Real(Speed.getRealType());
            missingAltitude = new Real(geoAltType);
        }
        catch (Exception e) {
            System.err.print("Couldn't initialize class: ");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

