/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.visad.WindBarbRenderer;
import ucar.visad.display.Displayable;
import ucar.visad.display.LineDrawing;
import visad.CommonUnit;
import visad.DataRenderer;
import visad.Field;
import visad.VisADException;
import visad.bom.BarbRendererJ2D;
import visad.java2d.DisplayRendererJ2D;

public class WindProfileDisplayable
extends LineDrawing {
    public WindProfileDisplayable() throws VisADException, RemoteException {
        super("WindProfileDisplayable");
    }

    protected WindProfileDisplayable(WindProfileDisplayable that) throws VisADException, RemoteException {
        super(that);
    }

    public void setProfile(Field profile) throws VisADException, RemoteException {
        if (profile == null) {
            throw new NullPointerException();
        }
        this.setData(profile);
    }

    public Field getProfile() throws VisADException, RemoteException {
        return (Field)this.getData();
    }

    public boolean equals(Object obj) {
        boolean equals;
        if (!(obj instanceof WindProfileDisplayable)) {
            equals = false;
        } else {
            try {
                WindProfileDisplayable that = (WindProfileDisplayable)obj;
                Field thisWind = this.getProfile();
                Field thatWind = that.getProfile();
                equals = this == that || (thisWind == null ? thatWind == null : thisWind.equals(thatWind)) && super.equals(that);
            }
            catch (Exception e) {
                System.err.println(this.getClass().getName() + ".equals(Object): " + "Couldn't get wind data: " + e);
                equals = false;
            }
        }
        return equals;
    }

    public int hashCode() {
        int code;
        try {
            Field wind = this.getProfile();
            code = (wind == null ? 0 : wind.hashCode()) ^ super.hashCode();
        }
        catch (Exception e) {
            System.err.println(this.getClass().getName() + ".hashCode(): " + "Couldn't get wind data: " + e);
            code = 0;
        }
        return code;
    }

    @Override
    public Displayable cloneForDisplay() throws VisADException, RemoteException {
        return new WindProfileDisplayable(this);
    }

    @Override
    protected DataRenderer getDataRenderer() {
        DataRenderer br = this.getDisplay().getDisplayRenderer() instanceof DisplayRendererJ2D ? new BarbRendererJ2D() : new WindBarbRenderer(CommonUnit.meterPerSecond);
        return br;
    }
}

