/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.view.sounding.MeanWindSet;
import ucar.unidata.view.sounding.WindProfile;
import ucar.unidata.view.sounding.WindProfileDisplayRenderer;
import ucar.unidata.view.sounding.WindProfileSet;
import ucar.visad.Util;
import ucar.visad.display.DisplayMaster;
import ucar.visad.display.Displayable;
import ucar.visad.display.DisplayableData;
import ucar.visad.functiontypes.CartesianHorizontalWindOfGeopotentialAltitude;
import ucar.visad.quantities.CartesianHorizontalWind;
import ucar.visad.quantities.GeopotentialAltitude;
import visad.CommonUnit;
import visad.ConstantMap;
import visad.CoordinateSystem;
import visad.DataReference;
import visad.Display;
import visad.DisplayEvent;
import visad.DisplayImpl;
import visad.DisplayListener;
import visad.DisplayRealType;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.Tuple;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.data.units.DefaultUnitsDB;

public abstract class WindProfileDisplay
extends DisplayMaster {
    public static String GEOPOTENTIAL_ALTITUDE = "geopotentialAltitude";
    public static String PROFILE_SPEED = "profileSpeed";
    public static String PROFILE_DIRECTION = "profileDirection";
    public static String ACTIVE_PROFILE = "activeProfile";
    public static String ACTIVE_MEAN_WIND = "activeMeanWind";
    private static final double ln10 = Math.log(10.0);
    private static Real defaultMinAltitude;
    private static Real defaultMaxAltitude;
    private WindProfileSet windProfileSet;
    private MeanWindSet meanWindSet;
    private RealTuple displayAltitudeExtent;
    private Unit speedUnit;
    private Unit altitudeUnit;
    private boolean autoscaleAltitude;
    private RealTuple altitudeExtent;
    private WindProfileDisplayRenderer renderer = (WindProfileDisplayRenderer)((Object)this.getDisplay().getDisplayRenderer());
    private ScalarMap altitudeMap;
    private ScalarMap altitudeColorMap;

    protected static Real getDefaultMinAltitude() {
        return defaultMinAltitude;
    }

    protected static Real getDefaultMaxAltitude() {
        return defaultMaxAltitude;
    }

    protected WindProfileDisplay(DisplayImpl displayImpl, Real minZ, Real maxZ, int displayableCount, DisplayRealType verticalDisplayRealType) throws VisADException, RemoteException {
        super(displayImpl, displayableCount);
        this.renderer.addCursorPositionListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                try {
                    WindProfileDisplay.this.setCursorPosition((double[])event.getNewValue());
                }
                catch (Exception e) {
                    System.err.println(this.getClass().getName() + "propertyChange(): " + "Couldn't handle change to cursor position: " + e);
                }
            }
        });
        this.displayAltitudeExtent = new RealTuple(new Real[]{minZ, maxZ});
        this.autoscaleAltitude = true;
        this.altitudeUnit = minZ.getUnit();
        this.renderer.setBoxOn(false);
        this.renderer.setCursorStringOn(false);
        this.getDisplay().getGraphicsModeControl().setScaleEnable(true);
        this.altitudeMap = new ScalarMap(GeopotentialAltitude.getRealType(), verticalDisplayRealType);
        this.setAltitudeMapRange();
        this.addScalarMap(this.altitudeMap);
        this.altitudeColorMap = new ScalarMap(GeopotentialAltitude.getRealType(), Display.Hue);
        this.setAltitudeColorMapRange();
        this.addScalarMap(this.altitudeColorMap);
        this.addScalarMap(new ConstantMap(1.0, Display.Saturation));
        this.windProfileSet = new WindProfileSet(this.newWindProfile(), this.getDisplay());
        this.addDisplayable(this.windProfileSet);
        this.windProfileSet.addPropertyChangeListener(WindProfileSet.GEOPOTENTIAL_ALTITUDE_EXTENT, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                try {
                    if (WindProfileDisplay.this.isAutoscaleAltitude()) {
                        WindProfileDisplay.this.setDisplayAltitudeExtent();
                    }
                }
                catch (Exception e) {
                    System.err.println(this.getClass().getName() + ".propertyChange(): " + "Couldn't handle change to profile altitude extent: " + e);
                }
            }
        });
        this.windProfileSet.addPropertyChangeListener(WindProfileSet.SPEED, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                PropertyChangeEvent newEvent = new PropertyChangeEvent(WindProfileDisplay.this, PROFILE_SPEED, event.getOldValue(), event.getNewValue());
                newEvent.setPropagationId(event.getPropagationId());
                WindProfileDisplay.this.firePropertyChange(newEvent);
            }
        });
        this.windProfileSet.addPropertyChangeListener(WindProfileSet.DIRECTION, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                PropertyChangeEvent newEvent = new PropertyChangeEvent(WindProfileDisplay.this, PROFILE_DIRECTION, event.getOldValue(), event.getNewValue());
                newEvent.setPropagationId(event.getPropagationId());
                WindProfileDisplay.this.firePropertyChange(newEvent);
            }
        });
        this.windProfileSet.addPropertyChangeListener(WindProfileSet.ACTIVE_WIND_PROFILE, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                try {
                    PropertyChangeEvent newEvent = new PropertyChangeEvent(WindProfileDisplay.this, ACTIVE_PROFILE, event.getOldValue(), event.getNewValue());
                    newEvent.setPropagationId(event.getPropagationId());
                    WindProfileDisplay.this.firePropertyChange(newEvent);
                }
                catch (Exception e) {
                    System.err.println(this.getClass().getName() + ".propertyChange(): " + "Couldn't handle change to active wind-profile: " + e);
                }
            }
        });
        this.addDisplayListener(new DisplayListener(){

            @Override
            public void displayChanged(DisplayEvent event) {
                int id = event.getId();
                try {
                    if (id == 10) {
                        WindProfileDisplay.this.firePropertyChange(ACTIVE_PROFILE, null, WindProfileDisplay.this.windProfileSet.getActiveWindProfile().getProfile());
                    }
                }
                catch (Exception e) {
                    System.err.println(this.getClass().getName() + ".displayChanged(): " + "Couldn't handle display change: " + e);
                }
            }
        });
        this.meanWindSet = new MeanWindSet(this.newMeanWind(), this.getDisplay());
        this.meanWindSet.addPropertyChangeListener(MeanWindSet.ACTIVE_MEAN_WIND, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                try {
                    PropertyChangeEvent newEvent = new PropertyChangeEvent(WindProfileDisplay.this, ACTIVE_MEAN_WIND, ((DisplayableData)event.getOldValue()).getData(), ((DisplayableData)event.getNewValue()).getData());
                    newEvent.setPropagationId(event.getPropagationId());
                    WindProfileDisplay.this.firePropertyChange(newEvent);
                }
                catch (Exception e) {
                    System.err.println(this.getClass().getName() + ".propertyChange(): " + "Couldn't handle change to active mean wind: " + e);
                }
            }
        });
        this.addDisplayable(this.meanWindSet);
    }

    protected WindProfileSet getWindProfileSet() {
        return this.windProfileSet;
    }

    public void setAutoscaleAltitude(boolean value) {
        this.autoscaleAltitude = value;
    }

    public boolean isAutoscaleAltitude() {
        return this.autoscaleAltitude;
    }

    public void addProfile(int index, Field field) throws VisADException, RemoteException {
        WindProfile profile = this.newWindProfile();
        profile.setVisible(false);
        FlatField ff = (FlatField)this.vetWinds(field);
        if (ff != null) {
            profile.setProfile(ff);
        }
        this.windProfileSet.addWindProfile(index, profile);
    }

    public void removeProfile(int index) throws IndexOutOfBoundsException, RemoteException, VisADException {
        this.windProfileSet.removeWindProfile(index);
    }

    public void setActiveWindProfile(int index) throws VisADException, RemoteException {
        this.windProfileSet.setActiveWindProfile(index);
    }

    public void setProfileVisible(int index, boolean visible) throws VisADException, RemoteException {
        this.windProfileSet.setVisible(visible, index, index);
    }

    protected abstract WindProfile newWindProfile() throws VisADException, RemoteException;

    public Field getWindProfile() throws RemoteException, VisADException {
        return this.windProfileSet.getActiveWindProfile().getProfile();
    }

    public void setMeanWind(int index, Tuple meanWind) throws VisADException, RemoteException {
        Displayable meanWindDisplayable = this.newMeanWind(meanWind);
        meanWindDisplayable.setVisible(false);
        this.meanWindSet.setMeanWind(index, meanWindDisplayable);
    }

    public void setMeanWind(int index, DataReference meanWindRef) throws VisADException, RemoteException {
        Displayable meanWindDisplayable = this.newMeanWind(meanWindRef);
        meanWindDisplayable.setVisible(false);
        this.meanWindSet.setMeanWind(index, meanWindDisplayable);
    }

    public void removeMeanWind(int index) throws IndexOutOfBoundsException, VisADException, RemoteException {
        this.meanWindSet.removeMeanWind(index);
    }

    public void setMeanWindVisible(int index, boolean visible) throws VisADException, RemoteException {
        this.meanWindSet.setVisible(visible, index, index);
    }

    public void setActiveMeanWind(int index) throws VisADException, RemoteException {
        this.meanWindSet.setActiveMeanWind(index);
    }

    public void clear() throws VisADException, RemoteException {
        this.windProfileSet.clear();
        this.meanWindSet.clear();
    }

    public Real getMinProfileAltitude() throws VisADException, RemoteException {
        return (Real)this.windProfileSet.getGeopotentialAltitudeExtent().getComponent(0);
    }

    public Real getMaxProfileAltitude() throws VisADException, RemoteException {
        return (Real)this.windProfileSet.getGeopotentialAltitudeExtent().getComponent(1);
    }

    public void setGeopotentialAltitude(Real geoAlt) throws VisADException, RemoteException {
        Real old = this.getGeopotentialAltitude();
        this.windProfileSet.setGeopotentialAltitude(geoAlt);
        this.firePropertyChange(GEOPOTENTIAL_ALTITUDE, old, geoAlt);
    }

    public Real getGeopotentialAltitude() {
        return this.windProfileSet.getGeopotentialAltitude();
    }

    protected Real getProfileSpeed() {
        return this.windProfileSet.getSpeed();
    }

    protected Real getProfileDirection() {
        return this.windProfileSet.getDirection();
    }

    public void setBackgroundVisible(boolean b) throws VisADException, RemoteException {
        this.altitudeMap.setScaleEnable(b);
    }

    public void setAltitudeScaleVisible(boolean visible) throws VisADException, RemoteException {
        this.altitudeMap.setScaleEnable(visible);
    }

    protected double computeIncrement(double extent, int maxCount) {
        double increment = Math.exp(ln10 * Math.ceil(Math.log(extent / (double)maxCount) / ln10));
        int count = (int)(extent / increment);
        if (count * 5 <= maxCount) {
            increment /= 5.0;
        } else if (count * 2 <= maxCount) {
            increment /= 2.0;
        }
        return increment;
    }

    protected void setAltitudeMapRange() throws RemoteException, VisADException {
        Unit altitudeUnit = ((RealType)this.altitudeMap.getScalar()).getDefaultUnit();
        this.altitudeMap.setRange(this.getMinDisplayAltitude().getValue(altitudeUnit), this.getMaxDisplayAltitude().getValue(altitudeUnit));
    }

    protected void setAltitudeColorMapRange() throws RemoteException, VisADException {
        Unit altitudeUnit = ((RealType)this.altitudeColorMap.getScalar()).getDefaultUnit();
        this.altitudeColorMap.setRange(this.getMinDisplayAltitude().getValue(altitudeUnit), this.getMaxDisplayAltitude().getValue(altitudeUnit));
    }

    protected void setDisplayAltitudeExtent() throws VisADException, RemoteException {
        Unit altUnit = this.getAltitudeUnit();
        double minProfileAlt = this.getMinProfileAltitude().getValue(altUnit);
        double maxProfileAlt = this.getMaxProfileAltitude().getValue(altUnit);
        double extent = maxProfileAlt - minProfileAlt;
        if (!Double.isNaN(extent) && !Double.isInfinite(extent) && extent > 0.0) {
            double increment = this.computeIncrement(extent, 5);
            this.setDisplayAltitudeExtent(new RealTuple(new Real[]{new Real(GeopotentialAltitude.getRealType(), Math.floor(minProfileAlt / increment) * increment, altUnit), new Real(GeopotentialAltitude.getRealType(), Math.ceil(maxProfileAlt / increment) * increment, altUnit)}));
        }
    }

    public void setDisplayAltitudeExtent(RealTuple extent) throws VisADException, RemoteException {
        this.displayAltitudeExtent = extent;
        this.displayAltitudeExtentChange();
    }

    protected abstract void displayAltitudeExtentChange() throws VisADException, RemoteException;

    public Real getMinDisplayAltitude() throws VisADException, RemoteException {
        return (Real)this.displayAltitudeExtent.getComponent(0);
    }

    public Real getMaxDisplayAltitude() throws VisADException, RemoteException {
        return (Real)this.displayAltitudeExtent.getComponent(1);
    }

    public void setAltitudeUnit(Unit geoAltUnit) throws UnitException, VisADException, RemoteException {
        if (!Unit.canConvert(geoAltUnit, CommonUnit.meterPerSecond)) {
            throw new UnitException("\"Geopotential altitude\" unit (" + geoAltUnit + ") isn't");
        }
        if (!geoAltUnit.equals(this.altitudeUnit)) {
            this.altitudeUnit = geoAltUnit;
            this.setDisplayAltitudeExtent();
        }
    }

    public Unit getAltitudeUnit() {
        return this.altitudeUnit;
    }

    protected abstract void setCursorPosition(double[] var1) throws VisADException, RemoteException;

    public double[] getCursorPosition() {
        return this.renderer.getCursorPosition();
    }

    protected abstract Displayable newMeanWind(Tuple var1) throws VisADException, RemoteException;

    protected abstract Displayable newMeanWind(DataReference var1) throws VisADException, RemoteException;

    protected abstract Displayable newMeanWind();

    private Field vetWinds(Field profile) throws VisADException, RemoteException {
        if (profile == null) {
            return profile;
        }
        boolean isSequence = GridUtil.isTimeSequence((FieldImpl)profile);
        FlatField data = isSequence ? (FlatField)profile.getSample(0) : (FlatField)profile;
        data = this.ensureCartesian(data);
        return data;
    }

    private FlatField ensureCartesian(FlatField input) throws VisADException, RemoteException {
        FlatField output;
        FunctionType inputFunction = (FunctionType)input.getType();
        if (!inputFunction.getDomain().getComponent(0).equals(GeopotentialAltitude.getRealType())) {
            input = Util.convertDomain(input, GeopotentialAltitude.getRealTupleType(), null);
        }
        if (Unit.canConvert(input.getDefaultRangeUnits()[0], CommonUnit.meterPerSecond) && Unit.canConvert(input.getDefaultRangeUnits()[1], CommonUnit.meterPerSecond)) {
            output = input;
        } else {
            RealTupleType cartesianType = CartesianHorizontalWind.getRealTupleType();
            output = new FlatField(CartesianHorizontalWindOfGeopotentialAltitude.instance(), input.getDomainSet());
            RealTupleType inputType = (RealTupleType)((FunctionType)input.getType()).getRange();
            ErrorEstimate[] inputErrors = input.getRangeErrors();
            ErrorEstimate[] outputErrors = new ErrorEstimate[inputErrors.length];
            output.setSamples(CoordinateSystem.transformCoordinates(cartesianType, cartesianType.getCoordinateSystem(), cartesianType.getDefaultUnits(), outputErrors, inputType, Util.getRangeCoordinateSystem(input), Util.getRangeUnits(input), inputErrors, input.getValues()));
        }
        return output;
    }

    static {
        try {
            defaultMinAltitude = new Real(GeopotentialAltitude.getRealType(), 0.0, DefaultUnitsDB.instance().get("gpm"));
            defaultMaxAltitude = new Real(GeopotentialAltitude.getRealType(), 16000.0, DefaultUnitsDB.instance().get("gpm"));
        }
        catch (Exception e) {
            System.err.print("Couldn't initialize class: ");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

