/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.visad.Util;
import ucar.visad.display.CompositeDisplayable;
import ucar.visad.functiontypes.CartesianHorizontalWindOfGeopotentialAltitude;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.CartesianHorizontalWind;
import ucar.visad.quantities.Direction;
import ucar.visad.quantities.GeopotentialAltitude;
import ucar.visad.quantities.PolarHorizontalWind;
import ucar.visad.quantities.SoutherlyWind;
import ucar.visad.quantities.Speed;
import ucar.visad.quantities.WesterlyWind;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Field;
import visad.FlatField;
import visad.FunctionImpl;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.SetType;
import visad.Unit;
import visad.VisADException;

public abstract class WindProfile
extends CompositeDisplayable {
    public static String WIND_PROFILE = "windProfile";
    public static String GEOPOTENTIAL_ALTITUDE = "geopotentialAltitude";
    public static String PRESSURE = "pressure";
    public static String SPEED = "speed";
    public static String DIRECTION = "direction";
    public static String GEOPOTENTIAL_ALTITUDE_EXTENT = "geopotentialAltitudeExtent";
    public static String MAXIMUM_SPEED = "maximumSpeed";
    private Real geopotentialAltitude;
    private Real pressure;
    private Real speed;
    private Real direction;
    private Real maxSpeed;
    private RealTuple altitudeExtent;
    private static Real missingAlt;
    private static Real missingPressure;
    private static Real missingSpeed;
    private static Real missingDirection;
    private FlatField missingWindField;

    protected FlatField getMissingWindField() {
        if (this.missingWindField == null) {
            try {
                this.missingWindField = new FlatField(CartesianHorizontalWindOfGeopotentialAltitude.instance());
            }
            catch (Exception e) {
                this.missingWindField = null;
            }
        }
        return this.missingWindField;
    }

    protected WindProfile() throws VisADException, RemoteException {
        this.geopotentialAltitude = missingAlt;
        this.pressure = missingPressure;
        this.speed = missingSpeed;
        this.direction = missingDirection;
        this.maxSpeed = missingSpeed;
        this.altitudeExtent = new RealTuple(new Real[]{missingAlt, missingAlt});
    }

    protected WindProfile(WindProfile that) throws RemoteException, VisADException {
        this.geopotentialAltitude = that.geopotentialAltitude;
        this.pressure = that.pressure;
        this.speed = that.speed;
        this.direction = that.direction;
        this.maxSpeed = that.maxSpeed;
        this.altitudeExtent = that.altitudeExtent;
    }

    public abstract void setProfile(Field var1) throws VisADException, RemoteException;

    public abstract void setOriginalProfile() throws VisADException, RemoteException;

    protected abstract Field getProfile() throws VisADException, RemoteException;

    protected void profileChange(Field oldProfile) throws VisADException, RemoteException {
        this.firePropertyChange(WIND_PROFILE, oldProfile, this.getProfile());
        this.setAltitudeExtent();
        this.setMaximumSpeed();
        this.setSpeedAndDirection();
    }

    protected void setAltitudeExtent() throws VisADException, RemoteException {
        Field profile = this.getProfile();
        SampledSet domainSet = (SampledSet)profile.getDomainSet();
        RealTupleType domType = ((SetType)domainSet.getType()).getDomain();
        RealType altType = (RealType)domType.getComponent(0);
        Unit altUnit = domainSet.getSetUnits()[0];
        RealTuple oldExtent = this.altitudeExtent;
        this.altitudeExtent = new RealTuple(new Real[]{new Real(altType, domainSet.getLow()[0], altUnit), new Real(altType, domainSet.getHi()[0], altUnit)});
        if (altType.equals(AirPressure.getRealType())) {
            this.altitudeExtent = (RealTuple)AirPressure.toAltitude(this.altitudeExtent);
        }
        this.firePropertyChange(GEOPOTENTIAL_ALTITUDE_EXTENT, oldExtent, this.altitudeExtent);
    }

    protected void setMaximumSpeed() throws RemoteException, VisADException {
        Field profile = this.getProfile();
        float[][] values = profile.getFloats(false);
        float max = 0.0f;
        for (int i = 0; i < values[0].length; ++i) {
            float u = values[0][i];
            float v = values[1][i];
            float spd = (float)Math.sqrt(u * u + v * v);
            if (spd != spd || !(spd > max)) continue;
            max = spd;
        }
        Real oldMax = this.maxSpeed;
        this.maxSpeed = new Real(Speed.getRealType(), max, profile.getDefaultRangeUnits()[0]);
        this.firePropertyChange(MAXIMUM_SPEED, oldMax, this.maxSpeed);
    }

    public Real getMaximumSpeed() {
        return this.maxSpeed;
    }

    public RealTuple getGeopotentialAltitudeExtent() {
        return this.altitudeExtent;
    }

    public void setGeopotentialAltitude(Real geopotentialAltitude) throws RemoteException, VisADException {
        Real oldAltitude = this.geopotentialAltitude;
        this.geopotentialAltitude = geopotentialAltitude;
        this.firePropertyChange(GEOPOTENTIAL_ALTITUDE, oldAltitude, geopotentialAltitude);
        this.setSpeedAndDirection();
    }

    public Real getGeopotentialAltitude() {
        return this.geopotentialAltitude;
    }

    public void setPressure(Real pressure) throws RemoteException, VisADException {
        Real oldPressure = this.pressure;
        this.pressure = pressure;
        this.firePropertyChange(PRESSURE, oldPressure, pressure);
        this.setSpeedAndDirection();
    }

    public Real getPressure() {
        return this.pressure;
    }

    protected void setSpeedAndDirection() throws RemoteException, VisADException {
        if (this.getGeopotentialAltitude().isMissing()) {
            return;
        }
        RealTuple spdDir = (RealTuple)((FunctionImpl)((Object)this.getProfile())).evaluate(this.getGeopotentialAltitude(), 101, 202);
        if (!((RealTupleType)spdDir.getType()).equals(PolarHorizontalWind.getRealTupleType())) {
            spdDir = PolarHorizontalWind.newRealTuple(spdDir);
        }
        this.setSpeed((Real)spdDir.getComponent(0));
        this.setDirection((Real)spdDir.getComponent(1));
    }

    public Real getSpeed() {
        return this.speed;
    }

    public Real getDirection() {
        return this.direction;
    }

    public static RealType getGeopotentialAltitudeRealType() throws VisADException {
        return GeopotentialAltitude.getRealType();
    }

    public static RealType getWesterlyWindRealType() throws VisADException {
        return WesterlyWind.getRealType();
    }

    public static RealType getSoutherlyWindRealType() throws VisADException {
        return SoutherlyWind.getRealType();
    }

    public boolean equals(Object obj) {
        WindProfile that;
        boolean equals = !(obj instanceof WindProfile) ? false : (that = (WindProfile)obj) == this || this.geopotentialAltitude.equals(that.geopotentialAltitude) && this.speed.equals(that.speed) && this.maxSpeed.equals(that.maxSpeed) && this.altitudeExtent.equals(that.altitudeExtent) && this.direction.equals(that.direction) && super.equals(that);
        return equals;
    }

    public int hashCode() {
        return this.geopotentialAltitude.hashCode() ^ this.speed.hashCode() ^ this.maxSpeed.hashCode() ^ this.altitudeExtent.hashCode() ^ this.direction.hashCode() ^ super.hashCode();
    }

    protected static FlatField ensureCartesian(FlatField input) throws VisADException, RemoteException {
        FlatField output;
        FunctionType inputFunction = (FunctionType)input.getType();
        if (Unit.canConvert(input.getDefaultRangeUnits()[0], CommonUnit.meterPerSecond) && Unit.canConvert(input.getDefaultRangeUnits()[1], CommonUnit.meterPerSecond)) {
            output = input;
        } else {
            if (!inputFunction.getDomain().getComponent(0).equals(GeopotentialAltitude.getRealType())) {
                throw new VisADException("Wrong domain type");
            }
            RealTupleType cartesianType = CartesianHorizontalWind.getRealTupleType();
            output = new FlatField(CartesianHorizontalWindOfGeopotentialAltitude.instance(), input.getDomainSet());
            RealTupleType inputType = (RealTupleType)((FunctionType)input.getType()).getRange();
            ErrorEstimate[] inputErrors = input.getRangeErrors();
            ErrorEstimate[] outputErrors = new ErrorEstimate[inputErrors.length];
            output.setSamples(CoordinateSystem.transformCoordinates(cartesianType, cartesianType.getCoordinateSystem(), cartesianType.getDefaultUnits(), outputErrors, inputType, Util.getRangeCoordinateSystem(input), Util.getRangeUnits(input), inputErrors, input.getValues()));
        }
        return output;
    }

    public abstract void setWindLevels(Gridded1DSet var1) throws VisADException, RemoteException;

    protected void setSpeed(Real spd) {
        Real oldSpeed = this.speed;
        this.speed = spd;
        this.firePropertyChange(SPEED, oldSpeed, this.speed);
    }

    protected void setDirection(Real dir) {
        Real oldDir = this.direction;
        this.direction = dir;
        this.firePropertyChange(DIRECTION, oldDir, this.direction);
    }

    static {
        try {
            missingAlt = new Real(GeopotentialAltitude.getRealType());
            missingPressure = new Real(AirPressure.getRealType());
            missingSpeed = new Real(Speed.getRealType());
            missingDirection = new Real(Direction.getRealType());
        }
        catch (Exception e) {
            System.err.print("Couldn't initialize class: ");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

