/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.data.grid.GridUtil;
import ucar.unidata.view.sounding.AerologicalCoordinateSystem;
import ucar.unidata.view.sounding.WindProfile;
import ucar.unidata.view.sounding.WindProfileDisplayable;
import ucar.visad.display.Displayable;
import ucar.visad.functiontypes.CartesianHorizontalWindOfPressure;
import ucar.visad.quantities.CommonUnits;
import ucar.visad.quantities.PolarHorizontalWind;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionImpl;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.LocalDisplay;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Unit;
import visad.VisADException;

public class WindBarbProfile
extends WindProfile {
    private WindProfileDisplayable profileDisplayable;
    private Field originalData;
    private AerologicalCoordinateSystem aeroCS;
    private FlatField missingWindField;
    private Gridded1DSet windLevels = null;

    public WindBarbProfile(LocalDisplay display) throws VisADException, RemoteException {
        this(display, null);
    }

    public WindBarbProfile(LocalDisplay display, AerologicalCoordinateSystem cs) throws VisADException, RemoteException {
        this.profileDisplayable = new WindProfileDisplayable();
        this.setProfile(this.getMissingWindField());
        this.aeroCS = cs;
        this.addDisplayable(this.profileDisplayable);
    }

    public void setCoordinateSystem(AerologicalCoordinateSystem acs) throws VisADException, RemoteException {
        this.aeroCS = acs;
        this.profileDisplayable.setData(this.convertToYDomain(this.getProfile()));
    }

    public AerologicalCoordinateSystem getCoordinateSystem() {
        return this.aeroCS;
    }

    protected WindBarbProfile(WindBarbProfile that) throws RemoteException, VisADException {
        super(that);
        this.setProfile(that.getProfile());
    }

    @Override
    protected FlatField getMissingWindField() {
        if (this.missingWindField == null) {
            try {
                this.missingWindField = new FlatField(CartesianHorizontalWindOfPressure.instance());
            }
            catch (Exception e) {
                this.missingWindField = null;
            }
        }
        return this.missingWindField;
    }

    @Override
    public void setProfile(Field profile) throws VisADException, RemoteException {
        Field transformed = this.convertToYDomain(profile);
        this.profileDisplayable.setData(transformed);
        this.originalData = profile;
    }

    @Override
    public void setOriginalProfile() throws VisADException, RemoteException {
        this.setProfile(this.originalData);
    }

    @Override
    protected Field getProfile() throws VisADException, RemoteException {
        return this.originalData;
    }

    @Override
    public void setWindLevels(Gridded1DSet levels) throws RemoteException, VisADException {
        this.windLevels = levels;
        this.profileDisplayable.setData(this.convertToYDomain(this.getProfile()));
    }

    @Override
    protected void setSpeedAndDirection() throws RemoteException, VisADException {
        if (this.getPressure().isMissing()) {
            return;
        }
        RealTuple spdDir = (RealTuple)((FunctionImpl)((Object)this.getProfile())).evaluate(this.getPressure(), 101, 202);
        if (!((RealTupleType)spdDir.getType()).equals(PolarHorizontalWind.getRealTupleType())) {
            spdDir = PolarHorizontalWind.newRealTuple(spdDir);
        }
        this.setSpeed((Real)spdDir.getComponent(0));
        this.setDirection((Real)spdDir.getComponent(1));
    }

    @Override
    public boolean equals(Object obj) {
        boolean equals;
        if (!(obj instanceof WindBarbProfile)) {
            equals = false;
        } else {
            try {
                WindBarbProfile that = (WindBarbProfile)obj;
                Field thisProfile = this.getProfile();
                Field thatProfile = that.getProfile();
                equals = this == that || (thisProfile == null ? thatProfile == null : thisProfile.equals(thatProfile)) && super.equals(that);
            }
            catch (Exception e) {
                System.err.println(this.getClass().getName() + ".equals(Object): " + "Couldn't get wind data: " + e);
                equals = false;
            }
        }
        return equals;
    }

    @Override
    public int hashCode() {
        int code;
        try {
            Field profile = this.getProfile();
            code = (profile == null ? 0 : profile.hashCode()) ^ super.hashCode();
        }
        catch (Exception e) {
            System.err.println(this.getClass().getName() + ".hashCode(): " + "Couldn't get wind data: " + e);
            code = 0;
        }
        return code;
    }

    @Override
    public Displayable cloneForDisplay() throws RemoteException, VisADException {
        return new WindBarbProfile(this);
    }

    private Field convertToYDomain(Field profile) throws VisADException, RemoteException {
        if (profile == null || this.aeroCS == null) {
            return profile;
        }
        boolean isSequence = GridUtil.isTimeSequence((FieldImpl)profile);
        FlatField data = isSequence ? (FlatField)profile.getSample(0) : (FlatField)profile;
        if (this.windLevels != null) {
            data = (FlatField)data.resample(this.windLevels);
        }
        SampledSet pSet = (SampledSet)data.getDomainSet();
        float[][] pressures = pSet.getSamples();
        float[][] pt = new float[2][pressures[0].length];
        pt[0] = pressures[0];
        float[][] xy = this.aeroCS.toReference(pt, new Unit[]{pSet.getSetUnits()[0], CommonUnits.CELSIUS});
        Gridded1DSet ySet = new Gridded1DSet((MathType)RealType.YAxis, (float[][])new float[][]{xy[1]}, xy[1].length);
        FunctionType ftype = new FunctionType(RealType.YAxis, ((FunctionType)data.getType()).getRange());
        FlatField ff = new FlatField(ftype, ySet);
        ff.setSamples(data.getFloats());
        return ff;
    }
}

