/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.ComputeCell;
import ucar.visad.Util;
import ucar.visad.functiontypes.AtmosphericProfile;
import ucar.visad.quantities.DewPoint;
import ucar.visad.quantities.VirtualTemperature;
import ucar.visad.quantities.WaterVaporMixingRatio;
import visad.Data;
import visad.DataReference;
import visad.Field;
import visad.TypeException;
import visad.VisADException;

public final class VirtualTemperatureProfileCell
extends ComputeCell {
    private static final Field noData;

    public VirtualTemperatureProfileCell(DataReference tempProfileRef, DataReference moistRef) throws VisADException, RemoteException {
        super("VirtualTemperatureProfileCell", new DataReference[]{tempProfileRef, moistRef}, noData);
        this.enableAllInputRefs();
    }

    @Override
    protected Data compute(Data[] datums) throws TypeException, VisADException, RemoteException {
        Data moisture;
        Field virtPro = noData;
        Field tempPro = (Field)datums[0];
        if (tempPro != null && (moisture = datums[1]) != null) {
            if (Util.isCompatible(moisture, DewPoint.getRealType())) {
                virtPro = (Field)VirtualTemperature.createFromDewPoint(tempPro.getDomainSet(), tempPro, moisture);
            } else if (Util.isCompatible(moisture, WaterVaporMixingRatio.getRealType())) {
                virtPro = (Field)VirtualTemperature.createFromMixingRatio(tempPro, moisture);
            } else {
                throw new TypeException("Unknown moisture type: " + moisture.getType());
            }
        }
        return virtPro;
    }

    static {
        try {
            noData = (Field)new AtmosphericProfile(VirtualTemperature.getRealType()).missingData();
        }
        catch (Exception ex) {
            System.err.println("Couldn't initialize class");
            ex.printStackTrace();
            throw new RuntimeException(ex.getMessage());
        }
    }
}

