/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import ucar.unidata.view.sounding.TemperatureCalculator;
import ucar.unidata.view.sounding.TemperatureCalculatorFactory;
import ucar.visad.Util;
import ucar.visad.display.LineDrawing;
import ucar.visad.quantities.AirPressure;
import ucar.visad.quantities.AirTemperature;
import ucar.visad.quantities.Pressure;
import ucar.visad.quantities.Temperature;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealType;
import visad.Set;
import visad.SingletonSet;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;

public abstract class Trajectory
extends LineDrawing {
    public static String TRAJECTORY = "trajectory";
    private static RealType generalPressureType;
    private static RealType generalTemperatureType;
    private static RealType specificPressureType;
    private static RealType specificTemperatureType;
    private static Unit pressureUnit;
    private static Unit temperatureUnit;
    private static double logMaxPresRatio;
    private static RealType pressureRatioType;
    private static FunctionType trajectoryType;
    private FlatField missingTrajectory;
    private TemperatureCalculatorFactory factory;
    private boolean descending;

    protected Trajectory(String name, TemperatureCalculatorFactory factory) throws RemoteException, VisADException {
        this(name, factory, false);
    }

    protected Trajectory(String name, TemperatureCalculatorFactory factory, boolean descending) throws RemoteException, VisADException {
        super(name);
        if (this.missingTrajectory == null) {
            this.missingTrajectory = new FlatField(trajectoryType, new SingletonSet(new RealTuple(AirPressure.getRealTupleType())));
        }
        this.setData(this.missingTrajectory);
        this.factory = factory;
        this.descending = descending;
    }

    protected Trajectory(Trajectory that) throws RemoteException, VisADException {
        super(that);
        this.factory = that.factory;
        this.descending = that.descending;
    }

    public void setTrajectory(Real startPressure, Real startTemperature, Real endPressure) throws TypeException, VisADException, RemoteException {
        Util.vetType(generalPressureType, startPressure);
        Util.vetType(generalTemperatureType, startTemperature);
        Util.vetType(generalPressureType, endPressure);
        double endPres = endPressure.getValue(pressureUnit);
        double startPres = startPressure.getValue(pressureUnit);
        if (!this.descending && endPres > startPres || this.descending && endPres < startPres) {
            this.setTrajectory(this.missingTrajectory);
        } else {
            double logPresExtent = Math.log(endPres / startPres);
            double logPresRatio = logPresExtent / Math.ceil(logPresExtent / (this.descending ? -logMaxPresRatio : logMaxPresRatio));
            int count = 1 + (int)Math.round(logPresExtent / logPresRatio);
            Real pressureRatio = new Real(pressureRatioType, Math.exp(logPresRatio));
            float[] pressures = new float[count];
            float[] temperatures = new float[count];
            Real pressure = startPressure;
            Real temperature = startTemperature;
            TemperatureCalculator calculator = this.factory.newTemperatureCalculator(startPressure, startTemperature);
            pressures[0] = (float)pressure.getValue(pressureUnit);
            temperatures[0] = (float)temperature.getValue(temperatureUnit);
            for (int i = 1; i < count; ++i) {
                pressure = (Real)pressure.multiply(pressureRatio);
                temperature = calculator.nextTemperature(pressure);
                pressures[i] = (float)pressure.getValue(pressureUnit);
                temperatures[i] = (float)temperature.getValue(temperatureUnit);
            }
            FlatField trajectory = new FlatField(trajectoryType, (Set)(pressures.length == 1 ? new SingletonSet(AirPressure.getRealTupleType(), new double[]{pressures[0]}, (CoordinateSystem)null, new Unit[]{pressureUnit}, (ErrorEstimate[])null) : new Gridded1DSet((MathType)AirPressure.getRealTupleType(), (float[][])new float[][]{pressures}, pressures.length, (CoordinateSystem)null, new Unit[]{pressureUnit}, (ErrorEstimate[])null)), (CoordinateSystem[])null, (Set[])null, new Unit[]{temperatureUnit});
            trajectory.setSamples(new float[][]{temperatures});
            this.setTrajectory(trajectory);
        }
    }

    public void clear() throws VisADException, RemoteException {
        this.setTrajectory(this.missingTrajectory);
    }

    public FlatField getTrajectory() throws VisADException, RemoteException {
        return (FlatField)this.getData();
    }

    public RealType getPressureType() {
        return specificPressureType;
    }

    public RealType getTemperatureType() {
        return specificTemperatureType;
    }

    protected void setTrajectory(FlatField trajectory) throws VisADException, RemoteException {
        FlatField old = this.getTrajectory();
        this.setData(trajectory);
        this.firePropertyChange(TRAJECTORY, old, trajectory);
    }

    static {
        try {
            generalPressureType = Pressure.getRealType();
            generalTemperatureType = Temperature.getRealType();
            specificPressureType = AirPressure.getRealType();
            specificTemperatureType = AirTemperature.getRealType();
            pressureUnit = specificPressureType.getDefaultUnit();
            temperatureUnit = specificTemperatureType.getDefaultUnit();
            logMaxPresRatio = Math.log(0.95);
            pressureRatioType = RealType.getRealType("TrajectoryPressureRatio", CommonUnit.dimensionless, null);
            trajectoryType = new FunctionType(AirPressure.getRealTupleType(), specificTemperatureType);
        }
        catch (Exception e) {
            System.err.print("Couldn't initialize class: ");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

