/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.rmi.RemoteException;
import java.text.NumberFormat;
import java.util.Arrays;
import ucar.visad.display.Displayable;
import ucar.visad.display.PolarLineDrawing;
import ucar.visad.quantities.PolarHorizontalWind;
import ucar.visad.quantities.Speed;
import visad.Data;
import visad.Display;
import visad.FieldImpl;
import visad.FunctionType;
import visad.Gridded1DSet;
import visad.Gridded2DSet;
import visad.MathType;
import visad.ScalarMap;
import visad.ScalarMapControlEvent;
import visad.ScalarMapEvent;
import visad.ScalarMapListener;
import visad.Text;
import visad.TextControl;
import visad.TextType;
import visad.Unit;
import visad.VisADException;

public class SpeedLabels
extends PolarLineDrawing {
    private FieldImpl field;
    private FunctionType functionType;
    private Unit defaultSpeedUnit;
    private float size = 1.0f;
    private NumberFormat format = NumberFormat.getInstance();
    private TextType textType;
    private volatile TextControl textControl;

    public SpeedLabels() throws RemoteException, VisADException {
        super("SpeedLabels", PolarHorizontalWind.getRealTupleType());
        this.textType = TextType.getTextType("SpeedLabel");
        this.functionType = new FunctionType(PolarHorizontalWind.getRealTupleType(), this.textType);
        this.defaultSpeedUnit = Speed.getRealType().getDefaultUnit();
        ScalarMap textMap = this.newTextMap();
        this.addTextMapListener(textMap);
        this.addScalarMap(textMap);
    }

    protected SpeedLabels(SpeedLabels that) throws RemoteException, VisADException {
        super(that);
        this.field = (FieldImpl)that.getData();
        this.functionType = that.functionType;
        this.defaultSpeedUnit = that.defaultSpeedUnit;
        this.size = that.size;
        this.format = (NumberFormat)that.format.clone();
        this.textType = that.textType;
        this.addTextMapListener(this.getScalarMap(this.newTextMap()));
    }

    private ScalarMap newTextMap() throws VisADException {
        return new ScalarMap(this.textType, Display.Text);
    }

    private void addTextMapListener(final ScalarMap textMap) {
        textMap.addScalarMapListener(new ScalarMapListener(){

            @Override
            public void controlChanged(ScalarMapControlEvent event) throws VisADException, RemoteException {
                block3: {
                    block2: {
                        int id = event.getId();
                        if (id == 3) break block2;
                        if (id != 5) break block3;
                    }
                    SpeedLabels.this.textControl = (TextControl)textMap.getControl();
                    SpeedLabels.this.textControl.setSize(SpeedLabels.this.size);
                }
            }

            @Override
            public void mapChanged(ScalarMapEvent event) {
            }
        });
    }

    public void setSize(double size) throws VisADException, RemoteException {
        this.size = (float)size;
        if (this.textControl != null) {
            this.textControl.setSize(size);
        }
    }

    public void setLabels(Gridded1DSet speedSet) throws VisADException, RemoteException {
        float[] spds = speedSet.getSamples()[0];
        float[] speeds = new float[spds.length - 1];
        System.arraycopy(spds, 0, speeds, 0, speeds.length);
        float[] directions = new float[speeds.length];
        Arrays.fill(directions, 270.0f);
        float[][] domainSamples = new float[][]{this.defaultSpeedUnit.toThis(speeds, speedSet.getSetUnits()[0]), directions};
        this.field = new FieldImpl(this.functionType, new Gridded2DSet((MathType)this.functionType.getDomain(), (float[][])domainSamples, domainSamples[0].length));
        Data[] labels = new Text[speeds.length];
        int maxWidth = 0;
        String[] strings = new String[speeds.length];
        int i = speeds.length;
        while (--i >= 0) {
            String label = this.format.format(speeds[i]).trim();
            int width = label.length();
            if (width > maxWidth) {
                maxWidth = width;
            }
            strings[i] = label;
        }
        if (labels == null || labels.length != speeds.length) {
            labels = new Text[speeds.length];
        }
        StringBuffer labelBuf = new StringBuffer(maxWidth);
        int i2 = speeds.length;
        while (--i2 >= 0) {
            for (int j = strings[i2].length(); j < maxWidth; ++j) {
                labelBuf.append(" ");
            }
            labelBuf.append(strings[i2]);
            String label = labelBuf.toString();
            labelBuf.setLength(0);
            labels[i2] = new Text(this.textType, label);
        }
        this.field.setSamples(labels, false);
        this.setData(this.field);
    }

    @Override
    public boolean equals(Object obj) {
        SpeedLabels that;
        boolean equals = !(obj instanceof SpeedLabels) ? false : (that = (SpeedLabels)obj) == this || this.size == that.size && this.format.equals(that.format) && this.field.equals(that.field) && super.equals(that);
        return equals;
    }

    @Override
    public int hashCode() {
        return new Float(this.size).hashCode() ^ this.format.hashCode() ^ this.field.hashCode() ^ super.hashCode();
    }

    @Override
    public Displayable cloneForDisplay() throws VisADException, RemoteException {
        return new SpeedLabels(this);
    }
}

