/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import ucar.unidata.view.sounding.AirTemperatureProfile;
import ucar.unidata.view.sounding.DewPointProfile;
import ucar.unidata.view.sounding.Sounding;
import ucar.visad.display.CompositeDisplayable;
import ucar.visad.display.Displayable;
import visad.LocalDisplay;
import visad.Real;
import visad.RealType;
import visad.VisADException;

public class SoundingSet
extends CompositeDisplayable {
    public static String PRESSURE = "pressure";
    public static String TEMPERATURE = "temperature";
    public static String DEW_POINT = "dewPoint";
    public static String ACTIVE_SOUNDING = "activeSounding";
    private Sounding missingSounding;
    private Sounding activeSounding;
    private Real pressure;
    private boolean constrainProfiles = true;
    private Real temperature;
    private Real dewPoint;
    private PropertyChangeListener temperatureListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            SoundingSet.this.temperature = (Real)event.getNewValue();
            PropertyChangeEvent newEvent = new PropertyChangeEvent(SoundingSet.this, TEMPERATURE, event.getOldValue(), SoundingSet.this.temperature);
            newEvent.setPropagationId(event.getPropagationId());
            SoundingSet.this.firePropertyChange(newEvent);
        }
    };
    private PropertyChangeListener dewPointListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            SoundingSet.this.dewPoint = (Real)event.getNewValue();
            PropertyChangeEvent newEvent = new PropertyChangeEvent(SoundingSet.this, DEW_POINT, event.getOldValue(), SoundingSet.this.dewPoint);
            newEvent.setPropagationId(event.getPropagationId());
            SoundingSet.this.firePropertyChange(newEvent);
        }
    };

    public SoundingSet(LocalDisplay display) throws VisADException, RemoteException {
        super(display);
        this.activeSounding = this.missingSounding = new Sounding(display);
        this.pressure = this.activeSounding.getPressure();
        this.temperature = this.activeSounding.getTemperature();
        this.dewPoint = this.activeSounding.getDewPoint();
    }

    public void addSounding(Sounding sounding) throws RemoteException, VisADException {
        this.addSounding(this.displayableCount(), sounding);
    }

    public void addSounding(int index, Sounding sounding) throws RemoteException, VisADException {
        this.setDisplayable(index, sounding);
        sounding.setConstrainProfiles(this.constrainProfiles);
    }

    public synchronized void removeSounding(int index) throws IndexOutOfBoundsException, RemoteException, VisADException {
        Sounding sounding = (Sounding)this.getDisplayable(index);
        if (sounding == null) {
            return;
        }
        if (sounding == this.activeSounding) {
            this.removeListeners(sounding);
        }
        this.removeDisplayable(sounding);
        if (this.displayableCount() == 0 || sounding == this.activeSounding) {
            this.setActiveSounding(this.missingSounding);
        }
    }

    public void setOriginalProfiles(int index) throws VisADException, RemoteException {
        Sounding sounding = (Sounding)this.getDisplayable(index);
        if (sounding != null) {
            sounding.setOriginalProfiles();
        }
    }

    public synchronized void setConstrainProfiles(boolean yes) throws RemoteException, VisADException {
        if (yes != this.constrainProfiles) {
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                ((Sounding)iter.next()).setConstrainProfiles(yes);
            }
        }
        this.constrainProfiles = yes;
    }

    public synchronized void setPressure(Real pressure) throws RemoteException, VisADException {
        Real oldPressure = this.pressure;
        this.pressure = pressure;
        this.activeSounding.setPressure(pressure);
        this.firePropertyChange(PRESSURE, oldPressure, this.pressure);
    }

    public Real getPressure() {
        return this.pressure;
    }

    public Real getTemperature() {
        return this.temperature;
    }

    public Real getDewPoint() {
        return this.dewPoint;
    }

    public synchronized Set getPressureRealTypeSet() throws VisADException, RemoteException {
        TreeSet<RealType> realTypeSet = new TreeSet<RealType>();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            realTypeSet.add(((Sounding)iter.next()).getPressureRealType());
        }
        return realTypeSet;
    }

    public synchronized Set getTemperatureRealTypeSet() throws VisADException, RemoteException {
        TreeSet<RealType> realTypeSet = new TreeSet<RealType>();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            realTypeSet.add(((Sounding)iter.next()).getTemperatureRealType());
        }
        return realTypeSet;
    }

    public synchronized Set getDewPointRealTypeSet() throws VisADException, RemoteException {
        TreeSet<RealType> realTypeSet = new TreeSet<RealType>();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            realTypeSet.add(((Sounding)iter.next()).getDewPointRealType());
        }
        return realTypeSet;
    }

    public synchronized void clear() throws VisADException, RemoteException {
        for (int i = 0; i < this.displayableCount(); ++i) {
            this.removeSounding(i);
        }
    }

    public synchronized void setActiveSounding(int index) throws VisADException, RemoteException {
        this.setActiveSounding(index < 0 ? this.missingSounding : (Sounding)this.getDisplayable(index));
    }

    protected synchronized void setActiveSounding(Sounding sounding) throws VisADException, RemoteException {
        if (sounding == null) {
            sounding = this.missingSounding;
        }
        Sounding old = this.activeSounding;
        sounding.setPressure(this.pressure);
        this.removeListeners(this.activeSounding);
        this.activeSounding = sounding;
        this.setTemperature(this.activeSounding.getTemperature());
        this.setDewPoint(this.activeSounding.getDewPoint());
        this.addListeners(this.activeSounding);
        this.firePropertyChange(ACTIVE_SOUNDING, old, this.activeSounding);
    }

    public Sounding getActiveSounding() {
        return this.activeSounding;
    }

    private synchronized void setTemperature(Real temp) {
        Real oldValue = this.temperature;
        this.temperature = temp;
        this.firePropertyChange(TEMPERATURE, oldValue, this.temperature);
    }

    private synchronized void setDewPoint(Real temp) {
        Real oldValue = this.dewPoint;
        this.dewPoint = temp;
        this.firePropertyChange(DEW_POINT, oldValue, this.dewPoint);
    }

    private void addListeners(Sounding sounding) {
        sounding.addPropertyChangeListener(Sounding.TEMPERATURE, this.temperatureListener);
        sounding.addPropertyChangeListener(Sounding.DEW_POINT, this.dewPointListener);
    }

    private void removeListeners(Sounding sounding) {
        sounding.removePropertyChangeListener(Sounding.TEMPERATURE, this.temperatureListener);
        sounding.removePropertyChangeListener(Sounding.DEW_POINT, this.dewPointListener);
    }

    public void setLinesWidth(float width, int lowerIndex, int upperIndex) throws RemoteException, VisADException {
        for (int index = lowerIndex; index <= upperIndex; ++index) {
            AirTemperatureProfile displayable = (AirTemperatureProfile)this.getDisplayable(index);
            if (displayable == null) continue;
            displayable.setLineWidth(width);
        }
    }

    public void setLineStyle(int style, int index) throws RemoteException, VisADException {
        CompositeDisplayable cdisplayable = (CompositeDisplayable)this.getDisplayable(index);
        if (cdisplayable != null) {
            int n = cdisplayable.displayableCount();
            for (int i = 0; i < n; ++i) {
                Displayable displayable = cdisplayable.getDisplayable(i);
                if (displayable != null && displayable instanceof AirTemperatureProfile) {
                    ((AirTemperatureProfile)displayable).setLineStyle(style);
                    continue;
                }
                if (!(displayable instanceof DewPointProfile)) continue;
                ((DewPointProfile)displayable).setLineStyle(style);
            }
        }
    }
}

