/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ucar.unidata.data.sounding.AddeSoundingAdapter;
import ucar.unidata.data.sounding.SoundingAdapter;
import ucar.unidata.data.sounding.SoundingOb;
import ucar.unidata.data.sounding.SoundingStation;
import ucar.unidata.gis.mcidasmap.McidasMap;
import ucar.unidata.idv.chooser.IdvChooser;
import ucar.unidata.idv.chooser.IdvChooserManager;
import ucar.unidata.idv.chooser.adde.AddeChooser;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PreferenceList;
import ucar.unidata.view.CompositeRenderer;
import ucar.unidata.view.sounding.SoundingFileBrowser;
import ucar.unidata.view.station.StationLocationMap;
import ucar.unidata.xml.XmlUtil;
import visad.DateTime;

public class SoundingSelector
extends IdvChooser {
    private IdvChooser idvChooser;
    private int connectionStep = 0;
    private static String CMD_SERVER = "cmd.server";
    private PreferenceList servers;
    private JTextField selectedFileDisplay;
    private JList timesList;
    private JList obsList;
    private Vector selectedObs = new Vector();
    private StationLocationMap stationMap;
    private String directory = null;
    private String filename = null;
    private static JFrame frame;
    private SoundingFileBrowser fileBrowser = null;
    AddeChooser addeChooser;
    private JComboBox groupSelector;
    private File selectedFile;
    private boolean declutter = true;
    SoundingAdapter soundingAdapter;
    private boolean multipleSelect = false;
    private boolean forServer = true;
    private boolean showMainHoursOnly = true;
    private String directoryName;

    public SoundingSelector(IdvChooser idvChooser, IdvChooserManager mgr, Element chooserNode) {
        super(mgr, chooserNode);
        this.idvChooser = idvChooser;
        this.servers = idvChooser.getPreferenceList("idv.data.adde.servers");
        this.forServer = XmlUtil.getAttribute((Node)chooserNode, "showserver", true);
        this.multipleSelect = true;
    }

    public SoundingSelector(PreferenceList servers) {
        this(servers, true, false);
    }

    public SoundingSelector(PreferenceList servers, boolean forServer, boolean multipleSelect) {
        this(servers, ".", "", forServer, multipleSelect);
    }

    public SoundingSelector(IdvChooser idvChooser, PreferenceList servers, boolean forServer, boolean multipleSelect) {
        this(idvChooser, servers, ".", "", forServer, multipleSelect);
    }

    public SoundingSelector(PreferenceList servers, String directoryName, String serverName) {
        this(servers, directoryName, serverName, true, false);
    }

    public SoundingSelector(PreferenceList servers, String directoryName, String serverName, boolean forServer, boolean multipleSelect) {
        this(null, servers, directoryName, serverName, forServer, multipleSelect);
    }

    public SoundingSelector(IdvChooser idvChooser, PreferenceList servers, String directoryName, String serverName, boolean forServer, boolean multipleSelect) {
        super(idvChooser.getIdv(), idvChooser.getXmlNode());
        this.directoryName = directoryName;
        this.idvChooser = idvChooser;
        this.forServer = forServer;
        this.servers = servers;
        this.multipleSelect = multipleSelect;
    }

    private SoundingFileBrowser getFileBrowser() {
        if (this.fileBrowser == null) {
            this.fileBrowser = new SoundingFileBrowser(this.directoryName);
            this.fileBrowser.addPropertyChangeListener("soundingAdapter", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    SoundingSelector.this.setSoundingAdapter((SoundingAdapter)evt.getNewValue());
                }
            });
        }
        return this.fileBrowser;
    }

    @Override
    public void updateStatus() {
        if (this.getHaveData()) {
            this.setStatus("Press \"Add Source\" to load the selected sounding data", "buttons");
            return;
        }
        if (this.forServer) {
            if (this.soundingAdapter == null) {
                this.setStatus("Please connect to the server");
            } else {
                this.setStatus("Select one or more soundings");
            }
        } else if (this.soundingAdapter == null) {
            this.setStatus("Select a sounding file");
        } else {
            this.setStatus("Select one or more soundings");
        }
    }

    @Override
    protected JComponent doMakeContents() {
        JComponent selectorPanel;
        GuiUtils.tmpInsets = new Insets(2, 2, 2, 2);
        List servers = this.idvChooser.getIdv().getIdvChooserManager().getAddeServers("point");
        this.addeChooser = new AddeChooser(this.idvChooser.getIdv().getIdvChooserManager(), null){

            @Override
            public void setStatus(String message, String from) {
                System.err.println("status:" + message);
                SoundingSelector.this.setStatus(message, from);
            }
        };
        this.groupSelector = GuiUtils.getEditableBox(Misc.newList("RTPTSRC"), null);
        JCheckBox extraTimeComp = null;
        if (this.forServer) {
            JButton connectBtn = new JButton("Connect");
            connectBtn.addActionListener(this);
            connectBtn.setActionCommand(CMD_SERVER);
            JCheckBox mainHoursCbx = new JCheckBox("00 & 12Z only", this.showMainHoursOnly);
            mainHoursCbx.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    SoundingSelector.this.showMainHoursOnly = ((JCheckBox)ev.getSource()).isSelected();
                    if (SoundingSelector.this.soundingAdapter != null) {
                        SoundingSelector.this.doUpdateInner(true);
                    }
                }
            });
            extraTimeComp = mainHoursCbx;
            selectorPanel = GuiUtils.hbox(new Component[]{this.addeChooser.getServerSelector(), GuiUtils.rLabel(" Group: "), this.groupSelector, GuiUtils.filler(), connectBtn});
            selectorPanel = GuiUtils.formLayout(new Component[]{GuiUtils.rLabel("Server:"), selectorPanel});
        } else {
            selectorPanel = GuiUtils.formLayout(new Component[]{GuiUtils.rLabel("File: "), this.getFileBrowser().getContents()});
        }
        JComponent topPanel = selectorPanel = GuiUtils.inset((Component)GuiUtils.leftCenter(selectorPanel, GuiUtils.filler()), 4);
        JPanel middlePanel = new JPanel(new BorderLayout());
        this.obsList = new JList();
        this.obsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                SoundingSelector.this.obsListClicked(e);
            }
        });
        JScrollPane obsPane = new JScrollPane(this.obsList);
        obsPane.setPreferredSize(new Dimension(175, 50));
        JScrollPane timesPane = new JScrollPane(this.createTimesList());
        timesPane.setPreferredSize(new Dimension(175, 50));
        JComponent timeLabel = new JLabel("Available Times:");
        if (extraTimeComp != null) {
            timeLabel = GuiUtils.vbox(timeLabel, extraTimeComp);
        }
        JPanel left = GuiUtils.doLayout(new Component[]{timeLabel, timesPane, new JLabel("Selected Soundings:"), obsPane}, 1, GuiUtils.WT_N, GuiUtils.WT_NYNY);
        middlePanel.add((Component)GuiUtils.inset((Component)left, 5), "West");
        JPanel p = new JPanel();
        p.setBorder(BorderFactory.createTitledBorder("Available Stations"));
        p.setLayout(new BorderLayout());
        CompositeRenderer mapRenderer = new CompositeRenderer();
        mapRenderer.addRenderer(new McidasMap("/auxdata/maps/OUTLSUPW"));
        mapRenderer.addRenderer(new McidasMap("/auxdata/maps/OUTLSUPU"));
        mapRenderer.setColor(MAP_COLOR);
        this.stationMap = new StationLocationMap(this.multipleSelect, mapRenderer);
        this.stationMap.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pe) {
                if (pe.getPropertyName().equals("selectedStation")) {
                    SoundingSelector.this.stationSelected((SoundingStation)pe.getNewValue());
                } else if (pe.getPropertyName().equals("unselectedStation")) {
                    SoundingSelector.this.stationUnselected((SoundingStation)pe.getNewValue());
                } else if (pe.getPropertyName().equals("unselectedAll")) {
                    SoundingSelector.this.unselectAll();
                }
            }
        });
        middlePanel.add((Component)this.stationMap, "Center");
        JComponent buttons = this.getDefaultButtons();
        return GuiUtils.topCenterBottom(topPanel, middlePanel, buttons);
    }

    private void stationSelected(SoundingStation station) {
        List selectedTimes = this.getSelectedTimes();
        if (selectedTimes == null || selectedTimes.size() < 1) {
            return;
        }
        for (int i = 0; i < selectedTimes.size(); ++i) {
            SoundingOb newObs;
            DateTime dt = (DateTime)selectedTimes.get(i);
            List times = this.soundingAdapter.getSoundingTimes(station);
            if (times == null || times.size() <= 0 || !times.contains(dt) || this.selectedObs.contains(newObs = new SoundingOb(station, dt))) continue;
            this.selectedObs.add(newObs);
        }
        this.obsList.setListData(this.selectedObs);
        this.checkLoadData();
    }

    public AddeChooser getAddeChooser() {
        return this.addeChooser;
    }

    private void checkLoadData() {
        this.setHaveData(this.obsList.getModel().getSize() > 0);
        this.updateStatus();
    }

    private void stationUnselected(SoundingStation station) {
        List selectedTimes = this.getSelectedTimes();
        if (selectedTimes == null || selectedTimes.size() < 1) {
            return;
        }
        for (int i = 0; i < selectedTimes.size(); ++i) {
            SoundingOb newObs = new SoundingOb(station, (DateTime)selectedTimes.get(i));
            if (!this.selectedObs.contains(newObs)) continue;
            this.selectedObs.remove(newObs);
        }
        this.obsList.setListData(this.selectedObs);
        this.checkLoadData();
    }

    private void unselectAll() {
        List selectedTimes = this.getSelectedTimes();
        if (selectedTimes == null || selectedTimes.size() < 1) {
            return;
        }
        this.selectedObs.removeAllElements();
        this.obsList.setListData(this.selectedObs);
        this.checkLoadData();
    }

    private String getServer() {
        return this.addeChooser.getServer();
    }

    private String getGroupName() {
        return this.groupSelector.getSelectedItem().toString();
    }

    private String getMandatoryDataset() {
        return this.getGroupName() + "/UPPERMAND";
    }

    private String getSigLevelDataset() {
        return this.getGroupName() + "/UPPERSIG";
    }

    private void obsListClicked(MouseEvent event) {
        if (!SwingUtilities.isRightMouseButton(event)) {
            return;
        }
        int index = this.obsList.locationToIndex(new Point(event.getX(), event.getY()));
        if (index < 0 || index >= this.selectedObs.size()) {
            return;
        }
        final SoundingOb obs = (SoundingOb)this.selectedObs.get(index);
        JPopupMenu popup = new JPopupMenu();
        JMenuItem mi = new JMenuItem("Remove " + obs);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundingSelector.this.selectedObs.remove(obs);
                SoundingSelector.this.obsList.setListData(SoundingSelector.this.selectedObs);
                SoundingSelector.this.checkLoadData();
                SoundingSelector.this.stationMap.setSelectedStations(SoundingSelector.this.getCurrentSelectedStations());
            }
        });
        popup.add(mi);
        mi = new JMenuItem("Remove all");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundingSelector.this.selectedObs.removeAllElements();
                SoundingSelector.this.obsList.setListData(SoundingSelector.this.selectedObs);
                SoundingSelector.this.checkLoadData();
                SoundingSelector.this.stationMap.setSelectedStations(SoundingSelector.this.getCurrentSelectedStations());
            }
        });
        popup.add(mi);
        popup.show(this.obsList, event.getX(), event.getY());
    }

    @Override
    public void doUpdate() {
        if (!this.forServer) {
            return;
        }
        this.doUpdateInner(false);
    }

    private void doUpdateInner(final boolean forceNewAdapter) {
        final int timestep = ++this.connectionStep;
        Misc.run(new Runnable(){

            @Override
            public void run() {
                SoundingSelector.this.clearWaitCursor();
                SoundingSelector.this.showWaitCursor();
                try {
                    if (forceNewAdapter) {
                        SoundingSelector.this.setStatus("Connecting to the server: " + SoundingSelector.this.getServer());
                        AddeSoundingAdapter newAdapter = new AddeSoundingAdapter(SoundingSelector.this.getServer(), SoundingSelector.this.getMandatoryDataset(), SoundingSelector.this.getSigLevelDataset(), SoundingSelector.this.showMainHoursOnly);
                        if (timestep != SoundingSelector.this.connectionStep) {
                            return;
                        }
                        SoundingSelector.this.soundingAdapter = null;
                        SoundingSelector.this.setSoundingAdapter(newAdapter);
                    } else if (SoundingSelector.this.soundingAdapter != null) {
                        SoundingSelector.this.setStatus("Connecting to the server: " + SoundingSelector.this.getServer());
                        List times = SoundingSelector.this.getSelectedTimes();
                        SoundingSelector.this.soundingAdapter.update();
                        SoundingSelector.this.setStations();
                        SoundingSelector.this.setTimesListData(times);
                    }
                }
                catch (Exception exc) {
                    LogUtil.logException("Updating sounding data", exc);
                }
                finally {
                    SoundingSelector.this.updateStatus();
                }
                SoundingSelector.this.showNormalCursor();
            }
        });
    }

    @Override
    public void doCancel() {
    }

    public SoundingAdapter getSoundingAdapter() {
        return this.soundingAdapter;
    }

    protected void setSoundingAdapter(SoundingAdapter newAdapter) {
        this.soundingAdapter = newAdapter;
        this.selectedObs.removeAllElements();
        this.obsList.setListData(this.selectedObs);
        this.setStations();
        this.setTimesListData();
        this.checkLoadData();
    }

    private JList createTimesList() {
        this.timesList = new JList();
        this.timesList.setSelectionMode(2);
        this.timesList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!SoundingSelector.this.timesList.isSelectionEmpty() && !e.getValueIsAdjusting()) {
                    Object[] t = SoundingSelector.this.timesList.getSelectedValues();
                    SoundingSelector.this.newTimes(Misc.toList(t));
                }
            }
        });
        return this.timesList;
    }

    private void newTimes(List times) {
        List current = this.stationMap.getSelectedStations();
        if (current == null || current.size() < 1) {
            return;
        }
        this.selectedObs.removeAllElements();
        for (int i = 0; i < times.size(); ++i) {
            DateTime dt = (DateTime)times.get(i);
            for (int j = 0; j < current.size(); ++j) {
                SoundingOb newObs;
                SoundingStation ss = (SoundingStation)current.get(j);
                List ssTimes = this.soundingAdapter.getSoundingTimes(ss);
                if (ssTimes == null || times.size() <= 0 || !ssTimes.contains(dt) || this.selectedObs.contains(newObs = new SoundingOb(ss, dt))) continue;
                this.selectedObs.add(newObs);
            }
        }
        this.obsList.setListData(this.selectedObs);
        this.checkLoadData();
    }

    private void setStations() {
        List current = this.getCurrentSelectedStations();
        this.stationMap.setStations(this.getSoundingAdapter().getStations(), current, this.declutter);
        this.stationMap.redraw();
    }

    private JCheckBox createDeclutterCheckBox() {
        JCheckBox cb = new JCheckBox("Declutter", this.declutter);
        cb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SoundingSelector.this.declutter = ((JCheckBox)e.getSource()).isSelected();
                SoundingSelector.this.stationMap.setDeclutter(SoundingSelector.this.declutter);
            }
        });
        return cb;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(CMD_SERVER)) {
            this.doUpdateInner(true);
        } else {
            super.actionPerformed(e);
        }
    }

    private List getCurrentSelectedStations() {
        ArrayList<SoundingStation> current = new ArrayList<SoundingStation>();
        DateTime currentTime = this.getSelectedTime();
        for (int i = 0; i < this.selectedObs.size(); ++i) {
            SoundingOb ob = (SoundingOb)this.selectedObs.get(i);
            if (!ob.getTimestamp().equals(currentTime)) continue;
            current.add(ob.getStation());
        }
        return current;
    }

    private void setTimesListData() {
        this.setTimesListData(null);
    }

    private void setTimesListData(List selected) {
        DateTime[] times = this.getSoundingAdapter().getSoundingTimes();
        if (times != null) {
            this.timesList.setListData(times);
            if (selected != null && selected.size() > 0) {
                ListModel lm = this.timesList.getModel();
                int[] indices = new int[times.length];
                int l = 0;
                for (int i = 0; i < lm.getSize(); ++i) {
                    if (!selected.contains(lm.getElementAt(i))) continue;
                    indices[l++] = i;
                }
                if (l > 0) {
                    int[] selectedIndices = new int[l];
                    System.arraycopy(indices, 0, selectedIndices, 0, l);
                    this.timesList.setSelectedIndices(selectedIndices);
                    this.timesList.ensureIndexIsVisible(selectedIndices[l - 1]);
                } else {
                    this.timesList.setSelectedValue(times[times.length - 1], true);
                }
            } else if (times.length > 0) {
                this.timesList.setSelectedValue(times[times.length - 1], true);
            }
        } else {
            LogUtil.userMessage("No data available");
        }
    }

    public static void main(String[] argv) {
        frame = new JFrame("Sounding Selector");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        SoundingSelector ss = new SoundingSelector(new PreferenceList(Misc.newList("adde.ucar.edu")), "/var/data/ldm/decoded", "adde.ucar.edu", true, true);
        Container contentPane = frame.getContentPane();
        contentPane.add((Component)ss.getContents(), "Center");
        JPanel panel = new JPanel(false);
        JButton dismiss = new JButton("Dismiss");
        dismiss.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        panel.add(dismiss);
        contentPane.add((Component)panel, "South");
        frame.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(screenSize.width / 2 - 320, screenSize.height / 2 - 125);
        frame.setVisible(true);
    }

    public DateTime getSelectedTime() {
        return (DateTime)this.timesList.getSelectedValue();
    }

    public List getSelectedTimes() {
        return Misc.toList(this.timesList.getSelectedValues());
    }

    public List getSelectedSoundings() {
        return this.selectedObs;
    }
}

