/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.File;
import java.util.Formatter;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.unidata.beans.NonVetoableProperty;
import ucar.unidata.beans.Property;
import ucar.unidata.beans.PropertySet;
import ucar.unidata.data.sounding.CDMStationProfileAdapter;
import ucar.unidata.data.sounding.CMASoundingAdapter;
import ucar.unidata.data.sounding.NetcdfSoundingAdapter;
import ucar.unidata.data.sounding.SoundingAdapter;
import ucar.unidata.data.sounding.SoundingAdapterImpl;
import ucar.unidata.util.FileManager;
import ucar.unidata.util.GuiUtils;
import ucar.unidata.util.LogUtil;
import ucar.unidata.util.Misc;
import ucar.unidata.util.PatternFileFilter;

public class SoundingFileBrowser {
    public static final PatternFileFilter FILTER_NC = new PatternFileFilter(".*ua\\.nc$,Upperair.*\\.nc$,.*\\.nc$", "netCDF Upper Air files (*ua.nc)");
    public static final PatternFileFilter FILTER_CMA_UA = new PatternFileFilter(".*\\.ta$", "CMA Upper Air files (*.ta)");
    public static final PatternFileFilter FILTER_GEM_UA = new PatternFileFilter(".*\\.gem$", "GEMPAK Upper Air files (*.gem)");
    private Property soundingAdapterProperty;
    private PropertySet propertySet = new PropertySet();
    protected JTextField selectedFileDisplay;
    private boolean ignoreChangingFile = false;
    private static JFrame frame = null;
    private JPanel contents;

    SoundingFileBrowser() {
        this(".");
    }

    SoundingFileBrowser(String directoryName) {
        this.soundingAdapterProperty = new NonVetoableProperty(this, "soundingAdapter");
        this.propertySet.addProperty(this.soundingAdapterProperty);
        File selectedFile = new File(directoryName != null ? directoryName : ".");
        this.selectedFileDisplay = new JTextField(30);
        this.selectedFileDisplay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                SoundingFileBrowser.this.checkNewFile(new File(SoundingFileBrowser.this.selectedFileDisplay.getText().trim()));
            }
        });
        GuiUtils.setNoFill();
        GuiUtils.tmpInsets = new Insets(0, 2, 0, 2);
        this.contents = GuiUtils.doLayout(new Component[]{this.selectedFileDisplay, this.fileSelectionButton()}, 2, GuiUtils.WT_N, GuiUtils.WT_N);
    }

    private JButton fileSelectionButton() {
        JButton fileSelectButton = new JButton("Select File...");
        fileSelectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String file = FileManager.getReadFile("Select Upper Air File", Misc.newList(FILTER_NC, FILTER_CMA_UA, FILTER_GEM_UA));
                if (file == null) {
                    return;
                }
                SoundingFileBrowser.this.checkNewFile(new File(file));
            }
        });
        return fileSelectButton;
    }

    protected void checkNewFile(File selectedFile) {
        if (this.ignoreChangingFile) {
            return;
        }
        if (!selectedFile.exists()) {
            LogUtil.userMessage("File does not exist:" + selectedFile);
            return;
        }
        SoundingAdapterImpl adapter = null;
        try {
            Formatter log = new Formatter();
            FeatureDatasetPoint dataset = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(FeatureType.STATION_PROFILE, selectedFile.toString(), null, log);
            adapter = dataset != null ? new CDMStationProfileAdapter(selectedFile) : (selectedFile.toString().endsWith(".gem") ? new CDMStationProfileAdapter(selectedFile) : new NetcdfSoundingAdapter(selectedFile));
        }
        catch (IllegalArgumentException ill) {
            System.out.println(ill.getMessage());
            try {
                adapter = new CMASoundingAdapter(selectedFile);
            }
            catch (Exception exc) {
                LogUtil.logException("Reading sounding:" + selectedFile, exc);
                return;
            }
        }
        catch (Exception exc) {
            LogUtil.logException("Reading sounding:" + selectedFile, exc);
            return;
        }
        if (adapter.getSoundingTimes() != null) {
            try {
                this.soundingAdapterProperty.setValueAndNotifyListeners(adapter);
                this.ignoreChangingFile = true;
                this.selectedFileDisplay.setText(selectedFile.getPath());
                this.ignoreChangingFile = false;
            }
            catch (PropertyVetoException excpt) {
                LogUtil.logException("New sounding dataset was vetoed: ", excpt);
            }
        } else {
            LogUtil.userMessage("Unable to read data from file " + selectedFile);
        }
    }

    public JPanel getContents() {
        return this.contents;
    }

    protected Property getSoundingAdapterProperty() {
        return this.soundingAdapterProperty;
    }

    public SoundingAdapter getSoundingAdapter() {
        return (SoundingAdapter)this.soundingAdapterProperty.getValue();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySet.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySet.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.propertySet.addPropertyChangeListener(name, listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.propertySet.removePropertyChangeListener(name, listener);
    }

    public static void main(String[] args) {
        frame = new JFrame("Sounding Browser Test");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        SoundingFileBrowser ncfb = new SoundingFileBrowser(args.length > 0 ? args[0] : "/var/data/ldm/decoded");
        frame.getContentPane().add(ncfb.getContents());
        frame.pack();
        frame.setVisible(true);
    }
}

