/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.view.sounding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import ucar.unidata.view.sounding.AirTemperatureProfile;
import ucar.unidata.view.sounding.DewPointProfile;
import ucar.unidata.view.sounding.Profile;
import ucar.visad.display.CompositeDisplayable;
import visad.Field;
import visad.FunctionType;
import visad.LocalDisplay;
import visad.Real;
import visad.RealType;
import visad.VisADException;

public class Sounding
extends CompositeDisplayable {
    public static String PRESSURE = "pressure";
    public static String TEMPERATURE = "temperature";
    public static String DEW_POINT = "dewPoint";
    private AirTemperatureProfile temperatureProfile;
    private DewPointProfile dewPointProfile;
    private boolean constrainProfiles = false;
    private Object constraintLock = new Object();
    private boolean constrainTemperatures = true;
    private boolean constrainDewPoints = true;
    private int lastModifiedField = 0;
    private static Constraint temperatureProfileConstraint;
    private static Constraint dewPointProfileConstraint;
    private static int temperatureField;
    private static int dewPointField;

    public Sounding(LocalDisplay display) throws VisADException, RemoteException {
        super(display);
        this.temperatureProfile = new AirTemperatureProfile();
        this.dewPointProfile = new DewPointProfile();
        this.temperatureProfile.addPropertyChangeListener("rangeValue", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                PropertyChangeEvent newEvent = new PropertyChangeEvent(Sounding.this, TEMPERATURE, event.getOldValue(), event.getNewValue());
                newEvent.setPropagationId(event.getPropagationId());
                Sounding.this.firePropertyChange(newEvent);
            }
        });
        this.temperatureProfile.addPropertyChangeListener("field", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                Sounding.this.lastModifiedField = temperatureField;
                try {
                    if (Sounding.this.constrainProfiles) {
                        if (Sounding.this.constrainTemperatures) {
                            Sounding.this.constrainTemperatures();
                        }
                        Sounding.this.constrainTemperatures = !Sounding.this.constrainTemperatures;
                    }
                }
                catch (Exception e) {
                    System.err.println(this.getClass().getName() + ".propertyChange(): " + "Couldn't constrain profile temperatures: " + e);
                }
            }
        });
        this.dewPointProfile.addPropertyChangeListener("rangeValue", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                PropertyChangeEvent newEvent = new PropertyChangeEvent(Sounding.this, DEW_POINT, event.getOldValue(), event.getNewValue());
                newEvent.setPropagationId(event.getPropagationId());
                Sounding.this.firePropertyChange(newEvent);
            }
        });
        this.dewPointProfile.addPropertyChangeListener("field", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                Sounding.this.lastModifiedField = dewPointField;
                try {
                    if (Sounding.this.constrainProfiles) {
                        if (Sounding.this.constrainDewPoints) {
                            Sounding.this.constrainDewPoints();
                        }
                        Sounding.this.constrainDewPoints = !Sounding.this.constrainDewPoints;
                    }
                }
                catch (Exception e) {
                    System.err.println(this.getClass().getName() + ".propertyChange(): " + "Couldn't constrain profile dew-points: " + e);
                }
            }
        });
        this.addDisplayable(this.temperatureProfile);
        this.addDisplayable(this.dewPointProfile);
    }

    public void setConstrainProfiles(boolean yes) throws RemoteException, VisADException {
        this.constrainProfiles = yes;
        if (yes) {
            if (this.lastModifiedField == temperatureField) {
                this.constrainTemperatures();
            } else if (this.lastModifiedField == dewPointField) {
                this.constrainDewPoints();
            }
        }
    }

    public void setFields(Field temperatureField, Field dewPointField) throws RemoteException, VisADException {
        this.temperatureProfile.setProfile(temperatureField);
        if (dewPointField != null) {
            this.dewPointProfile.setProfile(dewPointField);
        }
    }

    public void setTemperatureField(Field temperatureField) throws RemoteException, VisADException {
        this.temperatureProfile.setProfile(temperatureField);
    }

    public void setDewPointField(Field dewPointField) throws RemoteException, VisADException {
        this.dewPointProfile.setProfile(dewPointField);
    }

    public Field getTemperatureField() throws VisADException, RemoteException {
        return this.temperatureProfile.getProfile();
    }

    public Field getDewPointField() throws VisADException, RemoteException {
        return this.dewPointProfile.getProfile();
    }

    public void setOriginalProfiles() throws VisADException, RemoteException {
        this.temperatureProfile.setOriginalProfile();
        this.dewPointProfile.setOriginalProfile();
    }

    public void setPressure(Real pressure) throws RemoteException, VisADException {
        Real oldPressure = this.getPressure();
        this.temperatureProfile.setPressure(pressure);
        this.dewPointProfile.setPressure(pressure);
        this.firePropertyChange(PRESSURE, oldPressure, pressure);
    }

    public Real getPressure() {
        return this.temperatureProfile.getPressure();
    }

    public Real getTemperature() {
        return this.temperatureProfile.getRangeValue();
    }

    public Real getDewPoint() {
        return this.dewPointProfile.getRangeValue();
    }

    public RealType getPressureRealType() throws VisADException, RemoteException {
        return (RealType)((FunctionType)this.getTemperatureField().getType()).getDomain().getComponent(0);
    }

    public RealType getTemperatureRealType() throws VisADException, RemoteException {
        return (RealType)((FunctionType)this.getTemperatureField().getType()).getFlatRange().getComponent(0);
    }

    public RealType getDewPointRealType() throws VisADException, RemoteException {
        return (RealType)((FunctionType)this.getDewPointField().getType()).getFlatRange().getComponent(0);
    }

    private void constrainTemperatures() throws VisADException, RemoteException {
        Sounding.constrainProfile(this.temperatureProfile, temperatureProfileConstraint, this.dewPointProfile);
    }

    private void constrainDewPoints() throws VisADException, RemoteException {
        Sounding.constrainProfile(this.dewPointProfile, dewPointProfileConstraint, this.temperatureProfile);
    }

    private static void constrainProfile(Profile profile1, Constraint constraint, Profile profile2) throws VisADException, RemoteException {
    }

    static {
        temperatureField = 1;
        dewPointField = 2;
        temperatureProfileConstraint = new Constraint(){

            @Override
            public boolean isOK(Real value1, Real value2) {
                return value1.compareTo(value2) >= 0;
            }
        };
        dewPointProfileConstraint = new Constraint(){

            @Override
            public boolean isOK(Real value1, Real value2) {
                return value1.compareTo(value2) <= 0;
            }
        };
    }

    private static interface Constraint {
        public boolean isOK(Real var1, Real var2);
    }
}

